/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class JComponent
extends Container
implements Serializable {
    private static final long serialVersionUID = -7908749299918704233L;
    static boolean isPaintingDoubleBuffered = false;
    private static transient Rectangle rectCache;
    private static Locale defaultLocale;
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    public static final int UNDEFINED_CONDITION = -1;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    protected AccessibleContext accessibleContext;
    Dimension preferredSize;
    Dimension minimumSize;
    Dimension maximumSize;
    float alignmentX;
    float alignmentY;
    Border border;
    String toolTipText;
    boolean doubleBuffered;
    int debugGraphicsOptions;
    boolean opaque;
    protected ComponentUI ui;
    boolean requestFocusEnabled;
    boolean autoscrolls;
    protected EventListenerList listenerList;
    private Hashtable clientProperties;
    private InputMap inputMap_whenFocused;
    private InputMap inputMap_whenAncestorOfFocused;
    private ComponentInputMap inputMap_whenInFocusedWindow;
    private ActionMap actionMap;
    private boolean verifyInputWhenFocusTarget;
    private InputVerifier inputVerifier;
    private TransferHandler transferHandler;
    private boolean paintingTile;
    private Image dragBuffer;
    private boolean dragBufferInitialized;
    boolean isCompletelyDirty;
    static /* synthetic */ Class class$javax$swing$event$AncestorListener;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    private final Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object object) {
        return this.getClientProperties().get(object);
    }

    public final void putClientProperty(Object object, Object object2) {
        Hashtable hashtable = this.getClientProperties();
        Object object3 = hashtable.get(object);
        if (object2 != null) {
            hashtable.put(object, object2);
        } else {
            hashtable.remove(object);
        }
        this.firePropertyChange(object.toString(), object3, object2);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        Class clazz = class$javax$swing$event$AncestorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$AncestorListener = JComponent.class("[Ljavax.swing.event.AncestorListener;", false);
        }
        this.listenerList.remove(clazz, ancestorListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        Class clazz = class$java$beans$VetoableChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$VetoableChangeListener = JComponent.class("[Ljava.beans.VetoableChangeListener;", false);
        }
        this.listenerList.remove(clazz, vetoableChangeListener);
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        Class clazz = class$javax$swing$event$AncestorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$AncestorListener = JComponent.class("[Ljavax.swing.event.AncestorListener;", false);
        }
        this.listenerList.add(clazz, ancestorListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Class clazz = class$java$beans$PropertyChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$PropertyChangeListener = JComponent.class("[Ljava.beans.PropertyChangeListener;", false);
        }
        this.listenerList.add(clazz, propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        Class clazz = class$java$beans$VetoableChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$VetoableChangeListener = JComponent.class("[Ljava.beans.VetoableChangeListener;", false);
        }
        this.listenerList.add(clazz, vetoableChangeListener);
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$beans$PropertyChangeListener;
        if (clazz2 == null) {
            clazz2 = class$java$beans$PropertyChangeListener = JComponent.class("[Ljava.beans.PropertyChangeListener;", false);
        }
        if (clazz == clazz2) {
            return this.getPropertyChangeListeners();
        }
        return this.listenerList.getListeners(clazz);
    }

    public AncestorListener[] getAncestorListeners() {
        Class clazz = class$javax$swing$event$AncestorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$AncestorListener = JComponent.class("[Ljavax.swing.event.AncestorListener;", false);
        }
        return (AncestorListener[])this.getListeners(clazz);
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        Class clazz = class$java$beans$VetoableChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$VetoableChangeListener = JComponent.class("[Ljava.beans.VetoableChangeListener;", false);
        }
        return (VetoableChangeListener[])this.getListeners(clazz);
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        super.firePropertyChange(string, bl, bl2);
    }

    public void firePropertyChange(String string, char c, char c2) {
        super.firePropertyChange(string, c, c2);
    }

    public void firePropertyChange(String string, int n, int n2) {
        super.firePropertyChange(string, n, n2);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        VetoableChangeListener[] vetoableChangeListenerArray = this.getVetoableChangeListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < vetoableChangeListenerArray.length) {
            vetoableChangeListenerArray[n].vetoableChange(propertyChangeEvent);
            ++n;
        }
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public float getAlignmentX() {
        float f = this.alignmentX;
        if (this.alignmentX < 0.0f) {
            f = super.getAlignmentX();
        }
        return f;
    }

    public float getAlignmentY() {
        float f = this.alignmentY;
        if (this.alignmentY < 0.0f) {
            f = super.getAlignmentY();
        }
        return f;
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setBorder(Border border) {
        Border border2 = this.getBorder();
        if (border2 == border) {
            return;
        }
        this.border = border;
        this.firePropertyChange("border", border2, border);
        this.repaint();
    }

    public Border getBorder() {
        return this.border;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        int n = this.getDebugGraphicsOptions();
        if (n != -1) {
            if (!(graphics2 instanceof DebugGraphics)) {
                graphics2 = new DebugGraphics(graphics);
            }
            DebugGraphics debugGraphics = (DebugGraphics)graphics2;
            debugGraphics.setDebugOptions(debugGraphics.getDebugOptions() | n);
        }
        graphics2.setFont(this.getFont());
        graphics2.setColor(this.getForeground());
        return graphics2;
    }

    public int getDebugGraphicsOptions() {
        String string = System.getProperty("gnu.javax.swing.DebugGraphics");
        int n = this.debugGraphicsOptions;
        if (string != null && string.length() != 0) {
            if (n < 0) {
                n = 0;
            }
            if (string.equals("LOG")) {
                n |= 1;
            } else if (string.equals("FLASH")) {
                n |= 2;
            }
        }
        return n;
    }

    public Insets getInsets() {
        if (this.border == null) {
            return super.getInsets();
        }
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        Insets insets2 = this.getInsets();
        if (insets == null) {
            return insets2;
        }
        insets.left = insets2.left;
        insets.right = insets2.right;
        insets.top = insets2.top;
        insets.bottom = insets2.bottom;
        return insets;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public Dimension getMaximumSize() {
        Dimension dimension;
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        if (this.ui != null && (dimension = this.ui.getMaximumSize(this)) != null) {
            return dimension;
        }
        dimension = super.getMaximumSize();
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension;
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        if (this.ui != null && (dimension = this.ui.getMinimumSize(this)) != null) {
            return dimension;
        }
        dimension = super.getMinimumSize();
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2 = null;
        if (this.preferredSize != null) {
            dimension2 = new Dimension(this.preferredSize);
        } else if (this.ui != null && (dimension = this.ui.getPreferredSize(this)) != null) {
            dimension2 = dimension;
        }
        if (dimension2 == null) {
            dimension2 = super.getPreferredSize();
        }
        return dimension2;
    }

    public boolean isMaximumSizeSet() {
        boolean bl = false;
        if (this.maximumSize != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isMinimumSizeSet() {
        boolean bl = false;
        if (this.minimumSize != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isPreferredSizeSet() {
        boolean bl = false;
        if (this.preferredSize != null) {
            bl = true;
        }
        return bl;
    }

    public Component getNextFocusableComponent() {
        return null;
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        return null;
    }

    public JRootPane getRootPane() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        return jRootPane;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        jToolTip.setTipText(this.toolTipText);
        return jToolTip;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public void setToolTipText(String string) {
        if (string == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.toolTipText = null;
            return;
        }
        String string2 = this.toolTipText;
        this.toolTipText = string;
        if (string2 == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public Container getTopLevelAncestor() {
        Container container;
        Container container2 = container = this.getParent();
        while (container2 != null) {
            container = container2;
            container2 = container2.getParent();
        }
        return container;
    }

    public void computeVisibleRect(Rectangle rectangle) {
        Container container = this.getParent();
        if (container != null && container instanceof JComponent) {
            ((JComponent)container).computeVisibleRect(rectangle);
            rectangle.translate(-this.getX(), -this.getY());
            rectangle = SwingUtilities.computeIntersection(0, 0, this.getWidth(), this.getHeight(), rectangle);
        } else {
            rectangle.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    public void grabFocus() {
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return this.paintingTile;
    }

    public boolean isRequestFocusEnabled() {
        return this.requestFocusEnabled;
    }

    public boolean isValidateRoot() {
        return false;
    }

    public void paint(Graphics graphics) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (!isPaintingDoubleBuffered && this.isDoubleBuffered() && repaintManager.isDoubleBufferingEnabled()) {
            Rectangle rectangle = graphics.getClipBounds();
            this.paintDoubleBuffered(rectangle);
        } else {
            if (this.getClientProperty("bufferedDragging") != null && this.dragBuffer == null) {
                this.initializeDragBuffer();
            } else if (this.getClientProperty("bufferedDragging") == null && this.dragBuffer != null) {
                this.dragBuffer = null;
            }
            if (graphics.getClip() == null) {
                graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.dragBuffer != null && this.dragBufferInitialized) {
                graphics.drawImage(this.dragBuffer, 0, 0, this);
            } else {
                Graphics graphics2 = this.getComponentGraphics(graphics);
                this.paintComponent(graphics2);
                this.paintBorder(graphics2);
                this.paintChildren(graphics2);
                Rectangle rectangle = graphics2.getClipBounds();
                if (rectangle.x == 0 && rectangle.y == 0 && rectangle.width == this.getWidth() && rectangle.height == this.getHeight()) {
                    RepaintManager.currentManager(this).markCompletelyClean(this);
                }
            }
        }
    }

    private final void initializeDragBuffer() {
        this.dragBufferInitialized = false;
        if (this.dragBuffer == null || this.dragBuffer.getWidth(this) < this.getWidth() || this.dragBuffer.getHeight(this) < this.getHeight()) {
            this.dragBuffer = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics graphics = this.dragBuffer.getGraphics();
        this.paint(graphics);
        graphics.dispose();
        this.dragBufferInitialized = true;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintChildren(Graphics graphics) {
        Rectangle rectangle;
        int n;
        Shape shape = graphics.getClip();
        Rectangle rectangle2 = SwingUtilities.calculateInnerArea(this, rectCache);
        graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Component[] componentArray = this.getComponents();
        int n2 = componentArray.length - 1;
        if (!this.isOptimizedDrawingEnabled()) {
            n = 0;
            while (n < componentArray.length) {
                rectangle = componentArray[n].getBounds();
                if (componentArray[n].isOpaque() && componentArray[n].isVisible() && SwingUtilities.isRectangleContainingRectangle(rectangle, graphics.getClipBounds())) {
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        this.paintingTile = true;
        n = n2;
        while (true) {
            if (n < 0) {
                graphics.setClip(shape);
                return;
            }
            if (n == 0) {
                this.paintingTile = false;
            }
            if (componentArray[n].isVisible()) {
                rectangle = componentArray[n].getBounds(rectCache);
                Rectangle rectangle3 = graphics.getClipBounds();
                if (rectangle3 == null) {
                    rectangle3 = rectangle;
                }
                if (graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                    Object var11_10;
                    boolean bl = false;
                    try {
                        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        graphics.translate(rectangle.x, rectangle.y);
                        bl = true;
                        componentArray[n].paint(graphics);
                    }
                    catch (Throwable throwable) {
                        var11_10 = null;
                        if (bl) {
                            graphics.translate(-rectangle.x, -rectangle.y);
                        }
                        graphics.setClip(rectangle3);
                        throw throwable;
                    }
                    {
                        var11_10 = null;
                        if (bl) {
                            graphics.translate(-rectangle.x, -rectangle.y);
                        }
                        graphics.setClip(rectangle3);
                    }
                }
            }
            --n;
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = graphics;
            if (!(graphics instanceof Graphics2D)) {
                graphics2 = graphics.create();
            }
            this.ui.update(graphics2, this);
            if (!(graphics instanceof Graphics2D)) {
                graphics2.dispose();
            }
        }
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        this.paintImmediately(new Rectangle(n, n2, n3, n4));
    }

    public void paintImmediately(Rectangle rectangle) {
        Component component = this.findPaintRoot(rectangle);
        if (component == null) {
            return;
        }
        if (component == null || !component.isShowing()) {
            return;
        }
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, component);
        if (component instanceof JComponent) {
            ((JComponent)component).paintImmediately2(rectangle2);
        } else {
            component.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    void paintImmediately2(Rectangle rectangle) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (repaintManager.isDoubleBufferingEnabled() && this.isDoubleBuffered()) {
            this.paintDoubleBuffered(rectangle);
        } else {
            this.paintSimple(rectangle);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void paintDoubleBuffered(Rectangle rectangle) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        Component component = SwingUtilities.getRoot(this);
        Image image = repaintManager.getOffscreenBuffer(this, component.getWidth(), component.getHeight());
        Point point = SwingUtilities.convertPoint(this, 0, 0, component);
        Graphics graphics = image.getGraphics();
        graphics.translate(point.x, point.y);
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics = this.getComponentGraphics(graphics);
        isPaintingDoubleBuffered = true;
        try {
            this.paint(graphics);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            isPaintingDoubleBuffered = false;
            graphics.dispose();
            throw throwable;
        }
        {
            Object var8_9 = null;
            isPaintingDoubleBuffered = false;
            graphics.dispose();
            repaintManager.commitBuffer(component, new Rectangle(point.x + rectangle.x, point.y + rectangle.y, rectangle.width, rectangle.height));
            return;
        }
    }

    void paintSimple(Rectangle rectangle) {
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = this.getComponentGraphics(graphics);
        graphics2.setClip(rectangle);
        this.paint(graphics2);
        graphics2.dispose();
        if (graphics != graphics2) {
            graphics.dispose();
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.paramString());
        stringBuffer.append(",alignmentX=").append(this.getAlignmentX());
        stringBuffer.append(",alignmentY=").append(this.getAlignmentY());
        stringBuffer.append(",border=");
        if (this.getBorder() != null) {
            stringBuffer.append(this.getBorder());
        }
        stringBuffer.append(",maximumSize=");
        if (this.getMaximumSize() != null) {
            stringBuffer.append(this.getMaximumSize());
        }
        stringBuffer.append(",minimumSize=");
        if (this.getMinimumSize() != null) {
            stringBuffer.append(this.getMinimumSize());
        }
        stringBuffer.append(",preferredSize=");
        if (this.getPreferredSize() != null) {
            stringBuffer.append(this.getPreferredSize());
        }
        return stringBuffer.toString();
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        this.getInputMap(n).put(keyStroke, new ActionListenerProxy(actionListener, string));
    }

    public final void setInputMap(int n, InputMap inputMap) {
        this.enableEvents(8L);
        switch (n) {
            case 0: {
                this.inputMap_whenFocused = inputMap;
                break;
            }
            case 1: {
                this.inputMap_whenAncestorOfFocused = inputMap;
                break;
            }
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMap must be a ComponentInputMap");
                }
                this.inputMap_whenInFocusedWindow = (ComponentInputMap)inputMap;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final InputMap getInputMap(int n) {
        this.enableEvents(8L);
        switch (n) {
            case 0: {
                if (this.inputMap_whenFocused == null) {
                    this.inputMap_whenFocused = new InputMap();
                }
                return this.inputMap_whenFocused;
            }
            case 1: {
                if (this.inputMap_whenAncestorOfFocused == null) {
                    this.inputMap_whenAncestorOfFocused = new InputMap();
                }
                return this.inputMap_whenAncestorOfFocused;
            }
            case 2: {
                if (this.inputMap_whenInFocusedWindow == null) {
                    this.inputMap_whenInFocusedWindow = new ComponentInputMap(this);
                }
                return this.inputMap_whenInFocusedWindow;
            }
        }
        return null;
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0);
    }

    public final ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        if (this.inputMap_whenFocused != null && this.inputMap_whenFocused.get(keyStroke) != null) {
            return 0;
        }
        if (this.inputMap_whenAncestorOfFocused != null && this.inputMap_whenAncestorOfFocused.get(keyStroke) != null) {
            return 1;
        }
        if (this.inputMap_whenInFocusedWindow != null && this.inputMap_whenInFocusedWindow.get(keyStroke) != null) {
            return 2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        Object object = this.getInputMap().get(keyStroke);
        if (object != null) {
            if (object instanceof ActionListenerProxy) {
                return (ActionListenerProxy)object;
            }
            if (object instanceof String) {
                return this.getActionMap().get(object);
            }
        }
        return null;
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl;
        super.processKeyEvent(keyEvent);
        this.processComponentKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        boolean bl2 = false;
        if (keyEvent.getID() == 401) {
            bl2 = true;
        }
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl = bl2)) {
            keyEvent.consume();
            return;
        }
        if (this.processKeyBinding(keyStroke, keyEvent, 1, bl)) {
            keyEvent.consume();
            return;
        }
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JComponent && ((JComponent)container).processKeyBinding(keyStroke, keyEvent, 1, bl)) {
                keyEvent.consume();
                return;
            }
            if (container instanceof Window || container instanceof Applet) break;
            container = container.getParent();
        }
        if (container == null || keyEvent.isConsumed()) {
            return;
        }
        if (KeyboardManager.getManager().processKeyStroke(container, keyStroke, keyEvent)) {
            keyEvent.consume();
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (this.isEnabled()) {
            Object object;
            Action action = null;
            InputMap inputMap = this.getInputMap(n);
            if (inputMap != null && (object = inputMap.get(keyStroke)) != null) {
                action = object instanceof ActionListenerProxy ? (Action)object : this.getActionMap().get(object);
            }
            if (action != null && action.isEnabled()) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
    }

    public void resetKeyboardActions() {
        if (this.inputMap_whenFocused != null) {
            this.inputMap_whenFocused.clear();
        }
        if (this.inputMap_whenAncestorOfFocused != null) {
            this.inputMap_whenAncestorOfFocused.clear();
        }
        if (this.inputMap_whenInFocusedWindow != null) {
            this.inputMap_whenInFocusedWindow.clear();
        }
        if (this.actionMap != null) {
            this.actionMap.clear();
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        RepaintManager.currentManager(this).addDirtyRegion(this, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean requestDefaultFocus() {
        return false;
    }

    public void revalidate() {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    JComponent.this.revalidate();
                }
            });
        } else {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Container container = this.getParent();
        if (container instanceof JComponent) {
            ((JComponent)container).scrollRectToVisible(rectangle);
        }
    }

    public void setAlignmentX(float f) {
        this.alignmentX = f < 0.0f ? 0.0f : ((double)f > 1.0 ? 1.0f : f);
    }

    public void setAlignmentY(float f) {
        this.alignmentY = f < 0.0f ? 0.0f : ((double)f > 1.0 ? 1.0f : f);
    }

    public void setAutoscrolls(boolean bl) {
        this.autoscrolls = bl;
    }

    public void setDebugGraphicsOptions(int n) {
        this.debugGraphicsOptions = n;
    }

    public void setDoubleBuffered(boolean bl) {
        this.doubleBuffered = bl;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled()) {
            return;
        }
        super.setEnabled(bl);
        this.firePropertyChange("enabled", bl ^ true, bl);
        this.repaint();
    }

    public void setFont(Font font) {
        if (font == this.getFont()) {
            return;
        }
        super.setFont(font);
        this.revalidate();
        this.repaint();
    }

    public void setBackground(Color color) {
        if (color == this.getBackground()) {
            return;
        }
        super.setBackground(color);
        this.repaint();
    }

    public void setForeground(Color color) {
        if (color == this.getForeground()) {
            return;
        }
        super.setForeground(color);
        this.repaint();
    }

    public void setMaximumSize(Dimension dimension) {
        Dimension dimension2 = this.maximumSize;
        this.maximumSize = dimension != null ? new Dimension(dimension) : null;
        this.firePropertyChange("maximumSize", dimension2, this.maximumSize);
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minimumSize;
        this.minimumSize = dimension != null ? new Dimension(dimension) : null;
        this.firePropertyChange("minimumSize", dimension2, this.minimumSize);
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension != null ? new Dimension(dimension) : null;
        this.firePropertyChange("preferredSize", dimension2, this.preferredSize);
    }

    public void setNextFocusableComponent(Component component) {
    }

    public void setRequestFocusEnabled(boolean bl) {
        this.requestFocusEnabled = bl;
    }

    public TransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        if (this.transferHandler == transferHandler) {
            return;
        }
        TransferHandler transferHandler2 = this.transferHandler;
        this.transferHandler = transferHandler;
        this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
    }

    public void setOpaque(boolean bl) {
        boolean bl2 = this.opaque;
        this.opaque = bl;
        this.firePropertyChange("opaque", bl2, this.opaque);
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return;
        }
        super.setVisible(bl);
        if (bl) {
            this.fireAncestorEvent(this, 1);
        } else {
            this.fireAncestorEvent(this, 2);
        }
        Container container = this.getParent();
        if (container != null) {
            container.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        this.revalidate();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String getUIClassID() {
        return "ComponentUI";
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale;
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = this.inputVerifier;
        this.inputVerifier = inputVerifier;
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public void setVerifyInputWhenFocusTarget(boolean bl) {
        if (this.verifyInputWhenFocusTarget == bl) {
            return;
        }
        this.verifyInputWhenFocusTarget = bl;
        this.firePropertyChange("verifyInputWhenFocusTarget", bl ^ true, bl);
    }

    public void requestFocus() {
        if (this.isRequestFocusEnabled()) {
            super.requestFocus();
        }
    }

    public boolean requestFocus(boolean bl) {
        return super.requestFocus(bl);
    }

    public boolean requestFocusInWindow() {
        if (this.isRequestFocusEnabled()) {
            return super.requestFocusInWindow();
        }
        return false;
    }

    protected boolean requestFocusInWindow(boolean bl) {
        return super.requestFocusInWindow(bl);
    }

    public void addNotify() {
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        keyboardManager.clearBindingsForComp(this);
        keyboardManager.registerEntireMap((ComponentInputMap)this.getInputMap(2));
        super.addNotify();
        this.fireAncestorEvent(this, 1);
        this.firePropertyChange("ancestor", null, this.getParent());
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getManager().clearBindingsForComp(this);
        this.fireAncestorEvent(this, 2);
        this.firePropertyChange("ancestor", this.getParent(), null);
    }

    public boolean contains(int n, int n2) {
        if (this.ui == null) {
            return super.contains(n, n2);
        }
        return this.ui.contains(this, n, n2);
    }

    public void disable() {
        super.disable();
    }

    public void enable() {
        super.enable();
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public int getX() {
        return super.getX();
    }

    public int getY() {
        return super.getY();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public int getWidth() {
        return super.getWidth();
    }

    public void print(Graphics graphics) {
        boolean bl = this.isDoubleBuffered();
        this.setDoubleBuffered(false);
        this.printComponent(graphics);
        this.printBorder(graphics);
        this.printChildren(graphics);
        this.setDoubleBuffered(bl);
    }

    public void printAll(Graphics graphics) {
        this.print(graphics);
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        int n5 = this.getX();
        int n6 = this.getY();
        super.reshape(n, n2, n3, n4);
        if (n5 != this.getX() || n6 != this.getY()) {
            this.fireAncestorEvent(this, 3);
        }
    }

    void fireAncestorEvent(JComponent jComponent, int n) {
        int n2;
        Object object;
        AncestorListener[] ancestorListenerArray = this.getAncestorListeners();
        if (ancestorListenerArray.length > 0) {
            object = new AncestorEvent(this, n, jComponent, jComponent.getParent());
            n2 = 0;
            while (n2 < ancestorListenerArray.length) {
                switch (n) {
                    case 3: {
                        ancestorListenerArray[n2].ancestorMoved((AncestorEvent)object);
                        break;
                    }
                    case 1: {
                        ancestorListenerArray[n2].ancestorAdded((AncestorEvent)object);
                        break;
                    }
                    case 2: {
                        ancestorListenerArray[n2].ancestorRemoved((AncestorEvent)object);
                        break;
                    }
                }
                ++n2;
            }
        }
        object = this.getComponents();
        n2 = 0;
        while (n2 < ((Component[])object).length) {
            if (object[n2] instanceof JComponent) {
                JComponent jComponent2 = (JComponent)object[n2];
                jComponent2.fireAncestorEvent(jComponent, n);
            }
            ++n2;
        }
    }

    private final Component findPaintRoot(Rectangle rectangle) {
        Component component = this.findOverlapFreeParent(rectangle);
        if (component == null) {
            return null;
        }
        Component component2 = this.findOpaqueParent(component);
        return component2;
    }

    private final Component findOverlapFreeParent(Rectangle rectangle) {
        Rectangle rectangle2 = rectangle;
        Container container = this;
        Container container2 = this;
        while (container2 != null && !(container2 instanceof Window)) {
            Container container3 = container2.getParent();
            if (container3 == null || container3 instanceof Window) break;
            if (container3 instanceof JComponent && ((JComponent)container3).isOptimizedDrawingEnabled()) {
                container2 = container3;
                continue;
            }
            Rectangle rectangle3 = SwingUtilities.convertRectangle(container, rectangle2, container3);
            container = container3;
            rectangle2 = rectangle3;
            container2 = container3;
        }
        return container;
    }

    private final Component findOpaqueParent(Component component) {
        Container container;
        Component component2 = component;
        while (!(component2 instanceof JComponent && ((JComponent)component2).isOpaque() || !(component2 instanceof JComponent) || (container = component2.getParent()) == null)) {
            component2 = container;
        }
        return component2;
    }

    void updateComponentInputMap(ComponentInputMap componentInputMap) {
        InputMap inputMap = this.getInputMap(2);
        while (inputMap != null && inputMap != componentInputMap) {
            inputMap = inputMap.getParent();
        }
        if (inputMap == null) {
            return;
        }
        KeyboardManager keyboardManager = KeyboardManager.getManager();
        keyboardManager.clearBindingsForComp(componentInputMap.getComponent());
        keyboardManager.registerEntireMap((ComponentInputMap)this.getInputMap(2));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.alignmentX = -1.0f;
        this.alignmentY = -1.0f;
        this.doubleBuffered = true;
        this.opaque = false;
        this.autoscrolls = false;
        this.listenerList = new EventListenerList();
        this.isCompletelyDirty = false;
    }

    public JComponent() {
        this.this();
        this.setDropTarget(new DropTarget());
        defaultLocale = Locale.getDefault();
        this.debugGraphicsOptions = -1;
        this.setRequestFocusEnabled(true);
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        private static final long serialVersionUID = -7047089700479897799L;
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;
        private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public int getAccessibleChildrenCount() {
            int n = 0;
            Component[] componentArray = JComponent.this.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Accessible) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            int n2 = 0;
            Component[] componentArray = JComponent.this.getComponents();
            Accessible accessible = null;
            int n3 = 0;
            while (n2 != n) {
                if (componentArray[n3] instanceof Accessible) {
                    ++n2;
                }
                if (n2 == n) {
                    accessible = (Accessible)((Object)componentArray[n2]);
                }
                ++n3;
            }
            return accessible;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }

        public String getAccessibleName() {
            return null;
        }

        public String getAccessibleDescription() {
            return super.getAccessibleDescription();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        protected String getBorderTitle(Border border) {
            String string = null;
            if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                Border border2 = compoundBorder.getInsideBorder();
                string = this.getBorderTitle(border2);
                if (string == null) {
                    Border border3 = compoundBorder.getOutsideBorder();
                    string = this.getBorderTitle(border3);
                }
            } else if (border instanceof TitledBorder) {
                TitledBorder titledBorder = (TitledBorder)border;
                string = titledBorder.getTitle();
            }
            return string;
        }

        public String getToolTipText() {
            return JComponent.this.getToolTipText();
        }

        public String getTitledBorderText() {
            return this.getBorderTitle(JComponent.this.getBorder());
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected AccessibleJComponent() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleContainerHandler
        implements ContainerListener {
            public void componentAdded(ContainerEvent containerEvent) {
            }

            public void componentRemoved(ContainerEvent containerEvent) {
            }

            protected AccessibleContainerHandler() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleFocusHandler
        implements FocusListener {
            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
            }

            protected AccessibleFocusHandler() {
            }
        }
    }
}

