/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.behaviour;

import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.behaviour.DoubleActivityBase;

public class ConstantSpeedMove
extends DoubleActivityBase
implements Serializable {
    private double _from;
    private double _to;
    private double _speed;
    private double _timeout;

    public ConstantSpeedMove() {
        this._from = 0.0;
        this._to = 0.0;
        this._speed = 0.01;
        this._timeout = 1.0;
    }

    public ConstantSpeedMove(double d, double d2, double d3) {
        this._to = d2;
        this._from = d;
        this._speed = d3;
        this._timeout = this.duration();
    }

    public double getFrom() {
        return this._from;
    }

    public void setFrom(double d) {
        this._from = d;
        this._timeout = this.duration();
    }

    public double getTo() {
        return this._to;
    }

    public void setTo(double d) {
        this._to = d;
        this._timeout = this.duration();
    }

    public double getSpeed() {
        return this._speed;
    }

    public void setSpeed(double d) {
        this._speed = d;
        this._timeout = this.duration();
    }

    public double getValue() {
        return this._from + (1.0 - this._timeout / this.duration()) * (this._to - this._from);
    }

    public boolean isFinite() {
        return true;
    }

    public void reset() {
        this._from = this.getValue();
        this._timeout = this.duration();
        this.postUpdate(this.getValue());
    }

    public void performActivity(double d) {
        if (this._timeout > 0.0) {
            this._timeout -= d;
            if (this._timeout <= 0.0) {
                this._timeout = 0.0;
                this._from = this._to;
                this.postActivityComplete();
            }
            this.postUpdate(this.getValue());
        }
    }

    private double duration() {
        return Math.max(this._speed * Math.abs(this._to - this._from), 0.001);
    }

    public final DoubleBehaviourListener newFromAdapter() {
        return new FromAdapter();
    }

    public final DoubleBehaviourListener newToAdapter() {
        return new ToAdapter();
    }

    public final DoubleBehaviourListener newSpeedAdapter() {
        return new SpeedAdapter();
    }

    class SpeedAdapter
    implements DoubleBehaviourListener,
    Serializable {
        SpeedAdapter() {
        }

        public void behaviourUpdated(double d) {
            ConstantSpeedMove.this.setSpeed(d);
        }
    }

    class ToAdapter
    implements DoubleBehaviourListener,
    Serializable {
        ToAdapter() {
        }

        public void behaviourUpdated(double d) {
            ConstantSpeedMove.this.setTo(d);
        }
    }

    class FromAdapter
    implements DoubleBehaviourListener,
    Serializable {
        FromAdapter() {
        }

        public void behaviourUpdated(double d) {
            ConstantSpeedMove.this.setFrom(d);
        }
    }
}

