/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console.prefs;

import free.jin.I18n;
import free.jin.Preferences;
import free.jin.console.ConsoleManager;
import free.jin.console.prefs.TextStyleChooserPanel;
import free.jin.ui.PreferencesPanel;
import free.util.swing.ColorChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextPrefsPanel
extends PreferencesPanel {
    protected final ConsoleManager consoleManager;
    protected final Preferences prefs;
    private final Vector categoryPanels = new Vector();
    private CategoryPanel currentCategoryPanel;
    private ColorChooser selectionColorButton;
    private ColorChooser selectedColorButton;
    private CategoryPanel defaultSettingsPanel;
    private final JPanel categoryPanelHolder = new JPanel(new BorderLayout());
    private boolean handlingChangeEvent = false;
    protected final ChangeListener settingsChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            if (TextPrefsPanel.this.handlingChangeEvent) {
                return;
            }
            TextPrefsPanel.this.handlingChangeEvent = true;
            TextPrefsPanel.this.updatePropertiesFrom(TextPrefsPanel.this.currentCategoryPanel);
            TextPrefsPanel.this.updatePanels();
            TextPrefsPanel.this.fireStateChanged();
            TextPrefsPanel.this.handlingChangeEvent = false;
        }
    };

    public TextPrefsPanel(ConsoleManager consoleManager) {
        this.consoleManager = consoleManager;
        this.prefs = Preferences.createBackedUp((Preferences)Preferences.createNew(), (Preferences)consoleManager.getPrefs());
        this.createSettingsPanels();
        this.createLayout();
    }

    protected void addCategoryPanel(CategoryPanel categoryPanel) {
        this.categoryPanels.addElement(categoryPanel);
        TextStyleChooserPanel textStyleChooserPanel = categoryPanel.getTextStyleChooser();
        if (textStyleChooserPanel != null) {
            textStyleChooserPanel.addChangeListener(this.settingsChangeListener);
        }
    }

    protected void updatePropertiesFrom(CategoryPanel categoryPanel) {
        TextStyleChooserPanel textStyleChooserPanel = categoryPanel.getTextStyleChooser();
        if (textStyleChooserPanel == null) {
            throw new IllegalStateException("Updating preferences from a nondisplayed category panel");
        }
        if (categoryPanel == this.defaultSettingsPanel) {
            this.prefs.setColor("output-selection", this.selectionColorButton.getColor());
            this.prefs.setColor("output-selected", this.selectedColorButton.getColor());
            this.prefs.setColor("background", textStyleChooserPanel.getSelectedBackground());
            if (textStyleChooserPanel.isAntialiasingSelectionEnabled()) {
                this.prefs.setBool("output-text.antialias", this.defaultSettingsPanel.getTextStyleChooser().isAntialias());
            }
        }
        Font font = textStyleChooserPanel.getSelectedFont();
        Color color = textStyleChooserPanel.getSelectedForeground();
        String[] stringArray = categoryPanel.getCategories();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.setProperty(string, "font-family", font.getFamily());
            this.setProperty(string, "font-size", new Integer(font.getSize()));
            this.setProperty(string, "font-bold", font.isBold() ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty(string, "font-italic", font.isItalic() ? Boolean.TRUE : Boolean.FALSE);
            this.setProperty(string, "foreground", color);
        }
    }

    protected void updatePanels() {
        this.selectionColorButton.setColor(this.prefs.getColor("output-selection", UIManager.getColor("textHighlight")));
        this.selectedColorButton.setColor(this.prefs.getColor("output-selected", UIManager.getColor("textHighlightText")));
        Color color = this.prefs.getColor("background");
        boolean bl = this.prefs.getBool("output-text.antialias", false);
        for (int i = 0; i < this.categoryPanels.size(); ++i) {
            CategoryPanel categoryPanel = (CategoryPanel)this.categoryPanels.elementAt(i);
            TextStyleChooserPanel textStyleChooserPanel = categoryPanel.getTextStyleChooser();
            if (textStyleChooserPanel == null) continue;
            String string = categoryPanel.getMainCategory();
            Font font = this.getCategoryFont(string);
            Color color2 = (Color)this.prefs.lookup("foreground." + string, (Object)Color.white);
            textStyleChooserPanel.setSelectedFont(font);
            textStyleChooserPanel.setSelectedForeground(color2);
            textStyleChooserPanel.setSelectedBackground(color);
            textStyleChooserPanel.setAntialias(bl);
        }
    }

    protected void createSettingsPanels() {
        this.createDefaultSettingsPanel();
        this.createSettingsPanelsFromProperties();
    }

    private void createDefaultSettingsPanel() {
        boolean bl;
        Font font = this.getCategoryFont("");
        Color color = this.prefs.getColor("foreground");
        Color color2 = this.prefs.getColor("background");
        try {
            bl = Class.forName("java.awt.Graphics2D") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        boolean bl2 = this.prefs.getBool("output-text.antialias", false);
        TextStyleChooserPanel textStyleChooserPanel = new TextStyleChooserPanel(font, color, color2, bl2, true, bl);
        this.selectionColorButton = this.createSelectionColorButton();
        this.selectedColorButton = this.createSelectedColorButton();
        this.defaultSettingsPanel = new CategoryPanel(I18n.get((Class)TextPrefsPanel.class).getString("defaultTextCategoryName"), textStyleChooserPanel, new String[]{""});
        this.defaultSettingsPanel.setLayout(new BorderLayout(5, 5));
        this.defaultSettingsPanel.add((Component)textStyleChooserPanel, "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 15, 5));
        jPanel.add((Component)this.selectionColorButton);
        jPanel.add((Component)this.selectedColorButton);
        this.defaultSettingsPanel.add((Component)jPanel, "South");
        this.addCategoryPanel(this.defaultSettingsPanel);
        this.selectionColorButton.addChangeListener(this.settingsChangeListener);
        this.selectedColorButton.addChangeListener(this.settingsChangeListener);
    }

    private void createSettingsPanelsFromProperties() {
        int n = this.prefs.getInt("preferences.categories.count", 0);
        I18n i18n = this.consoleManager.getI18n();
        for (int i = 0; i < n; ++i) {
            CategoryPanel categoryPanel;
            String string;
            boolean bl = this.prefs.getBool("preferences.categories." + i + ".custom", false);
            if (bl) {
                string = this.prefs.getString("preferences.categories." + i + ".id");
                categoryPanel = this.createCustomCategoryPanel(string);
            } else {
                string = this.prefs.getString("preferences.categories." + i + ".nameKey");
                String string2 = i18n.getString(string);
                String string3 = this.prefs.getString("preferences.categories." + i + ".ids");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                for (int j = 0; j < stringArray.length; ++j) {
                    stringArray[j] = stringTokenizer.nextToken();
                }
                categoryPanel = new CategoryPanel(string2, stringArray);
            }
            this.addCategoryPanel(categoryPanel);
        }
    }

    protected CategoryPanel createCustomCategoryPanel(String string) {
        return null;
    }

    protected ColorChooser createSelectionColorButton() {
        ColorChooser colorChooser = I18n.get((Class)TextPrefsPanel.class).createColorChooser("selectionColorChooser");
        colorChooser.setColor(this.prefs.getColor("output-selection", UIManager.getColor("textHighlight")));
        return colorChooser;
    }

    protected ColorChooser createSelectedColorButton() {
        ColorChooser colorChooser = I18n.get((Class)TextPrefsPanel.class).createColorChooser("selectedTextColorChooser");
        colorChooser.setColor(this.prefs.getColor("output-selected", UIManager.getColor("textHighlightText")));
        return colorChooser;
    }

    protected void createLayout() {
        this.setLayout(new BorderLayout(10, 10));
        final JList jList = new JList(this.categoryPanels);
        jList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(jList);
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        JLabel jLabel = I18n.get((Class)TextPrefsPanel.class).createLabel("textTypeLabel");
        jLabel.setHorizontalAlignment(0);
        jLabel.setLabelFor(jList);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CategoryPanel categoryPanel = (CategoryPanel)jList.getSelectedValue();
                TextPrefsPanel.this.setCurrentPanel(categoryPanel);
            }
        });
        this.add(jPanel, "West");
        this.add(this.categoryPanelHolder, "Center");
        jList.setSelectedIndex(0);
    }

    private void setCurrentPanel(CategoryPanel categoryPanel) {
        this.categoryPanelHolder.removeAll();
        this.currentCategoryPanel = categoryPanel;
        if (this.currentCategoryPanel != null) {
            this.currentCategoryPanel.createTextStyleChooser();
            TextStyleChooserPanel textStyleChooserPanel = categoryPanel.getTextStyleChooser();
            textStyleChooserPanel.addChangeListener(this.settingsChangeListener);
            this.categoryPanelHolder.add((Component)this.currentCategoryPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void applyChanges() {
        Preferences preferences = this.consoleManager.getPrefs();
        Enumeration enumeration = this.prefs.getPreferenceNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.prefs.get(string);
            preferences.set(string, object);
        }
        if (!this.selectionColorButton.getColor().equals(UIManager.getColor("textHighlight"))) {
            preferences.setColor("output-selection", this.selectionColorButton.getColor());
        }
        if (!this.selectedColorButton.getColor().equals(UIManager.getColor("textHighlightText"))) {
            preferences.setColor("output-selected", this.selectedColorButton.getColor());
        }
        this.consoleManager.refreshFromProperties();
    }

    protected Font getCategoryFont(String string) {
        String string2 = (String)this.prefs.lookup("font-family." + string, (Object)"Monospaced");
        int n = (Integer)this.prefs.lookup("font-size." + string, (Object)new Integer(14));
        int n2 = 0;
        if (((Boolean)this.prefs.lookup("font-bold." + string, (Object)Boolean.FALSE)).booleanValue()) {
            n2 |= 1;
        }
        if (((Boolean)this.prefs.lookup("font-italic." + string, (Object)Boolean.FALSE)).booleanValue()) {
            n2 |= 2;
        }
        return new Font(string2, n2, n);
    }

    protected void setProperty(String string, String string2, Object object) {
        String string3;
        String string4 = string3 = string.equals("") ? string2 : string2 + "." + string;
        if (this.prefs.getBool(string3 + ".unmodifiable", false)) {
            return;
        }
        this.prefs.set(string3, object);
    }

    protected class CategoryPanel
    extends JPanel {
        private final String categoryName;
        private TextStyleChooserPanel textStyleChooser = null;
        private final String[] categories;

        public CategoryPanel(String string, TextStyleChooserPanel textStyleChooserPanel, String[] stringArray) {
            this.categoryName = string;
            this.textStyleChooser = textStyleChooserPanel;
            this.categories = stringArray;
        }

        public CategoryPanel(String string, String[] stringArray) {
            this.categoryName = string;
            this.categories = stringArray;
        }

        public TextStyleChooserPanel getTextStyleChooser() {
            return this.textStyleChooser;
        }

        public void createTextStyleChooser() {
            if (this.textStyleChooser == null) {
                String string = this.getMainCategory();
                Color color = TextPrefsPanel.this.prefs.getColor("background");
                boolean bl = TextPrefsPanel.this.prefs.getBool("output-text.antialias", false);
                Font font = TextPrefsPanel.this.getCategoryFont(string);
                Color color2 = (Color)TextPrefsPanel.this.prefs.lookup("foreground." + string, (Object)Color.white);
                this.textStyleChooser = new TextStyleChooserPanel(font, color2, color, bl, false, false);
                this.setLayout(new BorderLayout());
                this.add((Component)this.textStyleChooser, "Center");
            }
        }

        public String[] getCategories() {
            return (String[])this.categories.clone();
        }

        public String getMainCategory() {
            return this.getCategories()[0];
        }

        public String toString() {
            return this.categoryName;
        }
    }
}

