/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.mac.IMac;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PBKDF2
extends BasePRNG
implements Cloneable {
    private byte[] in;
    private int iterationCount;
    private byte[] salt;
    private IMac mac;
    private long count;

    public void setup(Map map) {
        char[] cArray;
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.hmac.pkcs5", Boolean.TRUE);
        byte[] byArray = (byte[])map.get("gnu.crypto.pbe.salt");
        if (byArray == null) {
            if (this.salt == null) {
                throw new IllegalArgumentException("no salt specified");
            }
        } else {
            this.salt = byArray;
        }
        if ((cArray = (char[])map.get("gnu.crypto.pbe.password")) != null) {
            try {
                hashMap.put("gnu.crypto.mac.key.material", new String(cArray).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error(unsupportedEncodingException.getMessage());
            }
        } else if (!this.initialised) {
            throw new IllegalArgumentException("no password specified");
        }
        try {
            this.mac.init(hashMap);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        Integer n = (Integer)map.get("gnu.crypto.pbe.iteration.count");
        if (n != null) {
            this.iterationCount = n;
        }
        if (this.iterationCount <= 0) {
            throw new IllegalArgumentException("bad iteration count");
        }
        this.count = 0L;
        this.buffer = new byte[this.mac.macSize()];
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException.getMessage());
        }
    }

    public void fillBlock() throws LimitReachedException {
        if (++this.count > 0xFFFFFFFFL) {
            throw new LimitReachedException();
        }
        Arrays.fill(this.buffer, (byte)0);
        int n = this.salt.length;
        this.in = new byte[n + 4];
        System.arraycopy(this.salt, 0, this.in, 0, this.salt.length);
        this.in[n++] = (byte)(this.count >>> 24);
        this.in[n++] = (byte)(this.count >>> 16);
        this.in[n++] = (byte)(this.count >>> 8);
        this.in[n] = (byte)this.count;
        int n2 = 0;
        while (n2 < this.iterationCount) {
            this.mac.reset();
            this.mac.update(this.in, 0, this.in.length);
            this.in = this.mac.digest();
            int n3 = 0;
            while (n3 < this.buffer.length) {
                int n4 = n3;
                this.buffer[n4] = (byte)(this.buffer[n4] ^ this.in[n3]);
                ++n3;
            }
            ++n2;
        }
    }

    public PBKDF2(IMac iMac) {
        super("PBKDF2-" + iMac.name());
        this.mac = iMac;
        this.iterationCount = -1;
    }
}

