require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_VMPARAM_H_)) {
    eval 'sub _POWERPC_VMPARAM_H_ () {1;}' unless defined(&_POWERPC_VMPARAM_H_);
    if(defined(&_KERNEL_OPT)) {
	require './powerpc/opt_modular.ph';
	require './powerpc/opt_ppcarch.ph';
	require './powerpc/opt_uvm.ph';
    }
    eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
    eval 'sub VM_FREELIST_FIRST256 () {1;}' unless defined(&VM_FREELIST_FIRST256);
    eval 'sub VM_FREELIST_FIRST16 () {2;}' unless defined(&VM_FREELIST_FIRST16);
    eval 'sub VM_NFREELIST () {3;}' unless defined(&VM_NFREELIST);
    eval 'sub VM_PHYSSEG_MAX () {16;}' unless defined(&VM_PHYSSEG_MAX);
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub VM_DEFAULT_ADDRESS_BOTTOMUP {
        my($da, $sz) = @_;
	    eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &maxdmap));
    }' unless defined(&VM_DEFAULT_ADDRESS_BOTTOMUP);
    eval 'sub MIN_PAGE_SHIFT () {12;}' unless defined(&MIN_PAGE_SHIFT);
    eval 'sub MAX_PAGE_SHIFT () {14;}' unless defined(&MAX_PAGE_SHIFT);
    eval 'sub MIN_PAGE_SIZE () {(1<<  &MIN_PAGE_SHIFT);}' unless defined(&MIN_PAGE_SIZE);
    eval 'sub MAX_PAGE_SIZE () {(1<<  &MAX_PAGE_SHIFT);}' unless defined(&MAX_PAGE_SIZE);
    if(defined(&_MODULE)) {
	if(defined(&_RUMPKERNEL)) {
	    eval 'sub VM_MAXUSER_ADDRESS () {0x7fff8000;}' unless defined(&VM_MAXUSER_ADDRESS);
	    eval 'sub VM_MIN_ADDRESS () {0x;}' unless defined(&VM_MIN_ADDRESS);
	    eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
	    eval 'sub MAXDSIZ () {(1024*1024*1024);}' unless defined(&MAXDSIZ);
	    eval 'sub MAXSSIZ () {(32*1024*1024);}' unless defined(&MAXSSIZ);
	    eval 'sub MAXTSIZ () {(256*1024*1024);}' unless defined(&MAXTSIZ);
	} else {
	    eval 'sub USRSTACK () {(( &vaddr_t)( &uintptr_t)& &__USRSTACK);}' unless defined(&USRSTACK);
	}
    } else {
	if(defined(&PPC_BOOKE)) {
	    require 'powerpc/booke/vmparam.ph';
	}
 elsif(defined(&PPC_IBM4XX)) {
	    require 'powerpc/ibm4xx/vmparam.ph';
	}
 elsif(defined(&PPC_OEA) || defined (&PPC_OEA64) || defined (&PPC_OEA64_BRIDGE)) {
	    require 'powerpc/oea/vmparam.ph';
	}
 elsif(defined(&_KERNEL)) {
	    die("unknown\ PPC\ variant");
	}
    }
    if(defined(&MODULAR) || defined(&_MODULAR)) {
	unless(defined(&__HAVE_PMAP_PHYSSEG)) {
	    eval 'sub __HAVE_PMAP_PHYSSEG () {1;}' unless defined(&__HAVE_PMAP_PHYSSEG);
	}
    }
}
1;
