/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TipUtil {
    private TipUtil() {
    }

    private static final String getHexString(Color c) {
        if (c == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("#");
        int r = c.getRed();
        if (r < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(r));
        int g2 = c.getGreen();
        if (g2 < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(g2));
        int b = c.getBlue();
        if (b < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b));
        return sb.toString();
    }

    public static Rectangle getScreenBoundsForPoint(int x, int y) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            GraphicsConfiguration[] configs = devices[i].getConfigurations();
            for (int j = 0; j < configs.length; ++j) {
                Rectangle gcBounds = configs[j].getBounds();
                if (!gcBounds.contains(x, y)) continue;
                return gcBounds;
            }
        }
        return env.getMaximumWindowBounds();
    }

    public static Color getToolTipBackground() {
        Color c = UIManager.getColor("ToolTip.background");
        boolean isNimbus = TipUtil.isNimbusLookAndFeel();
        if ((c == null || isNimbus) && ((c = UIManager.getColor("info")) == null || isNimbus && TipUtil.isDerivedColor(c))) {
            c = SystemColor.info;
        }
        if (c instanceof ColorUIResource) {
            c = new Color(c.getRGB());
        }
        return c;
    }

    public static Border getToolTipBorder() {
        Border border = UIManager.getBorder("ToolTip.border");
        if ((border == null || TipUtil.isNimbusLookAndFeel()) && (border = UIManager.getBorder("nimbusBorder")) == null) {
            border = BorderFactory.createLineBorder(SystemColor.controlDkShadow);
        }
        return border;
    }

    private static final boolean isDerivedColor(Color c) {
        return c != null && c.getClass().getName().endsWith(".DerivedColor");
    }

    private static final boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Nimbus");
    }

    public static void tweakTipEditorPane(JEditorPane textArea) {
        boolean isNimbus = TipUtil.isNimbusLookAndFeel();
        if (isNimbus) {
            Color selBG = textArea.getSelectionColor();
            Color selFG = textArea.getSelectedTextColor();
            textArea.setUI(new BasicEditorPaneUI());
            textArea.setSelectedTextColor(selFG);
            textArea.setSelectionColor(selBG);
        }
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.getCaret().setSelectionVisible(true);
        Color fg = UIManager.getColor("Label.foreground");
        if (fg == null || isNimbus && TipUtil.isDerivedColor(fg)) {
            fg = SystemColor.textText;
        }
        textArea.setForeground(fg);
        textArea.setBackground(TipUtil.getToolTipBackground());
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
        }
        HTMLDocument doc = (HTMLDocument)textArea.getDocument();
        doc.getStyleSheet().addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt" + "; color: " + TipUtil.getHexString(fg) + "; }");
        Color linkFG = RSyntaxUtilities.getHyperlinkForeground();
        doc.getStyleSheet().addRule("a { color: " + TipUtil.getHexString(linkFG) + "; }");
    }
}

