# Shell library containing functions and definitions common to amanda's
# shell scripts and wrappers.

# Include this file as follows:
#   prefix="/usr/pkg"
#   exec_prefix="${prefix}"
#   amlibexecdir="/usr/pkg/libexec/amanda"
#   . "${amlibexecdir}/amanda-sh-lib.sh"

####
# Configure variables

GREP="/usr/bin/grep"
EGREP="/usr/bin/egrep"
GETTEXT="/usr/pkg/bin/gettext"
GNUPLOT=""
GNUTAR="/usr/pkg/bin/gtar"
STAR="/usr/bin/star"
SAMBA_CLIENT="/usr/bin/smbclient"
GZIP=""
SORT="/usr/bin/sort"
PERL="/usr/pkg/bin/perl"
AWK="/usr/bin/awk"

####
# Set up PATH for finding amanda executables

PATH="/usr/pkg/sbin:/usr/pkg/libexec/amanda:$PATH"

####
# Gettext

# use as follows:
#   echo `_ "%s: '%s' is not executable" "$myname" "$binpath"`
# NOTE: use a text editor with shell syntax hilighting to avoid
# quoting errors!

if test -n "$GETTEXT"; then
    _() {
	    fmt=`$GETTEXT -d amanda "$1"`
	    shift
	    printf "$fmt" "$@"
    }
else
    _() {
	printf "$@"
    }
fi
