/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import gnu.javax.imageio.bmp.EncodeRGB1;
import gnu.javax.imageio.bmp.EncodeRGB16;
import gnu.javax.imageio.bmp.EncodeRGB24;
import gnu.javax.imageio.bmp.EncodeRGB32;
import gnu.javax.imageio.bmp.EncodeRGB4;
import gnu.javax.imageio.bmp.EncodeRGB8;
import gnu.javax.imageio.bmp.EncodeRLE4;
import gnu.javax.imageio.bmp.EncodeRLE8;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public abstract class BMPEncoder {
    public static BMPEncoder getEncoder(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        switch (bMPInfoHeader.getCompression()) {
            case 0: {
                switch (bMPInfoHeader.getBitCount()) {
                    case 32: {
                        return new EncodeRGB32(bMPFileHeader, bMPInfoHeader);
                    }
                    case 24: {
                        return new EncodeRGB24(bMPFileHeader, bMPInfoHeader);
                    }
                    case 16: {
                        return new EncodeRGB16(bMPFileHeader, bMPInfoHeader);
                    }
                    case 8: {
                        return new EncodeRGB8(bMPFileHeader, bMPInfoHeader);
                    }
                    case 4: {
                        return new EncodeRGB4(bMPFileHeader, bMPInfoHeader);
                    }
                    case 1: {
                        return new EncodeRGB1(bMPFileHeader, bMPInfoHeader);
                    }
                }
                return null;
            }
            case 2: {
                return new EncodeRLE4(bMPFileHeader, bMPInfoHeader);
            }
            case 1: {
                return new EncodeRLE8(bMPFileHeader, bMPInfoHeader);
            }
        }
        return null;
    }

    public abstract void encode(ImageOutputStream var1, IIOMetadata var2, IIOImage var3, ImageWriteParam var4) throws IOException;
}

