/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.peer.MenuBarPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MenuBar
extends MenuComponent
implements MenuContainer,
Serializable,
Accessible {
    private static final long serialVersionUID = -4930327919388951260L;
    private Menu helpMenu;
    private Vector menus;

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public synchronized void setHelpMenu(Menu menu) {
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        if (this.helpMenu != null) {
            if (menuBarPeer != null) {
                this.helpMenu.removeNotify();
            }
            this.helpMenu.setParent(null);
        }
        this.helpMenu = menu;
        MenuContainer menuContainer = menu.getParent();
        if (menuContainer != null) {
            menuContainer.remove(menu);
        }
        menu.setParent(this);
        if (menuBarPeer != null) {
            menu.addNotify();
            menuBarPeer.addHelpMenu(menu);
        }
    }

    public synchronized Menu add(Menu menu) {
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        MenuContainer menuContainer = menu.getParent();
        if (menuContainer != null) {
            menuContainer.remove(menu);
        }
        this.menus.addElement(menu);
        menu.setParent(this);
        if (menuBarPeer != null) {
            menu.addNotify();
            menuBarPeer.addMenu(menu);
        }
        return menu;
    }

    public synchronized void remove(int n) {
        Menu menu = (Menu)this.menus.remove(n);
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        if (menuBarPeer != null) {
            menu.removeNotify();
        }
        menu.setParent(null);
        if (menuBarPeer != null) {
            menuBarPeer.delMenu(n);
        }
    }

    public void remove(MenuComponent menuComponent) {
        int n = this.menus.indexOf(menuComponent);
        if (n == -1) {
            return;
        }
        this.remove(n);
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        int n = this.menus.size();
        int n2 = 0;
        if (this.getHelpMenu() == null) {
            n2 = 1;
        }
        return n + (1 - n2);
    }

    public Menu getMenu(int n) {
        return (Menu)this.menus.elementAt(n);
    }

    public void addNotify() {
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        if (menuBarPeer == null) {
            menuBarPeer = this.getToolkit().createMenuBar(this);
            this.setPeer(menuBarPeer);
        }
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            menu.addNotify();
            menuBarPeer.addMenu(menu);
        }
        if (this.helpMenu != null) {
            this.helpMenu.addNotify();
            menuBarPeer.addHelpMenu(this.helpMenu);
        }
    }

    public void removeNotify() {
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            menu.removeNotify();
        }
        super.removeNotify();
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            if (menu.getShortcut() == null) continue;
            vector.addElement(menu.getShortcut());
        }
        return vector.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            MenuShortcut menuShortcut2 = menu.getShortcut();
            if (menuShortcut2 == null || !menuShortcut2.equals(menuShortcut)) continue;
            return menu;
        }
        return null;
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        MenuItem menuItem;
        while ((menuItem = this.getShortcutMenuItem(menuShortcut)) != null) {
            menuItem.deleteShortcut();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    private final /* synthetic */ void this() {
        this.menus = new Vector();
    }

    public MenuBar() {
        this.this();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        private static final long serialVersionUID = -8577604491830083815L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        protected AccessibleAWTMenuBar() {
        }
    }
}

