/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.MultilineLabel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class MultilineToggleButton
extends JPanel {
    private JToggleButton _button;
    private MultilineLabel _label;
    public static int CHECKBOX_TYPE = 0;
    public static int RADIOBUTTON_TYPE = 1;

    public MultilineToggleButton(int type, String labelTxt) {
        this._button = type == CHECKBOX_TYPE ? new JCheckBox() : (type == RADIOBUTTON_TYPE ? new JRadioButton() : new JToggleButton());
        this._label = new MultilineLabel(labelTxt);
        this.build();
    }

    private void build() {
        this.setLayout(new BoxLayout(this, 2));
        this.add(this._button);
        this.add(Box.createHorizontalGlue());
        this.add(this._label);
    }

    public void setTopAlignment() {
        this._button.setAlignmentY(0.0f);
        this._label.setAlignmentY(0.0f);
    }

    public void setCenterAlignment() {
        this._button.setAlignmentY(0.5f);
        this._label.setAlignmentY(0.5f);
    }

    public JToggleButton getToggleButton() {
        return this._button;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this._label.setVisible(b);
        this._button.setVisible(b);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this._button.setEnabled(b);
        this._label.setEnabled(b);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        MultilineToggleButton chkCertA = new MultilineToggleButton(CHECKBOX_TYPE, "Very Long Text Goes Here");
        MultilineToggleButton radioButton = new MultilineToggleButton(RADIOBUTTON_TYPE, "Very Long Text");
        frame.setLayout(new BoxLayout(frame.getContentPane(), 1));
        frame.add(chkCertA);
        frame.add(radioButton);
        frame.pack();
        frame.setVisible(true);
    }
}

