/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.annotation.PostConstruct;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.wiztools.restclient.ui.StatusBarPanel;
import org.wiztools.restclient.ui.UIUtil;

public class StatusBarPanelImpl
extends JPanel
implements StatusBarPanel {
    private final JLabel jl_status = new JLabel(" WizTools.org RESTClient ");
    private final JProgressBar jpb_status = new JProgressBar();
    private Calendar statusLastUpdated;

    @PostConstruct
    protected void init() {
        this.statusLastUpdated = Calendar.getInstance();
        new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar c = (Calendar)StatusBarPanelImpl.this.statusLastUpdated.clone();
                c.add(13, 20);
                if (Calendar.getInstance().after(c)) {
                    StatusBarPanelImpl.this.setStatus("WizTools.org RESTClient ");
                }
            }
        }).start();
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new BorderLayout());
        this.jl_status.setFont(UIUtil.FONT_DIALOG_PLAIN);
        this.add((Component)this.jl_status, "Center");
        Dimension d = this.jpb_status.getPreferredSize();
        d.height -= 4;
        this.jpb_status.setPreferredSize(d);
        this.jpb_status.setIndeterminate(true);
        this.jpb_status.setVisible(false);
        this.add((Component)this.jpb_status, "East");
    }

    @Override
    public void setStatus(String status) {
        this.jl_status.setText(" " + status);
        this.jl_status.setToolTipText(status);
        this.statusLastUpdated = Calendar.getInstance();
    }

    @Override
    public void showProgressBar() {
        this.jpb_status.setVisible(true);
    }

    @Override
    public void hideProgressBar() {
        this.jpb_status.setVisible(false);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.setStatus("Cleared!");
    }
}

