<?php

SOY2::import("base.validator.SOY2ActionFormValidator_ArrayValidator");

/**
 * エントリーにラベルをつけます
 */
class  EntryLabelUpdateAction extends SOY2Action{
	
	/**
	 * エントリーID
	 */
	private $id;
	
	function setId($id){
		$this->id  = $id;
	}
		
	protected function execute(SOY2ActionRequest &$request,SOY2ActionForm &$form,SOY2ActionResponse &$response){
		
		$entryid = $this->id;
		$labels = $form->label;
		
		if(!is_array($labels)){
			$labels = array();
		}
		$logic = SOY2Logic::createInstance("logic.site.Entry.EntryLogic");
		try{
			$currentLabels = $logic->getLabeledEntryByEntryId($entryid);
		}catch(Exception $e){
			$currentLabels = array();
		}
		
		
		try{
			
			foreach($labels as $labelId){
				
				if(isset($currentLabels[$labelId])){
					//現在指定されたラベルがすでに割り当てられている。
					unset($currentLabels[$labelId]);
				}else{
					//CMS:PLUGIN callEventFunction
					CMSPlugin::callEventFunc('onEntryLabelApply',array("entryId"=>$entryid,"labelId"=>$labelId));
					$logic->setEntryLabel($entryid, $labelId);	
				}
			}
			
			//ここに残っているcurrentLabelsは消すべきものたち
			foreach($currentLabels as $labelId => $entryLabel){
				$logic->unsetEntryLabel($entryid, $labelId);
			}
			
			CMSPlugin::callEventFunc('afterEntryLabelsApply',array("entryId"=>$entryid));
			
			
			return SOY2Action::SUCCESS;
		}catch(Exception $e){
			$this->setErrorMessage("failed","エントリーのラベル付けに失敗しました。");
			return SOY2Action::FAILED;	
		}

		
	}
	
}

class EntryLabelUpdateActionForm extends SOY2ActionForm{
	
	var $label = array();
	
	/**
	 * @validator Array {"type":"number"}
	 */
	function setLabel($label){
		$this->label = $label;
	}
	
}
?>
