# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "10.5.0",
                "commands": r"gcc",
                "args": r"-O2, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12, -D__STDC_FORMAT_MACROS, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12",
                "linker args": r"-Wl,-zrelro, -L/usr/pkg/lib, -Wl,-R/usr/pkg/lib, -L/usr/lib, -Wl,-R/usr/lib, -O2, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12, -D__STDC_FORMAT_MACROS, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.0.11",
                "commands": r"cython-3.12",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "10.5.0",
                "commands": r"c++",
                "args": r"-O2, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12, -D__STDC_FORMAT_MACROS, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12",
                "linker args": r"-Wl,-zrelro, -L/usr/pkg/lib, -Wl,-R/usr/pkg/lib, -L/usr/lib, -Wl,-R/usr/lib, -O2, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12, -D__STDC_FORMAT_MACROS, -I/usr/pkg/include, -I/usr/include, -I/usr/pkg/include/python3.12",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "10.5.0",
                "commands": r"gfortran",
                "args": r"-O, -fPIC",
                "linker args": r"-Wl,-zrelro, -L/usr/pkg/lib, -Wl,-R/usr/pkg/lib, -L/usr/lib, -Wl,-R/usr/lib, -O, -fPIC",
            },
            "pythran": {
                "version": r"0.17.0",
                "include directory": r"../../../../../../pkg/lib/python3.12/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"powerpc",
                "family": r"ppc",
                "endian": r"big",
                "system": r"netbsd",
            },
            "build": {
                "cpu": r"powerpc",
                "family": r"ppc",
                "endian": r"big",
                "system": r"netbsd",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/pkg/include/netlib",
                "lib directory": r"/usr/pkg/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/pkgsrc/math/py-scipy/work/.buildlink/lib/pkgconfig",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/pkg/include/netlib",
                "lib directory": r"/usr/pkg/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/pkgsrc/math/py-scipy/work/.buildlink/lib/pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.13.6",
                "detection method": "config-tool",
                "include directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"/usr/pkg/bin/python3.12",
            "version": "3.12",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
