/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

public class KunststoffScrollButton
extends MetalScrollButton {
    public KunststoffScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
    }

    public void paint(Graphics g) {
        ColorUIResource colorShadow;
        Rectangle rectShadow;
        Rectangle rectReflection;
        boolean isVertical;
        super.paint(g);
        int width = this.getWidth();
        int height = this.getHeight();
        boolean bl = isVertical = this.getDirection() == 3 || this.getDirection() == 7;
        if (isVertical) {
            rectReflection = new Rectangle(1, 1, width, height / 2);
            rectShadow = new Rectangle(1, height / 2, width, height / 2 + 1);
        } else {
            rectReflection = new Rectangle(1, 1, width / 2, height);
            rectShadow = new Rectangle(width / 2, 1, width / 2 + 1, height);
        }
        ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
        if (colorReflection != null) {
            Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
            KunststoffUtilities.drawGradient(g, colorReflection, colorReflectionFaded, rectReflection, isVertical);
        }
        if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
            Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
            KunststoffUtilities.drawGradient(g, colorShadowFaded, colorShadow, rectShadow, isVertical);
        }
    }
}

