/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console.prefs;

import free.jin.BadChangesException;
import free.jin.GameListConnection;
import free.jin.I18n;
import free.jin.console.ConsoleManager;
import free.jin.ui.PreferencesPanel;
import free.util.swing.PreferredSizedPanel;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public final class BehaviourPrefsPanel
extends PreferencesPanel {
    private final ConsoleManager consoleManager;
    private final JRadioButton embeddedGameLists;
    private final JRadioButton externalGameLists;
    private final JCheckBox copyOnSelect;
    private final JRadioButton textGameLists;

    public BehaviourPrefsPanel(ConsoleManager consoleManager) {
        this.consoleManager = consoleManager;
        I18n i18n = I18n.get((Class)BehaviourPrefsPanel.class);
        if (consoleManager.getConn() instanceof GameListConnection) {
            this.embeddedGameLists = i18n.createRadioButton("embeddedGameListsRadioButton");
            this.externalGameLists = i18n.createRadioButton("externalGameListsRadioButton");
            this.textGameLists = i18n.createRadioButton("textGameListsRadioButton");
            switch (consoleManager.getGameListsDisplayStyle()) {
                case 0: {
                    this.embeddedGameLists.setSelected(true);
                    break;
                }
                case 1: {
                    this.externalGameLists.setSelected(true);
                    break;
                }
                case 2: {
                    this.textGameLists.setSelected(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.embeddedGameLists.addActionListener(this.proxyActionListener);
            this.externalGameLists.addActionListener(this.proxyActionListener);
            this.textGameLists.addActionListener(this.proxyActionListener);
        } else {
            this.embeddedGameLists = null;
            this.externalGameLists = null;
            this.textGameLists = null;
        }
        this.copyOnSelect = i18n.createCheckBox("copyOnSelectCheckBox");
        this.copyOnSelect.setSelected(consoleManager.isCopyOnSelect());
        this.copyOnSelect.addActionListener(this.proxyActionListener);
        this.createUI();
    }

    private void createUI() {
        ButtonGroup buttonGroup;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        I18n i18n = I18n.get((Class)BehaviourPrefsPanel.class);
        if (this.embeddedGameLists != null) {
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.embeddedGameLists);
            buttonGroup.add(this.externalGameLists);
            buttonGroup.add(this.textGameLists);
            PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel();
            preferredSizedPanel.setLayout(new BoxLayout((Container)preferredSizedPanel, 1));
            preferredSizedPanel.setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("gameListsDisplayPanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            this.embeddedGameLists.setAlignmentX(0.0f);
            this.externalGameLists.setAlignmentX(0.0f);
            this.textGameLists.setAlignmentX(0.0f);
            preferredSizedPanel.add(this.embeddedGameLists);
            preferredSizedPanel.add(this.externalGameLists);
            preferredSizedPanel.add(this.textGameLists);
            this.add((Component)preferredSizedPanel);
            this.add(Box.createVerticalStrut(10));
        }
        buttonGroup = new PreferredSizedPanel();
        ((Container)((Object)buttonGroup)).setLayout(new BoxLayout((Container)((Object)buttonGroup), 1));
        ((JComponent)((Object)buttonGroup)).setBorder(BorderFactory.createCompoundBorder(i18n.createTitledBorder("textSelectionPanel"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.copyOnSelect.setAlignmentX(0.0f);
        ((Container)((Object)buttonGroup)).add(this.copyOnSelect);
        this.add((Component)((Object)buttonGroup));
    }

    public void applyChanges() throws BadChangesException {
        if (this.embeddedGameLists != null) {
            if (this.embeddedGameLists.isSelected()) {
                this.consoleManager.setGameListsDisplayStyle(0);
            } else if (this.externalGameLists.isSelected()) {
                this.consoleManager.setGameListsDisplayStyle(1);
            } else {
                this.consoleManager.setGameListsDisplayStyle(2);
            }
        }
        this.consoleManager.setCopyOnSelect(this.copyOnSelect.isSelected());
    }
}

