# This file is part of Tryton.  The COPYRIGHT file at the top level of
# this repository contains the full copyright notices and license terms.
import unittest

from trytond.pool import Pool
from trytond.transaction import Transaction

from .test_tree import TreeTestCaseMixin


class PathTestCase(TreeTestCaseMixin, unittest.TestCase):
    "Test Path"
    model_name = 'test.path'

    def check_tree(self, parent_id=None):
        pool = Pool()
        Path = pool.get(self.model_name)

        with Transaction().set_context(active_test=False):
            children = Path.search([
                    ('parent', '=', parent_id),
                    ])
        for child in children:
            if child.parent:
                self.assertEqual(
                    child.path, '%s%s/' % (child.parent.path, child.id))
            else:
                self.assertEqual(child.path, '%s/' % child.id)
            self.check_tree(child.id)

    def rebuild(self):
        pool = Pool()
        Path = pool.get(self.model_name)
        Path._rebuild_path('parent')


def suite():
    return unittest.TestLoader().loadTestsFromTestCase(PathTestCase)
