package TDS::Admin::WriteServer::Direct;

use strict;
use vars qw(@ISA);

use File::Copy;
use File::Path;
use FileHandle;

use JConv;

use TDS::Collection;
use TDS::Admin::WriteServer;

@ISA = qw(TDS::Admin::WriteServer);

attributes qw();
################################################################

sub Write($$)
{
    my ($self, $content) = @_;

#    die "Direct Writing is NOT allowed"
#	unless $AllowDirectWriting;

    $self->SUPER::Write($content);
    
    # Kanji-code convert
    #jconv(\$body, $TDS::Collection::TdfJcode);
    *conv_i2t = mkjconv('auto', $TDS::Collection::TdfJcode || 'euc');
    conv_i2t(\$content);
    $content =~ s/\r\n/\n/g;    # convert newline
    $content =~ s/\r/\n/g;

    # directory check
    my $dir = $self->GetDirectory;
    unless (-d $dir){
	mkpath($dir, 0, 0755);
    }
    # backup
    my $filename = $self->GetFilename;
    if (-f $filename){
	copy($filename, "${filename}-bak");
    }

    my $fh = new FileHandle;
    $fh->open(">$filename") || die "cannot write to $filename";
    print $fh $content;
    $fh->close;
}


1;
