/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.FileSet;

public final class BatchTest
extends BaseTest {
    private Project project;
    private Vector filesets = new Vector();

    public BatchTest(Project project) {
        this.project = project;
    }

    public void addFileSet(FileSet fs) {
        this.filesets.addElement(fs);
    }

    public final Enumeration elements() {
        Object[] tests = this.createAllJUnitTest();
        return Enumerations.fromArray(tests);
    }

    final void addTestsTo(Vector v) {
        JUnitTest[] tests = this.createAllJUnitTest();
        v.ensureCapacity(v.size() + tests.length);
        for (int i = 0; i < tests.length; ++i) {
            v.addElement(tests[i]);
        }
    }

    private JUnitTest[] createAllJUnitTest() {
        String[] filenames = this.getFilenames();
        JUnitTest[] tests = new JUnitTest[filenames.length];
        for (int i = 0; i < tests.length; ++i) {
            String classname = BatchTest.javaToClass(filenames[i]);
            tests[i] = this.createJUnitTest(classname);
        }
        return tests;
    }

    private String[] getFilenames() {
        Vector<String> v = new Vector<String>();
        int size = this.filesets.size();
        for (int j = 0; j < size; ++j) {
            FileSet fs = (FileSet)this.filesets.elementAt(j);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            ds.scan();
            String[] f = ds.getIncludedFiles();
            for (int k = 0; k < f.length; ++k) {
                String pathname = f[k];
                if (pathname.endsWith(".java")) {
                    v.addElement(pathname.substring(0, pathname.length() - ".java".length()));
                    continue;
                }
                if (!pathname.endsWith(".class")) continue;
                v.addElement(pathname.substring(0, pathname.length() - ".class".length()));
            }
        }
        Object[] files = new String[v.size()];
        v.copyInto(files);
        return files;
    }

    public static final String javaToClass(String filename) {
        return filename.replace(File.separatorChar, '.');
    }

    private JUnitTest createJUnitTest(String classname) {
        JUnitTest test = new JUnitTest();
        test.setName(classname);
        test.setHaltonerror(this.haltOnError);
        test.setHaltonfailure(this.haltOnFail);
        test.setFiltertrace(this.filtertrace);
        test.setFork(this.fork);
        test.setIf(this.ifProperty);
        test.setUnless(this.unlessProperty);
        test.setTodir(this.destDir);
        test.setFailureProperty(this.failureProperty);
        test.setErrorProperty(this.errorProperty);
        Enumeration list = this.formatters.elements();
        while (list.hasMoreElements()) {
            test.addFormatter((FormatterElement)list.nextElement());
        }
        return test;
    }
}

