/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.Piece;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;
import free.chess.WildVariant;

public abstract class Move {
    protected final Square startingSquare;
    protected final Square endingSquare;
    protected final Player player;
    private final String stringRepresentation;

    public Move(Square square, Square square2, Player player, String string) {
        if (player == null) {
            throw new IllegalArgumentException("The moving player may not be null");
        }
        this.startingSquare = square;
        this.endingSquare = square2;
        this.player = player;
        this.stringRepresentation = string;
    }

    public Square getStartingSquare() {
        return this.startingSquare;
    }

    public Square getEndingSquare() {
        return this.endingSquare;
    }

    public Player getPlayer() {
        return this.player;
    }

    public final String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public String getMoveString() {
        Square square = this.getStartingSquare();
        Square square2 = this.getEndingSquare();
        String string = square == null ? "??" : square.toString();
        String string2 = square2 == null ? "??" : square2.toString();
        return string + string2;
    }

    public static Move parseWarrenSmith(String string, Position position, String string2) {
        WildVariant wildVariant = position.getVariant();
        char c = string.charAt(string.length() - 1);
        if (c == 'c') {
            return wildVariant.createShortCastling(position);
        }
        if (c == 'C') {
            return wildVariant.createLongCastling(position);
        }
        Square square = Square.parseSquare(string.substring(0, 2));
        Square square2 = Square.parseSquare(string.substring(2, 4));
        Piece piece = null;
        if ("NBRQK".indexOf(c) != -1) {
            String string3 = String.valueOf(string.charAt(string.length() - 1));
            if (position.getCurrentPlayer().isBlack()) {
                string3 = string3.toLowerCase();
            }
            piece = wildVariant.parsePiece(string3);
        }
        return wildVariant.createMove(position, square, square2, piece, string2);
    }

    public String toString() {
        if (this.getStringRepresentation() == null) {
            return this.getMoveString();
        }
        return this.getStringRepresentation();
    }
}

