/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.Pair;
import free.util.UnsupportedOperationException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;

public class TableLayout
implements LayoutManager2 {
    private final int columnCount;
    private final int xGap;
    private final int yGap;
    private final Vector rows = new Vector();

    public TableLayout(int n, int n2, int n3) {
        if (n <= 0) {
            throw new IllegalArgumentException("The amount of columns must be positive");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The horizontal gap may not be negative: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("The vertical gap may not be negative: " + n3);
        }
        this.columnCount = n;
        this.xGap = n2;
        this.yGap = n3;
    }

    public TableLayout(int n) {
        this(n, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            int n = this.rows.size();
            for (int i = 0; i < n; ++i) {
                Component[] componentArray = (Component[])this.rows.elementAt(i);
                for (int j = 0; j < componentArray.length; ++j) {
                    if (componentArray[j] != null) continue;
                    componentArray[j] = component;
                    return;
                }
            }
            Component[] componentArray = new Component[this.columnCount];
            componentArray[0] = component;
            this.rows.addElement(componentArray);
        }
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("deprecated addLayoutComponent(String, Component)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            int n;
            Component[] componentArray;
            int n2;
            int n3 = this.rows.size();
            block3: for (n2 = 0; n2 < n3; ++n2) {
                componentArray = (Component[])this.rows.elementAt(n2);
                for (n = 0; n < componentArray.length; ++n) {
                    if (componentArray[n] != component) continue;
                    componentArray[n] = null;
                    break block3;
                }
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                componentArray = (Component[])this.rows.elementAt(n2);
                n = 1;
                for (int i = 0; i < componentArray.length; ++i) {
                    if (componentArray[i] == null) continue;
                    n = 0;
                    break;
                }
                if (n == 0) break;
                this.rows.removeElementAt(n2);
            }
        }
    }

    private Dimension[][] getPreferredSizes(Container container) {
        int n = this.rows.size();
        Dimension[][] dimensionArray = new Dimension[n][this.columnCount];
        for (int i = 0; i < n; ++i) {
            Component component;
            Component[] componentArray = (Component[])this.rows.elementAt(i);
            for (int j = 0; j < this.columnCount && (component = componentArray[j]) != null; ++j) {
                if (component.getParent() != container) {
                    throw new IllegalStateException("Bad parent specified");
                }
                dimensionArray[i][j] = component.getPreferredSize();
            }
        }
        return dimensionArray;
    }

    private Pair calculateLayout(Dimension[][] dimensionArray) {
        int n = this.rows.size();
        int[] nArray = new int[this.columnCount];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            Dimension dimension;
            for (int j = 0; j < this.columnCount && (dimension = dimensionArray[i][j]) != null; ++j) {
                nArray[j] = Math.max(nArray[j], dimension.width);
                nArray2[i] = Math.max(nArray2[i], dimension.height);
            }
        }
        return new Pair(nArray, nArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = this.rows.size();
            Insets insets = container.getInsets();
            Dimension[][] dimensionArray = this.getPreferredSizes(container);
            Pair pair = this.calculateLayout(dimensionArray);
            int[] nArray = (int[])pair.getFirst();
            int[] nArray2 = (int[])pair.getSecond();
            Dimension dimension = this.calculatePreferredLayoutSize(container, nArray, nArray2);
            Dimension dimension2 = container.getSize();
            Dimension dimension3 = new Dimension(dimension2.width - this.xGap * (n - 1) - insets.left - insets.right, dimension2.height - this.yGap * (this.columnCount - 1) - insets.top - insets.bottom);
            Dimension dimension4 = new Dimension(dimension.width - this.xGap * (n - 1) - insets.left - insets.right, dimension.height - this.yGap * (this.columnCount - 1) - insets.top - insets.bottom);
            int n2 = insets.top;
            for (int i = 0; i < n; ++i) {
                int n3 = insets.left;
                int n4 = nArray2[i] * dimension3.height / dimension4.height;
                Component[] componentArray = (Component[])this.rows.elementAt(i);
                for (int j = 0; j < componentArray.length; ++j) {
                    int n5 = nArray[j] * dimension3.width / dimension4.width;
                    Component component = componentArray[j];
                    if (component == null) break;
                    Dimension dimension5 = component.getMaximumSize();
                    int n6 = Math.min(dimension5.width, n5);
                    int n7 = Math.min(dimension5.height, n4);
                    int n8 = n3 + (int)((float)(n5 - n6) * component.getAlignmentX());
                    int n9 = n2 + (int)((float)(n4 - n7) * component.getAlignmentY());
                    component.setBounds(n8, n9, n6, n7);
                    n3 += n5 + this.xGap;
                }
                n2 += n4 + this.yGap;
            }
        }
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension[][] dimensionArray = this.getPreferredSizes(container);
            Pair pair = this.calculateLayout(dimensionArray);
            int[] nArray = (int[])pair.getFirst();
            int[] nArray2 = (int[])pair.getSecond();
            return this.calculatePreferredLayoutSize(container, nArray, nArray2);
        }
    }

    private Dimension calculatePreferredLayoutSize(Container container, int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        for (n = 0; n < nArray2.length; ++n) {
            n3 += nArray2[n];
        }
        n2 += this.xGap * (nArray.length - 1);
        n3 += this.yGap * (nArray2.length - 1);
        Insets insets = container.getInsets();
        return new Dimension(n2 += insets.left + insets.right, n3 += insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }
}

