/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

abstract class ByteCharset
extends Charset {
    protected static final char NONE = '\ufffd';
    protected char[] lookupTable;

    public boolean contains(Charset charset) {
        boolean bl = false;
        if (charset instanceof US_ASCII || charset.getClass() == this.getClass()) {
            bl = true;
        }
        return bl;
    }

    char[] getLookupTable() {
        return this.lookupTable;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    ByteCharset(String string, String[] stringArray) {
        super(string, stringArray);
    }

    private static final class Decoder
    extends CharsetDecoder {
        private char[] lookup;

        protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                if (!charBuffer.hasRemaining()) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                char c = this.lookup[by & 0xFF];
                charBuffer.put(c);
            }
            return CoderResult.UNDERFLOW;
        }

        Decoder(ByteCharset byteCharset) {
            super(byteCharset, 1.0f, 1.0f);
            this.lookup = byteCharset.getLookupTable();
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private byte[] lookup;

        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            while (charBuffer.hasRemaining()) {
                byte by;
                char c = charBuffer.get();
                if (!byteBuffer.hasRemaining()) {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                byte by2 = 0;
                if (c < this.lookup.length) {
                    by2 = this.lookup[c];
                }
                if ((by = by2) != 0 || c == '\u0000') {
                    byteBuffer.put(by);
                    continue;
                }
                charBuffer.position(charBuffer.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            return CoderResult.UNDERFLOW;
        }

        Encoder(ByteCharset byteCharset) {
            super(byteCharset, 1.0f, 1.0f);
            char c;
            char[] cArray = byteCharset.getLookupTable();
            char c2 = '\u0000';
            int n = 0;
            while (n < cArray.length) {
                c = cArray[n];
                c2 = c > c2 && c < '\ufffd' ? c : c2;
                ++n;
            }
            this.lookup = new byte[c2 + 1];
            n = 0;
            while (n < cArray.length) {
                c = cArray[n];
                if (c != '\u0000' && c < '\ufffd') {
                    this.lookup[c] = (byte)n;
                }
                ++n;
            }
        }
    }
}

