/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.dss.FIPS186;
import gnu.java.security.provider.Gnu;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DSSParametersGenerator
extends AlgorithmParameterGeneratorSpi {
    private static final Provider GNU = new Gnu();
    private int modulusLength;
    private SecureRandom rnd;
    private FIPS186 fips;

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n % 64 != 0 || n < 512 || n > 1024) {
            throw new InvalidParameterException("Modulus size/length (in bits) MUST be a multiple of 64, greater than or equal to 512, and less than or equal to 1024");
        }
        this.modulusLength = n;
        this.rnd = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Wrong AlgorithmParameterSpec type: " + algorithmParameterSpec.getClass().getName());
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        BigInteger bigInteger = dSAParameterSpec.getP();
        int n = bigInteger.bitLength();
        this.engineInit(n, secureRandom);
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.modulusLength < 1) {
            this.modulusLength = 1024;
        }
        this.fips = new FIPS186(this.modulusLength, this.rnd);
        BigInteger[] bigIntegerArray = this.fips.generateParameters();
        BigInteger bigInteger = bigIntegerArray[3];
        BigInteger bigInteger2 = bigIntegerArray[2];
        BigInteger bigInteger3 = bigIntegerArray[5];
        DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(bigInteger, bigInteger2, bigInteger3);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("dss", GNU);
            algorithmParameters.init(dSAParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        return algorithmParameters;
    }

    private final /* synthetic */ void this() {
        this.modulusLength = -1;
    }

    public DSSParametersGenerator() {
        this.this();
    }
}

