/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_DATASET_H__
#define __SG_PLUGIN_DATASET_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"
#include "sg_dataset.h"
#include "sg_application.h"

#define SG_PLUGIN_DATASET(obj)        GTK_CHECK_CAST (obj, sg_plugin_dataset_get_type (), SGpluginDataset)
#define GTK_TYPE_SG_PLUGIN_DATASET   (sg_plugin_dataset_get_type ())
  
#define SG_PLUGIN_DATASET_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_dataset_get_type(), SGpluginDatasetClass)
#define GTK_IS_SG_PLUGIN_DATASET(obj)     GTK_CHECK_TYPE (obj, sg_plugin_dataset_get_type ())


typedef struct _SGpluginDataset   SGpluginDataset;
typedef struct _SGpluginDatasetClass   SGpluginDatasetClass;

struct _SGpluginDataset
{
  SGplugin plugin;

  gint min_independent_dims; /* minimum independent dimensions */
  gint max_independent_dims; /* maximum independent dimensions */
  gint min_dependent_dims; /* minimum dependent dimensions */
  gint max_dependent_dims; /* maximum dependent dimensions */
  gchar *style;  /* only if this iterator works with one particular style */
                                                                                
  SGdataset* (*construct)		(void);

  SGdataset* (*new_dataset_dialog) 	(SGpluginDataset *plugin, 
                                         SGpluginStyle *style,
		  			 SGapplication *app);
  SGdataset* (*edit_dataset_dialog) 	(SGpluginDataset *plugin, 
					 SGdataset *dataset,
		  			 SGapplication *app);

};

struct _SGpluginDatasetClass
{
  SGpluginClass parent_class;
};

GtkType         sg_plugin_dataset_get_type      ();
SGpluginDataset * sg_plugin_dataset_new         ();
SGdataset* 	sg_plugin_dataset_construct	(SGpluginDataset *plugin,
						 SGpluginStyle *style);	
SGdataset* 	sg_plugin_dataset_new_dialog	(SGpluginDataset *plugin,
						 SGpluginStyle *style,
						 SGapplication *app);
SGdataset* 	sg_plugin_dataset_edit_dialog	(SGpluginDataset *plugin,
						 SGdataset *dataset,
						 SGapplication *app);
SGpluginDataset * sg_plugin_dataset_get         (const gchar *name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_DATASET_H__ */

