/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.parosproxy.paros.db.AbstractTable;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class TableSession
extends AbstractTable {
    private static final String SESSIONID = "SESSIONID";
    private static final String SESSIONNAME = "SESSIONNAME";
    private static final String LASTACCESS = "LASTACCESS";
    private PreparedStatement psReadDate = null;
    private PreparedStatement psReadAll = null;
    private PreparedStatement psInsert = null;
    private PreparedStatement psUpdate = null;

    protected void reconnect(Connection connection) throws SQLException {
        this.psReadDate = connection.prepareStatement("SELECT * FROM SESSION WHERE LASTACCESS < ?");
        this.psReadAll = connection.prepareStatement("SELECT * FROM SESSION");
        this.psInsert = connection.prepareStatement("INSERT INTO SESSION (SESSIONID,SESSIONNAME) VALUES (?, ?)");
        this.psUpdate = connection.prepareStatement("UPDATE SESSION SET SESSIONNAME = ?,LASTACCESS = NOW WHERE SESSIONID = ?");
    }

    public synchronized void insert(long l, String string) throws SQLException {
        this.psInsert.setLong(1, l);
        this.psInsert.setString(2, string);
        this.psInsert.executeUpdate();
    }

    public synchronized void update(long l, String string) throws SQLException {
        this.psUpdate.setLong(2, l);
        this.psUpdate.setString(1, string);
        this.psUpdate.executeUpdate();
    }

    private RecordSession build(ResultSet resultSet) throws HttpMalformedHeaderException, SQLException {
        RecordSession recordSession = null;
        if (resultSet.next()) {
            recordSession = new RecordSession(resultSet.getLong(SESSIONID), resultSet.getString(SESSIONNAME), resultSet.getDate(LASTACCESS));
        }
        return recordSession;
    }
}

