/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.action;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.bluecow.spectro.Clip;

public class SaveAction
extends AbstractAction {
    private static final boolean PROMPT_ON_OVERWRITE = System.getProperty("mrj.version") != null;
    private final Clip clip;
    private final Component dialogOwner;

    public SaveAction(Clip clip, Component dialogOwner) {
        super("Save...");
        this.clip = clip;
        this.dialogOwner = dialogOwner;
        if (dialogOwner == null) {
            throw new NullPointerException("You have to specify an owning component for the save dialog");
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            boolean promptAgain;
            Window owner = this.dialogOwner instanceof Window ? (Window)this.dialogOwner : SwingUtilities.getWindowAncestor(this.dialogOwner);
            FileDialog fd = owner instanceof Frame ? new FileDialog((Frame)owner, "Save sample as", 1) : new FileDialog((Dialog)owner, "Save sample as", 1);
            File targetFile = null;
            do {
                promptAgain = false;
                fd.setVisible(true);
                String dir = fd.getDirectory();
                String fileName = fd.getFile();
                if (fileName == null) {
                    return;
                }
                if (!fileName.toLowerCase().endsWith(".wav")) {
                    fileName = fileName + ".wav";
                }
                targetFile = new File(dir, fileName);
                if (!PROMPT_ON_OVERWRITE || !targetFile.exists()) continue;
                int choice = JOptionPane.showOptionDialog(owner, "The file " + targetFile + " exists.\nDo you want to replace it?", "File exists", -1, 2, null, new String[]{"Replace", "Cancel"}, "Replace");
                if (choice == 0) {
                    promptAgain = false;
                    continue;
                }
                if (choice == 1) {
                    promptAgain = true;
                    continue;
                }
                if (choice == -1) {
                    return;
                }
                throw new RuntimeException("Unrecognized choice: " + choice);
            } while (promptAgain);
            AudioSystem.write(this.clip.getAudio(), AudioFileFormat.Type.WAVE, targetFile);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

