# Copyright (C) 2001-2003 Hewlett-Packard Corporation
# Licensed under the GNU General Public License
#  $Id: Patches.pm,v 1.31 2003/11/25 23:19:26 tyler_e Exp $
package Bastille::Patches;

use Bastille::API;

@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

delete $ENV{BASH_ENV};


#######################################################################
##                          Patches Module                            #
#######################################################################
#
# The purpose of this module is to Install Security Patch Check and/or
# configure it.

&InstallSPC;
&SpcRun;
&CronSPC;

sub InstallSPC {
    my $spc = &getGlobal('FILE','spc');
    if ( &GetDistro =~ "^HP-UX" and !( -e $spc ) ) {
	&B_log("DEBUG","# sub InstallSPC\n");
	my $spc_install_text = 
	    "\n---------------------------------\n" .
	    "Security Patch Check:\n" .
	    "---------------------------------\n" .
	    "Patching known security vulnerabilities is one of the most\n" .
	    "important steps you can take to secure a system. Security\n" .
	    "Patch Check is a tool which analyzes the software installed\n" .
	    "on your system.  It will tell you if any relevant security\n" .
	    "patches have been announced by Hewlett Packard that are not\n" .
	    "currently installed on your system.  Bastille has detected\n" .
	    "that you have not installed this tool.\n\n" .

	    "Please install Security Patch Check.  You can get it at:\n" . 
	    "   http://www.software.hp.com/cgi-bin/swdepot_parser.cgi/cgi/displayProductInfo.pl?productNumber=B6834AA\n".
	    "or alternatively, going to www.software.hp.com and selecting the security product category.\n";
	
	&B_TODO($spc_install_text);
    }
}

# To successfully run SPC in the cron and at Bastille run-time, the root user must accept the disclaimer

sub SpcRun {
    if ((&getGlobalConfig("Patches","spc_run") eq "Y")) {
        &B_log("DEBUG","# sub SpcRun\n");
	my $proxy = "";
	if(&getGlobalConfig("Patches","spc_proxy_yn") eq "Y") {
	    $proxy = &getGlobalConfig("Patches","spc_proxy");
	}

	if ($proxy ne "") {           # set proxy variable to the user's answer if one exists
	    $proxy = "export ftp_proxy=" . $proxy . "; ";
	}
	&B_TODO("\n---------------------------------\nInstall Security Patches:\n" .
		"---------------------------------\n" .
		"Please read the security patch information that has been placed\n" . 
		"in the following file and install patches as appropriate:\n\t" . 
		&getGlobal('BFILE',"required_security_patches") . "\n\n" .
		"It is also recommended that you subscribe to the HP Security\n" . 
		"Bulletin mailing list\n\n");
	
        my $spc = &getGlobal('FILE','spc');
	my $envexport = "export FTP_PASSIVE=1; export PATH=/usr/bin:/sbin;";
	my $catalogdir = &getGlobal('BDIR',"home");
	my $patchInfo = `$envexport $proxy $spc -r -q -d -c $catalogdir/security_catalog 2>&1` . "\n\n";
	
	&B_create_file(&getGlobal('BFILE',"required_security_patches"));
	&B_blank_file(&getGlobal('BFILE',"required_security_patches"), 'a$b');
	&B_append_line(&getGlobal('BFILE',"required_security_patches"),'a$b',$patchInfo);
    }
}

sub CronSPC {
    if ((&getGlobalConfig("Patches","spc_cron_run") eq "Y") || 
	(&getGlobalConfig("Patches","spc_cron_norun") eq "Y")) {
        &B_log("DEBUG","# sub CronSPC\n");
	my $proxy = "";
	if(&getGlobalConfig("Patches","spc_proxy_yn") eq "Y") {
	    $proxy = &getGlobalConfig("Patches","spc_proxy");
	}
	    
	my $umask = &getGlobal('BIN',"umask") . " 077;";
	my $envexport = "$umask export FTP_PASSIVE=1; export PATH=/usr/bin:/sbin;";
	my $catalogdir = &getGlobal('BDIR',"home");
	if ($proxy ne "") {      # set proxy variable to the user's answer if one exists
	    $proxy = "export ftp_proxy=" . $proxy . "; ";
	}
      

        my $mailprogram = &getGlobal('BIN','mail');
        my $uname = &getGlobal('BIN','uname');
	my $unameInfo = `$uname -n`;
	chomp $unameInfo;
        my $emailAddr='root@localhost';
	my $emailSub="Security Patch Check Results for $unameInfo";

	srand; # seed the random number generator (should this use system time?)
               # this is to prevent everyone from trying to access the ftp server
	       # at the same time.
	my $minute = int(rand(60));

	# set up the cron file for root
        my $spc=&getGlobal('FILE','spc');
        my $line = "$minute " . &getGlobalConfig("Patches", 'spc_cron_time') . 
                   " * * * ($envexport $proxy $spc" . 
                   " -r -q -d -c $catalogdir/security_catalog 2>&1 | " .
		   "$mailprogram -s \"$emailSub\" $emailAddr )";
        &B_Schedule($spc,$line);

    }
}

1;
