/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.SystemProperties;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.OverflowException;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.RecordingInputStream;
import gnu.javax.net.ssl.provider.Session;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLProtocolException;

class RecordInput {
    private static final boolean DEBUG_RECORD_LAYER = true;
    private static final Logger logger = SystemLogger.SYSTEM;
    private byte[] fragment;
    private int index;
    private ContentType type;
    private final DataInputStream in;
    private Session session;

    synchronized int available(ContentType contentType) throws IOException {
        if (this.fragment == null) {
            this.readRecord();
        }
        if (contentType != this.type) {
            return 0;
        }
        return this.fragment.length - this.index;
    }

    void setSession(Session session) {
        this.session = session;
    }

    synchronized int read(byte[] byArray, int n, int n2, ContentType contentType) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("size=" + byArray.length + " off=" + n + " len=" + n2);
        }
        if (this.fragment == null || this.index >= this.fragment.length) {
            this.readRecord();
        }
        if (contentType != this.type) {
            return 0;
        }
        n2 = Math.min(n2, this.fragment.length - this.index);
        System.arraycopy(this.fragment, this.index, byArray, n, n2);
        this.index += n2;
        return n2;
    }

    boolean pollClose() throws IOException {
        if (this.fragment == null || this.index >= this.fragment.length) {
            try {
                this.readRecord();
            }
            catch (AlertException alertException) {
                Alert alert = alertException.getAlert();
                if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                    return true;
                }
                throw alertException;
            }
        }
        return false;
    }

    private final void readRecord() throws IOException {
        this.type = ContentType.read(this.in);
        if ((this.type.getValue() & 0x80) != 0 || (this.type.getValue() & 0x40) != 0) {
            this.in.read();
            if ((this.type.getValue() & 0x40) != 0) {
                this.in.read();
            }
            this.type = ContentType.read(this.in);
            if (this.type != ContentType.CLIENT_HELLO_V2) {
                throw new SSLProtocolException("unsupported V2 message");
            }
            this.type = ContentType.HANDSHAKE;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            byteArrayOutputStream.write(1);
            RecordingInputStream recordingInputStream = new RecordingInputStream(this.in, byteArrayOutputStream);
            ProtocolVersion protocolVersion = ProtocolVersion.read(recordingInputStream);
            if (protocolVersion.compareTo(ProtocolVersion.SSL_3) < 0) {
                throw new SSLProtocolException("unsupported client version");
            }
            int n = (recordingInputStream.read() & 0xFF) << 8 | recordingInputStream.read() & 0xFF;
            n += (recordingInputStream.read() & 0xFF) << 8 | recordingInputStream.read() & 0xFF;
            n += (recordingInputStream.read() & 0xFF) << 8 | recordingInputStream.read() & 0xFF;
            int n2 = 0;
            while (n2 < n) {
                int n3 = (int)recordingInputStream.skip(n - n2);
                if (n3 <= 0) continue;
                n2 += n3;
            }
            this.fragment = byteArrayOutputStream.toByteArray();
            this.index = 0;
            return;
        }
        ProtocolVersion protocolVersion = ProtocolVersion.read(this.in);
        int n = this.in.readUnsignedShort();
        if (n > this.session.params.getFragmentLength() + 2048) {
            throw new OverflowException();
        }
        this.fragment = new byte[n];
        this.in.readFully(this.fragment);
        logger.log((Level)Component.SSL_RECORD_LAYER, ">> READ RECORD <<{4}struct {{4}  type = {0};{4}  version = {1};{4}  length = {2};{4}{3}{4}} TLSCiphertext;", new Object[]{this.type, protocolVersion, new Integer(n), Util.hexDump(this.fragment, "  "), SystemProperties.getProperty("line.separator")});
        this.fragment = this.session.params.decrypt(this.fragment, protocolVersion, this.type);
        this.index = 0;
        if (this.session.random != null) {
            this.session.random.setSeed(this.fragment);
        }
        if (this.type == ContentType.ALERT) {
            Alert alert;
            this.session.currentAlert = alert = Alert.read(new ByteArrayInputStream(this.fragment));
        }
        if (this.session.currentAlert != null) {
            throw new AlertException(this.session.currentAlert, false);
        }
    }

    RecordInput(InputStream inputStream, Session session) {
        this.in = new DataInputStream(inputStream);
        this.session = session;
    }
}

