<?php
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.
// Please pull this list from, and only from https://publicsuffix.org/list/public_suffix_list.dat,
// rather than any other VCS sites. Pulling from any other URL is not guaranteed to be supported.
// VERSION: 2025-03-28_19-52-32_UTC
// COMMIT: b39e35ef3835c5db7aaf311c179fc1f6d92b92d5
// Instructions on pulling and using this list can be found at https://publicsuffix.org/list/.

return [
 'ac' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'drr' => true,
  'feedback' => true,
  'forms' => true
 ],
 'ad' => true,
 'ae' => [
  'ac' => true,
  'co' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'sch' => true
 ],
 'aero' => [
  'airline' => true,
  'airport' => true,
  'accident-investigation' => true,
  'accident-prevention' => true,
  'aerobatic' => true,
  'aeroclub' => true,
  'aerodrome' => true,
  'agents' => true,
  'air-surveillance' => true,
  'air-traffic-control' => true,
  'aircraft' => true,
  'airtraffic' => true,
  'ambulance' => true,
  'association' => true,
  'author' => true,
  'ballooning' => true,
  'broker' => true,
  'caa' => true,
  'cargo' => true,
  'catering' => true,
  'certification' => true,
  'championship' => true,
  'charter' => true,
  'civilaviation' => true,
  'club' => true,
  'conference' => true,
  'consultant' => true,
  'consulting' => true,
  'control' => true,
  'council' => true,
  'crew' => true,
  'design' => true,
  'dgca' => true,
  'educator' => true,
  'emergency' => true,
  'engine' => true,
  'engineer' => true,
  'entertainment' => true,
  'equipment' => true,
  'exchange' => true,
  'express' => true,
  'federation' => true,
  'flight' => true,
  'freight' => true,
  'fuel' => true,
  'gliding' => true,
  'government' => true,
  'groundhandling' => true,
  'group' => true,
  'hanggliding' => true,
  'homebuilt' => true,
  'insurance' => true,
  'journal' => true,
  'journalist' => true,
  'leasing' => true,
  'logistics' => true,
  'magazine' => true,
  'maintenance' => true,
  'marketplace' => true,
  'media' => true,
  'microlight' => true,
  'modelling' => true,
  'navigation' => true,
  'parachuting' => true,
  'paragliding' => true,
  'passenger-association' => true,
  'pilot' => true,
  'press' => true,
  'production' => true,
  'recreation' => true,
  'repbody' => true,
  'res' => true,
  'research' => true,
  'rotorcraft' => true,
  'safety' => true,
  'scientist' => true,
  'services' => true,
  'show' => true,
  'skydiving' => true,
  'software' => true,
  'student' => true,
  'taxi' => true,
  'trader' => true,
  'trading' => true,
  'trainer' => true,
  'union' => true,
  'workinggroup' => true,
  'works' => true
 ],
 'af' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'ag' => [
  'co' => true,
  'com' => true,
  'net' => true,
  'nom' => true,
  'org' => true,
  'obj' => true
 ],
 'ai' => [
  'com' => true,
  'net' => true,
  'off' => true,
  'org' => true,
  'uwu' => true,
  'framer' => true
 ],
 'al' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'am' => [
  'co' => true,
  'com' => true,
  'commune' => true,
  'net' => true,
  'org' => true,
  'radio' => true
 ],
 'ao' => [
  'co' => true,
  'ed' => true,
  'edu' => true,
  'gov' => true,
  'gv' => true,
  'it' => true,
  'og' => true,
  'org' => true,
  'pb' => true
 ],
 'aq' => true,
 'ar' => [
  'bet' => true,
  'com' => true,
  'coop' => true,
  'edu' => true,
  'gob' => true,
  'gov' => true,
  'int' => true,
  'mil' => true,
  'musica' => true,
  'mutual' => true,
  'net' => true,
  'org' => true,
  'senasa' => true,
  'tur' => true
 ],
 'arpa' => [
  'e164' => true,
  'home' => true,
  'in-addr' => true,
  'ip6' => true,
  'iris' => true,
  'uri' => true,
  'urn' => true
 ],
 'as' => [
  'gov' => true
 ],
 'asia' => [
  'cloudns' => true,
  'daemon' => true,
  'dix' => true
 ],
 'at' => [
  'ac' => [
   'sth' => true
  ],
  'co' => true,
  'gv' => true,
  'or' => true,
  'funkfeuer' => [
   'wien' => true
  ],
  'futurecms' => [
   '*' => true,
   'ex' => [
    '*' => true
   ],
   'in' => [
    '*' => true
   ]
  ],
  'futurehosting' => true,
  'futuremailing' => true,
  'ortsinfo' => [
   'ex' => [
    '*' => true
   ],
   'kunden' => [
    '*' => true
   ]
  ],
  'biz' => true,
  'info' => true,
  '123webseite' => true,
  'priv' => true,
  'myspreadshop' => true,
  '12hp' => true,
  '2ix' => true,
  '4lima' => true,
  'lima-city' => true
 ],
 'au' => [
  'asn' => true,
  'com' => [
   'cloudlets' => [
    'mel' => true
   ],
   'myspreadshop' => true
  ],
  'edu' => [
   'act' => true,
   'catholic' => true,
   'nsw' => [
    'schools' => true
   ],
   'nt' => true,
   'qld' => true,
   'sa' => true,
   'tas' => true,
   'vic' => true,
   'wa' => true
  ],
  'gov' => [
   'qld' => true,
   'sa' => true,
   'tas' => true,
   'vic' => true,
   'wa' => true
  ],
  'id' => true,
  'net' => true,
  'org' => true,
  'conf' => true,
  'oz' => true,
  'act' => true,
  'nsw' => true,
  'nt' => true,
  'qld' => true,
  'sa' => true,
  'tas' => true,
  'vic' => true,
  'wa' => true
 ],
 'aw' => [
  'com' => true
 ],
 'ax' => true,
 'az' => [
  'biz' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'int' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'pp' => true,
  'pro' => true
 ],
 'ba' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'rs' => true
 ],
 'bb' => [
  'biz' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'net' => true,
  'org' => true,
  'store' => true,
  'tv' => true
 ],
 'bd' => [
  '*' => true
 ],
 'be' => [
  'ac' => true,
  'cloudns' => true,
  'webhosting' => true,
  'interhostsolutions' => [
   'cloud' => true
  ],
  'kuleuven' => [
   'ezproxy' => true
  ],
  '123website' => true,
  'myspreadshop' => true,
  'transurl' => [
   '*' => true
  ]
 ],
 'bf' => [
  'gov' => true
 ],
 'bg' => [
  '0' => true,
  '1' => true,
  '2' => true,
  '3' => true,
  '4' => true,
  '5' => true,
  '6' => true,
  '7' => true,
  '8' => true,
  '9' => true,
  'a' => true,
  'b' => true,
  'c' => true,
  'd' => true,
  'e' => true,
  'f' => true,
  'g' => true,
  'h' => true,
  'i' => true,
  'j' => true,
  'k' => true,
  'l' => true,
  'm' => true,
  'n' => true,
  'o' => true,
  'p' => true,
  'q' => true,
  'r' => true,
  's' => true,
  't' => true,
  'u' => true,
  'v' => true,
  'w' => true,
  'x' => true,
  'y' => true,
  'z' => true,
  'barsy' => true
 ],
 'bh' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'bi' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'or' => true,
  'org' => true
 ],
 'biz' => [
  'activetrail' => true,
  'cloud-ip' => true,
  'cloudns' => true,
  'jozi' => true,
  'dyndns' => true,
  'for-better' => true,
  'for-more' => true,
  'for-some' => true,
  'for-the' => true,
  'selfip' => true,
  'webhop' => true,
  'orx' => true,
  'mmafan' => true,
  'myftp' => true,
  'no-ip' => true,
  'dscloud' => true
 ],
 'bj' => [
  'africa' => true,
  'agro' => true,
  'architectes' => true,
  'assur' => true,
  'avocats' => true,
  'co' => true,
  'com' => true,
  'eco' => true,
  'econo' => true,
  'edu' => true,
  'info' => true,
  'loisirs' => true,
  'money' => true,
  'net' => true,
  'org' => true,
  'ote' => true,
  'restaurant' => true,
  'resto' => true,
  'tourism' => true,
  'univ' => true
 ],
 'bm' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'bn' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'co' => true
 ],
 'bo' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'int' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'tv' => true,
  'web' => true,
  'academia' => true,
  'agro' => true,
  'arte' => true,
  'blog' => true,
  'bolivia' => true,
  'ciencia' => true,
  'cooperativa' => true,
  'democracia' => true,
  'deporte' => true,
  'ecologia' => true,
  'economia' => true,
  'empresa' => true,
  'indigena' => true,
  'industria' => true,
  'info' => true,
  'medicina' => true,
  'movimiento' => true,
  'musica' => true,
  'natural' => true,
  'nombre' => true,
  'noticias' => true,
  'patria' => true,
  'plurinacional' => true,
  'politica' => true,
  'profesional' => true,
  'pueblo' => true,
  'revista' => true,
  'salud' => true,
  'tecnologia' => true,
  'tksat' => true,
  'transporte' => true,
  'wiki' => true
 ],
 'br' => [
  '9guacu' => true,
  'abc' => true,
  'adm' => true,
  'adv' => true,
  'agr' => true,
  'aju' => true,
  'am' => true,
  'anani' => true,
  'aparecida' => true,
  'app' => true,
  'arq' => true,
  'art' => true,
  'ato' => true,
  'b' => true,
  'barueri' => true,
  'belem' => true,
  'bet' => true,
  'bhz' => true,
  'bib' => true,
  'bio' => true,
  'blog' => true,
  'bmd' => true,
  'boavista' => true,
  'bsb' => true,
  'campinagrande' => true,
  'campinas' => true,
  'caxias' => true,
  'cim' => true,
  'cng' => true,
  'cnt' => true,
  'com' => [
   'simplesite' => true
  ],
  'contagem' => true,
  'coop' => true,
  'coz' => true,
  'cri' => true,
  'cuiaba' => true,
  'curitiba' => true,
  'def' => true,
  'des' => true,
  'det' => true,
  'dev' => true,
  'ecn' => true,
  'eco' => true,
  'edu' => true,
  'emp' => true,
  'enf' => true,
  'eng' => true,
  'esp' => true,
  'etc' => true,
  'eti' => true,
  'far' => true,
  'feira' => true,
  'flog' => true,
  'floripa' => true,
  'fm' => true,
  'fnd' => true,
  'fortal' => true,
  'fot' => true,
  'foz' => true,
  'fst' => true,
  'g12' => true,
  'geo' => true,
  'ggf' => true,
  'goiania' => true,
  'gov' => [
   'ac' => true,
   'al' => true,
   'am' => true,
   'ap' => true,
   'ba' => true,
   'ce' => true,
   'df' => true,
   'es' => true,
   'go' => true,
   'ma' => true,
   'mg' => true,
   'ms' => true,
   'mt' => true,
   'pa' => true,
   'pb' => true,
   'pe' => true,
   'pi' => true,
   'pr' => true,
   'rj' => true,
   'rn' => true,
   'ro' => true,
   'rr' => true,
   'rs' => true,
   'sc' => true,
   'se' => true,
   'sp' => true,
   'to' => true
  ],
  'gru' => true,
  'imb' => true,
  'ind' => true,
  'inf' => true,
  'jab' => true,
  'jampa' => true,
  'jdf' => true,
  'joinville' => true,
  'jor' => true,
  'jus' => true,
  'leg' => [
   'ac' => true,
   'al' => true,
   'am' => true,
   'ap' => true,
   'ba' => true,
   'ce' => true,
   'df' => true,
   'es' => true,
   'go' => true,
   'ma' => true,
   'mg' => true,
   'ms' => true,
   'mt' => true,
   'pa' => true,
   'pb' => true,
   'pe' => true,
   'pi' => true,
   'pr' => true,
   'rj' => true,
   'rn' => true,
   'ro' => true,
   'rr' => true,
   'rs' => true,
   'sc' => true,
   'se' => true,
   'sp' => true,
   'to' => true
  ],
  'leilao' => true,
  'lel' => true,
  'log' => true,
  'londrina' => true,
  'macapa' => true,
  'maceio' => true,
  'manaus' => true,
  'maringa' => true,
  'mat' => true,
  'med' => true,
  'mil' => true,
  'morena' => true,
  'mp' => true,
  'mus' => true,
  'natal' => true,
  'net' => true,
  'niteroi' => true,
  'nom' => [
   '*' => true
  ],
  'not' => true,
  'ntr' => true,
  'odo' => true,
  'ong' => true,
  'org' => true,
  'osasco' => true,
  'palmas' => true,
  'poa' => true,
  'ppg' => true,
  'pro' => true,
  'psc' => true,
  'psi' => true,
  'pvh' => true,
  'qsl' => true,
  'radio' => true,
  'rec' => true,
  'recife' => true,
  'rep' => true,
  'ribeirao' => true,
  'rio' => true,
  'riobranco' => true,
  'riopreto' => true,
  'salvador' => true,
  'sampa' => true,
  'santamaria' => true,
  'santoandre' => true,
  'saobernardo' => true,
  'saogonca' => true,
  'seg' => true,
  'sjc' => true,
  'slg' => true,
  'slz' => true,
  'sorocaba' => true,
  'srv' => true,
  'taxi' => true,
  'tc' => true,
  'tec' => true,
  'teo' => true,
  'the' => true,
  'tmp' => true,
  'trd' => true,
  'tur' => true,
  'tv' => true,
  'udi' => true,
  'vet' => true,
  'vix' => true,
  'vlog' => true,
  'wiki' => true,
  'zlg' => true
 ],
 'bs' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'we' => true
 ],
 'bt' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'bv' => true,
 'bw' => [
  'ac' => true,
  'co' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'by' => [
  'gov' => true,
  'mil' => true,
  'com' => true,
  'of' => true,
  'mediatech' => true
 ],
 'bz' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'za' => true,
  'mydns' => true,
  'gsj' => true
 ],
 'ca' => [
  'ab' => true,
  'bc' => true,
  'mb' => true,
  'nb' => true,
  'nf' => true,
  'nl' => true,
  'ns' => true,
  'nt' => true,
  'nu' => true,
  'on' => true,
  'pe' => true,
  'qc' => true,
  'sk' => true,
  'yk' => true,
  'gc' => true,
  'barsy' => true,
  'awdev' => [
   '*' => true
  ],
  'co' => true,
  'no-ip' => true,
  'myspreadshop' => true,
  'box' => true
 ],
 'cat' => true,
 'cc' => [
  'cleverapps' => true,
  'cloudns' => true,
  'ftpaccess' => true,
  'game-server' => true,
  'myphotos' => true,
  'scrapping' => true,
  'twmail' => true,
  'csx' => true,
  'fantasyleague' => true,
  'spawn' => [
   'instances' => true
  ]
 ],
 'cd' => [
  'gov' => true
 ],
 'cf' => true,
 'cg' => true,
 'ch' => [
  'square7' => true,
  'cloudns' => true,
  'cloudscale' => [
   'cust' => true,
   'lpg' => [
    'objects' => true
   ],
   'rma' => [
    'objects' => true
   ]
  ],
  'flow' => [
   'ae' => [
    'alp1' => true
   ],
   'appengine' => true
  ],
  'linkyard-cloud' => true,
  'gotdns' => true,
  'dnsking' => true,
  '123website' => true,
  'myspreadshop' => true,
  'firenet' => [
   '*' => true,
   'svc' => [
    '*' => true
   ]
  ],
  '12hp' => true,
  '2ix' => true,
  '4lima' => true,
  'lima-city' => true
 ],
 'ci' => [
  'ac' => true,
  'aéroport' => true,
  'asso' => true,
  'co' => true,
  'com' => true,
  'ed' => true,
  'edu' => true,
  'go' => true,
  'gouv' => true,
  'int' => true,
  'net' => true,
  'or' => true,
  'org' => true
 ],
 'ck' => [
  '*' => true,
  '!www' => true
 ],
 'cl' => [
  'co' => true,
  'gob' => true,
  'gov' => true,
  'mil' => true,
  'cloudns' => true
 ],
 'cm' => [
  'co' => true,
  'com' => true,
  'gov' => true,
  'net' => true
 ],
 'cn' => [
  'ac' => true,
  'com' => [
   'amazonaws' => [
    'cn-north-1' => [
     'execute-api' => true,
     'emrappui-prod' => true,
     'emrnotebooks-prod' => true,
     'emrstudio-prod' => true,
     'dualstack' => [
      's3' => true,
      's3-accesspoint' => true,
      's3-website' => true
     ],
     's3' => true,
     's3-accesspoint' => true,
     's3-deprecated' => true,
     's3-object-lambda' => true,
     's3-website' => true
    ],
    'cn-northwest-1' => [
     'execute-api' => true,
     'emrappui-prod' => true,
     'emrnotebooks-prod' => true,
     'emrstudio-prod' => true,
     'dualstack' => [
      's3' => true,
      's3-accesspoint' => true
     ],
     's3' => true,
     's3-accesspoint' => true,
     's3-object-lambda' => true,
     's3-website' => true
    ],
    'compute' => [
     '*' => true
    ],
    'airflow' => [
     'cn-north-1' => [
      '*' => true
     ],
     'cn-northwest-1' => [
      '*' => true
     ]
    ],
    'eb' => [
     'cn-north-1' => true,
     'cn-northwest-1' => true
    ],
    'elb' => [
     '*' => true
    ]
   ],
   'sagemaker' => [
    'cn-north-1' => [
     'notebook' => true,
     'studio' => true
    ],
    'cn-northwest-1' => [
     'notebook' => true,
     'studio' => true
    ]
   ]
  ],
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  '公司' => true,
  '網絡' => true,
  '网络' => true,
  'ah' => true,
  'bj' => true,
  'cq' => true,
  'fj' => true,
  'gd' => true,
  'gs' => true,
  'gx' => true,
  'gz' => true,
  'ha' => true,
  'hb' => true,
  'he' => true,
  'hi' => true,
  'hk' => true,
  'hl' => true,
  'hn' => true,
  'jl' => true,
  'js' => true,
  'jx' => true,
  'ln' => true,
  'mo' => true,
  'nm' => true,
  'nx' => true,
  'qh' => true,
  'sc' => true,
  'sd' => true,
  'sh' => [
   'as' => true
  ],
  'sn' => true,
  'sx' => true,
  'tj' => true,
  'tw' => true,
  'xj' => true,
  'xz' => true,
  'yn' => true,
  'zj' => true,
  'canva-apps' => true,
  'canvasite' => [
   'my' => [
    '*' => true
   ]
  ],
  'myqnapcloud' => true,
  'quickconnect' => [
   'direct' => true
  ]
 ],
 'co' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'nom' => true,
  'org' => true,
  'carrd' => true,
  'crd' => true,
  'otap' => [
   '*' => true
  ],
  'leadpages' => true,
  'lpages' => true,
  'mypi' => true,
  'xmit' => [
   '*' => true
  ],
  'firewalledreplit' => [
   'id' => true
  ],
  'repl' => [
   'id' => true
  ],
  'supabase' => true
 ],
 'com' => [
  'a2hosted' => true,
  'cpserver' => true,
  'adobeaemcloud' => [
   'dev' => [
    '*' => true
   ]
  ],
  'africa' => true,
  'airkitapps' => true,
  'airkitapps-au' => true,
  'aivencloud' => true,
  'alibabacloudcs' => true,
  'kasserver' => true,
  'amazonaws' => [
   'af-south-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-east-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-northeast-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-northeast-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-northeast-3' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-south-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-south-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'ap-southeast-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-southeast-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ap-southeast-3' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'ap-southeast-4' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'ap-southeast-5' => [
    'execute-api' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-deprecated' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'ca-central-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'ca-west-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'eu-central-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'eu-central-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'eu-north-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'eu-south-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'eu-south-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'eu-west-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-deprecated' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'eu-west-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'eu-west-3' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'il-central-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true
    ]
   ],
   'me-central-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'me-south-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'sa-east-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'us-east-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-deprecated' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'us-east-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-deprecated' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'us-gov-east-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'us-gov-west-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true
   ],
   'us-west-1' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'us-west-2' => [
    'execute-api' => true,
    'emrappui-prod' => true,
    'emrnotebooks-prod' => true,
    'emrstudio-prod' => true,
    'dualstack' => [
     's3' => true,
     's3-accesspoint' => true,
     's3-accesspoint-fips' => true,
     's3-fips' => true,
     's3-website' => true
    ],
    's3' => true,
    's3-accesspoint' => true,
    's3-accesspoint-fips' => true,
    's3-deprecated' => true,
    's3-fips' => true,
    's3-object-lambda' => true,
    's3-website' => true,
    'analytics-gateway' => true,
    'aws-cloud9' => [
     'webview-assets' => true
    ],
    'cloud9' => [
     'vfs' => true,
     'webview-assets' => true
    ]
   ],
   'compute' => [
    '*' => true
   ],
   'compute-1' => [
    '*' => true
   ],
   'airflow' => [
    'af-south-1' => [
     '*' => true
    ],
    'ap-east-1' => [
     '*' => true
    ],
    'ap-northeast-1' => [
     '*' => true
    ],
    'ap-northeast-2' => [
     '*' => true
    ],
    'ap-northeast-3' => [
     '*' => true
    ],
    'ap-south-1' => [
     '*' => true
    ],
    'ap-south-2' => [
     '*' => true
    ],
    'ap-southeast-1' => [
     '*' => true
    ],
    'ap-southeast-2' => [
     '*' => true
    ],
    'ap-southeast-3' => [
     '*' => true
    ],
    'ap-southeast-4' => [
     '*' => true
    ],
    'ca-central-1' => [
     '*' => true
    ],
    'ca-west-1' => [
     '*' => true
    ],
    'eu-central-1' => [
     '*' => true
    ],
    'eu-central-2' => [
     '*' => true
    ],
    'eu-north-1' => [
     '*' => true
    ],
    'eu-south-1' => [
     '*' => true
    ],
    'eu-south-2' => [
     '*' => true
    ],
    'eu-west-1' => [
     '*' => true
    ],
    'eu-west-2' => [
     '*' => true
    ],
    'eu-west-3' => [
     '*' => true
    ],
    'il-central-1' => [
     '*' => true
    ],
    'me-central-1' => [
     '*' => true
    ],
    'me-south-1' => [
     '*' => true
    ],
    'sa-east-1' => [
     '*' => true
    ],
    'us-east-1' => [
     '*' => true
    ],
    'us-east-2' => [
     '*' => true
    ],
    'us-west-1' => [
     '*' => true
    ],
    'us-west-2' => [
     '*' => true
    ]
   ],
   's3' => true,
   's3-1' => true,
   's3-ap-east-1' => true,
   's3-ap-northeast-1' => true,
   's3-ap-northeast-2' => true,
   's3-ap-northeast-3' => true,
   's3-ap-south-1' => true,
   's3-ap-southeast-1' => true,
   's3-ap-southeast-2' => true,
   's3-ca-central-1' => true,
   's3-eu-central-1' => true,
   's3-eu-north-1' => true,
   's3-eu-west-1' => true,
   's3-eu-west-2' => true,
   's3-eu-west-3' => true,
   's3-external-1' => true,
   's3-fips-us-gov-east-1' => true,
   's3-fips-us-gov-west-1' => true,
   's3-global' => [
    'accesspoint' => [
     'mrap' => true
    ]
   ],
   's3-me-south-1' => true,
   's3-sa-east-1' => true,
   's3-us-east-2' => true,
   's3-us-gov-east-1' => true,
   's3-us-gov-west-1' => true,
   's3-us-west-1' => true,
   's3-us-west-2' => true,
   's3-website-ap-northeast-1' => true,
   's3-website-ap-southeast-1' => true,
   's3-website-ap-southeast-2' => true,
   's3-website-eu-west-1' => true,
   's3-website-sa-east-1' => true,
   's3-website-us-east-1' => true,
   's3-website-us-gov-west-1' => true,
   's3-website-us-west-1' => true,
   's3-website-us-west-2' => true,
   'elb' => [
    '*' => true
   ]
  ],
  'amazoncognito' => [
   'af-south-1' => [
    'auth' => true
   ],
   'ap-east-1' => [
    'auth' => true
   ],
   'ap-northeast-1' => [
    'auth' => true
   ],
   'ap-northeast-2' => [
    'auth' => true
   ],
   'ap-northeast-3' => [
    'auth' => true
   ],
   'ap-south-1' => [
    'auth' => true
   ],
   'ap-south-2' => [
    'auth' => true
   ],
   'ap-southeast-1' => [
    'auth' => true
   ],
   'ap-southeast-2' => [
    'auth' => true
   ],
   'ap-southeast-3' => [
    'auth' => true
   ],
   'ap-southeast-4' => [
    'auth' => true
   ],
   'ca-central-1' => [
    'auth' => true
   ],
   'ca-west-1' => [
    'auth' => true
   ],
   'eu-central-1' => [
    'auth' => true
   ],
   'eu-central-2' => [
    'auth' => true
   ],
   'eu-north-1' => [
    'auth' => true
   ],
   'eu-south-1' => [
    'auth' => true
   ],
   'eu-south-2' => [
    'auth' => true
   ],
   'eu-west-1' => [
    'auth' => true
   ],
   'eu-west-2' => [
    'auth' => true
   ],
   'eu-west-3' => [
    'auth' => true
   ],
   'il-central-1' => [
    'auth' => true
   ],
   'me-central-1' => [
    'auth' => true
   ],
   'me-south-1' => [
    'auth' => true
   ],
   'sa-east-1' => [
    'auth' => true
   ],
   'us-east-1' => [
    'auth' => true,
    'auth-fips' => true
   ],
   'us-east-2' => [
    'auth' => true,
    'auth-fips' => true
   ],
   'us-gov-west-1' => [
    'auth-fips' => true
   ],
   'us-west-1' => [
    'auth' => true,
    'auth-fips' => true
   ],
   'us-west-2' => [
    'auth' => true,
    'auth-fips' => true
   ]
  ],
  'amplifyapp' => true,
  'awsapprunner' => [
   '*' => true
  ],
  'awsapps' => true,
  'elasticbeanstalk' => [
   'af-south-1' => true,
   'ap-east-1' => true,
   'ap-northeast-1' => true,
   'ap-northeast-2' => true,
   'ap-northeast-3' => true,
   'ap-south-1' => true,
   'ap-southeast-1' => true,
   'ap-southeast-2' => true,
   'ap-southeast-3' => true,
   'ca-central-1' => true,
   'eu-central-1' => true,
   'eu-north-1' => true,
   'eu-south-1' => true,
   'eu-west-1' => true,
   'eu-west-2' => true,
   'eu-west-3' => true,
   'il-central-1' => true,
   'me-south-1' => true,
   'sa-east-1' => true,
   'us-east-1' => true,
   'us-east-2' => true,
   'us-gov-east-1' => true,
   'us-gov-west-1' => true,
   'us-west-1' => true,
   'us-west-2' => true
  ],
  'awsglobalaccelerator' => true,
  'siiites' => true,
  'appspacehosted' => true,
  'appspaceusercontent' => true,
  'on-aptible' => true,
  'myasustor' => true,
  'balena-devices' => true,
  'boutir' => true,
  'bplaced' => true,
  'cafjs' => true,
  'canva-apps' => true,
  'cdn77-storage' => true,
  'br' => true,
  'cn' => true,
  'de' => true,
  'eu' => true,
  'jpn' => true,
  'mex' => true,
  'ru' => true,
  'sa' => true,
  'uk' => true,
  'us' => true,
  'za' => true,
  'clever-cloud' => [
   'services' => [
    '*' => true
   ]
  ],
  'dnsabr' => true,
  'ip-ddns' => true,
  'jdevcloud' => true,
  'wpdevcloud' => true,
  'cf-ipfs' => true,
  'cloudflare-ipfs' => true,
  'trycloudflare' => true,
  'co' => true,
  'devinapps' => [
   'staging' => true
  ],
  'builtwithdark' => true,
  'datadetect' => [
   'demo' => true,
   'instance' => true
  ],
  'dattolocal' => true,
  'dattorelay' => true,
  'dattoweb' => true,
  'mydatto' => true,
  'digitaloceanspaces' => [
   '*' => true
  ],
  'discordsays' => true,
  'discordsez' => true,
  'drayddns' => true,
  'dreamhosters' => true,
  'durumis' => true,
  'mydrobo' => true,
  'blogdns' => true,
  'cechire' => true,
  'dnsalias' => true,
  'dnsdojo' => true,
  'doesntexist' => true,
  'dontexist' => true,
  'doomdns' => true,
  'dyn-o-saur' => true,
  'dynalias' => true,
  'dyndns-at-home' => true,
  'dyndns-at-work' => true,
  'dyndns-blog' => true,
  'dyndns-free' => true,
  'dyndns-home' => true,
  'dyndns-ip' => true,
  'dyndns-mail' => true,
  'dyndns-office' => true,
  'dyndns-pics' => true,
  'dyndns-remote' => true,
  'dyndns-server' => true,
  'dyndns-web' => true,
  'dyndns-wiki' => true,
  'dyndns-work' => true,
  'est-a-la-maison' => true,
  'est-a-la-masion' => true,
  'est-le-patron' => true,
  'est-mon-blogueur' => true,
  'from-ak' => true,
  'from-al' => true,
  'from-ar' => true,
  'from-ca' => true,
  'from-ct' => true,
  'from-dc' => true,
  'from-de' => true,
  'from-fl' => true,
  'from-ga' => true,
  'from-hi' => true,
  'from-ia' => true,
  'from-id' => true,
  'from-il' => true,
  'from-in' => true,
  'from-ks' => true,
  'from-ky' => true,
  'from-ma' => true,
  'from-md' => true,
  'from-mi' => true,
  'from-mn' => true,
  'from-mo' => true,
  'from-ms' => true,
  'from-mt' => true,
  'from-nc' => true,
  'from-nd' => true,
  'from-ne' => true,
  'from-nh' => true,
  'from-nj' => true,
  'from-nm' => true,
  'from-nv' => true,
  'from-oh' => true,
  'from-ok' => true,
  'from-or' => true,
  'from-pa' => true,
  'from-pr' => true,
  'from-ri' => true,
  'from-sc' => true,
  'from-sd' => true,
  'from-tn' => true,
  'from-tx' => true,
  'from-ut' => true,
  'from-va' => true,
  'from-vt' => true,
  'from-wa' => true,
  'from-wi' => true,
  'from-wv' => true,
  'from-wy' => true,
  'getmyip' => true,
  'gotdns' => true,
  'hobby-site' => true,
  'homelinux' => true,
  'homeunix' => true,
  'iamallama' => true,
  'is-a-anarchist' => true,
  'is-a-blogger' => true,
  'is-a-bookkeeper' => true,
  'is-a-bulls-fan' => true,
  'is-a-caterer' => true,
  'is-a-chef' => true,
  'is-a-conservative' => true,
  'is-a-cpa' => true,
  'is-a-cubicle-slave' => true,
  'is-a-democrat' => true,
  'is-a-designer' => true,
  'is-a-doctor' => true,
  'is-a-financialadvisor' => true,
  'is-a-geek' => true,
  'is-a-green' => true,
  'is-a-guru' => true,
  'is-a-hard-worker' => true,
  'is-a-hunter' => true,
  'is-a-landscaper' => true,
  'is-a-lawyer' => true,
  'is-a-liberal' => true,
  'is-a-libertarian' => true,
  'is-a-llama' => true,
  'is-a-musician' => true,
  'is-a-nascarfan' => true,
  'is-a-nurse' => true,
  'is-a-painter' => true,
  'is-a-personaltrainer' => true,
  'is-a-photographer' => true,
  'is-a-player' => true,
  'is-a-republican' => true,
  'is-a-rockstar' => true,
  'is-a-socialist' => true,
  'is-a-student' => true,
  'is-a-teacher' => true,
  'is-a-techie' => true,
  'is-a-therapist' => true,
  'is-an-accountant' => true,
  'is-an-actor' => true,
  'is-an-actress' => true,
  'is-an-anarchist' => true,
  'is-an-artist' => true,
  'is-an-engineer' => true,
  'is-an-entertainer' => true,
  'is-certified' => true,
  'is-gone' => true,
  'is-into-anime' => true,
  'is-into-cars' => true,
  'is-into-cartoons' => true,
  'is-into-games' => true,
  'is-leet' => true,
  'is-not-certified' => true,
  'is-slick' => true,
  'is-uberleet' => true,
  'is-with-theband' => true,
  'isa-geek' => true,
  'isa-hockeynut' => true,
  'issmarterthanyou' => true,
  'likes-pie' => true,
  'likescandy' => true,
  'neat-url' => true,
  'saves-the-whales' => true,
  'selfip' => true,
  'sells-for-less' => true,
  'sells-for-u' => true,
  'servebbs' => true,
  'simple-url' => true,
  'space-to-rent' => true,
  'teaches-yoga' => true,
  'writesthisblog' => true,
  'ddnsfree' => true,
  'ddnsgeek' => true,
  'giize' => true,
  'gleeze' => true,
  'kozow' => true,
  'loseyourip' => true,
  'ooguy' => true,
  'theworkpc' => true,
  'mytuleap' => true,
  'tuleap-partners' => true,
  'encoreapi' => true,
  'evennode' => [
   'eu-1' => true,
   'eu-2' => true,
   'eu-3' => true,
   'eu-4' => true,
   'us-1' => true,
   'us-2' => true,
   'us-3' => true,
   'us-4' => true
  ],
  'onfabrica' => true,
  'fastly-edge' => true,
  'fastly-terrarium' => true,
  'fastvps-server' => true,
  'mydobiss' => true,
  'firebaseapp' => true,
  'fldrv' => true,
  'forgeblocks' => true,
  'framercanvas' => true,
  'freebox-os' => true,
  'freeboxos' => true,
  'freemyip' => true,
  'aliases121' => true,
  'gentapps' => true,
  'gentlentapis' => true,
  'githubusercontent' => true,
  '0emm' => [
   '*' => true
  ],
  'appspot' => [
   'r' => [
    '*' => true
   ]
  ],
  'blogspot' => true,
  'codespot' => true,
  'googleapis' => true,
  'googlecode' => true,
  'pagespeedmobilizer' => true,
  'withgoogle' => true,
  'withyoutube' => true,
  'grayjayleagues' => true,
  'hatenablog' => true,
  'hatenadiary' => true,
  'herokuapp' => true,
  'gr' => true,
  'smushcdn' => true,
  'wphostedmail' => true,
  'wpmucdn' => true,
  'pixolino' => true,
  'apps-1and1' => true,
  'live-website' => true,
  'dopaas' => true,
  'hosted-by-previder' => [
   'paas' => true
  ],
  'hosteur' => [
   'rag-cloud' => true,
   'rag-cloud-ch' => true
  ],
  'ik-server' => [
   'jcloud' => true,
   'jcloud-ver-jpc' => true
  ],
  'jelastic' => [
   'demo' => true
  ],
  'massivegrid' => [
   'paas' => true
  ],
  'wafaicloud' => [
   'jed' => true,
   'ryd' => true
  ],
  'webadorsite' => true,
  'joyent' => [
   'cns' => [
    '*' => true
   ]
  ],
  'lpusercontent' => true,
  'linode' => [
   'members' => true,
   'nodebalancer' => [
    '*' => true
   ]
  ],
  'linodeobjects' => [
   '*' => true
  ],
  'linodeusercontent' => [
   'ip' => true
  ],
  'localtonet' => true,
  'lovableproject' => true,
  'barsycenter' => true,
  'barsyonline' => true,
  'modelscape' => true,
  'mwcloudnonprod' => true,
  'polyspace' => true,
  'mazeplay' => true,
  'miniserver' => true,
  'atmeta' => true,
  'fbsbx' => [
   'apps' => true
  ],
  'meteorapp' => [
   'eu' => true
  ],
  'routingthecloud' => true,
  'mydbserver' => true,
  'hostedpi' => true,
  'mythic-beasts' => [
   'caracal' => true,
   'customer' => true,
   'fentiger' => true,
   'lynx' => true,
   'ocelot' => true,
   'oncilla' => true,
   'onza' => true,
   'sphinx' => true,
   'vs' => true,
   'x' => true,
   'yali' => true
  ],
  'nospamproxy' => [
   'cloud' => [
    'o365' => true
   ]
  ],
  '4u' => true,
  'nfshost' => true,
  '3utilities' => true,
  'blogsyte' => true,
  'ciscofreak' => true,
  'damnserver' => true,
  'ddnsking' => true,
  'ditchyourip' => true,
  'dnsiskinky' => true,
  'dynns' => true,
  'geekgalaxy' => true,
  'health-carereform' => true,
  'homesecuritymac' => true,
  'homesecuritypc' => true,
  'myactivedirectory' => true,
  'mysecuritycamera' => true,
  'myvnc' => true,
  'net-freaks' => true,
  'onthewifi' => true,
  'point2this' => true,
  'quicksytes' => true,
  'securitytactics' => true,
  'servebeer' => true,
  'servecounterstrike' => true,
  'serveexchange' => true,
  'serveftp' => true,
  'servegame' => true,
  'servehalflife' => true,
  'servehttp' => true,
  'servehumour' => true,
  'serveirc' => true,
  'servemp3' => true,
  'servep2p' => true,
  'servepics' => true,
  'servequake' => true,
  'servesarcasm' => true,
  'stufftoread' => true,
  'unusualperson' => true,
  'workisboring' => true,
  'myiphost' => true,
  'observableusercontent' => [
   'static' => true
  ],
  'simplesite' => true,
  'orsites' => true,
  'operaunite' => true,
  'customer-oci' => [
   '*' => true,
   'oci' => [
    '*' => true
   ],
   'ocp' => [
    '*' => true
   ],
   'ocs' => [
    '*' => true
   ]
  ],
  'oraclecloudapps' => [
   '*' => true
  ],
  'oraclegovcloudapps' => [
   '*' => true
  ],
  'authgear-staging' => true,
  'authgearapps' => true,
  'skygearapp' => true,
  'outsystemscloud' => true,
  'ownprovider' => true,
  'pgfog' => true,
  'pagexl' => true,
  'gotpantheon' => true,
  'paywhirl' => [
   '*' => true
  ],
  'upsunapp' => true,
  'postman-echo' => true,
  'prgmr' => [
   'xen' => true
  ],
  'pythonanywhere' => [
   'eu' => true
  ],
  'qa2' => true,
  'alpha-myqnapcloud' => true,
  'dev-myqnapcloud' => true,
  'mycloudnas' => true,
  'mynascloud' => true,
  'myqnapcloud' => true,
  'qualifioapp' => true,
  'ladesk' => true,
  'qbuser' => true,
  'quipelements' => [
   '*' => true
  ],
  'rackmaze' => true,
  'readthedocs-hosted' => true,
  'rhcloud' => true,
  'onrender' => true,
  'render' => [
   'app' => true
  ],
  'subsc-pay' => true,
  '180r' => true,
  'dojin' => true,
  'sakuratan' => true,
  'sakuraweb' => true,
  'x0' => true,
  'code' => [
   'builder' => [
    '*' => true
   ],
   'dev-builder' => [
    '*' => true
   ],
   'stg-builder' => [
    '*' => true
   ]
  ],
  'salesforce' => [
   'platform' => [
    'code-builder-stg' => [
     'test' => [
      '001' => [
       '*' => true
      ]
     ]
    ]
   ]
  ],
  'logoip' => true,
  'scrysec' => true,
  'firewall-gateway' => true,
  'myshopblocks' => true,
  'myshopify' => true,
  'shopitsite' => true,
  '1kapp' => true,
  'appchizi' => true,
  'applinzi' => true,
  'sinaapp' => true,
  'vipsinaapp' => true,
  'streamlitapp' => true,
  'try-snowplow' => true,
  'playstation-cloud' => true,
  'myspreadshop' => true,
  'w-corp-staticblitz' => true,
  'w-credentialless-staticblitz' => true,
  'w-staticblitz' => true,
  'stackhero-network' => true,
  'stdlib' => [
   'api' => true
  ],
  'strapiapp' => [
   'media' => true
  ],
  'streak-link' => true,
  'streaklinks' => true,
  'streakusercontent' => true,
  'temp-dns' => true,
  'dsmynas' => true,
  'familyds' => true,
  'mytabit' => true,
  'taveusercontent' => true,
  'tb-hosting' => [
   'site' => true
  ],
  'reservd' => true,
  'thingdustdata' => true,
  'townnews-staging' => true,
  'typeform' => [
   'pro' => true
  ],
  'hk' => true,
  'it' => true,
  'deus-canvas' => true,
  'vultrobjects' => [
   '*' => true
  ],
  'wafflecell' => true,
  'hotelwithflight' => true,
  'reserve-online' => true,
  'cprapid' => true,
  'pleskns' => true,
  'remotewd' => true,
  'wiardweb' => [
   'pages' => true
  ],
  'wixsite' => true,
  'wixstudio' => true,
  'messwithdns' => true,
  'woltlab-demo' => true,
  'wpenginepowered' => [
   'js' => true
  ],
  'xnbay' => [
   'u2' => true,
   'u2-local' => true
  ],
  'yolasite' => true
 ],
 'coop' => true,
 'cr' => [
  'ac' => true,
  'co' => true,
  'ed' => true,
  'fi' => true,
  'go' => true,
  'or' => true,
  'sa' => true
 ],
 'cu' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'inf' => true,
  'nat' => true,
  'net' => true,
  'org' => true
 ],
 'cv' => [
  'com' => true,
  'edu' => true,
  'id' => true,
  'int' => true,
  'net' => true,
  'nome' => true,
  'org' => true,
  'publ' => true
 ],
 'cw' => [
  'com' => true,
  'edu' => true,
  'net' => true,
  'org' => true
 ],
 'cx' => [
  'gov' => true,
  'cloudns' => true,
  'ath' => true,
  'info' => true,
  'assessments' => true,
  'calculators' => true,
  'funnels' => true,
  'paynow' => true,
  'quizzes' => true,
  'researched' => true,
  'tests' => true
 ],
 'cy' => [
  'ac' => true,
  'biz' => true,
  'com' => [
   'scaleforce' => [
    'j' => true
   ]
  ],
  'ekloges' => true,
  'gov' => true,
  'ltd' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'press' => true,
  'pro' => true,
  'tm' => true
 ],
 'cz' => [
  'contentproxy9' => [
   'rsc' => true
  ],
  'realm' => true,
  'e4' => true,
  'co' => true,
  'metacentrum' => [
   'cloud' => [
    '*' => true
   ],
   'custom' => true
  ],
  'muni' => [
   'cloud' => [
    'flt' => true,
    'usr' => true
   ]
  ]
 ],
 'de' => [
  'bplaced' => true,
  'square7' => true,
  'com' => true,
  'cosidns' => [
   'dyn' => true
  ],
  'dnsupdater' => true,
  'dynamisches-dns' => true,
  'internet-dns' => true,
  'l-o-g-i-n' => true,
  'ddnss' => [
   'dyn' => true,
   'dyndns' => true
  ],
  'dyn-ip24' => true,
  'dyndns1' => true,
  'home-webserver' => [
   'dyn' => true
  ],
  'myhome-server' => true,
  'dnshome' => true,
  'fuettertdasnetz' => true,
  'isteingeek' => true,
  'istmein' => true,
  'lebtimnetz' => true,
  'leitungsen' => true,
  'traeumtgerade' => true,
  'frusky' => [
   '*' => true
  ],
  'goip' => true,
  'günstigbestellen' => true,
  'günstigliefern' => true,
  'hs-heilbronn' => [
   'it' => [
    'pages' => true,
    'pages-research' => true
   ]
  ],
  'dyn-berlin' => true,
  'in-berlin' => true,
  'in-brb' => true,
  'in-butter' => true,
  'in-dsl' => true,
  'in-vpn' => true,
  'iservschule' => true,
  'mein-iserv' => true,
  'schulplattform' => true,
  'schulserver' => true,
  'test-iserv' => true,
  'keymachine' => true,
  'git-repos' => true,
  'lcube-server' => true,
  'svn-repos' => true,
  'barsy' => true,
  'webspaceconfig' => true,
  '123webseite' => true,
  'rub' => true,
  'ruhr-uni-bochum' => [
   'noc' => [
    'io' => true
   ]
  ],
  'logoip' => true,
  'firewall-gateway' => true,
  'my-gateway' => true,
  'my-router' => true,
  'spdns' => true,
  'speedpartner' => [
   'customer' => true
  ],
  'myspreadshop' => true,
  'taifun-dns' => true,
  '12hp' => true,
  '2ix' => true,
  '4lima' => true,
  'lima-city' => true,
  'dd-dns' => true,
  'dray-dns' => true,
  'draydns' => true,
  'dyn-vpn' => true,
  'dynvpn' => true,
  'mein-vigor' => true,
  'my-vigor' => true,
  'my-wan' => true,
  'syno-ds' => true,
  'synology-diskstation' => true,
  'synology-ds' => true,
  'uberspace' => [
   '*' => true
  ],
  'virtual-user' => true,
  'virtualuser' => true,
  'community-pro' => true,
  'diskussionsbereich' => true
 ],
 'dj' => true,
 'dk' => [
  'biz' => true,
  'co' => true,
  'firm' => true,
  'reg' => true,
  'store' => true,
  '123hjemmeside' => true,
  'myspreadshop' => true
 ],
 'dm' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'do' => [
  'art' => true,
  'com' => true,
  'edu' => true,
  'gob' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'sld' => true,
  'web' => true
 ],
 'dz' => [
  'art' => true,
  'asso' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'pol' => true,
  'soc' => true,
  'tm' => true
 ],
 'ec' => [
  'com' => true,
  'edu' => true,
  'fin' => true,
  'gob' => true,
  'gov' => true,
  'info' => true,
  'k12' => true,
  'med' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'pro' => true,
  'base' => true,
  'official' => true
 ],
 'edu' => [
  'rit' => [
   'git-pages' => true
  ]
 ],
 'ee' => [
  'aip' => true,
  'com' => true,
  'edu' => true,
  'fie' => true,
  'gov' => true,
  'lib' => true,
  'med' => true,
  'org' => true,
  'pri' => true,
  'riik' => true
 ],
 'eg' => [
  'ac' => true,
  'com' => true,
  'edu' => true,
  'eun' => true,
  'gov' => true,
  'info' => true,
  'me' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'sci' => true,
  'sport' => true,
  'tv' => true
 ],
 'er' => [
  '*' => true
 ],
 'es' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'nom' => true,
  'org' => true,
  '123miweb' => true,
  'myspreadshop' => true
 ],
 'et' => [
  'biz' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'name' => true,
  'net' => true,
  'org' => true
 ],
 'eu' => [
  'airkitapps' => true,
  'cloudns' => true,
  'dogado' => [
   'jelastic' => true
  ],
  'barsy' => true,
  'spdns' => true,
  'transurl' => [
   '*' => true
  ],
  'diskstation' => true
 ],
 'fi' => [
  'aland' => true,
  'dy' => true,
  'häkkinen' => true,
  'iki' => true,
  'cloudplatform' => [
   'fi' => true
  ],
  'datacenter' => [
   'demo' => true,
   'paas' => true
  ],
  'kapsi' => true,
  '123kotisivu' => true,
  'myspreadshop' => true
 ],
 'fj' => [
  'ac' => true,
  'biz' => true,
  'com' => true,
  'gov' => true,
  'info' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'pro' => true
 ],
 'fk' => [
  '*' => true
 ],
 'fm' => [
  'com' => true,
  'edu' => true,
  'net' => true,
  'org' => true,
  'radio' => true,
  'user' => [
   '*' => true
  ]
 ],
 'fo' => true,
 'fr' => [
  'asso' => true,
  'com' => true,
  'gouv' => true,
  'nom' => true,
  'prd' => true,
  'tm' => true,
  'avoues' => true,
  'cci' => true,
  'greta' => true,
  'huissier-justice' => true,
  'en-root' => true,
  'fbx-os' => true,
  'fbxos' => true,
  'freebox-os' => true,
  'freeboxos' => true,
  'goupile' => true,
  '123siteweb' => true,
  'on-web' => true,
  'chirurgiens-dentistes-en-france' => true,
  'dedibox' => true,
  'aeroport' => true,
  'avocat' => true,
  'chambagri' => true,
  'chirurgiens-dentistes' => true,
  'experts-comptables' => true,
  'medecin' => true,
  'notaires' => true,
  'pharmacien' => true,
  'port' => true,
  'veterinaire' => true,
  'myspreadshop' => true,
  'ynh' => true
 ],
 'ga' => true,
 'gb' => true,
 'gd' => [
  'edu' => true,
  'gov' => true
 ],
 'ge' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'pvt' => true,
  'school' => true
 ],
 'gf' => true,
 'gg' => [
  'co' => true,
  'net' => true,
  'org' => true,
  'botdash' => true,
  'kaas' => true,
  'stackit' => true,
  'panel' => [
   'daemon' => true
  ]
 ],
 'gh' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'org' => true
 ],
 'gi' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'ltd' => true,
  'mod' => true,
  'org' => true
 ],
 'gl' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'net' => true,
  'org' => true,
  'biz' => true
 ],
 'gm' => true,
 'gn' => [
  'ac' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'gov' => true,
 'gp' => [
  'asso' => true,
  'com' => true,
  'edu' => true,
  'mobi' => true,
  'net' => true,
  'org' => true
 ],
 'gq' => true,
 'gr' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'barsy' => true,
  'simplesite' => true
 ],
 'gs' => true,
 'gt' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'ind' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'gu' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'guam' => true,
  'info' => true,
  'net' => true,
  'org' => true,
  'web' => true
 ],
 'gw' => true,
 'gy' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'hk' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'idv' => true,
  'net' => true,
  'org' => true,
  '个人' => true,
  '個人' => true,
  '公司' => true,
  '政府' => true,
  '敎育' => true,
  '教育' => true,
  '箇人' => true,
  '組織' => true,
  '組织' => true,
  '網絡' => true,
  '網络' => true,
  '组織' => true,
  '组织' => true,
  '网絡' => true,
  '网络' => true,
  'inc' => true,
  'ltd' => true
 ],
 'hm' => true,
 'hn' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'hr' => [
  'com' => true,
  'from' => true,
  'iz' => true,
  'name' => true,
  'brendly' => [
   'shop' => true
  ]
 ],
 'ht' => [
  'adult' => true,
  'art' => true,
  'asso' => true,
  'com' => true,
  'coop' => true,
  'edu' => true,
  'firm' => true,
  'gouv' => true,
  'info' => true,
  'med' => true,
  'net' => true,
  'org' => true,
  'perso' => true,
  'pol' => true,
  'pro' => true,
  'rel' => true,
  'shop' => true,
  'rt' => true
 ],
 'hu' => [
  '2000' => true,
  'agrar' => true,
  'bolt' => true,
  'casino' => true,
  'city' => true,
  'co' => true,
  'erotica' => true,
  'erotika' => true,
  'film' => true,
  'forum' => true,
  'games' => true,
  'hotel' => true,
  'info' => true,
  'ingatlan' => true,
  'jogasz' => true,
  'konyvelo' => true,
  'lakas' => true,
  'media' => true,
  'news' => true,
  'org' => true,
  'priv' => true,
  'reklam' => true,
  'sex' => true,
  'shop' => true,
  'sport' => true,
  'suli' => true,
  'szex' => true,
  'tm' => true,
  'tozsde' => true,
  'utazas' => true,
  'video' => true
 ],
 'id' => [
  'ac' => true,
  'biz' => true,
  'co' => true,
  'desa' => true,
  'go' => true,
  'mil' => true,
  'my' => true,
  'net' => true,
  'or' => true,
  'ponpes' => true,
  'sch' => true,
  'web' => true,
  'zone' => true
 ],
 'ie' => [
  'gov' => true,
  'myspreadshop' => true
 ],
 'il' => [
  'ac' => true,
  'co' => [
   'ravpage' => true,
   'mytabit' => true,
   'tabitorder' => true
  ],
  'gov' => true,
  'idf' => true,
  'k12' => true,
  'muni' => true,
  'net' => true,
  'org' => true
 ],
 'ישראל' => [
  'אקדמיה' => true,
  'ישוב' => true,
  'צהל' => true,
  'ממשל' => true
 ],
 'im' => [
  'ac' => true,
  'co' => [
   'ltd' => true,
   'plc' => true
  ],
  'com' => true,
  'net' => true,
  'org' => true,
  'tt' => true,
  'tv' => true
 ],
 'in' => [
  '5g' => true,
  '6g' => true,
  'ac' => true,
  'ai' => true,
  'am' => true,
  'bihar' => true,
  'biz' => true,
  'business' => true,
  'ca' => true,
  'cn' => true,
  'co' => true,
  'com' => true,
  'coop' => true,
  'cs' => true,
  'delhi' => true,
  'dr' => true,
  'edu' => true,
  'er' => true,
  'firm' => true,
  'gen' => true,
  'gov' => true,
  'gujarat' => true,
  'ind' => true,
  'info' => true,
  'int' => true,
  'internet' => true,
  'io' => true,
  'me' => true,
  'mil' => true,
  'net' => true,
  'nic' => true,
  'org' => true,
  'pg' => true,
  'post' => true,
  'pro' => true,
  'res' => true,
  'travel' => true,
  'tv' => true,
  'uk' => true,
  'up' => true,
  'us' => true,
  'cloudns' => true,
  'barsy' => true,
  'web' => true,
  'supabase' => true
 ],
 'info' => [
  'cloudns' => true,
  'dynamic-dns' => true,
  'barrel-of-knowledge' => true,
  'barrell-of-knowledge' => true,
  'dyndns' => true,
  'for-our' => true,
  'groks-the' => true,
  'groks-this' => true,
  'here-for-more' => true,
  'knowsitall' => true,
  'selfip' => true,
  'webhop' => true,
  'barsy' => true,
  'mayfirst' => true,
  'mittwald' => true,
  'mittwaldserver' => true,
  'typo3server' => true,
  'dvrcam' => true,
  'ilovecollege' => true,
  'no-ip' => true,
  'forumz' => true,
  'nsupdate' => true,
  'dnsupdate' => true,
  'v-info' => true
 ],
 'int' => [
  'eu' => true
 ],
 'io' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'nom' => true,
  'org' => true,
  'on-acorn' => [
   '*' => true
  ],
  'myaddr' => true,
  'apigee' => true,
  'b-data' => true,
  'beagleboard' => true,
  'bitbucket' => true,
  'bluebite' => true,
  'boxfuse' => true,
  'brave' => [
   's' => [
    '*' => true
   ]
  ],
  'browsersafetymark' => true,
  'bubble' => [
   'cdn' => true
  ],
  'bubbleapps' => true,
  'bigv' => [
   'uk0' => true
  ],
  'cleverapps' => true,
  'cloudbeesusercontent' => true,
  'dappnode' => [
   'dyndns' => true
  ],
  'darklang' => true,
  'definima' => true,
  'dedyn' => true,
  'fh-muenster' => true,
  'shw' => true,
  'forgerock' => [
   'id' => true
  ],
  'github' => true,
  'gitlab' => true,
  'lolipop' => true,
  'hasura-app' => true,
  'hostyhosting' => true,
  'hypernode' => true,
  'moonscale' => [
   '*' => true
  ],
  'beebyte' => [
   'paas' => true
  ],
  'beebyteapp' => [
   'sekd1' => true
  ],
  'jele' => true,
  'webthings' => true,
  'loginline' => true,
  'barsy' => true,
  'azurecontainer' => [
   '*' => true
  ],
  'ngrok' => [
   'ap' => true,
   'au' => true,
   'eu' => true,
   'in' => true,
   'jp' => true,
   'sa' => true,
   'us' => true
  ],
  'nodeart' => [
   'stage' => true
  ],
  'pantheonsite' => true,
  'pstmn' => [
   'mock' => true
  ],
  'protonet' => true,
  'qcx' => [
   'sys' => [
    '*' => true
   ]
  ],
  'qoto' => true,
  'vaporcloud' => true,
  'myrdbx' => true,
  'rb-hosting' => [
   'site' => true
  ],
  'on-k3s' => [
   '*' => true
  ],
  'on-rio' => [
   '*' => true
  ],
  'readthedocs' => true,
  'resindevice' => true,
  'resinstaging' => [
   'devices' => true
  ],
  'hzc' => true,
  'sandcats' => true,
  'scrypted' => [
   'client' => true
  ],
  'mo-siemens' => true,
  'lair' => [
   'apps' => true
  ],
  'stolos' => [
   '*' => true
  ],
  'musician' => true,
  'utwente' => true,
  'edugit' => true,
  'telebit' => true,
  'thingdust' => [
   'dev' => [
    'cust' => true,
    'reservd' => true
   ],
   'disrec' => [
    'cust' => true,
    'reservd' => true
   ],
   'prod' => [
    'cust' => true
   ],
   'testing' => [
    'cust' => true,
    'reservd' => true
   ]
  ],
  'tickets' => true,
  '2038' => true,
  'webflow' => true,
  'webflowtest' => true,
  'editorx' => true,
  'wixstudio' => true,
  'basicserver' => true,
  'virtualserver' => true
 ],
 'iq' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'ir' => [
  'ac' => true,
  'co' => true,
  'gov' => true,
  'id' => true,
  'net' => true,
  'org' => true,
  'sch' => true,
  'ایران' => true,
  'ايران' => true,
  'arvanedge' => true
 ],
 'is' => true,
 'it' => [
  'edu' => true,
  'gov' => true,
  'abr' => true,
  'abruzzo' => true,
  'aosta-valley' => true,
  'aostavalley' => true,
  'bas' => true,
  'basilicata' => true,
  'cal' => true,
  'calabria' => true,
  'cam' => true,
  'campania' => true,
  'emilia-romagna' => true,
  'emiliaromagna' => true,
  'emr' => true,
  'friuli-v-giulia' => true,
  'friuli-ve-giulia' => true,
  'friuli-vegiulia' => true,
  'friuli-venezia-giulia' => true,
  'friuli-veneziagiulia' => true,
  'friuli-vgiulia' => true,
  'friuliv-giulia' => true,
  'friulive-giulia' => true,
  'friulivegiulia' => true,
  'friulivenezia-giulia' => true,
  'friuliveneziagiulia' => true,
  'friulivgiulia' => true,
  'fvg' => true,
  'laz' => true,
  'lazio' => true,
  'lig' => true,
  'liguria' => true,
  'lom' => true,
  'lombardia' => true,
  'lombardy' => true,
  'lucania' => true,
  'mar' => true,
  'marche' => true,
  'mol' => true,
  'molise' => true,
  'piedmont' => true,
  'piemonte' => true,
  'pmn' => true,
  'pug' => true,
  'puglia' => true,
  'sar' => true,
  'sardegna' => true,
  'sardinia' => true,
  'sic' => true,
  'sicilia' => true,
  'sicily' => true,
  'taa' => true,
  'tos' => true,
  'toscana' => true,
  'trentin-sud-tirol' => true,
  'trentin-süd-tirol' => true,
  'trentin-sudtirol' => true,
  'trentin-südtirol' => true,
  'trentin-sued-tirol' => true,
  'trentin-suedtirol' => true,
  'trentino' => true,
  'trentino-a-adige' => true,
  'trentino-aadige' => true,
  'trentino-alto-adige' => true,
  'trentino-altoadige' => true,
  'trentino-s-tirol' => true,
  'trentino-stirol' => true,
  'trentino-sud-tirol' => true,
  'trentino-süd-tirol' => true,
  'trentino-sudtirol' => true,
  'trentino-südtirol' => true,
  'trentino-sued-tirol' => true,
  'trentino-suedtirol' => true,
  'trentinoa-adige' => true,
  'trentinoaadige' => true,
  'trentinoalto-adige' => true,
  'trentinoaltoadige' => true,
  'trentinos-tirol' => true,
  'trentinostirol' => true,
  'trentinosud-tirol' => true,
  'trentinosüd-tirol' => true,
  'trentinosudtirol' => true,
  'trentinosüdtirol' => true,
  'trentinosued-tirol' => true,
  'trentinosuedtirol' => true,
  'trentinsud-tirol' => true,
  'trentinsüd-tirol' => true,
  'trentinsudtirol' => true,
  'trentinsüdtirol' => true,
  'trentinsued-tirol' => true,
  'trentinsuedtirol' => true,
  'tuscany' => true,
  'umb' => true,
  'umbria' => true,
  'val-d-aosta' => true,
  'val-daosta' => true,
  'vald-aosta' => true,
  'valdaosta' => true,
  'valle-aosta' => true,
  'valle-d-aosta' => true,
  'valle-daosta' => true,
  'valleaosta' => true,
  'valled-aosta' => true,
  'valledaosta' => true,
  'vallee-aoste' => true,
  'vallée-aoste' => true,
  'vallee-d-aoste' => true,
  'vallée-d-aoste' => true,
  'valleeaoste' => true,
  'valléeaoste' => true,
  'valleedaoste' => true,
  'valléedaoste' => true,
  'vao' => true,
  'vda' => true,
  'ven' => true,
  'veneto' => true,
  'ag' => true,
  'agrigento' => true,
  'al' => true,
  'alessandria' => true,
  'alto-adige' => true,
  'altoadige' => true,
  'an' => true,
  'ancona' => true,
  'andria-barletta-trani' => true,
  'andria-trani-barletta' => true,
  'andriabarlettatrani' => true,
  'andriatranibarletta' => true,
  'ao' => true,
  'aosta' => true,
  'aoste' => true,
  'ap' => true,
  'aq' => true,
  'aquila' => true,
  'ar' => true,
  'arezzo' => true,
  'ascoli-piceno' => true,
  'ascolipiceno' => true,
  'asti' => true,
  'at' => true,
  'av' => true,
  'avellino' => true,
  'ba' => true,
  'balsan' => true,
  'balsan-sudtirol' => true,
  'balsan-südtirol' => true,
  'balsan-suedtirol' => true,
  'bari' => true,
  'barletta-trani-andria' => true,
  'barlettatraniandria' => true,
  'belluno' => true,
  'benevento' => true,
  'bergamo' => true,
  'bg' => true,
  'bi' => true,
  'biella' => true,
  'bl' => true,
  'bn' => true,
  'bo' => true,
  'bologna' => true,
  'bolzano' => true,
  'bolzano-altoadige' => true,
  'bozen' => true,
  'bozen-sudtirol' => true,
  'bozen-südtirol' => true,
  'bozen-suedtirol' => true,
  'br' => true,
  'brescia' => true,
  'brindisi' => true,
  'bs' => true,
  'bt' => true,
  'bulsan' => true,
  'bulsan-sudtirol' => true,
  'bulsan-südtirol' => true,
  'bulsan-suedtirol' => true,
  'bz' => true,
  'ca' => true,
  'cagliari' => true,
  'caltanissetta' => true,
  'campidano-medio' => true,
  'campidanomedio' => true,
  'campobasso' => true,
  'carbonia-iglesias' => true,
  'carboniaiglesias' => true,
  'carrara-massa' => true,
  'carraramassa' => true,
  'caserta' => true,
  'catania' => true,
  'catanzaro' => true,
  'cb' => true,
  'ce' => true,
  'cesena-forli' => true,
  'cesena-forlì' => true,
  'cesenaforli' => true,
  'cesenaforlì' => true,
  'ch' => true,
  'chieti' => true,
  'ci' => true,
  'cl' => true,
  'cn' => true,
  'co' => true,
  'como' => true,
  'cosenza' => true,
  'cr' => true,
  'cremona' => true,
  'crotone' => true,
  'cs' => true,
  'ct' => true,
  'cuneo' => true,
  'cz' => true,
  'dell-ogliastra' => true,
  'dellogliastra' => true,
  'en' => true,
  'enna' => true,
  'fc' => true,
  'fe' => true,
  'fermo' => true,
  'ferrara' => true,
  'fg' => true,
  'fi' => true,
  'firenze' => true,
  'florence' => true,
  'fm' => true,
  'foggia' => true,
  'forli-cesena' => true,
  'forlì-cesena' => true,
  'forlicesena' => true,
  'forlìcesena' => true,
  'fr' => true,
  'frosinone' => true,
  'ge' => true,
  'genoa' => true,
  'genova' => true,
  'go' => true,
  'gorizia' => true,
  'gr' => true,
  'grosseto' => true,
  'iglesias-carbonia' => true,
  'iglesiascarbonia' => true,
  'im' => true,
  'imperia' => true,
  'is' => true,
  'isernia' => true,
  'kr' => true,
  'la-spezia' => true,
  'laquila' => true,
  'laspezia' => true,
  'latina' => true,
  'lc' => true,
  'le' => true,
  'lecce' => true,
  'lecco' => true,
  'li' => true,
  'livorno' => true,
  'lo' => true,
  'lodi' => true,
  'lt' => true,
  'lu' => true,
  'lucca' => true,
  'macerata' => true,
  'mantova' => true,
  'massa-carrara' => true,
  'massacarrara' => true,
  'matera' => true,
  'mb' => true,
  'mc' => true,
  'me' => true,
  'medio-campidano' => true,
  'mediocampidano' => true,
  'messina' => true,
  'mi' => true,
  'milan' => true,
  'milano' => true,
  'mn' => true,
  'mo' => true,
  'modena' => true,
  'monza' => true,
  'monza-brianza' => true,
  'monza-e-della-brianza' => true,
  'monzabrianza' => true,
  'monzaebrianza' => true,
  'monzaedellabrianza' => true,
  'ms' => true,
  'mt' => true,
  'na' => true,
  'naples' => true,
  'napoli' => true,
  'no' => true,
  'novara' => true,
  'nu' => true,
  'nuoro' => true,
  'og' => true,
  'ogliastra' => true,
  'olbia-tempio' => true,
  'olbiatempio' => true,
  'or' => true,
  'oristano' => true,
  'ot' => true,
  'pa' => true,
  'padova' => true,
  'padua' => true,
  'palermo' => true,
  'parma' => true,
  'pavia' => true,
  'pc' => true,
  'pd' => true,
  'pe' => true,
  'perugia' => true,
  'pesaro-urbino' => true,
  'pesarourbino' => true,
  'pescara' => true,
  'pg' => true,
  'pi' => true,
  'piacenza' => true,
  'pisa' => true,
  'pistoia' => true,
  'pn' => true,
  'po' => true,
  'pordenone' => true,
  'potenza' => true,
  'pr' => true,
  'prato' => true,
  'pt' => true,
  'pu' => true,
  'pv' => true,
  'pz' => true,
  'ra' => true,
  'ragusa' => true,
  'ravenna' => true,
  'rc' => true,
  're' => true,
  'reggio-calabria' => true,
  'reggio-emilia' => true,
  'reggiocalabria' => true,
  'reggioemilia' => true,
  'rg' => true,
  'ri' => true,
  'rieti' => true,
  'rimini' => true,
  'rm' => true,
  'rn' => true,
  'ro' => true,
  'roma' => true,
  'rome' => true,
  'rovigo' => true,
  'sa' => true,
  'salerno' => true,
  'sassari' => true,
  'savona' => true,
  'si' => true,
  'siena' => true,
  'siracusa' => true,
  'so' => true,
  'sondrio' => true,
  'sp' => true,
  'sr' => true,
  'ss' => true,
  'südtirol' => true,
  'suedtirol' => true,
  'sv' => true,
  'ta' => true,
  'taranto' => true,
  'te' => true,
  'tempio-olbia' => true,
  'tempioolbia' => true,
  'teramo' => true,
  'terni' => true,
  'tn' => true,
  'to' => true,
  'torino' => true,
  'tp' => true,
  'tr' => true,
  'trani-andria-barletta' => true,
  'trani-barletta-andria' => true,
  'traniandriabarletta' => true,
  'tranibarlettaandria' => true,
  'trapani' => true,
  'trento' => true,
  'treviso' => true,
  'trieste' => true,
  'ts' => true,
  'turin' => true,
  'tv' => true,
  'ud' => true,
  'udine' => true,
  'urbino-pesaro' => true,
  'urbinopesaro' => true,
  'va' => true,
  'varese' => true,
  'vb' => true,
  'vc' => true,
  've' => true,
  'venezia' => true,
  'venice' => true,
  'verbania' => true,
  'vercelli' => true,
  'verona' => true,
  'vi' => true,
  'vibo-valentia' => true,
  'vibovalentia' => true,
  'vicenza' => true,
  'viterbo' => true,
  'vr' => true,
  'vs' => true,
  'vt' => true,
  'vv' => true,
  '12chars' => true,
  'ibxos' => true,
  'iliadboxos' => true,
  'neen' => [
   'jc' => true
  ],
  '123homepage' => true,
  '16-b' => true,
  '32-b' => true,
  '64-b' => true,
  'myspreadshop' => true,
  'syncloud' => true
 ],
 'je' => [
  'co' => true,
  'net' => true,
  'org' => true,
  'of' => true
 ],
 'jm' => [
  '*' => true
 ],
 'jo' => [
  'agri' => true,
  'ai' => true,
  'com' => true,
  'edu' => true,
  'eng' => true,
  'fm' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'per' => true,
  'phd' => true,
  'sch' => true,
  'tv' => true
 ],
 'jobs' => true,
 'jp' => [
  'ac' => true,
  'ad' => true,
  'co' => true,
  'ed' => true,
  'go' => true,
  'gr' => true,
  'lg' => true,
  'ne' => [
   'aseinet' => [
    'user' => true
   ],
   'gehirn' => true,
   'ivory' => true,
   'mail-box' => true,
   'mints' => true,
   'mokuren' => true,
   'opal' => true,
   'sakura' => true,
   'sumomo' => true,
   'topaz' => true
  ],
  'or' => true,
  'aichi' => [
   'aisai' => true,
   'ama' => true,
   'anjo' => true,
   'asuke' => true,
   'chiryu' => true,
   'chita' => true,
   'fuso' => true,
   'gamagori' => true,
   'handa' => true,
   'hazu' => true,
   'hekinan' => true,
   'higashiura' => true,
   'ichinomiya' => true,
   'inazawa' => true,
   'inuyama' => true,
   'isshiki' => true,
   'iwakura' => true,
   'kanie' => true,
   'kariya' => true,
   'kasugai' => true,
   'kira' => true,
   'kiyosu' => true,
   'komaki' => true,
   'konan' => true,
   'kota' => true,
   'mihama' => true,
   'miyoshi' => true,
   'nishio' => true,
   'nisshin' => true,
   'obu' => true,
   'oguchi' => true,
   'oharu' => true,
   'okazaki' => true,
   'owariasahi' => true,
   'seto' => true,
   'shikatsu' => true,
   'shinshiro' => true,
   'shitara' => true,
   'tahara' => true,
   'takahama' => true,
   'tobishima' => true,
   'toei' => true,
   'togo' => true,
   'tokai' => true,
   'tokoname' => true,
   'toyoake' => true,
   'toyohashi' => true,
   'toyokawa' => true,
   'toyone' => true,
   'toyota' => true,
   'tsushima' => true,
   'yatomi' => true
  ],
  'akita' => [
   'akita' => true,
   'daisen' => true,
   'fujisato' => true,
   'gojome' => true,
   'hachirogata' => true,
   'happou' => true,
   'higashinaruse' => true,
   'honjo' => true,
   'honjyo' => true,
   'ikawa' => true,
   'kamikoani' => true,
   'kamioka' => true,
   'katagami' => true,
   'kazuno' => true,
   'kitaakita' => true,
   'kosaka' => true,
   'kyowa' => true,
   'misato' => true,
   'mitane' => true,
   'moriyoshi' => true,
   'nikaho' => true,
   'noshiro' => true,
   'odate' => true,
   'oga' => true,
   'ogata' => true,
   'semboku' => true,
   'yokote' => true,
   'yurihonjo' => true
  ],
  'aomori' => [
   'aomori' => true,
   'gonohe' => true,
   'hachinohe' => true,
   'hashikami' => true,
   'hiranai' => true,
   'hirosaki' => true,
   'itayanagi' => true,
   'kuroishi' => true,
   'misawa' => true,
   'mutsu' => true,
   'nakadomari' => true,
   'noheji' => true,
   'oirase' => true,
   'owani' => true,
   'rokunohe' => true,
   'sannohe' => true,
   'shichinohe' => true,
   'shingo' => true,
   'takko' => true,
   'towada' => true,
   'tsugaru' => true,
   'tsuruta' => true
  ],
  'chiba' => [
   'abiko' => true,
   'asahi' => true,
   'chonan' => true,
   'chosei' => true,
   'choshi' => true,
   'chuo' => true,
   'funabashi' => true,
   'futtsu' => true,
   'hanamigawa' => true,
   'ichihara' => true,
   'ichikawa' => true,
   'ichinomiya' => true,
   'inzai' => true,
   'isumi' => true,
   'kamagaya' => true,
   'kamogawa' => true,
   'kashiwa' => true,
   'katori' => true,
   'katsuura' => true,
   'kimitsu' => true,
   'kisarazu' => true,
   'kozaki' => true,
   'kujukuri' => true,
   'kyonan' => true,
   'matsudo' => true,
   'midori' => true,
   'mihama' => true,
   'minamiboso' => true,
   'mobara' => true,
   'mutsuzawa' => true,
   'nagara' => true,
   'nagareyama' => true,
   'narashino' => true,
   'narita' => true,
   'noda' => true,
   'oamishirasato' => true,
   'omigawa' => true,
   'onjuku' => true,
   'otaki' => true,
   'sakae' => true,
   'sakura' => true,
   'shimofusa' => true,
   'shirako' => true,
   'shiroi' => true,
   'shisui' => true,
   'sodegaura' => true,
   'sosa' => true,
   'tako' => true,
   'tateyama' => true,
   'togane' => true,
   'tohnosho' => true,
   'tomisato' => true,
   'urayasu' => true,
   'yachimata' => true,
   'yachiyo' => true,
   'yokaichiba' => true,
   'yokoshibahikari' => true,
   'yotsukaido' => true
  ],
  'ehime' => [
   'ainan' => true,
   'honai' => true,
   'ikata' => true,
   'imabari' => true,
   'iyo' => true,
   'kamijima' => true,
   'kihoku' => true,
   'kumakogen' => true,
   'masaki' => true,
   'matsuno' => true,
   'matsuyama' => true,
   'namikata' => true,
   'niihama' => true,
   'ozu' => true,
   'saijo' => true,
   'seiyo' => true,
   'shikokuchuo' => true,
   'tobe' => true,
   'toon' => true,
   'uchiko' => true,
   'uwajima' => true,
   'yawatahama' => true
  ],
  'fukui' => [
   'echizen' => true,
   'eiheiji' => true,
   'fukui' => true,
   'ikeda' => true,
   'katsuyama' => true,
   'mihama' => true,
   'minamiechizen' => true,
   'obama' => true,
   'ohi' => true,
   'ono' => true,
   'sabae' => true,
   'sakai' => true,
   'takahama' => true,
   'tsuruga' => true,
   'wakasa' => true
  ],
  'fukuoka' => [
   'ashiya' => true,
   'buzen' => true,
   'chikugo' => true,
   'chikuho' => true,
   'chikujo' => true,
   'chikushino' => true,
   'chikuzen' => true,
   'chuo' => true,
   'dazaifu' => true,
   'fukuchi' => true,
   'hakata' => true,
   'higashi' => true,
   'hirokawa' => true,
   'hisayama' => true,
   'iizuka' => true,
   'inatsuki' => true,
   'kaho' => true,
   'kasuga' => true,
   'kasuya' => true,
   'kawara' => true,
   'keisen' => true,
   'koga' => true,
   'kurate' => true,
   'kurogi' => true,
   'kurume' => true,
   'minami' => true,
   'miyako' => true,
   'miyama' => true,
   'miyawaka' => true,
   'mizumaki' => true,
   'munakata' => true,
   'nakagawa' => true,
   'nakama' => true,
   'nishi' => true,
   'nogata' => true,
   'ogori' => true,
   'okagaki' => true,
   'okawa' => true,
   'oki' => true,
   'omuta' => true,
   'onga' => true,
   'onojo' => true,
   'oto' => true,
   'saigawa' => true,
   'sasaguri' => true,
   'shingu' => true,
   'shinyoshitomi' => true,
   'shonai' => true,
   'soeda' => true,
   'sue' => true,
   'tachiarai' => true,
   'tagawa' => true,
   'takata' => true,
   'toho' => true,
   'toyotsu' => true,
   'tsuiki' => true,
   'ukiha' => true,
   'umi' => true,
   'usui' => true,
   'yamada' => true,
   'yame' => true,
   'yanagawa' => true,
   'yukuhashi' => true
  ],
  'fukushima' => [
   'aizubange' => true,
   'aizumisato' => true,
   'aizuwakamatsu' => true,
   'asakawa' => true,
   'bandai' => true,
   'date' => true,
   'fukushima' => true,
   'furudono' => true,
   'futaba' => true,
   'hanawa' => true,
   'higashi' => true,
   'hirata' => true,
   'hirono' => true,
   'iitate' => true,
   'inawashiro' => true,
   'ishikawa' => true,
   'iwaki' => true,
   'izumizaki' => true,
   'kagamiishi' => true,
   'kaneyama' => true,
   'kawamata' => true,
   'kitakata' => true,
   'kitashiobara' => true,
   'koori' => true,
   'koriyama' => true,
   'kunimi' => true,
   'miharu' => true,
   'mishima' => true,
   'namie' => true,
   'nango' => true,
   'nishiaizu' => true,
   'nishigo' => true,
   'okuma' => true,
   'omotego' => true,
   'ono' => true,
   'otama' => true,
   'samegawa' => true,
   'shimogo' => true,
   'shirakawa' => true,
   'showa' => true,
   'soma' => true,
   'sukagawa' => true,
   'taishin' => true,
   'tamakawa' => true,
   'tanagura' => true,
   'tenei' => true,
   'yabuki' => true,
   'yamato' => true,
   'yamatsuri' => true,
   'yanaizu' => true,
   'yugawa' => true
  ],
  'gifu' => [
   'anpachi' => true,
   'ena' => true,
   'gifu' => true,
   'ginan' => true,
   'godo' => true,
   'gujo' => true,
   'hashima' => true,
   'hichiso' => true,
   'hida' => true,
   'higashishirakawa' => true,
   'ibigawa' => true,
   'ikeda' => true,
   'kakamigahara' => true,
   'kani' => true,
   'kasahara' => true,
   'kasamatsu' => true,
   'kawaue' => true,
   'kitagata' => true,
   'mino' => true,
   'minokamo' => true,
   'mitake' => true,
   'mizunami' => true,
   'motosu' => true,
   'nakatsugawa' => true,
   'ogaki' => true,
   'sakahogi' => true,
   'seki' => true,
   'sekigahara' => true,
   'shirakawa' => true,
   'tajimi' => true,
   'takayama' => true,
   'tarui' => true,
   'toki' => true,
   'tomika' => true,
   'wanouchi' => true,
   'yamagata' => true,
   'yaotsu' => true,
   'yoro' => true
  ],
  'gunma' => [
   'annaka' => true,
   'chiyoda' => true,
   'fujioka' => true,
   'higashiagatsuma' => true,
   'isesaki' => true,
   'itakura' => true,
   'kanna' => true,
   'kanra' => true,
   'katashina' => true,
   'kawaba' => true,
   'kiryu' => true,
   'kusatsu' => true,
   'maebashi' => true,
   'meiwa' => true,
   'midori' => true,
   'minakami' => true,
   'naganohara' => true,
   'nakanojo' => true,
   'nanmoku' => true,
   'numata' => true,
   'oizumi' => true,
   'ora' => true,
   'ota' => true,
   'shibukawa' => true,
   'shimonita' => true,
   'shinto' => true,
   'showa' => true,
   'takasaki' => true,
   'takayama' => true,
   'tamamura' => true,
   'tatebayashi' => true,
   'tomioka' => true,
   'tsukiyono' => true,
   'tsumagoi' => true,
   'ueno' => true,
   'yoshioka' => true
  ],
  'hiroshima' => [
   'asaminami' => true,
   'daiwa' => true,
   'etajima' => true,
   'fuchu' => true,
   'fukuyama' => true,
   'hatsukaichi' => true,
   'higashihiroshima' => true,
   'hongo' => true,
   'jinsekikogen' => true,
   'kaita' => true,
   'kui' => true,
   'kumano' => true,
   'kure' => true,
   'mihara' => true,
   'miyoshi' => true,
   'naka' => true,
   'onomichi' => true,
   'osakikamijima' => true,
   'otake' => true,
   'saka' => true,
   'sera' => true,
   'seranishi' => true,
   'shinichi' => true,
   'shobara' => true,
   'takehara' => true
  ],
  'hokkaido' => [
   'abashiri' => true,
   'abira' => true,
   'aibetsu' => true,
   'akabira' => true,
   'akkeshi' => true,
   'asahikawa' => true,
   'ashibetsu' => true,
   'ashoro' => true,
   'assabu' => true,
   'atsuma' => true,
   'bibai' => true,
   'biei' => true,
   'bifuka' => true,
   'bihoro' => true,
   'biratori' => true,
   'chippubetsu' => true,
   'chitose' => true,
   'date' => true,
   'ebetsu' => true,
   'embetsu' => true,
   'eniwa' => true,
   'erimo' => true,
   'esan' => true,
   'esashi' => true,
   'fukagawa' => true,
   'fukushima' => true,
   'furano' => true,
   'furubira' => true,
   'haboro' => true,
   'hakodate' => true,
   'hamatonbetsu' => true,
   'hidaka' => true,
   'higashikagura' => true,
   'higashikawa' => true,
   'hiroo' => true,
   'hokuryu' => true,
   'hokuto' => true,
   'honbetsu' => true,
   'horokanai' => true,
   'horonobe' => true,
   'ikeda' => true,
   'imakane' => true,
   'ishikari' => true,
   'iwamizawa' => true,
   'iwanai' => true,
   'kamifurano' => true,
   'kamikawa' => true,
   'kamishihoro' => true,
   'kamisunagawa' => true,
   'kamoenai' => true,
   'kayabe' => true,
   'kembuchi' => true,
   'kikonai' => true,
   'kimobetsu' => true,
   'kitahiroshima' => true,
   'kitami' => true,
   'kiyosato' => true,
   'koshimizu' => true,
   'kunneppu' => true,
   'kuriyama' => true,
   'kuromatsunai' => true,
   'kushiro' => true,
   'kutchan' => true,
   'kyowa' => true,
   'mashike' => true,
   'matsumae' => true,
   'mikasa' => true,
   'minamifurano' => true,
   'mombetsu' => true,
   'moseushi' => true,
   'mukawa' => true,
   'muroran' => true,
   'naie' => true,
   'nakagawa' => true,
   'nakasatsunai' => true,
   'nakatombetsu' => true,
   'nanae' => true,
   'nanporo' => true,
   'nayoro' => true,
   'nemuro' => true,
   'niikappu' => true,
   'niki' => true,
   'nishiokoppe' => true,
   'noboribetsu' => true,
   'numata' => true,
   'obihiro' => true,
   'obira' => true,
   'oketo' => true,
   'okoppe' => true,
   'otaru' => true,
   'otobe' => true,
   'otofuke' => true,
   'otoineppu' => true,
   'oumu' => true,
   'ozora' => true,
   'pippu' => true,
   'rankoshi' => true,
   'rebun' => true,
   'rikubetsu' => true,
   'rishiri' => true,
   'rishirifuji' => true,
   'saroma' => true,
   'sarufutsu' => true,
   'shakotan' => true,
   'shari' => true,
   'shibecha' => true,
   'shibetsu' => true,
   'shikabe' => true,
   'shikaoi' => true,
   'shimamaki' => true,
   'shimizu' => true,
   'shimokawa' => true,
   'shinshinotsu' => true,
   'shintoku' => true,
   'shiranuka' => true,
   'shiraoi' => true,
   'shiriuchi' => true,
   'sobetsu' => true,
   'sunagawa' => true,
   'taiki' => true,
   'takasu' => true,
   'takikawa' => true,
   'takinoue' => true,
   'teshikaga' => true,
   'tobetsu' => true,
   'tohma' => true,
   'tomakomai' => true,
   'tomari' => true,
   'toya' => true,
   'toyako' => true,
   'toyotomi' => true,
   'toyoura' => true,
   'tsubetsu' => true,
   'tsukigata' => true,
   'urakawa' => true,
   'urausu' => true,
   'uryu' => true,
   'utashinai' => true,
   'wakkanai' => true,
   'wassamu' => true,
   'yakumo' => true,
   'yoichi' => true
  ],
  'hyogo' => [
   'aioi' => true,
   'akashi' => true,
   'ako' => true,
   'amagasaki' => true,
   'aogaki' => true,
   'asago' => true,
   'ashiya' => true,
   'awaji' => true,
   'fukusaki' => true,
   'goshiki' => true,
   'harima' => true,
   'himeji' => true,
   'ichikawa' => true,
   'inagawa' => true,
   'itami' => true,
   'kakogawa' => true,
   'kamigori' => true,
   'kamikawa' => true,
   'kasai' => true,
   'kasuga' => true,
   'kawanishi' => true,
   'miki' => true,
   'minamiawaji' => true,
   'nishinomiya' => true,
   'nishiwaki' => true,
   'ono' => true,
   'sanda' => true,
   'sannan' => true,
   'sasayama' => true,
   'sayo' => true,
   'shingu' => true,
   'shinonsen' => true,
   'shiso' => true,
   'sumoto' => true,
   'taishi' => true,
   'taka' => true,
   'takarazuka' => true,
   'takasago' => true,
   'takino' => true,
   'tamba' => true,
   'tatsuno' => true,
   'toyooka' => true,
   'yabu' => true,
   'yashiro' => true,
   'yoka' => true,
   'yokawa' => true
  ],
  'ibaraki' => [
   'ami' => true,
   'asahi' => true,
   'bando' => true,
   'chikusei' => true,
   'daigo' => true,
   'fujishiro' => true,
   'hitachi' => true,
   'hitachinaka' => true,
   'hitachiomiya' => true,
   'hitachiota' => true,
   'ibaraki' => true,
   'ina' => true,
   'inashiki' => true,
   'itako' => true,
   'iwama' => true,
   'joso' => true,
   'kamisu' => true,
   'kasama' => true,
   'kashima' => true,
   'kasumigaura' => true,
   'koga' => true,
   'miho' => true,
   'mito' => true,
   'moriya' => true,
   'naka' => true,
   'namegata' => true,
   'oarai' => true,
   'ogawa' => true,
   'omitama' => true,
   'ryugasaki' => true,
   'sakai' => true,
   'sakuragawa' => true,
   'shimodate' => true,
   'shimotsuma' => true,
   'shirosato' => true,
   'sowa' => true,
   'suifu' => true,
   'takahagi' => true,
   'tamatsukuri' => true,
   'tokai' => true,
   'tomobe' => true,
   'tone' => true,
   'toride' => true,
   'tsuchiura' => true,
   'tsukuba' => true,
   'uchihara' => true,
   'ushiku' => true,
   'yachiyo' => true,
   'yamagata' => true,
   'yawara' => true,
   'yuki' => true
  ],
  'ishikawa' => [
   'anamizu' => true,
   'hakui' => true,
   'hakusan' => true,
   'kaga' => true,
   'kahoku' => true,
   'kanazawa' => true,
   'kawakita' => true,
   'komatsu' => true,
   'nakanoto' => true,
   'nanao' => true,
   'nomi' => true,
   'nonoichi' => true,
   'noto' => true,
   'shika' => true,
   'suzu' => true,
   'tsubata' => true,
   'tsurugi' => true,
   'uchinada' => true,
   'wajima' => true
  ],
  'iwate' => [
   'fudai' => true,
   'fujisawa' => true,
   'hanamaki' => true,
   'hiraizumi' => true,
   'hirono' => true,
   'ichinohe' => true,
   'ichinoseki' => true,
   'iwaizumi' => true,
   'iwate' => true,
   'joboji' => true,
   'kamaishi' => true,
   'kanegasaki' => true,
   'karumai' => true,
   'kawai' => true,
   'kitakami' => true,
   'kuji' => true,
   'kunohe' => true,
   'kuzumaki' => true,
   'miyako' => true,
   'mizusawa' => true,
   'morioka' => true,
   'ninohe' => true,
   'noda' => true,
   'ofunato' => true,
   'oshu' => true,
   'otsuchi' => true,
   'rikuzentakata' => true,
   'shiwa' => true,
   'shizukuishi' => true,
   'sumita' => true,
   'tanohata' => true,
   'tono' => true,
   'yahaba' => true,
   'yamada' => true
  ],
  'kagawa' => [
   'ayagawa' => true,
   'higashikagawa' => true,
   'kanonji' => true,
   'kotohira' => true,
   'manno' => true,
   'marugame' => true,
   'mitoyo' => true,
   'naoshima' => true,
   'sanuki' => true,
   'tadotsu' => true,
   'takamatsu' => true,
   'tonosho' => true,
   'uchinomi' => true,
   'utazu' => true,
   'zentsuji' => true
  ],
  'kagoshima' => [
   'akune' => true,
   'amami' => true,
   'hioki' => true,
   'isa' => true,
   'isen' => true,
   'izumi' => true,
   'kagoshima' => true,
   'kanoya' => true,
   'kawanabe' => true,
   'kinko' => true,
   'kouyama' => true,
   'makurazaki' => true,
   'matsumoto' => true,
   'minamitane' => true,
   'nakatane' => true,
   'nishinoomote' => true,
   'satsumasendai' => true,
   'soo' => true,
   'tarumizu' => true,
   'yusui' => true
  ],
  'kanagawa' => [
   'aikawa' => true,
   'atsugi' => true,
   'ayase' => true,
   'chigasaki' => true,
   'ebina' => true,
   'fujisawa' => true,
   'hadano' => true,
   'hakone' => true,
   'hiratsuka' => true,
   'isehara' => true,
   'kaisei' => true,
   'kamakura' => true,
   'kiyokawa' => true,
   'matsuda' => true,
   'minamiashigara' => true,
   'miura' => true,
   'nakai' => true,
   'ninomiya' => true,
   'odawara' => true,
   'oi' => true,
   'oiso' => true,
   'sagamihara' => true,
   'samukawa' => true,
   'tsukui' => true,
   'yamakita' => true,
   'yamato' => true,
   'yokosuka' => true,
   'yugawara' => true,
   'zama' => true,
   'zushi' => true
  ],
  'kochi' => [
   'aki' => true,
   'geisei' => true,
   'hidaka' => true,
   'higashitsuno' => true,
   'ino' => true,
   'kagami' => true,
   'kami' => true,
   'kitagawa' => true,
   'kochi' => true,
   'mihara' => true,
   'motoyama' => true,
   'muroto' => true,
   'nahari' => true,
   'nakamura' => true,
   'nankoku' => true,
   'nishitosa' => true,
   'niyodogawa' => true,
   'ochi' => true,
   'okawa' => true,
   'otoyo' => true,
   'otsuki' => true,
   'sakawa' => true,
   'sukumo' => true,
   'susaki' => true,
   'tosa' => true,
   'tosashimizu' => true,
   'toyo' => true,
   'tsuno' => true,
   'umaji' => true,
   'yasuda' => true,
   'yusuhara' => true
  ],
  'kumamoto' => [
   'amakusa' => true,
   'arao' => true,
   'aso' => true,
   'choyo' => true,
   'gyokuto' => true,
   'kamiamakusa' => true,
   'kikuchi' => true,
   'kumamoto' => true,
   'mashiki' => true,
   'mifune' => true,
   'minamata' => true,
   'minamioguni' => true,
   'nagasu' => true,
   'nishihara' => true,
   'oguni' => true,
   'ozu' => true,
   'sumoto' => true,
   'takamori' => true,
   'uki' => true,
   'uto' => true,
   'yamaga' => true,
   'yamato' => true,
   'yatsushiro' => true
  ],
  'kyoto' => [
   'ayabe' => true,
   'fukuchiyama' => true,
   'higashiyama' => true,
   'ide' => true,
   'ine' => true,
   'joyo' => true,
   'kameoka' => true,
   'kamo' => true,
   'kita' => true,
   'kizu' => true,
   'kumiyama' => true,
   'kyotamba' => true,
   'kyotanabe' => true,
   'kyotango' => true,
   'maizuru' => true,
   'minami' => true,
   'minamiyamashiro' => true,
   'miyazu' => true,
   'muko' => true,
   'nagaokakyo' => true,
   'nakagyo' => true,
   'nantan' => true,
   'oyamazaki' => true,
   'sakyo' => true,
   'seika' => true,
   'tanabe' => true,
   'uji' => true,
   'ujitawara' => true,
   'wazuka' => true,
   'yamashina' => true,
   'yawata' => true
  ],
  'mie' => [
   'asahi' => true,
   'inabe' => true,
   'ise' => true,
   'kameyama' => true,
   'kawagoe' => true,
   'kiho' => true,
   'kisosaki' => true,
   'kiwa' => true,
   'komono' => true,
   'kumano' => true,
   'kuwana' => true,
   'matsusaka' => true,
   'meiwa' => true,
   'mihama' => true,
   'minamiise' => true,
   'misugi' => true,
   'miyama' => true,
   'nabari' => true,
   'shima' => true,
   'suzuka' => true,
   'tado' => true,
   'taiki' => true,
   'taki' => true,
   'tamaki' => true,
   'toba' => true,
   'tsu' => true,
   'udono' => true,
   'ureshino' => true,
   'watarai' => true,
   'yokkaichi' => true
  ],
  'miyagi' => [
   'furukawa' => true,
   'higashimatsushima' => true,
   'ishinomaki' => true,
   'iwanuma' => true,
   'kakuda' => true,
   'kami' => true,
   'kawasaki' => true,
   'marumori' => true,
   'matsushima' => true,
   'minamisanriku' => true,
   'misato' => true,
   'murata' => true,
   'natori' => true,
   'ogawara' => true,
   'ohira' => true,
   'onagawa' => true,
   'osaki' => true,
   'rifu' => true,
   'semine' => true,
   'shibata' => true,
   'shichikashuku' => true,
   'shikama' => true,
   'shiogama' => true,
   'shiroishi' => true,
   'tagajo' => true,
   'taiwa' => true,
   'tome' => true,
   'tomiya' => true,
   'wakuya' => true,
   'watari' => true,
   'yamamoto' => true,
   'zao' => true
  ],
  'miyazaki' => [
   'aya' => true,
   'ebino' => true,
   'gokase' => true,
   'hyuga' => true,
   'kadogawa' => true,
   'kawaminami' => true,
   'kijo' => true,
   'kitagawa' => true,
   'kitakata' => true,
   'kitaura' => true,
   'kobayashi' => true,
   'kunitomi' => true,
   'kushima' => true,
   'mimata' => true,
   'miyakonojo' => true,
   'miyazaki' => true,
   'morotsuka' => true,
   'nichinan' => true,
   'nishimera' => true,
   'nobeoka' => true,
   'saito' => true,
   'shiiba' => true,
   'shintomi' => true,
   'takaharu' => true,
   'takanabe' => true,
   'takazaki' => true,
   'tsuno' => true
  ],
  'nagano' => [
   'achi' => true,
   'agematsu' => true,
   'anan' => true,
   'aoki' => true,
   'asahi' => true,
   'azumino' => true,
   'chikuhoku' => true,
   'chikuma' => true,
   'chino' => true,
   'fujimi' => true,
   'hakuba' => true,
   'hara' => true,
   'hiraya' => true,
   'iida' => true,
   'iijima' => true,
   'iiyama' => true,
   'iizuna' => true,
   'ikeda' => true,
   'ikusaka' => true,
   'ina' => true,
   'karuizawa' => true,
   'kawakami' => true,
   'kiso' => true,
   'kisofukushima' => true,
   'kitaaiki' => true,
   'komagane' => true,
   'komoro' => true,
   'matsukawa' => true,
   'matsumoto' => true,
   'miasa' => true,
   'minamiaiki' => true,
   'minamimaki' => true,
   'minamiminowa' => true,
   'minowa' => true,
   'miyada' => true,
   'miyota' => true,
   'mochizuki' => true,
   'nagano' => true,
   'nagawa' => true,
   'nagiso' => true,
   'nakagawa' => true,
   'nakano' => true,
   'nozawaonsen' => true,
   'obuse' => true,
   'ogawa' => true,
   'okaya' => true,
   'omachi' => true,
   'omi' => true,
   'ookuwa' => true,
   'ooshika' => true,
   'otaki' => true,
   'otari' => true,
   'sakae' => true,
   'sakaki' => true,
   'saku' => true,
   'sakuho' => true,
   'shimosuwa' => true,
   'shinanomachi' => true,
   'shiojiri' => true,
   'suwa' => true,
   'suzaka' => true,
   'takagi' => true,
   'takamori' => true,
   'takayama' => true,
   'tateshina' => true,
   'tatsuno' => true,
   'togakushi' => true,
   'togura' => true,
   'tomi' => true,
   'ueda' => true,
   'wada' => true,
   'yamagata' => true,
   'yamanouchi' => true,
   'yasaka' => true,
   'yasuoka' => true
  ],
  'nagasaki' => [
   'chijiwa' => true,
   'futsu' => true,
   'goto' => true,
   'hasami' => true,
   'hirado' => true,
   'iki' => true,
   'isahaya' => true,
   'kawatana' => true,
   'kuchinotsu' => true,
   'matsuura' => true,
   'nagasaki' => true,
   'obama' => true,
   'omura' => true,
   'oseto' => true,
   'saikai' => true,
   'sasebo' => true,
   'seihi' => true,
   'shimabara' => true,
   'shinkamigoto' => true,
   'togitsu' => true,
   'tsushima' => true,
   'unzen' => true
  ],
  'nara' => [
   'ando' => true,
   'gose' => true,
   'heguri' => true,
   'higashiyoshino' => true,
   'ikaruga' => true,
   'ikoma' => true,
   'kamikitayama' => true,
   'kanmaki' => true,
   'kashiba' => true,
   'kashihara' => true,
   'katsuragi' => true,
   'kawai' => true,
   'kawakami' => true,
   'kawanishi' => true,
   'koryo' => true,
   'kurotaki' => true,
   'mitsue' => true,
   'miyake' => true,
   'nara' => true,
   'nosegawa' => true,
   'oji' => true,
   'ouda' => true,
   'oyodo' => true,
   'sakurai' => true,
   'sango' => true,
   'shimoichi' => true,
   'shimokitayama' => true,
   'shinjo' => true,
   'soni' => true,
   'takatori' => true,
   'tawaramoto' => true,
   'tenkawa' => true,
   'tenri' => true,
   'uda' => true,
   'yamatokoriyama' => true,
   'yamatotakada' => true,
   'yamazoe' => true,
   'yoshino' => true
  ],
  'niigata' => [
   'aga' => true,
   'agano' => true,
   'gosen' => true,
   'itoigawa' => true,
   'izumozaki' => true,
   'joetsu' => true,
   'kamo' => true,
   'kariwa' => true,
   'kashiwazaki' => true,
   'minamiuonuma' => true,
   'mitsuke' => true,
   'muika' => true,
   'murakami' => true,
   'myoko' => true,
   'nagaoka' => true,
   'niigata' => true,
   'ojiya' => true,
   'omi' => true,
   'sado' => true,
   'sanjo' => true,
   'seiro' => true,
   'seirou' => true,
   'sekikawa' => true,
   'shibata' => true,
   'tagami' => true,
   'tainai' => true,
   'tochio' => true,
   'tokamachi' => true,
   'tsubame' => true,
   'tsunan' => true,
   'uonuma' => true,
   'yahiko' => true,
   'yoita' => true,
   'yuzawa' => true
  ],
  'oita' => [
   'beppu' => true,
   'bungoono' => true,
   'bungotakada' => true,
   'hasama' => true,
   'hiji' => true,
   'himeshima' => true,
   'hita' => true,
   'kamitsue' => true,
   'kokonoe' => true,
   'kuju' => true,
   'kunisaki' => true,
   'kusu' => true,
   'oita' => true,
   'saiki' => true,
   'taketa' => true,
   'tsukumi' => true,
   'usa' => true,
   'usuki' => true,
   'yufu' => true
  ],
  'okayama' => [
   'akaiwa' => true,
   'asakuchi' => true,
   'bizen' => true,
   'hayashima' => true,
   'ibara' => true,
   'kagamino' => true,
   'kasaoka' => true,
   'kibichuo' => true,
   'kumenan' => true,
   'kurashiki' => true,
   'maniwa' => true,
   'misaki' => true,
   'nagi' => true,
   'niimi' => true,
   'nishiawakura' => true,
   'okayama' => true,
   'satosho' => true,
   'setouchi' => true,
   'shinjo' => true,
   'shoo' => true,
   'soja' => true,
   'takahashi' => true,
   'tamano' => true,
   'tsuyama' => true,
   'wake' => true,
   'yakage' => true
  ],
  'okinawa' => [
   'aguni' => true,
   'ginowan' => true,
   'ginoza' => true,
   'gushikami' => true,
   'haebaru' => true,
   'higashi' => true,
   'hirara' => true,
   'iheya' => true,
   'ishigaki' => true,
   'ishikawa' => true,
   'itoman' => true,
   'izena' => true,
   'kadena' => true,
   'kin' => true,
   'kitadaito' => true,
   'kitanakagusuku' => true,
   'kumejima' => true,
   'kunigami' => true,
   'minamidaito' => true,
   'motobu' => true,
   'nago' => true,
   'naha' => true,
   'nakagusuku' => true,
   'nakijin' => true,
   'nanjo' => true,
   'nishihara' => true,
   'ogimi' => true,
   'okinawa' => true,
   'onna' => true,
   'shimoji' => true,
   'taketomi' => true,
   'tarama' => true,
   'tokashiki' => true,
   'tomigusuku' => true,
   'tonaki' => true,
   'urasoe' => true,
   'uruma' => true,
   'yaese' => true,
   'yomitan' => true,
   'yonabaru' => true,
   'yonaguni' => true,
   'zamami' => true
  ],
  'osaka' => [
   'abeno' => true,
   'chihayaakasaka' => true,
   'chuo' => true,
   'daito' => true,
   'fujiidera' => true,
   'habikino' => true,
   'hannan' => true,
   'higashiosaka' => true,
   'higashisumiyoshi' => true,
   'higashiyodogawa' => true,
   'hirakata' => true,
   'ibaraki' => true,
   'ikeda' => true,
   'izumi' => true,
   'izumiotsu' => true,
   'izumisano' => true,
   'kadoma' => true,
   'kaizuka' => true,
   'kanan' => true,
   'kashiwara' => true,
   'katano' => true,
   'kawachinagano' => true,
   'kishiwada' => true,
   'kita' => true,
   'kumatori' => true,
   'matsubara' => true,
   'minato' => true,
   'minoh' => true,
   'misaki' => true,
   'moriguchi' => true,
   'neyagawa' => true,
   'nishi' => true,
   'nose' => true,
   'osakasayama' => true,
   'sakai' => true,
   'sayama' => true,
   'sennan' => true,
   'settsu' => true,
   'shijonawate' => true,
   'shimamoto' => true,
   'suita' => true,
   'tadaoka' => true,
   'taishi' => true,
   'tajiri' => true,
   'takaishi' => true,
   'takatsuki' => true,
   'tondabayashi' => true,
   'toyonaka' => true,
   'toyono' => true,
   'yao' => true
  ],
  'saga' => [
   'ariake' => true,
   'arita' => true,
   'fukudomi' => true,
   'genkai' => true,
   'hamatama' => true,
   'hizen' => true,
   'imari' => true,
   'kamimine' => true,
   'kanzaki' => true,
   'karatsu' => true,
   'kashima' => true,
   'kitagata' => true,
   'kitahata' => true,
   'kiyama' => true,
   'kouhoku' => true,
   'kyuragi' => true,
   'nishiarita' => true,
   'ogi' => true,
   'omachi' => true,
   'ouchi' => true,
   'saga' => true,
   'shiroishi' => true,
   'taku' => true,
   'tara' => true,
   'tosu' => true,
   'yoshinogari' => true
  ],
  'saitama' => [
   'arakawa' => true,
   'asaka' => true,
   'chichibu' => true,
   'fujimi' => true,
   'fujimino' => true,
   'fukaya' => true,
   'hanno' => true,
   'hanyu' => true,
   'hasuda' => true,
   'hatogaya' => true,
   'hatoyama' => true,
   'hidaka' => true,
   'higashichichibu' => true,
   'higashimatsuyama' => true,
   'honjo' => true,
   'ina' => true,
   'iruma' => true,
   'iwatsuki' => true,
   'kamiizumi' => true,
   'kamikawa' => true,
   'kamisato' => true,
   'kasukabe' => true,
   'kawagoe' => true,
   'kawaguchi' => true,
   'kawajima' => true,
   'kazo' => true,
   'kitamoto' => true,
   'koshigaya' => true,
   'kounosu' => true,
   'kuki' => true,
   'kumagaya' => true,
   'matsubushi' => true,
   'minano' => true,
   'misato' => true,
   'miyashiro' => true,
   'miyoshi' => true,
   'moroyama' => true,
   'nagatoro' => true,
   'namegawa' => true,
   'niiza' => true,
   'ogano' => true,
   'ogawa' => true,
   'ogose' => true,
   'okegawa' => true,
   'omiya' => true,
   'otaki' => true,
   'ranzan' => true,
   'ryokami' => true,
   'saitama' => true,
   'sakado' => true,
   'satte' => true,
   'sayama' => true,
   'shiki' => true,
   'shiraoka' => true,
   'soka' => true,
   'sugito' => true,
   'toda' => true,
   'tokigawa' => true,
   'tokorozawa' => true,
   'tsurugashima' => true,
   'urawa' => true,
   'warabi' => true,
   'yashio' => true,
   'yokoze' => true,
   'yono' => true,
   'yorii' => true,
   'yoshida' => true,
   'yoshikawa' => true,
   'yoshimi' => true
  ],
  'shiga' => [
   'aisho' => true,
   'gamo' => true,
   'higashiomi' => true,
   'hikone' => true,
   'koka' => true,
   'konan' => true,
   'kosei' => true,
   'koto' => true,
   'kusatsu' => true,
   'maibara' => true,
   'moriyama' => true,
   'nagahama' => true,
   'nishiazai' => true,
   'notogawa' => true,
   'omihachiman' => true,
   'otsu' => true,
   'ritto' => true,
   'ryuoh' => true,
   'takashima' => true,
   'takatsuki' => true,
   'torahime' => true,
   'toyosato' => true,
   'yasu' => true
  ],
  'shimane' => [
   'akagi' => true,
   'ama' => true,
   'gotsu' => true,
   'hamada' => true,
   'higashiizumo' => true,
   'hikawa' => true,
   'hikimi' => true,
   'izumo' => true,
   'kakinoki' => true,
   'masuda' => true,
   'matsue' => true,
   'misato' => true,
   'nishinoshima' => true,
   'ohda' => true,
   'okinoshima' => true,
   'okuizumo' => true,
   'shimane' => true,
   'tamayu' => true,
   'tsuwano' => true,
   'unnan' => true,
   'yakumo' => true,
   'yasugi' => true,
   'yatsuka' => true
  ],
  'shizuoka' => [
   'arai' => true,
   'atami' => true,
   'fuji' => true,
   'fujieda' => true,
   'fujikawa' => true,
   'fujinomiya' => true,
   'fukuroi' => true,
   'gotemba' => true,
   'haibara' => true,
   'hamamatsu' => true,
   'higashiizu' => true,
   'ito' => true,
   'iwata' => true,
   'izu' => true,
   'izunokuni' => true,
   'kakegawa' => true,
   'kannami' => true,
   'kawanehon' => true,
   'kawazu' => true,
   'kikugawa' => true,
   'kosai' => true,
   'makinohara' => true,
   'matsuzaki' => true,
   'minamiizu' => true,
   'mishima' => true,
   'morimachi' => true,
   'nishiizu' => true,
   'numazu' => true,
   'omaezaki' => true,
   'shimada' => true,
   'shimizu' => true,
   'shimoda' => true,
   'shizuoka' => true,
   'susono' => true,
   'yaizu' => true,
   'yoshida' => true
  ],
  'tochigi' => [
   'ashikaga' => true,
   'bato' => true,
   'haga' => true,
   'ichikai' => true,
   'iwafune' => true,
   'kaminokawa' => true,
   'kanuma' => true,
   'karasuyama' => true,
   'kuroiso' => true,
   'mashiko' => true,
   'mibu' => true,
   'moka' => true,
   'motegi' => true,
   'nasu' => true,
   'nasushiobara' => true,
   'nikko' => true,
   'nishikata' => true,
   'nogi' => true,
   'ohira' => true,
   'ohtawara' => true,
   'oyama' => true,
   'sakura' => true,
   'sano' => true,
   'shimotsuke' => true,
   'shioya' => true,
   'takanezawa' => true,
   'tochigi' => true,
   'tsuga' => true,
   'ujiie' => true,
   'utsunomiya' => true,
   'yaita' => true
  ],
  'tokushima' => [
   'aizumi' => true,
   'anan' => true,
   'ichiba' => true,
   'itano' => true,
   'kainan' => true,
   'komatsushima' => true,
   'matsushige' => true,
   'mima' => true,
   'minami' => true,
   'miyoshi' => true,
   'mugi' => true,
   'nakagawa' => true,
   'naruto' => true,
   'sanagochi' => true,
   'shishikui' => true,
   'tokushima' => true,
   'wajiki' => true
  ],
  'tokyo' => [
   'adachi' => true,
   'akiruno' => true,
   'akishima' => true,
   'aogashima' => true,
   'arakawa' => true,
   'bunkyo' => true,
   'chiyoda' => true,
   'chofu' => true,
   'chuo' => true,
   'edogawa' => true,
   'fuchu' => true,
   'fussa' => true,
   'hachijo' => true,
   'hachioji' => true,
   'hamura' => true,
   'higashikurume' => true,
   'higashimurayama' => true,
   'higashiyamato' => true,
   'hino' => true,
   'hinode' => true,
   'hinohara' => true,
   'inagi' => true,
   'itabashi' => true,
   'katsushika' => true,
   'kita' => true,
   'kiyose' => true,
   'kodaira' => true,
   'koganei' => true,
   'kokubunji' => true,
   'komae' => true,
   'koto' => true,
   'kouzushima' => true,
   'kunitachi' => true,
   'machida' => true,
   'meguro' => true,
   'minato' => true,
   'mitaka' => true,
   'mizuho' => true,
   'musashimurayama' => true,
   'musashino' => true,
   'nakano' => true,
   'nerima' => true,
   'ogasawara' => true,
   'okutama' => true,
   'ome' => true,
   'oshima' => true,
   'ota' => true,
   'setagaya' => true,
   'shibuya' => true,
   'shinagawa' => true,
   'shinjuku' => true,
   'suginami' => true,
   'sumida' => true,
   'tachikawa' => true,
   'taito' => true,
   'tama' => true,
   'toshima' => true
  ],
  'tottori' => [
   'chizu' => true,
   'hino' => true,
   'kawahara' => true,
   'koge' => true,
   'kotoura' => true,
   'misasa' => true,
   'nanbu' => true,
   'nichinan' => true,
   'sakaiminato' => true,
   'tottori' => true,
   'wakasa' => true,
   'yazu' => true,
   'yonago' => true
  ],
  'toyama' => [
   'asahi' => true,
   'fuchu' => true,
   'fukumitsu' => true,
   'funahashi' => true,
   'himi' => true,
   'imizu' => true,
   'inami' => true,
   'johana' => true,
   'kamiichi' => true,
   'kurobe' => true,
   'nakaniikawa' => true,
   'namerikawa' => true,
   'nanto' => true,
   'nyuzen' => true,
   'oyabe' => true,
   'taira' => true,
   'takaoka' => true,
   'tateyama' => true,
   'toga' => true,
   'tonami' => true,
   'toyama' => true,
   'unazuki' => true,
   'uozu' => true,
   'yamada' => true
  ],
  'wakayama' => [
   'arida' => true,
   'aridagawa' => true,
   'gobo' => true,
   'hashimoto' => true,
   'hidaka' => true,
   'hirogawa' => true,
   'inami' => true,
   'iwade' => true,
   'kainan' => true,
   'kamitonda' => true,
   'katsuragi' => true,
   'kimino' => true,
   'kinokawa' => true,
   'kitayama' => true,
   'koya' => true,
   'koza' => true,
   'kozagawa' => true,
   'kudoyama' => true,
   'kushimoto' => true,
   'mihama' => true,
   'misato' => true,
   'nachikatsuura' => true,
   'shingu' => true,
   'shirahama' => true,
   'taiji' => true,
   'tanabe' => true,
   'wakayama' => true,
   'yuasa' => true,
   'yura' => true
  ],
  'yamagata' => [
   'asahi' => true,
   'funagata' => true,
   'higashine' => true,
   'iide' => true,
   'kahoku' => true,
   'kaminoyama' => true,
   'kaneyama' => true,
   'kawanishi' => true,
   'mamurogawa' => true,
   'mikawa' => true,
   'murayama' => true,
   'nagai' => true,
   'nakayama' => true,
   'nanyo' => true,
   'nishikawa' => true,
   'obanazawa' => true,
   'oe' => true,
   'oguni' => true,
   'ohkura' => true,
   'oishida' => true,
   'sagae' => true,
   'sakata' => true,
   'sakegawa' => true,
   'shinjo' => true,
   'shirataka' => true,
   'shonai' => true,
   'takahata' => true,
   'tendo' => true,
   'tozawa' => true,
   'tsuruoka' => true,
   'yamagata' => true,
   'yamanobe' => true,
   'yonezawa' => true,
   'yuza' => true
  ],
  'yamaguchi' => [
   'abu' => true,
   'hagi' => true,
   'hikari' => true,
   'hofu' => true,
   'iwakuni' => true,
   'kudamatsu' => true,
   'mitou' => true,
   'nagato' => true,
   'oshima' => true,
   'shimonoseki' => true,
   'shunan' => true,
   'tabuse' => true,
   'tokuyama' => true,
   'toyota' => true,
   'ube' => true,
   'yuu' => true
  ],
  'yamanashi' => [
   'chuo' => true,
   'doshi' => true,
   'fuefuki' => true,
   'fujikawa' => true,
   'fujikawaguchiko' => true,
   'fujiyoshida' => true,
   'hayakawa' => true,
   'hokuto' => true,
   'ichikawamisato' => true,
   'kai' => true,
   'kofu' => true,
   'koshu' => true,
   'kosuge' => true,
   'minami-alps' => true,
   'minobu' => true,
   'nakamichi' => true,
   'nanbu' => true,
   'narusawa' => true,
   'nirasaki' => true,
   'nishikatsura' => true,
   'oshino' => true,
   'otsuki' => true,
   'showa' => true,
   'tabayama' => true,
   'tsuru' => true,
   'uenohara' => true,
   'yamanakako' => true,
   'yamanashi' => true
  ],
  '三重' => true,
  '京都' => true,
  '佐賀' => true,
  '兵庫' => true,
  '北海道' => true,
  '千葉' => true,
  '和歌山' => true,
  '埼玉' => true,
  '大分' => true,
  '大阪' => true,
  '奈良' => true,
  '宮城' => true,
  '宮崎' => true,
  '富山' => true,
  '山口' => true,
  '山形' => true,
  '山梨' => true,
  '岐阜' => true,
  '岡山' => true,
  '岩手' => true,
  '島根' => true,
  '広島' => true,
  '徳島' => true,
  '愛媛' => true,
  '愛知' => true,
  '新潟' => true,
  '東京' => true,
  '栃木' => true,
  '沖縄' => true,
  '滋賀' => true,
  '熊本' => true,
  '石川' => true,
  '神奈川' => true,
  '福井' => true,
  '福岡' => true,
  '福島' => true,
  '秋田' => true,
  '群馬' => true,
  '茨城' => true,
  '長崎' => true,
  '長野' => true,
  '青森' => true,
  '静岡' => true,
  '香川' => true,
  '高知' => true,
  '鳥取' => true,
  '鹿児島' => true,
  'kawasaki' => [
   '*' => true,
   '!city' => true
  ],
  'kitakyushu' => [
   '*' => true,
   '!city' => true
  ],
  'kobe' => [
   '*' => true,
   '!city' => true
  ],
  'nagoya' => [
   '*' => true,
   '!city' => true
  ],
  'sapporo' => [
   '*' => true,
   '!city' => true
  ],
  'sendai' => [
   '*' => true,
   '!city' => true
  ],
  'yokohama' => [
   '*' => true,
   '!city' => true
  ],
  'buyshop' => true,
  'fashionstore' => true,
  'handcrafted' => true,
  'kawaiishop' => true,
  'supersale' => true,
  'theshop' => true,
  '0am' => true,
  '0g0' => true,
  '0j0' => true,
  '0t0' => true,
  'mydns' => true,
  'pgw' => true,
  'wjg' => true,
  'usercontent' => true,
  'angry' => true,
  'babyblue' => true,
  'babymilk' => true,
  'backdrop' => true,
  'bambina' => true,
  'bitter' => true,
  'blush' => true,
  'boo' => true,
  'boy' => true,
  'boyfriend' => true,
  'but' => true,
  'candypop' => true,
  'capoo' => true,
  'catfood' => true,
  'cheap' => true,
  'chicappa' => true,
  'chillout' => true,
  'chips' => true,
  'chowder' => true,
  'chu' => true,
  'ciao' => true,
  'cocotte' => true,
  'coolblog' => true,
  'cranky' => true,
  'cutegirl' => true,
  'daa' => true,
  'deca' => true,
  'deci' => true,
  'digick' => true,
  'egoism' => true,
  'fakefur' => true,
  'fem' => true,
  'flier' => true,
  'floppy' => true,
  'fool' => true,
  'frenchkiss' => true,
  'girlfriend' => true,
  'girly' => true,
  'gloomy' => true,
  'gonna' => true,
  'greater' => true,
  'hacca' => true,
  'heavy' => true,
  'her' => true,
  'hiho' => true,
  'hippy' => true,
  'holy' => true,
  'hungry' => true,
  'icurus' => true,
  'itigo' => true,
  'jellybean' => true,
  'kikirara' => true,
  'kill' => true,
  'kilo' => true,
  'kuron' => true,
  'littlestar' => true,
  'lolipopmc' => true,
  'lolitapunk' => true,
  'lomo' => true,
  'lovepop' => true,
  'lovesick' => true,
  'main' => true,
  'mods' => true,
  'mond' => true,
  'mongolian' => true,
  'moo' => true,
  'namaste' => true,
  'nikita' => true,
  'nobushi' => true,
  'noor' => true,
  'oops' => true,
  'parallel' => true,
  'parasite' => true,
  'pecori' => true,
  'peewee' => true,
  'penne' => true,
  'pepper' => true,
  'perma' => true,
  'pigboat' => true,
  'pinoko' => true,
  'punyu' => true,
  'pupu' => true,
  'pussycat' => true,
  'pya' => true,
  'raindrop' => true,
  'readymade' => true,
  'sadist' => true,
  'schoolbus' => true,
  'secret' => true,
  'staba' => true,
  'stripper' => true,
  'sub' => true,
  'sunnyday' => true,
  'thick' => true,
  'tonkotsu' => true,
  'under' => true,
  'upper' => true,
  'velvet' => true,
  'verse' => true,
  'versus' => true,
  'vivian' => true,
  'watson' => true,
  'weblike' => true,
  'whitesnow' => true,
  'zombie' => true,
  'hateblo' => true,
  'hatenablog' => true,
  'hatenadiary' => true,
  '2-d' => true,
  'bona' => true,
  'crap' => true,
  'daynight' => true,
  'eek' => true,
  'flop' => true,
  'halfmoon' => true,
  'jeez' => true,
  'matrix' => true,
  'mimoza' => true,
  'netgamers' => true,
  'nyanta' => true,
  'o0o0' => true,
  'rdy' => true,
  'rgr' => true,
  'rulez' => true,
  'sakurastorage' => [
   'isk01' => [
    's3' => true
   ],
   'isk02' => [
    's3' => true
   ]
  ],
  'saloon' => true,
  'sblo' => true,
  'skr' => true,
  'tank' => true,
  'uh-oh' => true,
  'undo' => true,
  'webaccel' => [
   'rs' => true,
   'user' => true
  ],
  'websozai' => true,
  'xii' => true
 ],
 'ke' => [
  'ac' => true,
  'co' => true,
  'go' => true,
  'info' => true,
  'me' => true,
  'mobi' => true,
  'ne' => true,
  'or' => true,
  'sc' => true
 ],
 'kg' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'us' => true
 ],
 'kh' => [
  '*' => true
 ],
 'ki' => [
  'biz' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'net' => true,
  'org' => true
 ],
 'km' => [
  'ass' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'nom' => true,
  'org' => true,
  'prd' => true,
  'tm' => true,
  'asso' => true,
  'coop' => true,
  'gouv' => true,
  'medecin' => true,
  'notaires' => true,
  'pharmaciens' => true,
  'presse' => true,
  'veterinaire' => true
 ],
 'kn' => [
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'kp' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'org' => true,
  'rep' => true,
  'tra' => true
 ],
 'kr' => [
  'ac' => true,
  'ai' => true,
  'co' => true,
  'es' => true,
  'go' => true,
  'hs' => true,
  'io' => true,
  'it' => true,
  'kg' => true,
  'me' => true,
  'mil' => true,
  'ms' => true,
  'ne' => true,
  'or' => true,
  'pe' => true,
  're' => true,
  'sc' => true,
  'busan' => true,
  'chungbuk' => true,
  'chungnam' => true,
  'daegu' => true,
  'daejeon' => true,
  'gangwon' => true,
  'gwangju' => true,
  'gyeongbuk' => true,
  'gyeonggi' => true,
  'gyeongnam' => true,
  'incheon' => true,
  'jeju' => true,
  'jeonbuk' => true,
  'jeonnam' => true,
  'seoul' => true,
  'ulsan' => true,
  'c01' => true,
  'eliv-dns' => true
 ],
 'kw' => [
  'com' => true,
  'edu' => true,
  'emb' => true,
  'gov' => true,
  'ind' => true,
  'net' => true,
  'org' => true
 ],
 'ky' => [
  'com' => true,
  'edu' => true,
  'net' => true,
  'org' => true
 ],
 'kz' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'jcloud' => true
 ],
 'la' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'int' => true,
  'net' => true,
  'org' => true,
  'per' => true,
  'bnr' => true
 ],
 'lb' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'lc' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'oy' => true
 ],
 'li' => true,
 'lk' => [
  'ac' => true,
  'assn' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'grp' => true,
  'hotel' => true,
  'int' => true,
  'ltd' => true,
  'net' => true,
  'ngo' => true,
  'org' => true,
  'sch' => true,
  'soc' => true,
  'web' => true
 ],
 'lr' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'ls' => [
  'ac' => true,
  'biz' => true,
  'co' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'net' => true,
  'org' => true,
  'sc' => true
 ],
 'lt' => [
  'gov' => true
 ],
 'lu' => [
  '123website' => true
 ],
 'lv' => [
  'asn' => true,
  'com' => true,
  'conf' => true,
  'edu' => true,
  'gov' => true,
  'id' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'ly' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'id' => true,
  'med' => true,
  'net' => true,
  'org' => true,
  'plc' => true,
  'sch' => true
 ],
 'ma' => [
  'ac' => true,
  'co' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'press' => true
 ],
 'mc' => [
  'asso' => true,
  'tm' => true
 ],
 'md' => [
  'ir' => true
 ],
 'me' => [
  'ac' => true,
  'co' => true,
  'edu' => true,
  'gov' => true,
  'its' => true,
  'net' => true,
  'org' => true,
  'priv' => true,
  'c66' => true,
  'craft' => true,
  'edgestack' => true,
  'filegear' => true,
  'glitch' => true,
  'filegear-sg' => true,
  'lohmus' => true,
  'barsy' => true,
  'mcdir' => true,
  'brasilia' => true,
  'ddns' => true,
  'dnsfor' => true,
  'hopto' => true,
  'loginto' => true,
  'noip' => true,
  'webhop' => true,
  'soundcast' => true,
  'tcp4' => true,
  'vp4' => true,
  'diskstation' => true,
  'dscloud' => true,
  'i234' => true,
  'myds' => true,
  'synology' => true,
  'transip' => [
   'site' => true
  ],
  'nohost' => true
 ],
 'mg' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'nom' => true,
  'org' => true,
  'prd' => true
 ],
 'mh' => true,
 'mil' => true,
 'mk' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'inf' => true,
  'name' => true,
  'net' => true,
  'org' => true
 ],
 'ml' => [
  'ac' => true,
  'art' => true,
  'asso' => true,
  'com' => true,
  'edu' => true,
  'gouv' => true,
  'gov' => true,
  'info' => true,
  'inst' => true,
  'net' => true,
  'org' => true,
  'pr' => true,
  'presse' => true
 ],
 'mm' => [
  '*' => true
 ],
 'mn' => [
  'edu' => true,
  'gov' => true,
  'org' => true,
  'nyc' => true
 ],
 'mo' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'mobi' => [
  'barsy' => true,
  'dscloud' => true
 ],
 'mp' => [
  'ju' => true
 ],
 'mq' => true,
 'mr' => [
  'gov' => true
 ],
 'ms' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'minisite' => true
 ],
 'mt' => [
  'com' => true,
  'edu' => true,
  'net' => true,
  'org' => true
 ],
 'mu' => [
  'ac' => true,
  'co' => true,
  'com' => true,
  'gov' => true,
  'net' => true,
  'or' => true,
  'org' => true
 ],
 'museum' => true,
 'mv' => [
  'aero' => true,
  'biz' => true,
  'com' => true,
  'coop' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'int' => true,
  'mil' => true,
  'museum' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'pro' => true
 ],
 'mw' => [
  'ac' => true,
  'biz' => true,
  'co' => true,
  'com' => true,
  'coop' => true,
  'edu' => true,
  'gov' => true,
  'int' => true,
  'net' => true,
  'org' => true
 ],
 'mx' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'net' => true,
  'org' => true
 ],
 'my' => [
  'biz' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'org' => true
 ],
 'mz' => [
  'ac' => true,
  'adv' => true,
  'co' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'na' => [
  'alt' => true,
  'co' => true,
  'com' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'name' => [
  'her' => [
   'forgot' => true
  ],
  'his' => [
   'forgot' => true
  ]
 ],
 'nc' => [
  'asso' => true,
  'nom' => true
 ],
 'ne' => true,
 'net' => [
  'adobeaemcloud' => true,
  'adobeio-static' => true,
  'adobeioruntime' => true,
  'akadns' => true,
  'akamai' => true,
  'akamai-staging' => true,
  'akamaiedge' => true,
  'akamaiedge-staging' => true,
  'akamaihd' => true,
  'akamaihd-staging' => true,
  'akamaiorigin' => true,
  'akamaiorigin-staging' => true,
  'akamaized' => true,
  'akamaized-staging' => true,
  'edgekey' => true,
  'edgekey-staging' => true,
  'edgesuite' => true,
  'edgesuite-staging' => true,
  'alwaysdata' => true,
  'myamaze' => true,
  'cloudfront' => true,
  'appudo' => true,
  'atlassian-dev' => [
   'prod' => [
    'cdn' => true
   ]
  ],
  'myfritz' => true,
  'onavstack' => true,
  'shopselect' => true,
  'blackbaudcdn' => true,
  'boomla' => true,
  'bplaced' => true,
  'square7' => true,
  'cdn77' => [
   'r' => true
  ],
  'cdn77-ssl' => true,
  'gb' => true,
  'hu' => true,
  'jp' => true,
  'se' => true,
  'uk' => true,
  'clickrising' => true,
  'ddns-ip' => true,
  'dns-cloud' => true,
  'dns-dynamic' => true,
  'cloudaccess' => true,
  'cloudflare' => [
   'cdn' => true
  ],
  'cloudflareanycast' => [
   'cdn' => true
  ],
  'cloudflarecn' => [
   'cdn' => true
  ],
  'cloudflareglobal' => [
   'cdn' => true
  ],
  'ctfcloud' => true,
  'feste-ip' => true,
  'knx-server' => true,
  'static-access' => true,
  'cryptonomic' => [
   '*' => true
  ],
  'dattolocal' => true,
  'mydatto' => true,
  'debian' => true,
  'definima' => true,
  'deno' => true,
  'at-band-camp' => true,
  'blogdns' => true,
  'broke-it' => true,
  'buyshouses' => true,
  'dnsalias' => true,
  'dnsdojo' => true,
  'does-it' => true,
  'dontexist' => true,
  'dynalias' => true,
  'dynathome' => true,
  'endofinternet' => true,
  'from-az' => true,
  'from-co' => true,
  'from-la' => true,
  'from-ny' => true,
  'gets-it' => true,
  'ham-radio-op' => true,
  'homeftp' => true,
  'homeip' => true,
  'homelinux' => true,
  'homeunix' => true,
  'in-the-band' => true,
  'is-a-chef' => true,
  'is-a-geek' => true,
  'isa-geek' => true,
  'kicks-ass' => true,
  'office-on-the' => true,
  'podzone' => true,
  'scrapper-site' => true,
  'selfip' => true,
  'sells-it' => true,
  'servebbs' => true,
  'serveftp' => true,
  'thruhere' => true,
  'webhop' => true,
  'casacam' => true,
  'dynu' => true,
  'dynv6' => true,
  'twmail' => true,
  'ru' => true,
  'channelsdvr' => [
   'u' => true
  ],
  'fastly' => [
   'freetls' => true,
   'map' => true,
   'prod' => [
    'a' => true,
    'global' => true
   ],
   'ssl' => [
    'a' => true,
    'b' => true,
    'global' => true
   ]
  ],
  'fastlylb' => [
   'map' => true
  ],
  'edgeapp' => true,
  'keyword-on' => true,
  'live-on' => true,
  'server-on' => true,
  'cdn-edges' => true,
  'heteml' => true,
  'cloudfunctions' => true,
  'grafana-dev' => true,
  'iobb' => true,
  'moonscale' => true,
  'in-dsl' => true,
  'in-vpn' => true,
  'oninferno' => true,
  'botdash' => true,
  'apps-1and1' => true,
  'ipifony' => true,
  'cloudjiffy' => [
   'fra1-de' => true,
   'west1-us' => true
  ],
  'elastx' => [
   'jls-sto1' => true,
   'jls-sto2' => true,
   'jls-sto3' => true
  ],
  'massivegrid' => [
   'paas' => [
    'fr-1' => true,
    'lon-1' => true,
    'lon-2' => true,
    'ny-1' => true,
    'ny-2' => true,
    'sg-1' => true
   ]
  ],
  'saveincloud' => [
   'jelastic' => true,
   'nordeste-idc' => true
  ],
  'scaleforce' => [
   'j' => true
  ],
  'kinghost' => true,
  'uni5' => true,
  'krellian' => true,
  'ggff' => true,
  'localcert' => true,
  'localhostcert' => true,
  'localto' => [
   '*' => true
  ],
  'barsy' => true,
  'memset' => true,
  'azure-api' => true,
  'azure-mobile' => true,
  'azureedge' => true,
  'azurefd' => true,
  'azurestaticapps' => [
   '1' => true,
   '2' => true,
   '3' => true,
   '4' => true,
   '5' => true,
   '6' => true,
   '7' => true,
   'centralus' => true,
   'eastasia' => true,
   'eastus2' => true,
   'westeurope' => true,
   'westus2' => true
  ],
  'azurewebsites' => true,
  'cloudapp' => true,
  'trafficmanager' => true,
  'windows' => [
   'core' => [
    'blob' => true
   ],
   'servicebus' => true
  ],
  'mynetname' => [
   'sn' => true
  ],
  'routingthecloud' => true,
  'bounceme' => true,
  'ddns' => true,
  'eating-organic' => true,
  'mydissent' => true,
  'myeffect' => true,
  'mymediapc' => true,
  'mypsx' => true,
  'mysecuritycamera' => true,
  'nhlfan' => true,
  'no-ip' => true,
  'pgafan' => true,
  'privatizehealthinsurance' => true,
  'redirectme' => true,
  'serveblog' => true,
  'serveminecraft' => true,
  'sytes' => true,
  'dnsup' => true,
  'hicam' => true,
  'now-dns' => true,
  'ownip' => true,
  'vpndns' => true,
  'cloudycluster' => true,
  'ovh' => [
   'hosting' => [
    '*' => true
   ],
   'webpaas' => [
    '*' => true
   ]
  ],
  'rackmaze' => true,
  'myradweb' => true,
  'in' => true,
  'subsc-pay' => true,
  'squares' => true,
  'schokokeks' => true,
  'firewall-gateway' => true,
  'seidat' => true,
  'senseering' => true,
  'siteleaf' => true,
  'mafelo' => true,
  'myspreadshop' => true,
  'vps-host' => [
   'jelastic' => [
    'atl' => true,
    'njs' => true,
    'ric' => true
   ]
  ],
  'srcf' => [
   'soc' => true,
   'user' => true
  ],
  'supabase' => true,
  'dsmynas' => true,
  'familyds' => true,
  'ts' => [
   'c' => [
    '*' => true
   ]
  ],
  'torproject' => [
   'pages' => true
  ],
  'vusercontent' => true,
  'reserve-online' => true,
  'community-pro' => true,
  'meinforum' => true,
  'yandexcloud' => [
   'storage' => true,
   'website' => true
  ],
  'za' => true
 ],
 'nf' => [
  'arts' => true,
  'com' => true,
  'firm' => true,
  'info' => true,
  'net' => true,
  'other' => true,
  'per' => true,
  'rec' => true,
  'store' => true,
  'web' => true
 ],
 'ng' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'i' => true,
  'mil' => true,
  'mobi' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'sch' => true,
  'biz' => [
   'co' => true,
   'dl' => true,
   'go' => true,
   'lg' => true,
   'on' => true
  ],
  'col' => true,
  'firm' => true,
  'gen' => true,
  'ltd' => true,
  'ngo' => true,
  'plc' => true
 ],
 'ni' => [
  'ac' => true,
  'biz' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'gob' => true,
  'in' => true,
  'info' => true,
  'int' => true,
  'mil' => true,
  'net' => true,
  'nom' => true,
  'org' => true,
  'web' => true
 ],
 'nl' => [
  'co' => true,
  'hosting-cluster' => true,
  'gov' => true,
  'khplay' => true,
  '123website' => true,
  'myspreadshop' => true,
  'transurl' => [
   '*' => true
  ],
  'cistron' => true,
  'demon' => true
 ],
 'no' => [
  'fhs' => true,
  'folkebibl' => true,
  'fylkesbibl' => true,
  'idrett' => true,
  'museum' => true,
  'priv' => true,
  'vgs' => true,
  'dep' => true,
  'herad' => true,
  'kommune' => true,
  'mil' => true,
  'stat' => true,
  'aa' => [
   'gs' => true
  ],
  'ah' => [
   'gs' => true
  ],
  'bu' => [
   'gs' => true
  ],
  'fm' => [
   'gs' => true
  ],
  'hl' => [
   'gs' => true
  ],
  'hm' => [
   'gs' => true
  ],
  'jan-mayen' => [
   'gs' => true
  ],
  'mr' => [
   'gs' => true
  ],
  'nl' => [
   'gs' => true
  ],
  'nt' => [
   'gs' => true
  ],
  'of' => [
   'gs' => true
  ],
  'ol' => [
   'gs' => true
  ],
  'oslo' => [
   'gs' => true
  ],
  'rl' => [
   'gs' => true
  ],
  'sf' => [
   'gs' => true
  ],
  'st' => [
   'gs' => true
  ],
  'svalbard' => [
   'gs' => true
  ],
  'tm' => [
   'gs' => true
  ],
  'tr' => [
   'gs' => true
  ],
  'va' => [
   'gs' => true
  ],
  'vf' => [
   'gs' => true
  ],
  'akrehamn' => true,
  'åkrehamn' => true,
  'algard' => true,
  'ålgård' => true,
  'arna' => true,
  'bronnoysund' => true,
  'brønnøysund' => true,
  'brumunddal' => true,
  'bryne' => true,
  'drobak' => true,
  'drøbak' => true,
  'egersund' => true,
  'fetsund' => true,
  'floro' => true,
  'florø' => true,
  'fredrikstad' => true,
  'hokksund' => true,
  'honefoss' => true,
  'hønefoss' => true,
  'jessheim' => true,
  'jorpeland' => true,
  'jørpeland' => true,
  'kirkenes' => true,
  'kopervik' => true,
  'krokstadelva' => true,
  'langevag' => true,
  'langevåg' => true,
  'leirvik' => true,
  'mjondalen' => true,
  'mjøndalen' => true,
  'mo-i-rana' => true,
  'mosjoen' => true,
  'mosjøen' => true,
  'nesoddtangen' => true,
  'orkanger' => true,
  'osoyro' => true,
  'osøyro' => true,
  'raholt' => true,
  'råholt' => true,
  'sandnessjoen' => true,
  'sandnessjøen' => true,
  'skedsmokorset' => true,
  'slattum' => true,
  'spjelkavik' => true,
  'stathelle' => true,
  'stavern' => true,
  'stjordalshalsen' => true,
  'stjørdalshalsen' => true,
  'tananger' => true,
  'tranby' => true,
  'vossevangen' => true,
  'aarborte' => true,
  'aejrie' => true,
  'afjord' => true,
  'åfjord' => true,
  'agdenes' => true,
  'akershus' => [
   'nes' => true
  ],
  'aknoluokta' => true,
  'ákŋoluokta' => true,
  'al' => true,
  'ål' => true,
  'alaheadju' => true,
  'álaheadju' => true,
  'alesund' => true,
  'ålesund' => true,
  'alstahaug' => true,
  'alta' => true,
  'áltá' => true,
  'alvdal' => true,
  'amli' => true,
  'åmli' => true,
  'amot' => true,
  'åmot' => true,
  'andasuolo' => true,
  'andebu' => true,
  'andoy' => true,
  'andøy' => true,
  'ardal' => true,
  'årdal' => true,
  'aremark' => true,
  'arendal' => true,
  'ås' => true,
  'aseral' => true,
  'åseral' => true,
  'asker' => true,
  'askim' => true,
  'askoy' => true,
  'askøy' => true,
  'askvoll' => true,
  'asnes' => true,
  'åsnes' => true,
  'audnedaln' => true,
  'aukra' => true,
  'aure' => true,
  'aurland' => true,
  'aurskog-holand' => true,
  'aurskog-høland' => true,
  'austevoll' => true,
  'austrheim' => true,
  'averoy' => true,
  'averøy' => true,
  'badaddja' => true,
  'bådåddjå' => true,
  'bærum' => true,
  'bahcavuotna' => true,
  'báhcavuotna' => true,
  'bahccavuotna' => true,
  'báhccavuotna' => true,
  'baidar' => true,
  'báidár' => true,
  'bajddar' => true,
  'bájddar' => true,
  'balat' => true,
  'bálát' => true,
  'balestrand' => true,
  'ballangen' => true,
  'balsfjord' => true,
  'bamble' => true,
  'bardu' => true,
  'barum' => true,
  'batsfjord' => true,
  'båtsfjord' => true,
  'bearalvahki' => true,
  'bearalváhki' => true,
  'beardu' => true,
  'beiarn' => true,
  'berg' => true,
  'bergen' => true,
  'berlevag' => true,
  'berlevåg' => true,
  'bievat' => true,
  'bievát' => true,
  'bindal' => true,
  'birkenes' => true,
  'bjarkoy' => true,
  'bjarkøy' => true,
  'bjerkreim' => true,
  'bjugn' => true,
  'bodo' => true,
  'bodø' => true,
  'bokn' => true,
  'bomlo' => true,
  'bømlo' => true,
  'bremanger' => true,
  'bronnoy' => true,
  'brønnøy' => true,
  'budejju' => true,
  'buskerud' => [
   'nes' => true
  ],
  'bygland' => true,
  'bykle' => true,
  'cahcesuolo' => true,
  'čáhcesuolo' => true,
  'davvenjarga' => true,
  'davvenjárga' => true,
  'davvesiida' => true,
  'deatnu' => true,
  'dielddanuorri' => true,
  'divtasvuodna' => true,
  'divttasvuotna' => true,
  'donna' => true,
  'dønna' => true,
  'dovre' => true,
  'drammen' => true,
  'drangedal' => true,
  'dyroy' => true,
  'dyrøy' => true,
  'eid' => true,
  'eidfjord' => true,
  'eidsberg' => true,
  'eidskog' => true,
  'eidsvoll' => true,
  'eigersund' => true,
  'elverum' => true,
  'enebakk' => true,
  'engerdal' => true,
  'etne' => true,
  'etnedal' => true,
  'evenassi' => true,
  'evenášši' => true,
  'evenes' => true,
  'evje-og-hornnes' => true,
  'farsund' => true,
  'fauske' => true,
  'fedje' => true,
  'fet' => true,
  'finnoy' => true,
  'finnøy' => true,
  'fitjar' => true,
  'fjaler' => true,
  'fjell' => true,
  'fla' => true,
  'flå' => true,
  'flakstad' => true,
  'flatanger' => true,
  'flekkefjord' => true,
  'flesberg' => true,
  'flora' => true,
  'folldal' => true,
  'forde' => true,
  'førde' => true,
  'forsand' => true,
  'fosnes' => true,
  'fræna' => true,
  'frana' => true,
  'frei' => true,
  'frogn' => true,
  'froland' => true,
  'frosta' => true,
  'froya' => true,
  'frøya' => true,
  'fuoisku' => true,
  'fuossko' => true,
  'fusa' => true,
  'fyresdal' => true,
  'gaivuotna' => true,
  'gáivuotna' => true,
  'galsa' => true,
  'gálsá' => true,
  'gamvik' => true,
  'gangaviika' => true,
  'gáŋgaviika' => true,
  'gaular' => true,
  'gausdal' => true,
  'giehtavuoatna' => true,
  'gildeskal' => true,
  'gildeskål' => true,
  'giske' => true,
  'gjemnes' => true,
  'gjerdrum' => true,
  'gjerstad' => true,
  'gjesdal' => true,
  'gjovik' => true,
  'gjøvik' => true,
  'gloppen' => true,
  'gol' => true,
  'gran' => true,
  'grane' => true,
  'granvin' => true,
  'gratangen' => true,
  'grimstad' => true,
  'grong' => true,
  'grue' => true,
  'gulen' => true,
  'guovdageaidnu' => true,
  'ha' => true,
  'hå' => true,
  'habmer' => true,
  'hábmer' => true,
  'hadsel' => true,
  'hægebostad' => true,
  'hagebostad' => true,
  'halden' => true,
  'halsa' => true,
  'hamar' => true,
  'hamaroy' => true,
  'hammarfeasta' => true,
  'hámmárfeasta' => true,
  'hammerfest' => true,
  'hapmir' => true,
  'hápmir' => true,
  'haram' => true,
  'hareid' => true,
  'harstad' => true,
  'hasvik' => true,
  'hattfjelldal' => true,
  'haugesund' => true,
  'hedmark' => [
   'os' => true,
   'valer' => true,
   'våler' => true
  ],
  'hemne' => true,
  'hemnes' => true,
  'hemsedal' => true,
  'hitra' => true,
  'hjartdal' => true,
  'hjelmeland' => true,
  'hobol' => true,
  'hobøl' => true,
  'hof' => true,
  'hol' => true,
  'hole' => true,
  'holmestrand' => true,
  'holtalen' => true,
  'holtålen' => true,
  'hordaland' => [
   'os' => true
  ],
  'hornindal' => true,
  'horten' => true,
  'hoyanger' => true,
  'høyanger' => true,
  'hoylandet' => true,
  'høylandet' => true,
  'hurdal' => true,
  'hurum' => true,
  'hvaler' => true,
  'hyllestad' => true,
  'ibestad' => true,
  'inderoy' => true,
  'inderøy' => true,
  'iveland' => true,
  'ivgu' => true,
  'jevnaker' => true,
  'jolster' => true,
  'jølster' => true,
  'jondal' => true,
  'kafjord' => true,
  'kåfjord' => true,
  'karasjohka' => true,
  'kárášjohka' => true,
  'karasjok' => true,
  'karlsoy' => true,
  'karmoy' => true,
  'karmøy' => true,
  'kautokeino' => true,
  'klabu' => true,
  'klæbu' => true,
  'klepp' => true,
  'kongsberg' => true,
  'kongsvinger' => true,
  'kraanghke' => true,
  'kråanghke' => true,
  'kragero' => true,
  'kragerø' => true,
  'kristiansand' => true,
  'kristiansund' => true,
  'krodsherad' => true,
  'krødsherad' => true,
  'kvæfjord' => true,
  'kvænangen' => true,
  'kvafjord' => true,
  'kvalsund' => true,
  'kvam' => true,
  'kvanangen' => true,
  'kvinesdal' => true,
  'kvinnherad' => true,
  'kviteseid' => true,
  'kvitsoy' => true,
  'kvitsøy' => true,
  'laakesvuemie' => true,
  'lærdal' => true,
  'lahppi' => true,
  'láhppi' => true,
  'lardal' => true,
  'larvik' => true,
  'lavagis' => true,
  'lavangen' => true,
  'leangaviika' => true,
  'leaŋgaviika' => true,
  'lebesby' => true,
  'leikanger' => true,
  'leirfjord' => true,
  'leka' => true,
  'leksvik' => true,
  'lenvik' => true,
  'lerdal' => true,
  'lesja' => true,
  'levanger' => true,
  'lier' => true,
  'lierne' => true,
  'lillehammer' => true,
  'lillesand' => true,
  'lindas' => true,
  'lindås' => true,
  'lindesnes' => true,
  'loabat' => true,
  'loabát' => true,
  'lodingen' => true,
  'lødingen' => true,
  'lom' => true,
  'loppa' => true,
  'lorenskog' => true,
  'lørenskog' => true,
  'loten' => true,
  'løten' => true,
  'lund' => true,
  'lunner' => true,
  'luroy' => true,
  'lurøy' => true,
  'luster' => true,
  'lyngdal' => true,
  'lyngen' => true,
  'malatvuopmi' => true,
  'málatvuopmi' => true,
  'malselv' => true,
  'målselv' => true,
  'malvik' => true,
  'mandal' => true,
  'marker' => true,
  'marnardal' => true,
  'masfjorden' => true,
  'masoy' => true,
  'måsøy' => true,
  'matta-varjjat' => true,
  'mátta-várjjat' => true,
  'meland' => true,
  'meldal' => true,
  'melhus' => true,
  'meloy' => true,
  'meløy' => true,
  'meraker' => true,
  'meråker' => true,
  'midsund' => true,
  'midtre-gauldal' => true,
  'moareke' => true,
  'moåreke' => true,
  'modalen' => true,
  'modum' => true,
  'molde' => true,
  'more-og-romsdal' => [
   'heroy' => true,
   'sande' => true
  ],
  'møre-og-romsdal' => [
   'herøy' => true,
   'sande' => true
  ],
  'moskenes' => true,
  'moss' => true,
  'mosvik' => true,
  'muosat' => true,
  'muosát' => true,
  'naamesjevuemie' => true,
  'nååmesjevuemie' => true,
  'nærøy' => true,
  'namdalseid' => true,
  'namsos' => true,
  'namsskogan' => true,
  'nannestad' => true,
  'naroy' => true,
  'narviika' => true,
  'narvik' => true,
  'naustdal' => true,
  'navuotna' => true,
  'návuotna' => true,
  'nedre-eiker' => true,
  'nesna' => true,
  'nesodden' => true,
  'nesseby' => true,
  'nesset' => true,
  'nissedal' => true,
  'nittedal' => true,
  'nord-aurdal' => true,
  'nord-fron' => true,
  'nord-odal' => true,
  'norddal' => true,
  'nordkapp' => true,
  'nordland' => [
   'bo' => true,
   'bø' => true,
   'heroy' => true,
   'herøy' => true
  ],
  'nordre-land' => true,
  'nordreisa' => true,
  'nore-og-uvdal' => true,
  'notodden' => true,
  'notteroy' => true,
  'nøtterøy' => true,
  'odda' => true,
  'oksnes' => true,
  'øksnes' => true,
  'omasvuotna' => true,
  'oppdal' => true,
  'oppegard' => true,
  'oppegård' => true,
  'orkdal' => true,
  'orland' => true,
  'ørland' => true,
  'orskog' => true,
  'ørskog' => true,
  'orsta' => true,
  'ørsta' => true,
  'osen' => true,
  'osteroy' => true,
  'osterøy' => true,
  'ostfold' => [
   'valer' => true
  ],
  'østfold' => [
   'våler' => true
  ],
  'ostre-toten' => true,
  'østre-toten' => true,
  'overhalla' => true,
  'ovre-eiker' => true,
  'øvre-eiker' => true,
  'oyer' => true,
  'øyer' => true,
  'oygarden' => true,
  'øygarden' => true,
  'oystre-slidre' => true,
  'øystre-slidre' => true,
  'porsanger' => true,
  'porsangu' => true,
  'porsáŋgu' => true,
  'porsgrunn' => true,
  'rade' => true,
  'råde' => true,
  'radoy' => true,
  'radøy' => true,
  'rælingen' => true,
  'rahkkeravju' => true,
  'ráhkkerávju' => true,
  'raisa' => true,
  'ráisa' => true,
  'rakkestad' => true,
  'ralingen' => true,
  'rana' => true,
  'randaberg' => true,
  'rauma' => true,
  'rendalen' => true,
  'rennebu' => true,
  'rennesoy' => true,
  'rennesøy' => true,
  'rindal' => true,
  'ringebu' => true,
  'ringerike' => true,
  'ringsaker' => true,
  'risor' => true,
  'risør' => true,
  'rissa' => true,
  'roan' => true,
  'rodoy' => true,
  'rødøy' => true,
  'rollag' => true,
  'romsa' => true,
  'romskog' => true,
  'rømskog' => true,
  'roros' => true,
  'røros' => true,
  'rost' => true,
  'røst' => true,
  'royken' => true,
  'røyken' => true,
  'royrvik' => true,
  'røyrvik' => true,
  'ruovat' => true,
  'rygge' => true,
  'salangen' => true,
  'salat' => true,
  'sálat' => true,
  'sálát' => true,
  'saltdal' => true,
  'samnanger' => true,
  'sandefjord' => true,
  'sandnes' => true,
  'sandoy' => true,
  'sandøy' => true,
  'sarpsborg' => true,
  'sauda' => true,
  'sauherad' => true,
  'sel' => true,
  'selbu' => true,
  'selje' => true,
  'seljord' => true,
  'siellak' => true,
  'sigdal' => true,
  'siljan' => true,
  'sirdal' => true,
  'skanit' => true,
  'skánit' => true,
  'skanland' => true,
  'skånland' => true,
  'skaun' => true,
  'skedsmo' => true,
  'ski' => true,
  'skien' => true,
  'skierva' => true,
  'skiervá' => true,
  'skiptvet' => true,
  'skjak' => true,
  'skjåk' => true,
  'skjervoy' => true,
  'skjervøy' => true,
  'skodje' => true,
  'smola' => true,
  'smøla' => true,
  'snaase' => true,
  'snåase' => true,
  'snasa' => true,
  'snåsa' => true,
  'snillfjord' => true,
  'snoasa' => true,
  'sogndal' => true,
  'sogne' => true,
  'søgne' => true,
  'sokndal' => true,
  'sola' => true,
  'solund' => true,
  'somna' => true,
  'sømna' => true,
  'sondre-land' => true,
  'søndre-land' => true,
  'songdalen' => true,
  'sor-aurdal' => true,
  'sør-aurdal' => true,
  'sor-fron' => true,
  'sør-fron' => true,
  'sor-odal' => true,
  'sør-odal' => true,
  'sor-varanger' => true,
  'sør-varanger' => true,
  'sorfold' => true,
  'sørfold' => true,
  'sorreisa' => true,
  'sørreisa' => true,
  'sortland' => true,
  'sorum' => true,
  'sørum' => true,
  'spydeberg' => true,
  'stange' => true,
  'stavanger' => true,
  'steigen' => true,
  'steinkjer' => true,
  'stjordal' => true,
  'stjørdal' => true,
  'stokke' => true,
  'stor-elvdal' => true,
  'stord' => true,
  'stordal' => true,
  'storfjord' => true,
  'strand' => true,
  'stranda' => true,
  'stryn' => true,
  'sula' => true,
  'suldal' => true,
  'sund' => true,
  'sunndal' => true,
  'surnadal' => true,
  'sveio' => true,
  'svelvik' => true,
  'sykkylven' => true,
  'tana' => true,
  'telemark' => [
   'bo' => true,
   'bø' => true
  ],
  'time' => true,
  'tingvoll' => true,
  'tinn' => true,
  'tjeldsund' => true,
  'tjome' => true,
  'tjøme' => true,
  'tokke' => true,
  'tolga' => true,
  'tonsberg' => true,
  'tønsberg' => true,
  'torsken' => true,
  'træna' => true,
  'trana' => true,
  'tranoy' => true,
  'tranøy' => true,
  'troandin' => true,
  'trogstad' => true,
  'trøgstad' => true,
  'tromsa' => true,
  'tromso' => true,
  'tromsø' => true,
  'trondheim' => true,
  'trysil' => true,
  'tvedestrand' => true,
  'tydal' => true,
  'tynset' => true,
  'tysfjord' => true,
  'tysnes' => true,
  'tysvær' => true,
  'tysvar' => true,
  'ullensaker' => true,
  'ullensvang' => true,
  'ulvik' => true,
  'unjarga' => true,
  'unjárga' => true,
  'utsira' => true,
  'vaapste' => true,
  'vadso' => true,
  'vadsø' => true,
  'værøy' => true,
  'vaga' => true,
  'vågå' => true,
  'vagan' => true,
  'vågan' => true,
  'vagsoy' => true,
  'vågsøy' => true,
  'vaksdal' => true,
  'valle' => true,
  'vang' => true,
  'vanylven' => true,
  'vardo' => true,
  'vardø' => true,
  'varggat' => true,
  'várggát' => true,
  'varoy' => true,
  'vefsn' => true,
  'vega' => true,
  'vegarshei' => true,
  'vegårshei' => true,
  'vennesla' => true,
  'verdal' => true,
  'verran' => true,
  'vestby' => true,
  'vestfold' => [
   'sande' => true
  ],
  'vestnes' => true,
  'vestre-slidre' => true,
  'vestre-toten' => true,
  'vestvagoy' => true,
  'vestvågøy' => true,
  'vevelstad' => true,
  'vik' => true,
  'vikna' => true,
  'vindafjord' => true,
  'voagat' => true,
  'volda' => true,
  'voss' => true,
  'co' => true,
  '123hjemmeside' => true,
  'myspreadshop' => true
 ],
 'np' => [
  '*' => true
 ],
 'nr' => [
  'biz' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'net' => true,
  'org' => true
 ],
 'nu' => [
  'merseine' => true,
  'mine' => true,
  'shacknet' => true,
  'enterprisecloud' => true
 ],
 'nz' => [
  'ac' => true,
  'co' => true,
  'cri' => true,
  'geek' => true,
  'gen' => true,
  'govt' => true,
  'health' => true,
  'iwi' => true,
  'kiwi' => true,
  'maori' => true,
  'māori' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'parliament' => true,
  'school' => true,
  'cloudns' => true
 ],
 'om' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'med' => true,
  'museum' => true,
  'net' => true,
  'org' => true,
  'pro' => true
 ],
 'onion' => true,
 'org' => [
  'altervista' => true,
  'pimienta' => true,
  'poivron' => true,
  'potager' => true,
  'sweetpepper' => true,
  'cdn77' => [
   'c' => true,
   'rsc' => true
  ],
  'cdn77-secure' => [
   'origin' => [
    'ssl' => true
   ]
  ],
  'ae' => true,
  'cloudns' => true,
  'ip-dynamic' => true,
  'ddnss' => true,
  'dpdns' => true,
  'duckdns' => true,
  'tunk' => true,
  'blogdns' => true,
  'blogsite' => true,
  'boldlygoingnowhere' => true,
  'dnsalias' => true,
  'dnsdojo' => true,
  'doesntexist' => true,
  'dontexist' => true,
  'doomdns' => true,
  'dvrdns' => true,
  'dynalias' => true,
  'dyndns' => [
   'go' => true,
   'home' => true
  ],
  'endofinternet' => true,
  'endoftheinternet' => true,
  'from-me' => true,
  'game-host' => true,
  'gotdns' => true,
  'hobby-site' => true,
  'homedns' => true,
  'homeftp' => true,
  'homelinux' => true,
  'homeunix' => true,
  'is-a-bruinsfan' => true,
  'is-a-candidate' => true,
  'is-a-celticsfan' => true,
  'is-a-chef' => true,
  'is-a-geek' => true,
  'is-a-knight' => true,
  'is-a-linux-user' => true,
  'is-a-patsfan' => true,
  'is-a-soxfan' => true,
  'is-found' => true,
  'is-lost' => true,
  'is-saved' => true,
  'is-very-bad' => true,
  'is-very-evil' => true,
  'is-very-good' => true,
  'is-very-nice' => true,
  'is-very-sweet' => true,
  'isa-geek' => true,
  'kicks-ass' => true,
  'misconfused' => true,
  'podzone' => true,
  'readmyblog' => true,
  'selfip' => true,
  'sellsyourhome' => true,
  'servebbs' => true,
  'serveftp' => true,
  'servegame' => true,
  'stuff-4-sale' => true,
  'webhop' => true,
  'accesscam' => true,
  'camdvr' => true,
  'freeddns' => true,
  'mywire' => true,
  'webredirect' => true,
  'twmail' => true,
  'eu' => [
   'al' => true,
   'asso' => true,
   'at' => true,
   'au' => true,
   'be' => true,
   'bg' => true,
   'ca' => true,
   'cd' => true,
   'ch' => true,
   'cn' => true,
   'cy' => true,
   'cz' => true,
   'de' => true,
   'dk' => true,
   'edu' => true,
   'ee' => true,
   'es' => true,
   'fi' => true,
   'fr' => true,
   'gr' => true,
   'hr' => true,
   'hu' => true,
   'ie' => true,
   'il' => true,
   'in' => true,
   'int' => true,
   'is' => true,
   'it' => true,
   'jp' => true,
   'kr' => true,
   'lt' => true,
   'lu' => true,
   'lv' => true,
   'me' => true,
   'mk' => true,
   'mt' => true,
   'my' => true,
   'net' => true,
   'ng' => true,
   'nl' => true,
   'no' => true,
   'nz' => true,
   'pl' => true,
   'pt' => true,
   'ro' => true,
   'ru' => true,
   'se' => true,
   'si' => true,
   'sk' => true,
   'tr' => true,
   'uk' => true,
   'us' => true
  ],
  'fedorainfracloud' => true,
  'fedorapeople' => true,
  'fedoraproject' => [
   'cloud' => true,
   'os' => [
    'app' => true
   ],
   'stg' => [
    'os' => [
     'app' => true
    ]
   ]
  ],
  'freedesktop' => true,
  'hatenadiary' => true,
  'hepforge' => true,
  'in-dsl' => true,
  'in-vpn' => true,
  'js' => true,
  'barsy' => true,
  'mayfirst' => true,
  'routingthecloud' => true,
  'bmoattachments' => true,
  'cable-modem' => true,
  'collegefan' => true,
  'couchpotatofries' => true,
  'hopto' => true,
  'mlbfan' => true,
  'myftp' => true,
  'mysecuritycamera' => true,
  'nflfan' => true,
  'no-ip' => true,
  'read-books' => true,
  'ufcfan' => true,
  'zapto' => true,
  'dynserv' => true,
  'now-dns' => true,
  'is-local' => true,
  'httpbin' => true,
  'pubtls' => true,
  'jpn' => true,
  'my-firewall' => true,
  'myfirewall' => true,
  'spdns' => true,
  'small-web' => true,
  'dsmynas' => true,
  'familyds' => true,
  'teckids' => [
   's3' => true
  ],
  'tuxfamily' => true,
  'diskstation' => true,
  'hk' => true,
  'us' => true,
  'toolforge' => true,
  'wmcloud' => true,
  'wmflabs' => true,
  'za' => true
 ],
 'pa' => [
  'abo' => true,
  'ac' => true,
  'com' => true,
  'edu' => true,
  'gob' => true,
  'ing' => true,
  'med' => true,
  'net' => true,
  'nom' => true,
  'org' => true,
  'sld' => true
 ],
 'pe' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'mil' => true,
  'net' => true,
  'nom' => true,
  'org' => true
 ],
 'pf' => [
  'com' => true,
  'edu' => true,
  'org' => true
 ],
 'pg' => [
  '*' => true
 ],
 'ph' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'i' => true,
  'mil' => true,
  'net' => true,
  'ngo' => true,
  'org' => true,
  'cloudns' => true
 ],
 'pk' => [
  'ac' => true,
  'biz' => true,
  'com' => true,
  'edu' => true,
  'fam' => true,
  'gkp' => true,
  'gob' => true,
  'gog' => true,
  'gok' => true,
  'gop' => true,
  'gos' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'web' => true
 ],
 'pl' => [
  'com' => true,
  'net' => true,
  'org' => true,
  'agro' => true,
  'aid' => true,
  'atm' => true,
  'auto' => true,
  'biz' => true,
  'edu' => true,
  'gmina' => true,
  'gsm' => true,
  'info' => true,
  'mail' => true,
  'media' => true,
  'miasta' => true,
  'mil' => true,
  'nieruchomosci' => true,
  'nom' => true,
  'pc' => true,
  'powiat' => true,
  'priv' => true,
  'realestate' => true,
  'rel' => true,
  'sex' => true,
  'shop' => true,
  'sklep' => true,
  'sos' => true,
  'szkola' => true,
  'targi' => true,
  'tm' => true,
  'tourism' => true,
  'travel' => true,
  'turystyka' => true,
  'gov' => [
   'ap' => true,
   'griw' => true,
   'ic' => true,
   'is' => true,
   'kmpsp' => true,
   'konsulat' => true,
   'kppsp' => true,
   'kwp' => true,
   'kwpsp' => true,
   'mup' => true,
   'mw' => true,
   'oia' => true,
   'oirm' => true,
   'oke' => true,
   'oow' => true,
   'oschr' => true,
   'oum' => true,
   'pa' => true,
   'pinb' => true,
   'piw' => true,
   'po' => true,
   'pr' => true,
   'psp' => true,
   'psse' => true,
   'pup' => true,
   'rzgw' => true,
   'sa' => true,
   'sdn' => true,
   'sko' => true,
   'so' => true,
   'sr' => true,
   'starostwo' => true,
   'ug' => true,
   'ugim' => true,
   'um' => true,
   'umig' => true,
   'upow' => true,
   'uppo' => true,
   'us' => true,
   'uw' => true,
   'uzs' => true,
   'wif' => true,
   'wiih' => true,
   'winb' => true,
   'wios' => true,
   'witd' => true,
   'wiw' => true,
   'wkz' => true,
   'wsa' => true,
   'wskr' => true,
   'wsse' => true,
   'wuoz' => true,
   'wzmiuw' => true,
   'zp' => true,
   'zpisdn' => true
  ],
  'augustow' => true,
  'babia-gora' => true,
  'bedzin' => true,
  'beskidy' => true,
  'bialowieza' => true,
  'bialystok' => true,
  'bielawa' => true,
  'bieszczady' => true,
  'boleslawiec' => true,
  'bydgoszcz' => true,
  'bytom' => true,
  'cieszyn' => true,
  'czeladz' => true,
  'czest' => true,
  'dlugoleka' => true,
  'elblag' => true,
  'elk' => true,
  'glogow' => true,
  'gniezno' => true,
  'gorlice' => true,
  'grajewo' => true,
  'ilawa' => true,
  'jaworzno' => true,
  'jelenia-gora' => true,
  'jgora' => true,
  'kalisz' => true,
  'karpacz' => true,
  'kartuzy' => true,
  'kaszuby' => true,
  'katowice' => true,
  'kazimierz-dolny' => true,
  'kepno' => true,
  'ketrzyn' => true,
  'klodzko' => true,
  'kobierzyce' => true,
  'kolobrzeg' => true,
  'konin' => true,
  'konskowola' => true,
  'kutno' => true,
  'lapy' => true,
  'lebork' => true,
  'legnica' => true,
  'lezajsk' => true,
  'limanowa' => true,
  'lomza' => true,
  'lowicz' => true,
  'lubin' => true,
  'lukow' => true,
  'malbork' => true,
  'malopolska' => true,
  'mazowsze' => true,
  'mazury' => true,
  'mielec' => true,
  'mielno' => true,
  'mragowo' => true,
  'naklo' => true,
  'nowaruda' => true,
  'nysa' => true,
  'olawa' => true,
  'olecko' => true,
  'olkusz' => true,
  'olsztyn' => true,
  'opoczno' => true,
  'opole' => true,
  'ostroda' => true,
  'ostroleka' => true,
  'ostrowiec' => true,
  'ostrowwlkp' => true,
  'pila' => true,
  'pisz' => true,
  'podhale' => true,
  'podlasie' => true,
  'polkowice' => true,
  'pomorskie' => true,
  'pomorze' => true,
  'prochowice' => true,
  'pruszkow' => true,
  'przeworsk' => true,
  'pulawy' => true,
  'radom' => true,
  'rawa-maz' => true,
  'rybnik' => true,
  'rzeszow' => true,
  'sanok' => true,
  'sejny' => true,
  'skoczow' => true,
  'slask' => true,
  'slupsk' => true,
  'sosnowiec' => true,
  'stalowa-wola' => true,
  'starachowice' => true,
  'stargard' => true,
  'suwalki' => true,
  'swidnica' => true,
  'swiebodzin' => true,
  'swinoujscie' => true,
  'szczecin' => true,
  'szczytno' => true,
  'tarnobrzeg' => true,
  'tgory' => true,
  'turek' => true,
  'tychy' => true,
  'ustka' => true,
  'walbrzych' => true,
  'warmia' => true,
  'warszawa' => true,
  'waw' => true,
  'wegrow' => true,
  'wielun' => true,
  'wlocl' => true,
  'wloclawek' => true,
  'wodzislaw' => true,
  'wolomin' => true,
  'wroclaw' => true,
  'zachpomor' => true,
  'zagan' => true,
  'zarow' => true,
  'zgora' => true,
  'zgorzelec' => true,
  'art' => true,
  'gliwice' => true,
  'krakow' => true,
  'poznan' => true,
  'wroc' => true,
  'zakopane' => true,
  'beep' => true,
  'ecommerce-shop' => true,
  'cfolks' => true,
  'dfirma' => true,
  'dkonto' => true,
  'you2' => true,
  'shoparena' => true,
  'homesklep' => true,
  'sdscloud' => true,
  'unicloud' => true,
  'lodz' => true,
  'pabianice' => true,
  'plock' => true,
  'sieradz' => true,
  'skierniewice' => true,
  'zgierz' => true,
  'krasnik' => true,
  'leczna' => true,
  'lubartow' => true,
  'lublin' => true,
  'poniatowa' => true,
  'swidnik' => true,
  'co' => true,
  'torun' => true,
  'simplesite' => true,
  'myspreadshop' => true,
  'gda' => true,
  'gdansk' => true,
  'gdynia' => true,
  'med' => true,
  'sopot' => true,
  'bielsko' => true
 ],
 'pm' => [
  'own' => true,
  'name' => true
 ],
 'pn' => [
  'co' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'post' => true,
 'pr' => [
  'biz' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'isla' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'pro' => true,
  'ac' => true,
  'est' => true,
  'prof' => true
 ],
 'pro' => [
  'aaa' => true,
  'aca' => true,
  'acct' => true,
  'avocat' => true,
  'bar' => true,
  'cpa' => true,
  'eng' => true,
  'jur' => true,
  'law' => true,
  'med' => true,
  'recht' => true,
  '12chars' => true,
  'cloudns' => true,
  'barsy' => true,
  'ngrok' => true
 ],
 'ps' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'plo' => true,
  'sec' => true
 ],
 'pt' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'int' => true,
  'net' => true,
  'nome' => true,
  'org' => true,
  'publ' => true,
  '123paginaweb' => true
 ],
 'pw' => [
  'gov' => true,
  'cloudns' => true,
  'x443' => true
 ],
 'py' => [
  'com' => true,
  'coop' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'qa' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'sch' => true
 ],
 're' => [
  'asso' => true,
  'com' => true,
  'netlib' => true,
  'can' => true
 ],
 'ro' => [
  'arts' => true,
  'com' => true,
  'firm' => true,
  'info' => true,
  'nom' => true,
  'nt' => true,
  'org' => true,
  'rec' => true,
  'store' => true,
  'tm' => true,
  'www' => true,
  'co' => true,
  'shop' => true,
  'barsy' => true
 ],
 'rs' => [
  'ac' => true,
  'co' => true,
  'edu' => true,
  'gov' => true,
  'in' => true,
  'org' => true,
  'brendly' => [
   'shop' => true
  ],
  'barsy' => true,
  'ox' => true
 ],
 'ru' => [
  'ac' => true,
  'edu' => true,
  'gov' => true,
  'int' => true,
  'mil' => true,
  'eurodir' => true,
  'adygeya' => true,
  'bashkiria' => true,
  'bir' => true,
  'cbg' => true,
  'com' => true,
  'dagestan' => true,
  'grozny' => true,
  'kalmykia' => true,
  'kustanai' => true,
  'marine' => true,
  'mordovia' => true,
  'msk' => true,
  'mytis' => true,
  'nalchik' => true,
  'nov' => true,
  'pyatigorsk' => true,
  'spb' => true,
  'vladikavkaz' => true,
  'vladimir' => true,
  'na4u' => true,
  'mircloud' => true,
  'myjino' => [
   'hosting' => [
    '*' => true
   ],
   'landing' => [
    '*' => true
   ],
   'spectrum' => [
    '*' => true
   ],
   'vps' => [
    '*' => true
   ]
  ],
  'cldmail' => [
   'hb' => true
  ],
  'mcdir' => [
   'vps' => true
  ],
  'mcpre' => true,
  'net' => true,
  'org' => true,
  'pp' => true,
  'lk3' => true,
  'ras' => true
 ],
 'rw' => [
  'ac' => true,
  'co' => true,
  'coop' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'sa' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'med' => true,
  'net' => true,
  'org' => true,
  'pub' => true,
  'sch' => true
 ],
 'sb' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'sc' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'sd' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'med' => true,
  'net' => true,
  'org' => true,
  'tv' => true
 ],
 'se' => [
  'a' => true,
  'ac' => true,
  'b' => true,
  'bd' => true,
  'brand' => true,
  'c' => true,
  'd' => true,
  'e' => true,
  'f' => true,
  'fh' => true,
  'fhsk' => true,
  'fhv' => true,
  'g' => true,
  'h' => true,
  'i' => true,
  'k' => true,
  'komforb' => true,
  'kommunalforbund' => true,
  'komvux' => true,
  'l' => true,
  'lanbib' => true,
  'm' => true,
  'n' => true,
  'naturbruksgymn' => true,
  'o' => true,
  'org' => true,
  'p' => true,
  'parti' => true,
  'pp' => true,
  'press' => true,
  'r' => true,
  's' => true,
  't' => true,
  'tm' => true,
  'u' => true,
  'w' => true,
  'x' => true,
  'y' => true,
  'z' => true,
  'com' => true,
  'iopsys' => true,
  '123minsida' => true,
  'itcouldbewor' => true,
  'myspreadshop' => true
 ],
 'sg' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'enscaled' => true
 ],
 'sh' => [
  'com' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'hashbang' => true,
  'botda' => true,
  'platform' => [
   'ent' => true,
   'eu' => true,
   'us' => true
  ],
  'now' => true
 ],
 'si' => [
  'f5' => true,
  'gitapp' => true,
  'gitpage' => true
 ],
 'sj' => true,
 'sk' => true,
 'sl' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true
 ],
 'sm' => true,
 'sn' => [
  'art' => true,
  'com' => true,
  'edu' => true,
  'gouv' => true,
  'org' => true,
  'perso' => true,
  'univ' => true
 ],
 'so' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'me' => true,
  'net' => true,
  'org' => true,
  'surveys' => true
 ],
 'sr' => true,
 'ss' => [
  'biz' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'me' => true,
  'net' => true,
  'org' => true,
  'sch' => true
 ],
 'st' => [
  'co' => true,
  'com' => true,
  'consulado' => true,
  'edu' => true,
  'embaixada' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'principe' => true,
  'saotome' => true,
  'store' => true,
  'helioho' => true,
  'kirara' => true,
  'noho' => true
 ],
 'su' => [
  'abkhazia' => true,
  'adygeya' => true,
  'aktyubinsk' => true,
  'arkhangelsk' => true,
  'armenia' => true,
  'ashgabad' => true,
  'azerbaijan' => true,
  'balashov' => true,
  'bashkiria' => true,
  'bryansk' => true,
  'bukhara' => true,
  'chimkent' => true,
  'dagestan' => true,
  'east-kazakhstan' => true,
  'exnet' => true,
  'georgia' => true,
  'grozny' => true,
  'ivanovo' => true,
  'jambyl' => true,
  'kalmykia' => true,
  'kaluga' => true,
  'karacol' => true,
  'karaganda' => true,
  'karelia' => true,
  'khakassia' => true,
  'krasnodar' => true,
  'kurgan' => true,
  'kustanai' => true,
  'lenug' => true,
  'mangyshlak' => true,
  'mordovia' => true,
  'msk' => true,
  'murmansk' => true,
  'nalchik' => true,
  'navoi' => true,
  'north-kazakhstan' => true,
  'nov' => true,
  'obninsk' => true,
  'penza' => true,
  'pokrovsk' => true,
  'sochi' => true,
  'spb' => true,
  'tashkent' => true,
  'termez' => true,
  'togliatti' => true,
  'troitsk' => true,
  'tselinograd' => true,
  'tula' => true,
  'tuva' => true,
  'vladikavkaz' => true,
  'vladimir' => true,
  'vologda' => true
 ],
 'sv' => [
  'com' => true,
  'edu' => true,
  'gob' => true,
  'org' => true,
  'red' => true
 ],
 'sx' => [
  'gov' => true
 ],
 'sy' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'sz' => [
  'ac' => true,
  'co' => true,
  'org' => true
 ],
 'tc' => true,
 'td' => true,
 'tel' => true,
 'tf' => [
  'sch' => true
 ],
 'tg' => true,
 'th' => [
  'ac' => true,
  'co' => true,
  'go' => true,
  'in' => true,
  'mi' => true,
  'net' => true,
  'or' => true,
  'online' => true,
  'shop' => true
 ],
 'tj' => [
  'ac' => true,
  'biz' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'go' => true,
  'gov' => true,
  'int' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'nic' => true,
  'org' => true,
  'test' => true,
  'web' => true
 ],
 'tk' => true,
 'tl' => [
  'gov' => true
 ],
 'tm' => [
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'nom' => true,
  'org' => true
 ],
 'tn' => [
  'com' => true,
  'ens' => true,
  'fin' => true,
  'gov' => true,
  'ind' => true,
  'info' => true,
  'intl' => true,
  'mincom' => true,
  'nat' => true,
  'net' => true,
  'org' => true,
  'perso' => true,
  'tourism' => true,
  'orangecloud' => true
 ],
 'to' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  '611' => true,
  'oya' => true,
  'x0' => true,
  'quickconnect' => [
   'direct' => true
  ],
  'vpnplus' => true
 ],
 'tr' => [
  'av' => true,
  'bbs' => true,
  'bel' => true,
  'biz' => true,
  'com' => true,
  'dr' => true,
  'edu' => true,
  'gen' => true,
  'gov' => true,
  'info' => true,
  'k12' => true,
  'kep' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'pol' => true,
  'tel' => true,
  'tsk' => true,
  'tv' => true,
  'web' => true,
  'nc' => [
   'gov' => true
  ]
 ],
 'tt' => [
  'biz' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'mil' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'pro' => true
 ],
 'tv' => [
  'better-than' => true,
  'dyndns' => true,
  'on-the-web' => true,
  'worse-than' => true,
  'from' => true,
  'sakura' => true
 ],
 'tw' => [
  'club' => true,
  'com' => [
   'mymailer' => true
  ],
  'ebiz' => true,
  'edu' => true,
  'game' => true,
  'gov' => true,
  'idv' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'url' => true,
  'mydns' => true
 ],
 'tz' => [
  'ac' => true,
  'co' => true,
  'go' => true,
  'hotel' => true,
  'info' => true,
  'me' => true,
  'mil' => true,
  'mobi' => true,
  'ne' => true,
  'or' => true,
  'sc' => true,
  'tv' => true
 ],
 'ua' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'in' => true,
  'net' => true,
  'org' => true,
  'cherkassy' => true,
  'cherkasy' => true,
  'chernigov' => true,
  'chernihiv' => true,
  'chernivtsi' => true,
  'chernovtsy' => true,
  'ck' => true,
  'cn' => true,
  'cr' => true,
  'crimea' => true,
  'cv' => true,
  'dn' => true,
  'dnepropetrovsk' => true,
  'dnipropetrovsk' => true,
  'donetsk' => true,
  'dp' => true,
  'if' => true,
  'ivano-frankivsk' => true,
  'kh' => true,
  'kharkiv' => true,
  'kharkov' => true,
  'kherson' => true,
  'khmelnitskiy' => true,
  'khmelnytskyi' => true,
  'kiev' => true,
  'kirovograd' => true,
  'km' => true,
  'kr' => true,
  'kropyvnytskyi' => true,
  'krym' => true,
  'ks' => true,
  'kv' => true,
  'kyiv' => true,
  'lg' => true,
  'lt' => true,
  'lugansk' => true,
  'luhansk' => true,
  'lutsk' => true,
  'lv' => true,
  'lviv' => true,
  'mk' => true,
  'mykolaiv' => true,
  'nikolaev' => true,
  'od' => true,
  'odesa' => true,
  'odessa' => true,
  'pl' => true,
  'poltava' => true,
  'rivne' => true,
  'rovno' => true,
  'rv' => true,
  'sb' => true,
  'sebastopol' => true,
  'sevastopol' => true,
  'sm' => true,
  'sumy' => true,
  'te' => true,
  'ternopil' => true,
  'uz' => true,
  'uzhgorod' => true,
  'uzhhorod' => true,
  'vinnica' => true,
  'vinnytsia' => true,
  'vn' => true,
  'volyn' => true,
  'yalta' => true,
  'zakarpattia' => true,
  'zaporizhzhe' => true,
  'zaporizhzhia' => true,
  'zhitomir' => true,
  'zhytomyr' => true,
  'zp' => true,
  'zt' => true,
  'cc' => true,
  'inf' => true,
  'ltd' => true,
  'cx' => true,
  'ie' => true,
  'biz' => true,
  'co' => true,
  'pp' => true,
  'v' => true
 ],
 'ug' => [
  'ac' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'go' => true,
  'gov' => true,
  'mil' => true,
  'ne' => true,
  'or' => true,
  'org' => true,
  'sc' => true,
  'us' => true
 ],
 'uk' => [
  'ac' => true,
  'co' => [
   'bytemark' => [
    'dh' => true,
    'vm' => true
   ],
   'layershift' => [
    'j' => true
   ],
   'barsy' => true,
   'barsyonline' => true,
   'retrosnub' => [
    'cust' => true
   ],
   'nh-serv' => true,
   'no-ip' => true,
   'adimo' => true,
   'myspreadshop' => true
  ],
  'gov' => [
   'api' => true,
   'campaign' => true,
   'service' => true
  ],
  'ltd' => true,
  'me' => true,
  'net' => true,
  'nhs' => true,
  'org' => [
   'glug' => true,
   'lug' => true,
   'lugs' => true,
   'affinitylottery' => true,
   'raffleentry' => true,
   'weeklylottery' => true
  ],
  'plc' => true,
  'police' => true,
  'sch' => [
   '*' => true
  ],
  'conn' => true,
  'copro' => true,
  'hosp' => true,
  'independent-commission' => true,
  'independent-inquest' => true,
  'independent-inquiry' => true,
  'independent-panel' => true,
  'independent-review' => true,
  'public-inquiry' => true,
  'royal-commission' => true,
  'pymnt' => true,
  'barsy' => true,
  'nimsite' => true,
  'oraclegovcloudapps' => [
   '*' => true
  ]
 ],
 'us' => [
  'dni' => true,
  'isa' => true,
  'nsn' => true,
  'ak' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'al' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ar' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'as' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'az' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ca' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'co' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ct' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'dc' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'de' => [
   'cc' => true,
   'lib' => true
  ],
  'fl' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ga' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'gu' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'hi' => [
   'cc' => true,
   'lib' => true
  ],
  'ia' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'id' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'il' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'in' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ks' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ky' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'la' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ma' => [
   'k12' => [
    'chtr' => true,
    'paroch' => true,
    'pvt' => true
   ],
   'cc' => true,
   'lib' => true
  ],
  'md' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'me' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'mi' => [
   'k12' => true,
   'cc' => true,
   'lib' => true,
   'ann-arbor' => true,
   'cog' => true,
   'dst' => true,
   'eaton' => true,
   'gen' => true,
   'mus' => true,
   'tec' => true,
   'washtenaw' => true
  ],
  'mn' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'mo' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ms' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'mt' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'nc' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'nd' => [
   'cc' => true,
   'lib' => true
  ],
  'ne' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'nh' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'nj' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'nm' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'nv' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ny' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'oh' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ok' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'or' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'pa' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'pr' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ri' => [
   'cc' => true,
   'lib' => true
  ],
  'sc' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'sd' => [
   'cc' => true,
   'lib' => true
  ],
  'tn' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'tx' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'ut' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'va' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'vi' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'vt' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'wa' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'wi' => [
   'k12' => true,
   'cc' => true,
   'lib' => true
  ],
  'wv' => [
   'cc' => true
  ],
  'wy' => [
   'cc' => true,
   'k12' => true,
   'lib' => true
  ],
  'cloudns' => true,
  'is-by' => true,
  'land-4-sale' => true,
  'stuff-4-sale' => true,
  'heliohost' => true,
  'enscaled' => [
   'phx' => true
  ],
  'mircloud' => true,
  'ngo' => true,
  'golffan' => true,
  'noip' => true,
  'pointto' => true,
  'freeddns' => true,
  'srv' => [
   'gh' => true,
   'gl' => true
  ],
  'platterp' => true,
  'servername' => true
 ],
 'uy' => [
  'com' => true,
  'edu' => true,
  'gub' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'uz' => [
  'co' => true,
  'com' => true,
  'net' => true,
  'org' => true
 ],
 'va' => true,
 'vc' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'gv' => [
   'd' => true
  ],
  '0e' => [
   '*' => true
  ],
  'mydns' => true
 ],
 've' => [
  'arts' => true,
  'bib' => true,
  'co' => true,
  'com' => true,
  'e12' => true,
  'edu' => true,
  'emprende' => true,
  'firm' => true,
  'gob' => true,
  'gov' => true,
  'info' => true,
  'int' => true,
  'mil' => true,
  'net' => true,
  'nom' => true,
  'org' => true,
  'rar' => true,
  'rec' => true,
  'store' => true,
  'tec' => true,
  'web' => true
 ],
 'vg' => [
  'edu' => true
 ],
 'vi' => [
  'co' => true,
  'com' => true,
  'k12' => true,
  'net' => true,
  'org' => true
 ],
 'vn' => [
  'ac' => true,
  'ai' => true,
  'biz' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'health' => true,
  'id' => true,
  'info' => true,
  'int' => true,
  'io' => true,
  'name' => true,
  'net' => true,
  'org' => true,
  'pro' => true,
  'angiang' => true,
  'bacgiang' => true,
  'backan' => true,
  'baclieu' => true,
  'bacninh' => true,
  'baria-vungtau' => true,
  'bentre' => true,
  'binhdinh' => true,
  'binhduong' => true,
  'binhphuoc' => true,
  'binhthuan' => true,
  'camau' => true,
  'cantho' => true,
  'caobang' => true,
  'daklak' => true,
  'daknong' => true,
  'danang' => true,
  'dienbien' => true,
  'dongnai' => true,
  'dongthap' => true,
  'gialai' => true,
  'hagiang' => true,
  'haiduong' => true,
  'haiphong' => true,
  'hanam' => true,
  'hanoi' => true,
  'hatinh' => true,
  'haugiang' => true,
  'hoabinh' => true,
  'hungyen' => true,
  'khanhhoa' => true,
  'kiengiang' => true,
  'kontum' => true,
  'laichau' => true,
  'lamdong' => true,
  'langson' => true,
  'laocai' => true,
  'longan' => true,
  'namdinh' => true,
  'nghean' => true,
  'ninhbinh' => true,
  'ninhthuan' => true,
  'phutho' => true,
  'phuyen' => true,
  'quangbinh' => true,
  'quangnam' => true,
  'quangngai' => true,
  'quangninh' => true,
  'quangtri' => true,
  'soctrang' => true,
  'sonla' => true,
  'tayninh' => true,
  'thaibinh' => true,
  'thainguyen' => true,
  'thanhhoa' => true,
  'thanhphohochiminh' => true,
  'thuathienhue' => true,
  'tiengiang' => true,
  'travinh' => true,
  'tuyenquang' => true,
  'vinhlong' => true,
  'vinhphuc' => true,
  'yenbai' => true
 ],
 'vu' => [
  'com' => true,
  'edu' => true,
  'net' => true,
  'org' => true
 ],
 'wf' => [
  'biz' => true,
  'sch' => true
 ],
 'ws' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'net' => true,
  'org' => true,
  'advisor' => [
   '*' => true
  ],
  'cloud66' => true,
  'dyndns' => true,
  'mypets' => true
 ],
 'yt' => [
  'org' => true
 ],
 'امارات' => true,
 'հայ' => true,
 'বাংলা' => true,
 'бг' => true,
 'البحرين' => true,
 'бел' => true,
 '中国' => true,
 '中國' => true,
 'الجزائر' => true,
 'مصر' => true,
 'ею' => true,
 'ευ' => true,
 'موريتانيا' => true,
 'გე' => true,
 'ελ' => true,
 '香港' => [
  '個人' => true,
  '公司' => true,
  '政府' => true,
  '教育' => true,
  '組織' => true,
  '網絡' => true
 ],
 'ಭಾರತ' => true,
 'ଭାରତ' => true,
 'ভাৰত' => true,
 'भारतम्' => true,
 'भारोत' => true,
 'ڀارت' => true,
 'ഭാരതം' => true,
 'भारत' => true,
 'بارت' => true,
 'بھارت' => true,
 'భారత్' => true,
 'ભારત' => true,
 'ਭਾਰਤ' => true,
 'ভারত' => true,
 'இந்தியா' => true,
 'ایران' => true,
 'ايران' => true,
 'عراق' => true,
 'الاردن' => true,
 '한국' => true,
 'қаз' => true,
 'ລາວ' => true,
 'ලංකා' => true,
 'இலங்கை' => true,
 'المغرب' => true,
 'мкд' => true,
 'мон' => true,
 '澳門' => true,
 '澳门' => true,
 'مليسيا' => true,
 'عمان' => true,
 'پاکستان' => true,
 'پاكستان' => true,
 'فلسطين' => true,
 'срб' => [
  'ак' => true,
  'обр' => true,
  'од' => true,
  'орг' => true,
  'пр' => true,
  'упр' => true
 ],
 'рф' => true,
 'قطر' => true,
 'السعودية' => true,
 'السعودیة' => true,
 'السعودیۃ' => true,
 'السعوديه' => true,
 'سودان' => true,
 '新加坡' => true,
 'சிங்கப்பூர்' => true,
 'سورية' => true,
 'سوريا' => true,
 'ไทย' => [
  'ทหาร' => true,
  'ธุรกิจ' => true,
  'เน็ต' => true,
  'รัฐบาล' => true,
  'ศึกษา' => true,
  'องค์กร' => true
 ],
 'تونس' => true,
 '台灣' => true,
 '台湾' => true,
 '臺灣' => true,
 'укр' => true,
 'اليمن' => true,
 'xxx' => true,
 'ye' => [
  'com' => true,
  'edu' => true,
  'gov' => true,
  'mil' => true,
  'net' => true,
  'org' => true
 ],
 'za' => [
  'ac' => true,
  'agric' => true,
  'alt' => true,
  'co' => true,
  'edu' => true,
  'gov' => true,
  'grondar' => true,
  'law' => true,
  'mil' => true,
  'net' => true,
  'ngo' => true,
  'nic' => true,
  'nis' => true,
  'nom' => true,
  'org' => true,
  'school' => true,
  'tm' => true,
  'web' => true
 ],
 'zm' => [
  'ac' => true,
  'biz' => true,
  'co' => true,
  'com' => true,
  'edu' => true,
  'gov' => true,
  'info' => true,
  'mil' => true,
  'net' => true,
  'org' => true,
  'sch' => true
 ],
 'zw' => [
  'ac' => true,
  'co' => true,
  'gov' => true,
  'mil' => true,
  'org' => true
 ],
 'aaa' => true,
 'aarp' => true,
 'abb' => true,
 'abbott' => true,
 'abbvie' => true,
 'abc' => true,
 'able' => true,
 'abogado' => true,
 'abudhabi' => true,
 'academy' => [
  'official' => true
 ],
 'accenture' => true,
 'accountant' => true,
 'accountants' => true,
 'aco' => true,
 'actor' => true,
 'ads' => true,
 'adult' => true,
 'aeg' => true,
 'aetna' => true,
 'afl' => true,
 'africa' => true,
 'agakhan' => true,
 'agency' => true,
 'aig' => true,
 'airbus' => true,
 'airforce' => true,
 'airtel' => true,
 'akdn' => true,
 'alibaba' => true,
 'alipay' => true,
 'allfinanz' => true,
 'allstate' => true,
 'ally' => true,
 'alsace' => true,
 'alstom' => true,
 'amazon' => true,
 'americanexpress' => true,
 'americanfamily' => true,
 'amex' => true,
 'amfam' => true,
 'amica' => true,
 'amsterdam' => true,
 'analytics' => true,
 'android' => true,
 'anquan' => true,
 'anz' => true,
 'aol' => true,
 'apartments' => true,
 'app' => [
  'adaptable' => true,
  'aiven' => true,
  'beget' => [
   '*' => true
  ],
  'brave' => [
   's' => [
    '*' => true
   ]
  ],
  'clerk' => true,
  'clerkstage' => true,
  'wnext' => true,
  'csb' => [
   'preview' => true
  ],
  'deta' => true,
  'ondigitalocean' => true,
  'easypanel' => true,
  'encr' => true,
  'evervault' => [
   'relay' => true
  ],
  'expo' => [
   'staging' => true
  ],
  'edgecompute' => true,
  'on-fleek' => true,
  'flutterflow' => true,
  'framer' => true,
  'hosted' => [
   '*' => true
  ],
  'run' => [
   '*' => true
  ],
  'web' => true,
  'hasura' => true,
  'botdash' => true,
  'loginline' => true,
  'lovable' => true,
  'medusajs' => true,
  'messerli' => true,
  'netfy' => true,
  'netlify' => true,
  'ngrok' => true,
  'ngrok-free' => true,
  'developer' => [
   '*' => true
  ],
  'noop' => true,
  'northflank' => [
   '*' => true
  ],
  'upsun' => [
   '*' => true
  ],
  'replit' => [
   'id' => true
  ],
  'nyat' => true,
  'snowflake' => [
   '*' => true,
   'privatelink' => [
    '*' => true
   ]
  ],
  'streamlit' => true,
  'storipress' => true,
  'telebit' => true,
  'typedream' => true,
  'vercel' => true,
  'bookonline' => true,
  'wdh' => true,
  'zeabur' => true,
  'zerops' => [
   '*' => true
  ]
 ],
 'apple' => true,
 'aquarelle' => true,
 'arab' => true,
 'aramco' => true,
 'archi' => true,
 'army' => true,
 'art' => true,
 'arte' => true,
 'asda' => true,
 'associates' => true,
 'athleta' => true,
 'attorney' => true,
 'auction' => true,
 'audi' => true,
 'audible' => true,
 'audio' => true,
 'auspost' => true,
 'author' => true,
 'auto' => true,
 'autos' => true,
 'aws' => [
  'sagemaker' => [
   'ap-northeast-1' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'ap-northeast-2' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'ap-south-1' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'ap-southeast-1' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'ap-southeast-2' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'ca-central-1' => [
    'labeling' => true,
    'notebook' => true,
    'notebook-fips' => true,
    'studio' => true
   ],
   'eu-central-1' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'eu-west-1' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'eu-west-2' => [
    'labeling' => true,
    'notebook' => true,
    'studio' => true
   ],
   'us-east-1' => [
    'labeling' => true,
    'notebook' => true,
    'notebook-fips' => true,
    'studio' => true
   ],
   'us-east-2' => [
    'labeling' => true,
    'notebook' => true,
    'notebook-fips' => true,
    'studio' => true
   ],
   'us-west-2' => [
    'labeling' => true,
    'notebook' => true,
    'notebook-fips' => true,
    'studio' => true
   ],
   'af-south-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'ap-east-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'ap-northeast-3' => [
    'notebook' => true,
    'studio' => true
   ],
   'ap-south-2' => [
    'notebook' => true
   ],
   'ap-southeast-3' => [
    'notebook' => true,
    'studio' => true
   ],
   'ap-southeast-4' => [
    'notebook' => true
   ],
   'ca-west-1' => [
    'notebook' => true,
    'notebook-fips' => true
   ],
   'eu-central-2' => [
    'notebook' => true,
    'studio' => true
   ],
   'eu-north-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'eu-south-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'eu-south-2' => [
    'notebook' => true,
    'studio' => true
   ],
   'eu-west-3' => [
    'notebook' => true,
    'studio' => true
   ],
   'il-central-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'me-central-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'me-south-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'sa-east-1' => [
    'notebook' => true,
    'studio' => true
   ],
   'us-gov-east-1' => [
    'notebook' => true,
    'notebook-fips' => true,
    'studio' => true,
    'studio-fips' => true
   ],
   'us-gov-west-1' => [
    'notebook' => true,
    'notebook-fips' => true,
    'studio' => true,
    'studio-fips' => true
   ],
   'us-west-1' => [
    'notebook' => true,
    'notebook-fips' => true,
    'studio' => true
   ],
   'experiments' => [
    '*' => true
   ]
  ],
  'repost' => [
   'private' => [
    '*' => true
   ]
  ],
  'on' => [
   'ap-northeast-1' => [
    'transfer-webapp' => true
   ],
   'ap-southeast-1' => [
    'transfer-webapp' => true
   ],
   'ap-southeast-2' => [
    'transfer-webapp' => true
   ],
   'eu-central-1' => [
    'transfer-webapp' => true
   ],
   'eu-north-1' => [
    'transfer-webapp' => true
   ],
   'eu-west-1' => [
    'transfer-webapp' => true
   ],
   'us-east-1' => [
    'transfer-webapp' => true
   ],
   'us-east-2' => [
    'transfer-webapp' => true
   ],
   'us-west-2' => [
    'transfer-webapp' => true
   ]
  ]
 ],
 'axa' => true,
 'azure' => true,
 'baby' => true,
 'baidu' => true,
 'banamex' => true,
 'band' => true,
 'bank' => true,
 'bar' => true,
 'barcelona' => true,
 'barclaycard' => true,
 'barclays' => true,
 'barefoot' => true,
 'bargains' => true,
 'baseball' => true,
 'basketball' => [
  'aus' => true,
  'nz' => true
 ],
 'bauhaus' => true,
 'bayern' => true,
 'bbc' => true,
 'bbt' => true,
 'bbva' => true,
 'bcg' => true,
 'bcn' => true,
 'beats' => true,
 'beauty' => true,
 'beer' => true,
 'bentley' => true,
 'berlin' => true,
 'best' => true,
 'bestbuy' => true,
 'bet' => true,
 'bharti' => true,
 'bible' => true,
 'bid' => true,
 'bike' => true,
 'bing' => true,
 'bingo' => true,
 'bio' => true,
 'black' => true,
 'blackfriday' => true,
 'blockbuster' => true,
 'blog' => true,
 'bloomberg' => true,
 'blue' => true,
 'bms' => true,
 'bmw' => true,
 'bnpparibas' => true,
 'boats' => true,
 'boehringer' => true,
 'bofa' => true,
 'bom' => true,
 'bond' => true,
 'boo' => true,
 'book' => true,
 'booking' => true,
 'bosch' => true,
 'bostik' => true,
 'boston' => true,
 'bot' => true,
 'boutique' => true,
 'box' => true,
 'bradesco' => true,
 'bridgestone' => true,
 'broadway' => true,
 'broker' => true,
 'brother' => true,
 'brussels' => true,
 'build' => [
  'v0' => true
 ],
 'builders' => [
  'cloudsite' => true
 ],
 'business' => [
  'co' => true
 ],
 'buy' => true,
 'buzz' => true,
 'bzh' => true,
 'cab' => true,
 'cafe' => true,
 'cal' => true,
 'call' => true,
 'calvinklein' => true,
 'cam' => true,
 'camera' => true,
 'camp' => [
  'emf' => [
   'at' => true
  ]
 ],
 'canon' => true,
 'capetown' => true,
 'capital' => true,
 'capitalone' => true,
 'car' => true,
 'caravan' => true,
 'cards' => true,
 'care' => true,
 'career' => true,
 'careers' => true,
 'cars' => true,
 'casa' => [
  'nabu' => [
   'ui' => true
  ]
 ],
 'case' => true,
 'cash' => true,
 'casino' => true,
 'catering' => true,
 'catholic' => true,
 'cba' => true,
 'cbn' => true,
 'cbre' => true,
 'center' => true,
 'ceo' => true,
 'cern' => true,
 'cfa' => true,
 'cfd' => true,
 'chanel' => true,
 'channel' => true,
 'charity' => true,
 'chase' => true,
 'chat' => true,
 'cheap' => true,
 'chintai' => true,
 'christmas' => true,
 'chrome' => true,
 'church' => true,
 'cipriani' => true,
 'circle' => true,
 'cisco' => true,
 'citadel' => true,
 'citi' => true,
 'citic' => true,
 'city' => true,
 'claims' => true,
 'cleaning' => true,
 'click' => true,
 'clinic' => true,
 'clinique' => true,
 'clothing' => true,
 'cloud' => [
  'elementor' => true,
  'encoway' => [
   'eu' => true
  ],
  'statics' => [
   '*' => true
  ],
  'ravendb' => true,
  'axarnet' => [
   'es-1' => true
  ],
  'diadem' => true,
  'jelastic' => [
   'vip' => true
  ],
  'jele' => true,
  'jenv-aruba' => [
   'aruba' => [
    'eur' => [
     'it1' => true
    ]
   ],
   'it1' => true
  ],
  'keliweb' => [
   'cs' => true
  ],
  'oxa' => [
   'tn' => true,
   'uk' => true
  ],
  'primetel' => [
   'uk' => true
  ],
  'reclaim' => [
   'ca' => true,
   'uk' => true,
   'us' => true
  ],
  'trendhosting' => [
   'ch' => true,
   'de' => true
  ],
  'jotelulu' => true,
  'kuleuven' => true,
  'laravel' => true,
  'linkyard' => true,
  'magentosite' => [
   '*' => true
  ],
  'matlab' => true,
  'observablehq' => true,
  'perspecta' => true,
  'vapor' => true,
  'on-rancher' => [
   '*' => true
  ],
  'scw' => [
   'baremetal' => [
    'fr-par-1' => true,
    'fr-par-2' => true,
    'nl-ams-1' => true
   ],
   'fr-par' => [
    'cockpit' => true,
    'fnc' => [
     'functions' => true
    ],
    'k8s' => [
     'nodes' => true
    ],
    's3' => true,
    's3-website' => true,
    'whm' => true
   ],
   'instances' => [
    'priv' => true,
    'pub' => true
   ],
   'k8s' => true,
   'nl-ams' => [
    'cockpit' => true,
    'k8s' => [
     'nodes' => true
    ],
    's3' => true,
    's3-website' => true,
    'whm' => true
   ],
   'pl-waw' => [
    'cockpit' => true,
    'k8s' => [
     'nodes' => true
    ],
    's3' => true,
    's3-website' => true
   ],
   'scalebook' => true,
   'smartlabeling' => true
  ],
  'servebolt' => true,
  'onstackit' => [
   'runs' => true
  ],
  'trafficplex' => true,
  'unison-services' => true,
  'urown' => true,
  'voorloper' => true,
  'zap' => true
 ],
 'club' => [
  'cloudns' => true,
  'jele' => true,
  'barsy' => true
 ],
 'clubmed' => true,
 'coach' => true,
 'codes' => [
  'owo' => [
   '*' => true
  ]
 ],
 'coffee' => true,
 'college' => true,
 'cologne' => true,
 'commbank' => true,
 'community' => [
  'nog' => true,
  'ravendb' => true,
  'myforum' => true
 ],
 'company' => true,
 'compare' => true,
 'computer' => true,
 'comsec' => true,
 'condos' => true,
 'construction' => true,
 'consulting' => true,
 'contact' => true,
 'contractors' => true,
 'cooking' => true,
 'cool' => [
  'elementor' => true,
  'de' => true
 ],
 'corsica' => true,
 'country' => true,
 'coupon' => true,
 'coupons' => true,
 'courses' => true,
 'cpa' => true,
 'credit' => true,
 'creditcard' => true,
 'creditunion' => true,
 'cricket' => true,
 'crown' => true,
 'crs' => true,
 'cruise' => true,
 'cruises' => true,
 'cuisinella' => true,
 'cymru' => true,
 'cyou' => true,
 'dad' => true,
 'dance' => true,
 'data' => true,
 'date' => true,
 'dating' => true,
 'datsun' => true,
 'day' => true,
 'dclk' => true,
 'dds' => true,
 'deal' => true,
 'dealer' => true,
 'deals' => true,
 'degree' => true,
 'delivery' => true,
 'dell' => true,
 'deloitte' => true,
 'delta' => true,
 'democrat' => true,
 'dental' => true,
 'dentist' => true,
 'desi' => true,
 'design' => [
  'graphic' => true,
  'bss' => true
 ],
 'dev' => [
  '12chars' => true,
  'myaddr' => true,
  'panel' => true,
  'lcl' => [
   '*' => true
  ],
  'lclstage' => [
   '*' => true
  ],
  'stg' => [
   '*' => true
  ],
  'stgstage' => [
   '*' => true
  ],
  'pages' => true,
  'r2' => true,
  'workers' => true,
  'deno' => true,
  'deno-staging' => true,
  'deta' => true,
  'evervault' => [
   'relay' => true
  ],
  'fly' => true,
  'githubpreview' => true,
  'gateway' => [
   '*' => true
  ],
  'hrsn' => [
   'psl' => [
    'sub' => true,
    'wc' => [
     '*' => true,
     '!ignored' => true,
     'sub' => [
      '*' => true,
      '!ignored' => true
     ]
    ]
   ]
  ],
  'botdash' => true,
  'inbrowser' => [
   '*' => true
  ],
  'is-a-good' => true,
  'is-a' => true,
  'iserv' => true,
  'runcontainers' => true,
  'localcert' => [
   'user' => [
    '*' => true
   ]
  ],
  'loginline' => true,
  'barsy' => true,
  'mediatech' => true,
  'modx' => true,
  'ngrok' => true,
  'ngrok-free' => true,
  'is-a-fullstack' => true,
  'is-cool' => true,
  'is-not-a' => true,
  'localplayer' => true,
  'xmit' => true,
  'platter-app' => true,
  'replit' => [
   'archer' => true,
   'bones' => true,
   'canary' => true,
   'global' => true,
   'hacker' => true,
   'id' => true,
   'janeway' => true,
   'kim' => true,
   'kira' => true,
   'kirk' => true,
   'odo' => true,
   'paris' => true,
   'picard' => true,
   'pike' => true,
   'prerelease' => true,
   'reed' => true,
   'riker' => true,
   'sisko' => true,
   'spock' => true,
   'staging' => true,
   'sulu' => true,
   'tarpit' => true,
   'teams' => true,
   'tucker' => true,
   'wesley' => true,
   'worf' => true
  ],
  'crm' => [
   'd' => [
    '*' => true
   ],
   'w' => [
    '*' => true
   ],
   'wa' => [
    '*' => true
   ],
   'wb' => [
    '*' => true
   ],
   'wc' => [
    '*' => true
   ],
   'wd' => [
    '*' => true
   ],
   'we' => [
    '*' => true
   ],
   'wf' => [
    '*' => true
   ]
  ],
  'vercel' => true,
  'webhare' => [
   '*' => true
  ]
 ],
 'dhl' => true,
 'diamonds' => true,
 'diet' => true,
 'digital' => [
  'cloudapps' => [
   'london' => true
  ]
 ],
 'direct' => [
  'libp2p' => true
 ],
 'directory' => true,
 'discount' => true,
 'discover' => true,
 'dish' => true,
 'diy' => true,
 'dnp' => true,
 'docs' => true,
 'doctor' => true,
 'dog' => true,
 'domains' => true,
 'dot' => true,
 'download' => true,
 'drive' => true,
 'dtv' => true,
 'dubai' => true,
 'dunlop' => true,
 'dupont' => true,
 'durban' => true,
 'dvag' => true,
 'dvr' => true,
 'earth' => true,
 'eat' => true,
 'eco' => true,
 'edeka' => true,
 'education' => [
  'co' => true
 ],
 'email' => [
  'crisp' => [
   'on' => true
  ],
  'tawk' => [
   'p' => true
  ],
  'tawkto' => [
   'p' => true
  ]
 ],
 'emerck' => true,
 'energy' => true,
 'engineer' => true,
 'engineering' => true,
 'enterprises' => true,
 'epson' => true,
 'equipment' => true,
 'ericsson' => true,
 'erni' => true,
 'esq' => true,
 'estate' => [
  'compute' => [
   '*' => true
  ]
 ],
 'eurovision' => true,
 'eus' => [
  'party' => [
   'user' => true
  ]
 ],
 'events' => [
  'koobin' => true,
  'co' => true
 ],
 'exchange' => true,
 'expert' => true,
 'exposed' => true,
 'express' => true,
 'extraspace' => true,
 'fage' => true,
 'fail' => true,
 'fairwinds' => true,
 'faith' => true,
 'family' => true,
 'fan' => true,
 'fans' => true,
 'farm' => [
  'storj' => true
 ],
 'farmers' => true,
 'fashion' => true,
 'fast' => true,
 'fedex' => true,
 'feedback' => true,
 'ferrari' => true,
 'ferrero' => true,
 'fidelity' => true,
 'fido' => true,
 'film' => true,
 'final' => true,
 'finance' => true,
 'financial' => [
  'co' => true
 ],
 'fire' => true,
 'firestone' => true,
 'firmdale' => true,
 'fish' => true,
 'fishing' => true,
 'fit' => true,
 'fitness' => true,
 'flickr' => true,
 'flights' => true,
 'flir' => true,
 'florist' => true,
 'flowers' => true,
 'fly' => true,
 'foo' => true,
 'food' => true,
 'football' => true,
 'ford' => true,
 'forex' => true,
 'forsale' => true,
 'forum' => true,
 'foundation' => true,
 'fox' => true,
 'free' => true,
 'fresenius' => true,
 'frl' => true,
 'frogans' => true,
 'frontier' => true,
 'ftr' => true,
 'fujitsu' => true,
 'fun' => true,
 'fund' => true,
 'furniture' => true,
 'futbol' => true,
 'fyi' => true,
 'gal' => true,
 'gallery' => true,
 'gallo' => true,
 'gallup' => true,
 'game' => true,
 'games' => [
  'pley' => true,
  'sheezy' => true
 ],
 'gap' => true,
 'garden' => true,
 'gay' => [
  'pages' => true
 ],
 'gbiz' => true,
 'gdn' => [
  'cnpy' => true
 ],
 'gea' => true,
 'gent' => true,
 'genting' => true,
 'george' => true,
 'ggee' => true,
 'gift' => true,
 'gifts' => true,
 'gives' => true,
 'giving' => true,
 'glass' => true,
 'gle' => true,
 'global' => [
  'appwrite' => true
 ],
 'globo' => true,
 'gmail' => true,
 'gmbh' => true,
 'gmo' => true,
 'gmx' => true,
 'godaddy' => true,
 'gold' => true,
 'goldpoint' => true,
 'golf' => true,
 'goo' => true,
 'goodyear' => true,
 'goog' => [
  'cloud' => true,
  'translate' => true,
  'usercontent' => [
   '*' => true
  ]
 ],
 'google' => true,
 'gop' => true,
 'got' => true,
 'grainger' => true,
 'graphics' => true,
 'gratis' => true,
 'green' => true,
 'gripe' => true,
 'grocery' => true,
 'group' => [
  'discourse' => true
 ],
 'gucci' => true,
 'guge' => true,
 'guide' => true,
 'guitars' => true,
 'guru' => true,
 'hair' => true,
 'hamburg' => true,
 'hangout' => true,
 'haus' => true,
 'hbo' => true,
 'hdfc' => true,
 'hdfcbank' => true,
 'health' => [
  'hra' => true
 ],
 'healthcare' => true,
 'help' => true,
 'helsinki' => true,
 'here' => true,
 'hermes' => true,
 'hiphop' => true,
 'hisamitsu' => true,
 'hitachi' => true,
 'hiv' => true,
 'hkt' => true,
 'hockey' => true,
 'holdings' => true,
 'holiday' => true,
 'homedepot' => true,
 'homegoods' => true,
 'homes' => true,
 'homesense' => true,
 'honda' => true,
 'horse' => true,
 'hospital' => true,
 'host' => [
  'cloudaccess' => true,
  'freesite' => true,
  'easypanel' => true,
  'fastvps' => true,
  'myfast' => true,
  'tempurl' => true,
  'wpmudev' => true,
  'jele' => true,
  'mircloud' => true,
  'wp2' => true,
  'half' => true
 ],
 'hosting' => [
  'opencraft' => true
 ],
 'hot' => true,
 'hotels' => true,
 'hotmail' => true,
 'house' => true,
 'how' => true,
 'hsbc' => true,
 'hughes' => true,
 'hyatt' => true,
 'hyundai' => true,
 'ibm' => true,
 'icbc' => true,
 'ice' => true,
 'icu' => true,
 'ieee' => true,
 'ifm' => true,
 'ikano' => true,
 'imamat' => true,
 'imdb' => true,
 'immo' => true,
 'immobilien' => true,
 'inc' => true,
 'industries' => true,
 'infiniti' => true,
 'ing' => true,
 'ink' => true,
 'institute' => true,
 'insurance' => true,
 'insure' => true,
 'international' => true,
 'intuit' => true,
 'investments' => true,
 'ipiranga' => true,
 'irish' => true,
 'ismaili' => true,
 'ist' => true,
 'istanbul' => true,
 'itau' => true,
 'itv' => true,
 'jaguar' => true,
 'java' => true,
 'jcb' => true,
 'jeep' => true,
 'jetzt' => true,
 'jewelry' => true,
 'jio' => true,
 'jll' => true,
 'jmp' => true,
 'jnj' => true,
 'joburg' => true,
 'jot' => true,
 'joy' => true,
 'jpmorgan' => true,
 'jprs' => true,
 'juegos' => true,
 'juniper' => true,
 'kaufen' => true,
 'kddi' => true,
 'kerryhotels' => true,
 'kerryproperties' => true,
 'kfh' => true,
 'kia' => true,
 'kids' => true,
 'kim' => true,
 'kindle' => true,
 'kitchen' => true,
 'kiwi' => true,
 'koeln' => true,
 'komatsu' => true,
 'kosher' => true,
 'kpmg' => true,
 'kpn' => true,
 'krd' => [
  'co' => true,
  'edu' => true
 ],
 'kred' => true,
 'kuokgroup' => true,
 'kyoto' => true,
 'lacaixa' => true,
 'lamborghini' => true,
 'lamer' => true,
 'lancaster' => true,
 'land' => true,
 'landrover' => true,
 'lanxess' => true,
 'lasalle' => true,
 'lat' => true,
 'latino' => true,
 'latrobe' => true,
 'law' => true,
 'lawyer' => true,
 'lds' => true,
 'lease' => true,
 'leclerc' => true,
 'lefrak' => true,
 'legal' => true,
 'lego' => true,
 'lexus' => true,
 'lgbt' => true,
 'lidl' => true,
 'life' => true,
 'lifeinsurance' => true,
 'lifestyle' => true,
 'lighting' => true,
 'like' => true,
 'lilly' => true,
 'limited' => true,
 'limo' => true,
 'lincoln' => true,
 'link' => [
  'myfritz' => true,
  'cyon' => true,
  'dweb' => [
   '*' => true
  ],
  'inbrowser' => [
   '*' => true
  ],
  'nftstorage' => [
   'ipfs' => true
  ],
  'mypep' => true,
  'storacha' => [
   'ipfs' => true
  ],
  'w3s' => [
   'ipfs' => true
  ]
 ],
 'live' => [
  'aem' => true,
  'hlx' => true,
  'ewp' => [
   '*' => true
  ]
 ],
 'living' => true,
 'llc' => true,
 'llp' => true,
 'loan' => true,
 'loans' => true,
 'locker' => true,
 'locus' => true,
 'lol' => [
  'omg' => true
 ],
 'london' => true,
 'lotte' => true,
 'lotto' => true,
 'love' => true,
 'lpl' => true,
 'lplfinancial' => true,
 'ltd' => true,
 'ltda' => true,
 'lundbeck' => true,
 'luxe' => true,
 'luxury' => true,
 'madrid' => true,
 'maif' => true,
 'maison' => true,
 'makeup' => true,
 'man' => true,
 'management' => true,
 'mango' => true,
 'map' => true,
 'market' => true,
 'marketing' => true,
 'markets' => true,
 'marriott' => true,
 'marshalls' => true,
 'mattel' => true,
 'mba' => true,
 'mckinsey' => true,
 'med' => true,
 'media' => [
  'framer' => true
 ],
 'meet' => true,
 'melbourne' => true,
 'meme' => true,
 'memorial' => true,
 'men' => true,
 'menu' => [
  'barsy' => true,
  'barsyonline' => true
 ],
 'merck' => true,
 'merckmsd' => true,
 'miami' => true,
 'microsoft' => true,
 'mini' => true,
 'mint' => true,
 'mit' => true,
 'mitsubishi' => true,
 'mlb' => true,
 'mls' => true,
 'mma' => true,
 'mobile' => true,
 'moda' => true,
 'moe' => true,
 'moi' => true,
 'mom' => [
  'ind' => true
 ],
 'monash' => true,
 'money' => true,
 'monster' => true,
 'mormon' => true,
 'mortgage' => true,
 'moscow' => true,
 'moto' => true,
 'motorcycles' => true,
 'mov' => true,
 'movie' => true,
 'msd' => true,
 'mtn' => true,
 'mtr' => true,
 'music' => true,
 'nab' => true,
 'nagoya' => true,
 'navy' => true,
 'nba' => true,
 'nec' => true,
 'netbank' => true,
 'netflix' => true,
 'network' => [
  'alces' => [
   '*' => true
  ],
  'co' => true,
  'arvo' => true,
  'azimuth' => true,
  'tlon' => true
 ],
 'neustar' => true,
 'new' => true,
 'news' => [
  'noticeable' => true
 ],
 'next' => true,
 'nextdirect' => true,
 'nexus' => true,
 'nfl' => true,
 'ngo' => true,
 'nhk' => true,
 'nico' => true,
 'nike' => true,
 'nikon' => true,
 'ninja' => true,
 'nissan' => true,
 'nissay' => true,
 'nokia' => true,
 'norton' => true,
 'now' => true,
 'nowruz' => true,
 'nowtv' => true,
 'nra' => true,
 'nrw' => true,
 'ntt' => true,
 'nyc' => true,
 'obi' => true,
 'observer' => true,
 'office' => true,
 'okinawa' => true,
 'olayan' => true,
 'olayangroup' => true,
 'ollo' => true,
 'omega' => true,
 'one' => [
  'kin' => [
   '*' => true
  ],
  'service' => true
 ],
 'ong' => [
  'obl' => true
 ],
 'onl' => true,
 'online' => [
  'eero' => true,
  'eero-stage' => true,
  'websitebuilder' => true,
  'barsy' => true
 ],
 'ooo' => true,
 'open' => true,
 'oracle' => true,
 'orange' => [
  'tech' => true
 ],
 'organic' => true,
 'origins' => true,
 'osaka' => true,
 'otsuka' => true,
 'ott' => true,
 'ovh' => [
  'nerdpol' => true
 ],
 'page' => [
  'aem' => true,
  'hlx' => true,
  'hlx3' => true,
  'translated' => true,
  'codeberg' => true,
  'heyflow' => true,
  'prvcy' => true,
  'rocky' => true,
  'pdns' => true,
  'plesk' => true
 ],
 'panasonic' => true,
 'paris' => true,
 'pars' => true,
 'partners' => true,
 'parts' => true,
 'party' => true,
 'pay' => true,
 'pccw' => true,
 'pet' => true,
 'pfizer' => true,
 'pharmacy' => true,
 'phd' => true,
 'philips' => true,
 'phone' => true,
 'photo' => true,
 'photography' => true,
 'photos' => [
  'framer' => true
 ],
 'physio' => true,
 'pics' => true,
 'pictet' => true,
 'pictures' => [
  '1337' => true
 ],
 'pid' => true,
 'pin' => true,
 'ping' => true,
 'pink' => true,
 'pioneer' => true,
 'pizza' => [
  'ngrok' => true
 ],
 'place' => [
  'co' => true
 ],
 'play' => true,
 'playstation' => true,
 'plumbing' => true,
 'plus' => true,
 'pnc' => true,
 'pohl' => true,
 'poker' => true,
 'politie' => true,
 'porn' => true,
 'pramerica' => true,
 'praxi' => true,
 'press' => true,
 'prime' => true,
 'prod' => true,
 'productions' => true,
 'prof' => true,
 'progressive' => true,
 'promo' => true,
 'properties' => true,
 'property' => true,
 'protection' => true,
 'pru' => true,
 'prudential' => true,
 'pub' => [
  'id' => [
   '*' => true
  ],
  'kin' => [
   '*' => true
  ],
  'barsy' => true
 ],
 'pwc' => true,
 'qpon' => true,
 'quebec' => true,
 'quest' => true,
 'racing' => true,
 'radio' => true,
 'read' => true,
 'realestate' => true,
 'realtor' => true,
 'realty' => true,
 'recipes' => true,
 'red' => true,
 'redstone' => true,
 'redumbrella' => true,
 'rehab' => true,
 'reise' => true,
 'reisen' => true,
 'reit' => true,
 'reliance' => true,
 'ren' => true,
 'rent' => true,
 'rentals' => true,
 'repair' => true,
 'report' => true,
 'republican' => true,
 'rest' => true,
 'restaurant' => true,
 'review' => true,
 'reviews' => true,
 'rexroth' => true,
 'rich' => true,
 'richardli' => true,
 'ricoh' => true,
 'ril' => true,
 'rio' => true,
 'rip' => [
  'clan' => true
 ],
 'rocks' => [
  'myddns' => true,
  'stackit' => true,
  'lima-city' => true,
  'webspace' => true
 ],
 'rodeo' => true,
 'rogers' => true,
 'room' => true,
 'rsvp' => true,
 'rugby' => true,
 'ruhr' => true,
 'run' => [
  'appwrite' => [
   '*' => true
  ],
  'development' => true,
  'ravendb' => true,
  'liara' => [
   'iran' => true
  ],
  'servers' => true,
  'build' => [
   '*' => true
  ],
  'code' => [
   '*' => true
  ],
  'database' => [
   '*' => true
  ],
  'migration' => [
   '*' => true
  ],
  'onporter' => true,
  'repl' => true,
  'stackit' => true,
  'val' => [
   'express' => true,
   'web' => true
  ],
  'wix' => true
 ],
 'rwe' => true,
 'ryukyu' => true,
 'saarland' => true,
 'safe' => true,
 'safety' => true,
 'sakura' => true,
 'sale' => true,
 'salon' => true,
 'samsclub' => true,
 'samsung' => true,
 'sandvik' => true,
 'sandvikcoromant' => true,
 'sanofi' => true,
 'sap' => true,
 'sarl' => true,
 'sas' => true,
 'save' => true,
 'saxo' => true,
 'sbi' => true,
 'sbs' => true,
 'scb' => true,
 'schaeffler' => true,
 'schmidt' => true,
 'scholarships' => true,
 'school' => true,
 'schule' => true,
 'schwarz' => true,
 'science' => true,
 'scot' => [
  'gov' => [
   'service' => true
  ]
 ],
 'search' => true,
 'seat' => true,
 'secure' => true,
 'security' => true,
 'seek' => true,
 'select' => true,
 'sener' => true,
 'services' => [
  'loginline' => true
 ],
 'seven' => true,
 'sew' => true,
 'sex' => true,
 'sexy' => true,
 'sfr' => true,
 'shangrila' => true,
 'sharp' => true,
 'shell' => true,
 'shia' => true,
 'shiksha' => true,
 'shoes' => true,
 'shop' => [
  'base' => true,
  'hoplix' => true,
  'barsy' => true,
  'barsyonline' => true,
  'shopware' => true
 ],
 'shopping' => true,
 'shouji' => true,
 'show' => true,
 'silk' => true,
 'sina' => true,
 'singles' => true,
 'site' => [
  'square' => true,
  'canva' => [
   'my' => [
    '*' => true
   ]
  ],
  'cloudera' => [
   '*' => true
  ],
  'convex' => true,
  'cyon' => true,
  'fastvps' => true,
  'heyflow' => true,
  'jele' => true,
  'jouwweb' => true,
  'loginline' => true,
  'barsy' => true,
  'notion' => true,
  'omniwe' => true,
  'opensocial' => true,
  'madethis' => true,
  'platformsh' => [
   '*' => true
  ],
  'tst' => [
   '*' => true
  ],
  'byen' => true,
  'srht' => true,
  'novecore' => true,
  'cpanel' => true,
  'wpsquared' => true
 ],
 'ski' => true,
 'skin' => true,
 'sky' => true,
 'skype' => true,
 'sling' => true,
 'smart' => true,
 'smile' => true,
 'sncf' => true,
 'soccer' => true,
 'social' => true,
 'softbank' => true,
 'software' => true,
 'sohu' => true,
 'solar' => true,
 'solutions' => true,
 'song' => true,
 'sony' => true,
 'soy' => true,
 'spa' => true,
 'space' => [
  'myfast' => true,
  'heiyu' => true,
  'hf' => [
   'static' => true
  ],
  'app-ionos' => true,
  'project' => true,
  'uber' => true,
  'xs4all' => true
 ],
 'sport' => true,
 'spot' => true,
 'srl' => true,
 'stada' => true,
 'staples' => true,
 'star' => true,
 'statebank' => true,
 'statefarm' => true,
 'stc' => true,
 'stcgroup' => true,
 'stockholm' => true,
 'storage' => true,
 'store' => [
  'barsy' => true,
  'sellfy' => true,
  'shopware' => true,
  'storebase' => true
 ],
 'stream' => true,
 'studio' => true,
 'study' => true,
 'style' => true,
 'sucks' => true,
 'supplies' => true,
 'supply' => true,
 'support' => [
  'barsy' => true
 ],
 'surf' => true,
 'surgery' => true,
 'suzuki' => true,
 'swatch' => true,
 'swiss' => true,
 'sydney' => true,
 'systems' => [
  'knightpoint' => true
 ],
 'tab' => true,
 'taipei' => true,
 'talk' => true,
 'taobao' => true,
 'target' => true,
 'tatamotors' => true,
 'tatar' => true,
 'tattoo' => true,
 'tax' => true,
 'taxi' => true,
 'tci' => true,
 'tdk' => true,
 'team' => [
  'discourse' => true,
  'jelastic' => true
 ],
 'tech' => [
  'cleverapps' => true
 ],
 'technology' => [
  'co' => true
 ],
 'temasek' => true,
 'tennis' => true,
 'teva' => true,
 'thd' => true,
 'theater' => true,
 'theatre' => true,
 'tiaa' => true,
 'tickets' => true,
 'tienda' => true,
 'tips' => true,
 'tires' => true,
 'tirol' => true,
 'tjmaxx' => true,
 'tjx' => true,
 'tkmaxx' => true,
 'tmall' => true,
 'today' => [
  'prequalifyme' => true
 ],
 'tokyo' => true,
 'tools' => [
  'addr' => [
   'dyn' => true
  ],
  'myaddr' => true
 ],
 'top' => [
  'ntdll' => true,
  'wadl' => [
   '*' => true
  ]
 ],
 'toray' => true,
 'toshiba' => true,
 'total' => true,
 'tours' => true,
 'town' => true,
 'toyota' => true,
 'toys' => true,
 'trade' => true,
 'trading' => true,
 'training' => true,
 'travel' => true,
 'travelers' => true,
 'travelersinsurance' => true,
 'trust' => true,
 'trv' => true,
 'tube' => true,
 'tui' => true,
 'tunes' => true,
 'tushu' => true,
 'tvs' => true,
 'ubank' => true,
 'ubs' => true,
 'unicom' => true,
 'university' => true,
 'uno' => true,
 'uol' => true,
 'ups' => true,
 'vacations' => true,
 'vana' => true,
 'vanguard' => true,
 'vegas' => true,
 'ventures' => true,
 'verisign' => true,
 'versicherung' => true,
 'vet' => true,
 'viajes' => true,
 'video' => true,
 'vig' => true,
 'viking' => true,
 'villas' => true,
 'vin' => true,
 'vip' => true,
 'virgin' => true,
 'visa' => true,
 'vision' => true,
 'viva' => true,
 'vivo' => true,
 'vlaanderen' => true,
 'vodka' => true,
 'volvo' => true,
 'vote' => true,
 'voting' => true,
 'voto' => true,
 'voyage' => true,
 'wales' => true,
 'walmart' => true,
 'walter' => true,
 'wang' => true,
 'wanggou' => true,
 'watch' => true,
 'watches' => true,
 'weather' => true,
 'weatherchannel' => true,
 'webcam' => true,
 'weber' => true,
 'website' => [
  'framer' => true
 ],
 'wed' => true,
 'wedding' => true,
 'weibo' => true,
 'weir' => true,
 'whoswho' => true,
 'wien' => true,
 'wiki' => [
  'framer' => true
 ],
 'williamhill' => true,
 'win' => true,
 'windows' => true,
 'wine' => true,
 'winners' => true,
 'wme' => true,
 'wolterskluwer' => true,
 'woodside' => true,
 'work' => true,
 'works' => true,
 'world' => true,
 'wow' => true,
 'wtc' => true,
 'wtf' => true,
 'xbox' => true,
 'xerox' => true,
 'xihuan' => true,
 'xin' => true,
 'कॉम' => true,
 'セール' => true,
 '佛山' => true,
 '慈善' => true,
 '集团' => true,
 '在线' => true,
 '点看' => true,
 'คอม' => true,
 '八卦' => true,
 'موقع' => true,
 '公益' => true,
 '公司' => true,
 '香格里拉' => true,
 '网站' => true,
 '移动' => true,
 '我爱你' => true,
 'москва' => true,
 'католик' => true,
 'онлайн' => true,
 'сайт' => true,
 '联通' => true,
 'קום' => true,
 '时尚' => true,
 '微博' => true,
 '淡马锡' => true,
 'ファッション' => true,
 'орг' => true,
 'नेट' => true,
 'ストア' => true,
 'アマゾン' => true,
 '삼성' => true,
 '商标' => true,
 '商店' => true,
 '商城' => true,
 'дети' => true,
 'ポイント' => true,
 '新闻' => true,
 '家電' => true,
 'كوم' => true,
 '中文网' => true,
 '中信' => true,
 '娱乐' => true,
 '谷歌' => true,
 '電訊盈科' => true,
 '购物' => true,
 'クラウド' => true,
 '通販' => true,
 '网店' => true,
 'संगठन' => true,
 '餐厅' => true,
 '网络' => true,
 'ком' => true,
 '亚马逊' => true,
 '食品' => true,
 '飞利浦' => true,
 '手机' => true,
 'ارامكو' => true,
 'العليان' => true,
 'بازار' => true,
 'ابوظبي' => true,
 'كاثوليك' => true,
 'همراه' => true,
 '닷컴' => true,
 '政府' => true,
 'شبكة' => true,
 'بيتك' => true,
 'عرب' => true,
 '机构' => true,
 '组织机构' => true,
 '健康' => true,
 '招聘' => true,
 'рус' => [
  'биз' => true,
  'ком' => true,
  'крым' => true,
  'мир' => true,
  'мск' => true,
  'орг' => true,
  'самара' => true,
  'сочи' => true,
  'спб' => true,
  'я' => true
 ],
 '大拿' => true,
 'みんな' => true,
 'グーグル' => true,
 '世界' => true,
 '書籍' => true,
 '网址' => true,
 '닷넷' => true,
 'コム' => true,
 '天主教' => true,
 '游戏' => true,
 'vermögensberater' => true,
 'vermögensberatung' => true,
 '企业' => true,
 '信息' => true,
 '嘉里大酒店' => true,
 '嘉里' => true,
 '广东' => true,
 '政务' => true,
 'xyz' => [
  'botdash' => true,
  'telebit' => [
   '*' => true
  ]
 ],
 'yachts' => true,
 'yahoo' => true,
 'yamaxun' => true,
 'yandex' => true,
 'yodobashi' => true,
 'yoga' => true,
 'yokohama' => true,
 'you' => true,
 'youtube' => true,
 'yun' => true,
 'zappos' => true,
 'zara' => true,
 'zero' => true,
 'zip' => true,
 'zone' => [
  'cloud66' => true,
  'triton' => [
   '*' => true
  ],
  'stackit' => true,
  'lima' => true
 ],
 'zuerich' => true
];
?>