/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.LineTable;
import gnu.classpath.jdwp.util.VariableTable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MethodCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeLineTable(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeVariableTable(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeByteCodes(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executeIsObsolete(byteBuffer, dataOutputStream);
                    break;
                }
                case 5: {
                    this.executeVariableTableWithGeneric(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in Method Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeLineTable(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ClassReferenceTypeId classReferenceTypeId = (ClassReferenceTypeId)this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = classReferenceTypeId.getType();
        VMMethod vMMethod = VMMethod.readId(clazz, byteBuffer);
        LineTable lineTable = vMMethod.getLineTable();
        lineTable.write(dataOutputStream);
    }

    private final void executeVariableTable(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ClassReferenceTypeId classReferenceTypeId = (ClassReferenceTypeId)this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = classReferenceTypeId.getType();
        VMMethod vMMethod = VMMethod.readId(clazz, byteBuffer);
        VariableTable variableTable = vMMethod.getVariableTable();
        variableTable.write(dataOutputStream);
    }

    private final void executeByteCodes(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command ByteCodes not implemented.");
    }

    private final void executeIsObsolete(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(false);
    }

    private final void executeVariableTableWithGeneric(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }
}

