/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    private static final long serialVersionUID = 6108874887143696463L;
    public static final BigDecimal ZERO = new BigDecimal(BigInteger.valueOf(0L), 0);
    public static final BigDecimal ONE = new BigDecimal(BigInteger.valueOf(1L), 0);
    public static final BigDecimal TEN = new BigDecimal(BigInteger.valueOf(10L), 0);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private BigInteger intVal;
    private int scale;

    public static BigDecimal valueOf(long l) {
        return BigDecimal.valueOf(l, 0);
    }

    public static BigDecimal valueOf(long l, int n) throws NumberFormatException {
        if (n == 0 && (long)((int)l) == l) {
            switch ((int)l) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
        }
        return new BigDecimal(BigInteger.valueOf(l), n);
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigInteger bigInteger = this.intVal;
        BigInteger bigInteger2 = bigDecimal.intVal;
        if (this.scale < bigDecimal.scale) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(10L).pow(bigDecimal.scale - this.scale));
        } else if (this.scale > bigDecimal.scale) {
            bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(10L).pow(this.scale - bigDecimal.scale));
        }
        return new BigDecimal(bigInteger.add(bigInteger2), Math.max(this.scale, bigDecimal.scale));
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        return this.add(bigDecimal.negate());
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        return new BigDecimal(this.intVal.multiply(bigDecimal.intVal), this.scale + bigDecimal.scale);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) throws ArithmeticException, IllegalArgumentException {
        return this.divide(bigDecimal, this.scale, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) throws ArithmeticException, IllegalArgumentException {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("illegal rounding mode: " + n2);
        }
        if (n < 0) {
            throw new ArithmeticException("scale is negative: " + n);
        }
        if (this.intVal.signum() == 0) {
            return n == 0 ? ZERO : new BigDecimal(BigDecimal.ZERO.intVal, n);
        }
        BigInteger bigInteger = bigDecimal.intVal;
        int n3 = n - (this.scale - bigDecimal.scale);
        if (n3 < 0) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(10L).pow(-n3));
            n3 = 0;
        }
        BigInteger bigInteger2 = this.intVal.multiply(BigInteger.valueOf(10L).pow(n3));
        BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger);
        BigInteger bigInteger3 = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() == 0) {
            return new BigDecimal(bigInteger3, n);
        }
        if (n2 == 7) {
            throw new ArithmeticException("newScale is not large enough");
        }
        int n4 = this.intVal.signum() * bigInteger.signum();
        if (n2 == 2) {
            int n5 = 0;
            if (n4 > 0) {
                n5 = 1;
            }
            n2 = 1 - n5;
        } else if (n2 == 3) {
            int n6 = 0;
            if (n4 < 0) {
                n6 = 1;
            }
            n2 = 1 - n6;
        } else {
            BigInteger bigInteger4 = bigIntegerArray[1].signum() < 0 ? bigIntegerArray[1].negate() : bigIntegerArray[1];
            bigInteger = bigInteger.signum() < 0 ? bigInteger.negate() : bigInteger;
            int n7 = bigInteger4.shiftLeft(1).compareTo(bigInteger);
            switch (n2) {
                case 4: {
                    int n8 = 0;
                    if (n7 < 0) {
                        n8 = 1;
                    }
                    n2 = n8;
                    break;
                }
                case 5: {
                    int n9 = 0;
                    if (n7 > 0) {
                        n9 = 1;
                    }
                    n2 = 1 - n9;
                    break;
                }
                case 6: {
                    if (n7 < 0) {
                        n2 = 1;
                        break;
                    }
                    if (n7 > 0) {
                        n2 = 0;
                        break;
                    }
                    if (bigInteger3.testBit(0)) {
                        n2 = 0;
                        break;
                    }
                    n2 = 1;
                    break;
                }
            }
        }
        if (n2 == 0) {
            bigInteger3 = bigInteger3.add(BigInteger.valueOf(n4 > 0 ? 1 : -1));
        }
        return new BigDecimal(bigInteger3, n);
    }

    public int compareTo(BigDecimal bigDecimal) {
        BigInteger[] bigIntegerArray;
        if (this.scale == bigDecimal.scale) {
            return this.intVal.compareTo(bigDecimal.intVal);
        }
        BigInteger[] bigIntegerArray2 = this.intVal.divideAndRemainder(BigInteger.valueOf(10L).pow(this.scale));
        int n = bigIntegerArray2[0].compareTo((bigIntegerArray = bigDecimal.intVal.divideAndRemainder(BigInteger.valueOf(10L).pow(bigDecimal.scale)))[0]);
        if (n != 0) {
            return n;
        }
        if (this.scale < bigDecimal.scale) {
            bigIntegerArray2[1] = bigIntegerArray2[1].multiply(BigInteger.valueOf(10L).pow(bigDecimal.scale - this.scale));
        } else if (this.scale > bigDecimal.scale) {
            bigIntegerArray[1] = bigIntegerArray[1].multiply(BigInteger.valueOf(10L).pow(this.scale - bigDecimal.scale));
        }
        return bigIntegerArray2[1].compareTo(bigIntegerArray[1]);
    }

    public int compareTo(Object object) {
        return this.compareTo((BigDecimal)object);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof BigDecimal && this.scale == ((BigDecimal)object).scale && this.compareTo((BigDecimal)object) == 0) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.intValue() ^ this.scale;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        switch (this.compareTo(bigDecimal)) {
            case 1: {
                return this;
            }
        }
        return bigDecimal;
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        switch (this.compareTo(bigDecimal)) {
            case -1: {
                return this;
            }
        }
        return bigDecimal;
    }

    public BigDecimal movePointLeft(int n) {
        return n < 0 ? this.movePointRight(-n) : new BigDecimal(this.intVal, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        if (this.scale >= n) {
            return new BigDecimal(this.intVal, this.scale - n);
        }
        return new BigDecimal(this.intVal.multiply(BigInteger.valueOf(10L).pow(n - this.scale)), 0);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public BigDecimal abs() {
        return new BigDecimal(this.intVal.abs(), this.scale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public String toString() {
        String string = this.intVal.toString();
        if (this.scale == 0) {
            return string;
        }
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        int n2 = n;
        int n3 = string.length() - this.scale - n2;
        int n4 = string.length() + 2;
        int n5 = 0;
        if (n3 <= 0) {
            n5 = -n3 + 1;
        }
        StringBuffer stringBuffer = new StringBuffer(n4 + n5);
        if (n3 <= 0) {
            if (n2 != 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append('0').append('.');
            while (n3 < 0) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string.substring(n2));
        } else {
            stringBuffer.append(string);
            stringBuffer.insert(n3 + n2, '.');
        }
        return stringBuffer.toString();
    }

    public BigInteger toBigInteger() {
        return this.scale == 0 ? this.intVal : this.intVal.divide(BigInteger.valueOf(10L).pow(this.scale));
    }

    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public long longValue() {
        return this.toBigInteger().longValue();
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public BigDecimal setScale(int n) throws ArithmeticException {
        return this.setScale(n, 7);
    }

    public BigDecimal setScale(int n, int n2) throws ArithmeticException, IllegalArgumentException {
        return this.divide(ONE, n, n2);
    }

    public BigDecimal(BigInteger bigInteger) {
        this(bigInteger, 0);
    }

    public BigDecimal(BigInteger bigInteger, int n) throws NumberFormatException {
        if (n < 0) {
            throw new NumberFormatException("scale of " + n + " is < 0");
        }
        this.intVal = bigInteger;
        this.scale = n;
    }

    public BigDecimal(double d) throws NumberFormatException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException("invalid argument: " + d);
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & 0xFFFFFFFFFFFFFL;
        long l3 = l >>> 52 & 0x7FFL;
        int n = 0;
        if (l3 == 0L) {
            n = 1;
        }
        int n2 = n;
        l3 -= (long)(1023 - n2);
        l3 -= 52L;
        if (n2 == 0) {
            l2 |= 0x10000000000000L;
        }
        while (l3 < 0L && (l2 & 1L) == 0L) {
            ++l3;
            l2 >>= 1;
        }
        this.intVal = BigInteger.valueOf(l < 0L ? -l2 : l2);
        if (l3 < 0L) {
            this.scale = (int)(-l3);
            BigInteger bigInteger = BigInteger.valueOf(5).pow(this.scale);
            this.intVal = this.intVal.multiply(bigInteger);
        } else {
            this.intVal = this.intVal.shiftLeft((int)l3);
            this.scale = 0;
        }
    }

    public BigDecimal(String string) throws NumberFormatException {
        String string2;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        if (string.charAt(0) == '+') {
            ++n2;
            ++n3;
        } else if (string.charAt(0) == '-') {
            ++n2;
            ++n3;
            bl = true;
        }
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '.') {
                if (n4 >= 0) {
                    throw new NumberFormatException("multiple `.'s in number");
                }
                n4 = n3;
            } else {
                if (c == 'e' || c == 'E') break;
                if (Character.digit(c, 10) < 0) {
                    throw new NumberFormatException("unrecognized character: " + c);
                }
            }
            ++n3;
        }
        if (n4 >= 0) {
            string2 = string.substring(n2, n4) + string.substring(n4 + 1, n3);
            this.scale = n3 - 1 - n4;
        } else {
            string2 = string.substring(n2, n3);
            this.scale = 0;
        }
        if (string2.length() == 0) {
            throw new NumberFormatException("no digits seen");
        }
        if (bl) {
            string2 = "-" + string2;
        }
        this.intVal = new BigInteger(string2);
        if (n3 < n) {
            if (string.charAt(++n3) == '+') {
                ++n3;
            }
            if (n3 >= n) {
                throw new NumberFormatException("no exponent following e or E");
            }
            try {
                int n5 = Integer.parseInt(string.substring(n3));
                n5 -= this.scale;
                if (this.signum() == 0) {
                    this.scale = 0;
                } else if (n5 > 0) {
                    this.intVal = this.intVal.multiply(BigInteger.valueOf(10L).pow(n5));
                    this.scale = 0;
                } else {
                    this.scale = -n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("malformed exponent");
            }
        }
    }
}

