/*!
 * rspamd-D3Pie 1.1.2 (https://github.com/moisseev/rspamd-D3Pie)
 * Copyright (c) 2022, Alexander Moisseev, BSD 2-Clause
 */
function D3Pie(t,e){"use strict";if("string"!=typeof t||0===t.length)throw new Error("D3Pie: id must be a non-empty string");if(!/^[a-zA-Z_-][\w-]*$/u.test(t))throw new Error('D3Pie: id must start with a letter, underscore, or hyphen, and contain only alphanumeric characters, hyphens (-), and underscores (_). Got: "'+t+'"');const n=$.extend(!0,{canvasPadding:5,cornerRadius:3,duration:1250,gradient:{enabled:!0,percentage:100},labels:{inner:{hideWhenLessThanPercentage:4,offset:.15},outer:{collideHeight:13,format:"label",pieDistance:30}},padAngle:.01,pieCenterOffset:{x:0,y:0},size:{canvasHeight:400,canvasWidth:600,pieInnerRadius:"20%",pieOuterRadius:"85%"},title:"",total:{enabled:!1}},e),a=[];function l(t){const e=t.split(".");let a=n;for(const t of e)a=a[t];return a}function r(t,e){const n=l(t),r=parseFloat(n);isFinite(r)?void 0!==e.min&&r<e.min?a.push(t+" must be >= "+e.min+", got: "+r):void 0!==e.max&&r>e.max&&a.push(t+" must be <= "+e.max+", got: "+r):a.push(t+" must be a finite number, got: "+n)}function i(t){const e=l(t);if("number"==typeof e)(!isFinite(e)||e<0)&&a.push(t+" must be a non-negative number, got: "+e);else if("string"==typeof e){const n=/^(?<pct>\d+)%$/u.exec(e);if(n){const e=parseInt(n.groups.pct,10);e>99&&a.push(t+" percentage must be 0-99, got: "+e+"%")}else a.push(t+' must be a number or percentage string (e.g. "85%"), got: '+e)}else a.push(t+" must be a number or percentage string, got: "+typeof e)}if(r("canvasPadding",{min:0}),r("cornerRadius",{min:0}),r("duration",{min:0}),r("gradient.percentage",{min:0,max:100}),r("labels.inner.hideWhenLessThanPercentage",{min:0,max:100}),r("labels.inner.offset",{min:-1,max:1}),r("labels.outer.collideHeight",{min:1}),r("labels.outer.pieDistance",{min:0}),r("padAngle",{min:0,max:2*Math.PI}),r("pieCenterOffset.x",{}),r("pieCenterOffset.y",{}),r("size.canvasHeight",{min:50}),r("size.canvasWidth",{min:50}),i("size.pieOuterRadius"),i("size.pieInnerRadius"),function(t,e){const n=l(t);if(!e.includes(n)){const l=e.map(t=>'"'+t+'"').join(", ");a.push(t+" must be one of ["+l+'], got: "'+n+'"')}}("labels.outer.format",["none","label"]),a.length>0)throw new Error("D3Pie configuration errors:\n  - "+a.join("\n  - "));this.destroy=function(){d3.select("#"+t).selectAll("*").on("click",null).on("mousemove",null).on("mouseover",null).on("mouseout",null),d3.selectAll("#"+t+" svg, #"+t+"-tooltip").remove()},this.destroy();const s=d3.select("#"+t).append("svg").attr("class","d3pie").attr("width",n.size.canvasWidth).attr("height",n.size.canvasHeight);let o=0;if(""!==n.title){const t=s.append("svg:text").attr("class","chart-title").attr("x",n.size.canvasWidth/2);t.append("tspan").text(n.title+" "),o=t.node().getBBox().height,t.attr("y",o+n.canvasPadding)}const c=s.append("g").attr("transform","translate("+(n.size.canvasWidth/2+n.pieCenterOffset.x)+","+(n.size.canvasHeight/2+o/2+n.pieCenterOffset.y)+")"),d={},u={},{outerRadius:p,innerRadius:f}=function(){function t(t,e){if(!/%/u.test(t))return parseInt(t,10);const n=Math.max(0,Math.min(99,parseInt(t.replace(/[\D]/u,""),10)))/100;return Math.floor(e*n)}const e=n.size.canvasWidth-2*n.canvasPadding,a=n.size.canvasHeight-2*n.canvasPadding-o;let l=Math.min(e,a)/2;if("none"!==n.labels.outer.format){const t=parseInt(n.labels.outer.pieDistance,10);l>t&&(l-=t)}const r=t(n.size.pieOuterRadius,l);return{outerRadius:r,innerRadius:t(n.size.pieInnerRadius,r)}}(),g=p+n.labels.outer.pieDistance,h=d3.line().curve(d3.curveCatmullRomOpen),b=d3.select("body").append("div").attr("id",t+"-tooltip").attr("class","d3pie-tooltip"),m=b.append("span").attr("id",t+"-tooltip-text");function v(t){t.on("mouseover",function(t,e){const n=b.datum().total,a=n?Math.round(100*e.data.value/n):NaN;e.data.value?(b.transition().duration(300).style("opacity",1),m.text(e.data.label+(n?": "+e.data.value+" ("+a+"%)":""))):b.transition().duration(300).style("opacity",0),b.each(function(t){t.height=this.getBoundingClientRect().height})}).on("mouseout",function(){b.transition().duration(300).style("opacity",0)}).on("mousemove",t=>{const{pageX:e,pageY:n}=t;b.style("left",e+"px").style("top",function(t){return n-t.height-2+"px"})})}const x=c.append("g"),y=c.append("g");if(v(y),y.append("circle").attr("r",f).style("opacity",0),n.total.enabled){const t=y.append("text").attr("class","total-text");t.append("tspan").attr("class","total-value").style("font-size",.6*f+"px"),t.append("tspan").attr("x","0").attr("dy",.5*f).text(void 0!==n.total.label?n.total.label:"Total")}const A=s.append("defs");if(f>0){const e=A.append("mask").attr("id",t+"-donut-mask");e.append("rect").attr("x",-n.size.canvasWidth).attr("y",-n.size.canvasHeight).attr("width",2*n.size.canvasWidth).attr("height",2*n.size.canvasHeight).attr("fill","white"),e.append("circle").attr("r",f).attr("fill","black"),x.attr("mask","url(#"+t+"-donut-mask)")}this.data=function(e){let a=$.extend(!0,[],e);const l=new Set;for(let t=0;t<a.length;t+=1){const e=a[t];if(!e||"string"!=typeof e.label||""===e.label)throw new Error("D3Pie: data["+t+"] must have a non-empty string 'label' property");if(l.has(e.label))throw new Error('D3Pie: duplicate label "'+e.label+'" found. All labels must be unique.');l.add(e.label)}const r=[],i=a.reduce(function(t,e){return t+(e.value||0)},0);b.datum({total:i}),y.datum({data:{label:void 0!==n.total.label?n.total.label:"Total",value:i}}),n.total.enabled&&y.select(".total-value").text(d3.format(".3~s")(i)),a.unshift({label:"undefined",color:n.gradient.enabled?"steelblue":"#ecf1f5",value:0===i?1:0});const s=d3.scaleOrdinal(d3.schemeSet1);function o(t,e){return void 0!==t&&void 0!==t.color?t.color:s(e)}function c(t,e,n=e){return d3.arc().innerRadius(e).outerRadius(n).centroid(t)}function m(t){return d3.interpolate(d[t.data.label],t)}function w(t){const e=g-.1;return Math.max(-e,Math.min(e,t))}const z=d3.transition().duration(n.duration);if(n.gradient.enabled){const e=A.selectAll("radialGradient").data(a,function(t){return t.label}).enter().append("radialGradient").attr("gradientUnits","userSpaceOnUse").attr("cx",0).attr("cy",0).attr("r","120%").attr("id",function(e,n){return t+"-grad"+n});e.append("stop").attr("class","grad-stop-0").style("stop-color",function(t,e){return o(t,e)}),e.append("stop").attr("class","grad-stop-1").attr("offset",n.gradient.percentage+"%"),A.selectAll("radialGradient").select(".grad-stop-0").transition(z).style("stop-color",function(t,e){return o(t,e)})}function P(t){return t.data.label}const R=d3.pie().sort(null).value(function(t){return t.value}),M=x.selectAll(".slice-g").data(R(a),P),D=M.enter().append("g").attr("class","slice-g");if(v(D),D.append("path").attr("id",function(e,n){return t+"-slice"+n}).attr("class","slice").attr("fill",function(e,a){return n.gradient.enabled?"url(#"+t+"-grad"+a+")":o(e.data,a)}),M.exit().each(function(t){const e=a.find(function(e){return e.label===t.data.label});e&&(e.value=0)}),R(a).forEach(function(t,e){if(void 0===d[t.data.label]){const n=e?d[R(a)[e-1].data.label].endAngle:0;d[t.data.label]={startAngle:n,endAngle:n}}}),x.selectAll(".slice").data(R(a),P).transition(z).attrTween("d",function(t){return function(e){return d3.arc().padAngle(n.padAngle).cornerRadius(n.cornerRadius).innerRadius(f).outerRadius(p)(m(t)(e))}}).end().then(function(){a=a.filter(function(t,e){return 0===e||t.value}),A.selectAll("radialGradient").data(a,function(t){return t.label}).exit().remove(),x.selectAll(".slice-g").data(R(a),P).exit().each(function(t){delete d[t.data.label],delete u[t.data.label]}).remove();for(const t of R(a))d[t.data.label]=t,"none"!==n.labels.outer.format&&(u[t.data.label].currentAngle=u[t.data.label].newAngle);x.selectAll(".slice-g").classed("first-slice",!1);const t=x.select(".slice-g");t.empty()||t.classed("first-slice",!0)}).catch(t=>{t&&"object"==typeof t&&"startAngle"in t&&"endAngle"in t||console.error("D3Pie error:",t)}),D.append("text").attr("class","inner-label").attr("dy",".35em"),x.selectAll(".inner-label").data(R(a),P).text(function(t){return"undefined"===t.data.label?"undefined":Math.round(100*t.data.value/i)+"%"}).transition(z).attrTween("opacity",function(t){return t.data.value?function(e){const a=m(t)(e);return 100*(a.endAngle-a.startAngle)/(2*Math.PI)<n.labels.inner.hideWhenLessThanPercentage?0:1}:function(){return 0}}).attrTween("transform",function(t){return function(e){return"translate("+c(m(t)(e),f*(1-n.labels.inner.offset),p*(1+n.labels.inner.offset))+")"}}),"none"!==n.labels.outer.format){R(a).forEach(function(t,e){if(void 0===u[t.data.label]){const n=e?d[R(a)[e-1].data.label].endAngle:0;u[t.data.label]={currentAngle:{startAngle:n,endAngle:n},newAngle:{startAngle:n,endAngle:n}}}let l=0;const[i,s]=c(t,g);t.data.value&&(l=i>=0?n.labels.outer.collideHeight:-n.labels.outer.collideHeight),r.push({fx:l,y:s})}),d3.forceSimulation(r).alphaMin(.5).force("collide",d3.forceCollide(n.labels.outer.collideHeight/2)).force("boundY",function(){for(const t of r)t.y=w(t.y)}).tick(30);const t=D.append("g").attr("class","outer-label-g");t.append("text").attr("class","outer-label").attr("dy",".35em").text(P),t.append("path").attr("class","link"),x.selectAll(".outer-label-g").data(R(a),P).transition(z).style("opacity",function(t,e){return e&&t.value?1:0}).each(function(t,e){$(this).children(".link").attr("stroke",o(t.data,e))}),x.selectAll(".outer-label").data(R(a),P).transition(z).attrTween("transform",function(t,e){u[t.data.label].newAngle=function(){const n=w(r[e].y);let a=Math.sqrt(Math.pow(g,2)-Math.pow(n,2));(t.endAngle+t.startAngle)/2>Math.PI&&(a*=-1);let l=Math.PI/2-Math.atan2(-n,a);return l<0&&(l+=2*Math.PI),{startAngle:l,endAngle:l}}();const n=d3.interpolate(u[t.data.label].currentAngle,u[t.data.label].newAngle);return function(a){const l=c(n(a),g),[r,i]=l,s=r>0?{dx:5,textAnchor:"start"}:{dx:-5,textAnchor:"end"};return d3.select(x.selectAll(".link").nodes()[e]).datum([c(m(t)(a),p),c(m(t)(a),p+5),[r,i],[r+s.dx,i]]).attr("d",h),d3.select(x.selectAll(".outer-label").nodes()[e]).attr("dx",s.dx).style("text-anchor",s.textAnchor),"translate("+l+")"}})}}}