/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.MacException;
import gnu.javax.net.ssl.provider.OverflowException;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SecurityParameters;
import gnu.javax.net.ssl.provider.Session;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.net.ssl.SSLException;

class GNUSecurityParameters
implements SecurityParameters {
    private static final boolean DEBUG_RECORD_LAYER = false;
    private static final PrintWriter debug = new PrintWriter(System.err, true);
    IMode inCipher;
    IMode outCipher;
    IRandom inRandom;
    IRandom outRandom;
    IMac inMac;
    IMac outMac;
    long inSequence = 0L;
    long outSequence = 0L;
    Session session;
    ProtocolVersion version;
    int fragmentLength;
    private Inflater inflater;
    private Deflater deflater;

    public void reset() {
        this.inSequence = 0L;
        this.outSequence = 0L;
        this.inCipher = null;
        this.outCipher = null;
        this.inMac = null;
        this.outMac = null;
        this.inRandom = null;
        this.outRandom = null;
        this.deflater = null;
        this.inflater = null;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void setVersion(ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
    }

    public void setInCipher(Object object) {
        if (object instanceof IMode) {
            this.inCipher = (IMode)object;
            this.inRandom = null;
        } else {
            this.inRandom = (IRandom)object;
            this.inCipher = null;
        }
    }

    public void setOutCipher(Object object) {
        if (object instanceof IMode) {
            this.outCipher = (IMode)object;
            this.outRandom = null;
        } else {
            this.outRandom = (IRandom)object;
            this.outCipher = null;
        }
    }

    public void setInMac(Object object) {
        this.inMac = (IMac)object;
        this.inSequence = 0L;
    }

    public void setOutMac(Object object) {
        this.outMac = (IMac)object;
        this.outSequence = 0L;
    }

    public void setDeflating(boolean bl) {
        if (bl) {
            if (this.deflater == null) {
                this.deflater = new Deflater();
            }
        } else {
            this.deflater = null;
        }
    }

    public void setInflating(boolean bl) {
        if (bl) {
            if (this.inflater == null) {
                this.inflater = new Inflater();
            }
        } else {
            this.inflater = null;
        }
    }

    public int getFragmentLength() {
        return this.fragmentLength;
    }

    public void setFragmentLength(int n) {
        this.fragmentLength = n;
    }

    public synchronized byte[] decrypt(byte[] byArray, ProtocolVersion protocolVersion, ContentType contentType) throws MacException, OverflowException, SSLException {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        if (this.inCipher != null) {
            n4 = this.inCipher.currentBlockSize();
            n3 = 0;
            while (n3 < byArray.length) {
                this.inCipher.update(byArray, n3, byArray, n3);
                n3 += n4;
            }
            n3 = byArray[byArray.length - 1] & 0xFF;
            n2 = byArray.length - n3 - 1;
            if (protocolVersion == ProtocolVersion.SSL_3) {
                if (n3 >= n4) {
                    bl = true;
                }
            } else {
                n = n2;
                while (n < byArray.length) {
                    if ((byArray[n] & 0xFF) != n3) {
                        bl = true;
                    }
                    ++n;
                }
            }
            byArray = Util.trim(byArray, n2);
        } else if (this.inRandom != null) {
            GNUSecurityParameters.transformRC4(byArray, 0, byArray.length, byArray, 0, this.inRandom);
        }
        if (this.inMac != null) {
            this.inMac.update((byte)(this.inSequence >>> 56));
            this.inMac.update((byte)(this.inSequence >>> 48));
            this.inMac.update((byte)(this.inSequence >>> 40));
            this.inMac.update((byte)(this.inSequence >>> 32));
            this.inMac.update((byte)(this.inSequence >>> 24));
            this.inMac.update((byte)(this.inSequence >>> 16));
            this.inMac.update((byte)(this.inSequence >>> 8));
            this.inMac.update((byte)this.inSequence);
            this.inMac.update((byte)contentType.getValue());
            if (protocolVersion != ProtocolVersion.SSL_3) {
                this.inMac.update((byte)protocolVersion.getMajor());
                this.inMac.update((byte)protocolVersion.getMinor());
            }
            n4 = this.inMac.macSize();
            n3 = byArray.length - n4;
            this.inMac.update((byte)(n3 >>> 8));
            this.inMac.update((byte)n3);
            this.inMac.update(byArray, 0, n3);
            byte[] byArray2 = this.inMac.digest();
            this.inMac.reset();
            n = 0;
            while (n < n4) {
                if (byArray[n + n3] != byArray2[n]) {
                    throw new MacException();
                }
                ++n;
            }
            if (bl) {
                throw new MacException();
            }
            byArray = Util.trim(byArray, n3);
        }
        if (this.inflater != null) {
            byte[] byArray3 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length << 1);
            this.inflater.setInput(byArray);
            try {
                while ((n2 = this.inflater.inflate(byArray3)) > 0) {
                    byteArrayOutputStream.write(byArray3, 0, n2);
                    if (byteArrayOutputStream.size() <= this.fragmentLength + 1024) continue;
                    throw new OverflowException("inflated data too large");
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new SSLException(String.valueOf(dataFormatException));
            }
            byArray = byteArrayOutputStream.toByteArray();
            this.inflater.reset();
        }
        ++this.inSequence;
        return byArray;
    }

    public synchronized byte[] encrypt(byte[] byArray, int n, int n2, ContentType contentType) throws SSLException, OverflowException {
        int n3;
        Object object;
        byte[] byArray2;
        if (this.deflater != null) {
            byArray2 = new byte[1024];
            object = new ByteArrayOutputStream(n2 >>> 1);
            this.deflater.setInput(byArray, n, n2);
            this.deflater.finish();
            n2 = 0;
            while ((n2 = this.deflater.deflate(byArray2)) > 0) {
                ((ByteArrayOutputStream)object).write(byArray2, 0, n2);
            }
            if (((ByteArrayOutputStream)object).size() > this.fragmentLength + 1024) {
                throw new OverflowException("deflated data too large");
            }
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            n = 0;
            n2 = byArray.length;
            this.deflater.reset();
        }
        byArray2 = new byte[]{};
        if (this.outMac != null) {
            this.outMac.update((byte)(this.outSequence >>> 56));
            this.outMac.update((byte)(this.outSequence >>> 48));
            this.outMac.update((byte)(this.outSequence >>> 40));
            this.outMac.update((byte)(this.outSequence >>> 32));
            this.outMac.update((byte)(this.outSequence >>> 24));
            this.outMac.update((byte)(this.outSequence >>> 16));
            this.outMac.update((byte)(this.outSequence >>> 8));
            this.outMac.update((byte)this.outSequence);
            this.outMac.update((byte)contentType.getValue());
            if (this.version != ProtocolVersion.SSL_3) {
                this.outMac.update((byte)this.version.getMajor());
                this.outMac.update((byte)this.version.getMinor());
            }
            this.outMac.update((byte)(n2 >>> 8));
            this.outMac.update((byte)n2);
            this.outMac.update(byArray, n, n2);
            byArray2 = this.outMac.digest();
            this.outMac.reset();
        }
        ++this.outSequence;
        object = new byte[0];
        if (this.outCipher != null) {
            n3 = this.outCipher.currentBlockSize() - (n2 + byArray2.length + 1) % this.outCipher.currentBlockSize();
            if (this.version != ProtocolVersion.SSL_3 && this.session.random != null) {
                n3 += (Math.abs(this.session.random.nextInt()) & 7) * this.outCipher.currentBlockSize();
                while (n3 > 255) {
                    n3 -= this.outCipher.currentBlockSize();
                }
            }
            object = new byte[n3 + 1];
            Arrays.fill((byte[])object, (byte)n3);
        }
        n3 = n2 + byArray2.length + ((Object)object).length;
        if (this.outCipher != null) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
            System.arraycopy(object, 0, byArray3, n2 + byArray2.length, ((Object)object).length);
            int n4 = this.outCipher.currentBlockSize();
            int n5 = 0;
            while (n5 < n3) {
                this.outCipher.update(byArray3, n5, byArray3, n5);
                n5 += n4;
            }
            return byArray3;
        }
        if (this.outRandom != null) {
            byte[] byArray4 = new byte[n3];
            GNUSecurityParameters.transformRC4(byArray, n, n2, byArray4, 0, this.outRandom);
            GNUSecurityParameters.transformRC4(byArray2, 0, byArray2.length, byArray4, n2, this.outRandom);
            return byArray4;
        }
        if (byArray2.length == 0) {
            return Util.trim(byArray, n, n2);
        }
        return Util.concat(Util.trim(byArray, n, n2), byArray2);
    }

    private static final void transformRC4(byte[] byArray, int n, int n2, byte[] byArray2, int n3, IRandom iRandom) {
        if (iRandom == null) {
            throw new IllegalStateException();
        }
        if (byArray == null || byArray2 == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n + n2 > byArray.length || n3 < 0 || n3 + n2 > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            int n4 = 0;
            while (n4 < n2) {
                byArray2[n3 + n4] = (byte)(byArray[n + n4] ^ iRandom.nextByte());
                ++n4;
            }
        }
        catch (LimitReachedException limitReachedException) {
            throw new Error(limitReachedException.toString());
        }
    }

    GNUSecurityParameters(Session session) {
        this.session = session;
        this.fragmentLength = 16384;
    }
}

