/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Currency
implements Serializable {
    static final long serialVersionUID = -158308464356906721L;
    private static transient Properties properties;
    private static transient Map countryMap;
    private static transient Map cache;
    private String currencyCode;
    private transient int fractionDigits;
    static /* synthetic */ Class class$java$util$Currency;

    public final String getCurrencyCode() {
        return this.currencyCode;
    }

    public final int getDefaultFractionDigits() {
        return this.fractionDigits;
    }

    public static final Currency getInstance(Locale locale) {
        Currency currency;
        String string = locale.getCountry();
        if (locale == null || string == null) {
            throw new NullPointerException("The locale or its country is null.");
        }
        String string2 = (String)countryMap.get(string);
        if (string2 == null) {
            currency = new Currency(locale);
            string2 = currency.getCurrencyCode();
            if (string2 == null) {
                return null;
            }
            countryMap.put(string, string2);
            cache.put(string2, currency);
        } else {
            currency = (Currency)cache.get(string2);
        }
        return currency;
    }

    public static final Currency getInstance(String string) {
        if (string == null) {
            throw new NullPointerException("The supplied currency code is null.");
        }
        if (string.equals("XXX")) {
            return new Currency("XXX");
        }
        Currency currency = (Currency)cache.get(string);
        if (currency == null) {
            Locale[] localeArray = Locale.getAvailableLocales();
            int n = 0;
            while (n < localeArray.length) {
                try {
                    Currency currency2 = Currency.getInstance(localeArray[n]);
                    if (currency2 != null && currency2.getCurrencyCode().equals(string)) {
                        return currency2;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n;
            }
            throw new IllegalArgumentException("The currency code, " + string + ", is not supported.");
        }
        return currency;
    }

    public final String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public final String getSymbol(Locale locale) {
        return LocaleHelper.getLocalizedString(locale, this.currencyCode, "currenciesSymbol", false, true);
    }

    public final String toString() {
        return this.getCurrencyCode();
    }

    private final Object readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.currencyCode);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Currency() {
    }

    private Currency(Locale locale) {
        String string = locale.getCountry();
        if (string.equals("")) {
            throw new IllegalArgumentException("Invalid (empty) country code for locale:" + locale);
        }
        String string2 = string + ".currency";
        String string3 = string + ".fractionDigits";
        this.currencyCode = properties.getProperty(string2);
        if (this.currencyCode == null) {
            return;
        }
        int n = this.currencyCode.indexOf(",");
        if (n != -1) {
            this.currencyCode = this.currencyCode.substring(0, n);
        }
        this.fractionDigits = Integer.parseInt(properties.getProperty(string3));
    }

    private Currency(String string) {
        this.currencyCode = string;
        this.fractionDigits = -1;
    }

    static {
        countryMap = new HashMap();
        cache = new HashMap();
        properties = new Properties();
        try {
            Class clazz = class$java$util$Currency;
            if (clazz == null) {
                clazz = class$java$util$Currency = Currency.class("[Ljava.util.Currency;", false);
            }
            properties.load(clazz.getResourceAsStream("iso4217.properties"));
        }
        catch (IOException iOException) {
            System.out.println("Failed to load currency resource: " + iOException);
        }
    }
}

