/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.CDR.gnuValueStream;
import gnu.CORBA.GIOP.CharSets_OSF;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Adler32;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ULongSeqHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IOR {
    public static final int FAILED = 10;
    public Internet_profile Internet;
    public String Id;
    public byte[] key;
    ArrayList profiles;
    public boolean Big_Endian;

    public static IOR parse(String string) throws BAD_PARAM {
        try {
            if (!string.startsWith("IOR:")) {
                throw new BAD_PARAM("The string refernce must start with IOR:", 10, CompletionStatus.COMPLETED_NO);
            }
            IOR iOR = new IOR();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string2 = string;
            string2 = string2.substring(string2.indexOf(":") + 1);
            int n = 0;
            while (n < string2.length()) {
                char c = (char)Integer.parseInt(string2.substring(n, n + 2), 16);
                byteArrayOutputStream.write(c);
                n += 2;
            }
            BufferredCdrInput bufferredCdrInput = new BufferredCdrInput(byteArrayOutputStream.toByteArray());
            iOR._read(bufferredCdrInput);
            return iOR;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BAD_PARAM(exception + " while parsing " + string, 10, CompletionStatus.COMPLETED_NO);
        }
    }

    public void _read(AbstractCdrInput abstractCdrInput) throws IOException, BAD_PARAM {
        int n = abstractCdrInput.read_long();
        if (n != 0) {
            this.Big_Endian = false;
            abstractCdrInput.setBigEndian(false);
        }
        this._read_no_endian(abstractCdrInput);
    }

    public void _read_no_endian(AbstractCdrInput abstractCdrInput) throws IOException, BAD_PARAM {
        this.Id = abstractCdrInput.read_string();
        int n = abstractCdrInput.read_long();
        if (n == 0) {
            this.Id = null;
            this.Internet = null;
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = abstractCdrInput.read_long();
            BufferredCdrInput bufferredCdrInput = abstractCdrInput.read_encapsulation();
            if (n3 == 0) {
                this.Internet = new Internet_profile();
                this.Internet.version = Version.read_version(bufferredCdrInput);
                this.Internet.host = bufferredCdrInput.read_string();
                this.Internet.port = bufferredCdrInput.gnu_read_ushort();
                this.key = bufferredCdrInput.read_sequence();
                int n4 = 0;
                try {
                    if (this.Internet.version.since_inclusive(1, 1)) {
                        n4 = bufferredCdrInput.read_long();
                    }
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = bufferredCdrInput.read_long();
                        if (n6 == 1) {
                            this.Internet.CodeSets.read(bufferredCdrInput);
                        } else {
                            TaggedComponent taggedComponent = new TaggedComponent();
                            taggedComponent.tag = n6;
                            taggedComponent.component_data = bufferredCdrInput.read_sequence();
                            this.Internet.components.add(taggedComponent);
                        }
                        ++n5;
                    }
                }
                catch (Unexpected unexpected) {
                    unexpected.printStackTrace();
                }
            } else {
                TaggedProfile taggedProfile = new TaggedProfile();
                taggedProfile.tag = n3;
                taggedProfile.profile_data = bufferredCdrInput.buffer.getBuffer();
                this.profiles.add(taggedProfile);
            }
            ++n2;
        }
    }

    public void _write(AbstractCdrOutput abstractCdrOutput) {
        abstractCdrOutput.write(0);
        this._write_no_endian(abstractCdrOutput);
    }

    public static void write_null(AbstractCdrOutput abstractCdrOutput) {
        abstractCdrOutput.write_string("");
        abstractCdrOutput.write_long(0);
    }

    public void _write_no_endian(AbstractCdrOutput abstractCdrOutput) {
        abstractCdrOutput.write_string(this.Id);
        abstractCdrOutput.write_long(1 + this.profiles.size());
        abstractCdrOutput.write_long(0);
        this.Internet.write(abstractCdrOutput);
        int n = 0;
        while (n < this.profiles.size()) {
            TaggedProfile taggedProfile = (TaggedProfile)this.profiles.get(n);
            TaggedProfileHelper.write(abstractCdrOutput, taggedProfile);
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.Id);
        stringBuffer.append(" at ");
        stringBuffer.append(this.Internet);
        if (!this.Big_Endian) {
            stringBuffer.append(" (Little endian) ");
        }
        stringBuffer.append(" Key ");
        int n = 0;
        while (n < this.key.length) {
            stringBuffer.append(Integer.toHexString(this.key[n] & 0xFF));
            ++n;
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.Internet.CodeSets);
        return stringBuffer.toString();
    }

    public String toStringFormatted() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nObject Id:\n  ");
        stringBuffer.append(this.Id);
        stringBuffer.append("\nObject is accessible at:\n  ");
        stringBuffer.append(this.Internet);
        if (this.Big_Endian) {
            stringBuffer.append("\n  Big endian encoding");
        } else {
            stringBuffer.append("\n  Little endian encoding.");
        }
        stringBuffer.append("\nObject Key\n  ");
        int n = 0;
        while (n < this.key.length) {
            stringBuffer.append(Integer.toHexString(this.key[n] & 0xFF));
            ++n;
        }
        stringBuffer.append("\nSupported code sets:");
        stringBuffer.append("\n Wide:");
        stringBuffer.append(this.Internet.CodeSets.wide.toStringFormatted());
        stringBuffer.append(" Narrow:");
        stringBuffer.append(this.Internet.CodeSets.wide.toStringFormatted());
        return stringBuffer.toString();
    }

    public String toStringifiedReference() {
        BufferedCdrOutput bufferedCdrOutput = new BufferedCdrOutput();
        this._write(bufferedCdrOutput);
        StringBuffer stringBuffer = new StringBuffer("IOR:");
        byte[] byArray = bufferedCdrOutput.buffer.toByteArray();
        int n = 0;
        while (n < byArray.length) {
            String string = Integer.toHexString(byArray[n] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void add_ior_component(TaggedComponent taggedComponent) {
        this.Internet.components.add(taggedComponent);
        int n = 0;
        while (n < this.profiles.size()) {
            TaggedProfile taggedProfile = (TaggedProfile)this.profiles.get(n);
            IOR.addComponentTo(taggedProfile, taggedComponent);
            ++n;
        }
    }

    public void add_ior_component_to_profile(TaggedComponent taggedComponent, int n) {
        if (n == 0) {
            this.Internet.components.add(taggedComponent);
        } else {
            int n2 = 0;
            while (n2 < this.profiles.size()) {
                TaggedProfile taggedProfile = (TaggedProfile)this.profiles.get(n2);
                if (taggedProfile.tag == n) {
                    IOR.addComponentTo(taggedProfile, taggedComponent);
                }
                ++n2;
            }
        }
    }

    private static final void addComponentTo(TaggedProfile taggedProfile, TaggedComponent taggedComponent) {
        gnuValueStream gnuValueStream2;
        if (taggedProfile.tag == 1) {
            int n;
            TaggedComponent[] taggedComponentArray;
            if (taggedProfile.profile_data.length > 0) {
                gnuValueStream2 = new BufferredCdrInput(taggedProfile.profile_data);
                taggedComponentArray = new TaggedComponent[((AbstractCdrInput)((Object)gnuValueStream2)).read_long()];
                n = 0;
                while (n < taggedComponentArray.length) {
                    taggedComponentArray[n] = TaggedComponentHelper.read((InputStream)((Object)gnuValueStream2));
                    ++n;
                }
            } else {
                taggedComponentArray = new TaggedComponent[]{};
            }
            gnuValueStream2 = new BufferedCdrOutput(taggedProfile.profile_data.length + taggedComponent.component_data.length + 8);
            ((AbstractCdrOutput)((Object)gnuValueStream2)).write_long(taggedComponentArray.length + 1);
            n = 0;
            while (n < taggedComponentArray.length) {
                TaggedComponentHelper.write((org.omg.CORBA.portable.OutputStream)((Object)gnuValueStream2), taggedComponentArray[n]);
                ++n;
            }
            TaggedComponentHelper.write((org.omg.CORBA.portable.OutputStream)((Object)gnuValueStream2), taggedComponent);
            try {
                ((OutputStream)((Object)gnuValueStream2)).close();
            }
            catch (IOException iOException) {
                throw new Unexpected(iOException);
            }
        } else {
            throw new BAD_PARAM("Unsupported profile type " + taggedProfile.tag);
        }
        taggedProfile.profile_data = ((BufferedCdrOutput)gnuValueStream2).buffer.toByteArray();
    }

    public boolean equals(Object object) {
        if (object instanceof IOR) {
            boolean bl;
            boolean bl2 = true;
            IOR iOR = (IOR)object;
            if (this.Internet == null || iOR.Internet == null) {
                boolean bl3 = false;
                if (this.Internet == iOR.Internet) {
                    bl3 = true;
                }
                return bl3;
            }
            if (this.key != null && iOR.key != null) {
                bl = Arrays.equals(this.key, iOR.key);
            } else {
                boolean bl4 = false;
                if (this.key == iOR.key) {
                    bl4 = bl = true;
                }
            }
            if (this.Internet != null && this.Internet.host != null && iOR.Internet != null && iOR.Internet.host != null) {
                bl2 = iOR.Internet.host.equals(this.Internet.host);
            }
            boolean bl5 = false;
            if (bl & bl2 && this.Internet.port == iOR.Internet.port) {
                bl5 = true;
            }
            return bl5;
        }
        return false;
    }

    public int hashCode() {
        Adler32 adler32 = new Adler32();
        if (this.key != null) {
            adler32.update(this.key);
        }
        if (this.Internet != null) {
            if (this.Internet.host != null) {
                adler32.update(this.Internet.host.getBytes());
            }
            adler32.update(this.Internet.port);
        }
        return (int)adler32.getValue();
    }

    private final /* synthetic */ void this() {
        this.Internet = new Internet_profile();
        this.profiles = new ArrayList();
        this.Big_Endian = true;
    }

    public IOR() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Internet_profile {
        public static final int TAG_INTERNET_IOP = 0;
        public String host;
        public Version version;
        public int port;
        public CodeSets_profile CodeSets;
        ArrayList components;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.host);
            stringBuffer.append(":");
            stringBuffer.append(this.port);
            stringBuffer.append(" (v");
            stringBuffer.append(this.version);
            stringBuffer.append(")");
            if (this.components.size() > 0) {
                stringBuffer.append(" " + this.components.size() + " extra components.");
            }
            return stringBuffer.toString();
        }

        public void write(AbstractCdrOutput abstractCdrOutput) {
            try {
                AbstractCdrOutput abstractCdrOutput2 = abstractCdrOutput.createEncapsulation();
                this.version.write(abstractCdrOutput2);
                abstractCdrOutput2.write_string(this.host);
                abstractCdrOutput2.write_ushort((short)(this.port & (char)-1));
                abstractCdrOutput2.write_long(IOR.this.key.length);
                abstractCdrOutput2.write(IOR.this.key);
                abstractCdrOutput2.write_long(1 + this.components.size());
                abstractCdrOutput2.write_long(1);
                this.CodeSets.write(abstractCdrOutput2);
                int n = 0;
                while (n < this.components.size()) {
                    TaggedComponent taggedComponent = (TaggedComponent)this.components.get(n);
                    TaggedComponentHelper.write(abstractCdrOutput2, taggedComponent);
                    ++n;
                }
                abstractCdrOutput2.close();
            }
            catch (Exception exception) {
                MARSHAL mARSHAL = new MARSHAL("Unable to write Internet profile.");
                mARSHAL.minor = 1195573273;
                mARSHAL.initCause(exception);
                throw mARSHAL;
            }
        }

        private final /* synthetic */ void this() {
            this.version = new Version(1, 2);
            this.CodeSets = new CodeSets_profile();
            this.components = new ArrayList();
        }

        public Internet_profile() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class CodeSets_profile {
        public static final int TAG_CODE_SETS = 1;
        public CodeSet_component narrow;
        public CodeSet_component wide;
        public CodeSetServiceContext negotiated;

        public void read(AbstractCdrInput abstractCdrInput) {
            BufferredCdrInput bufferredCdrInput = abstractCdrInput.read_encapsulation();
            this.narrow.read(bufferredCdrInput);
            this.wide.read(bufferredCdrInput);
        }

        public String toString() {
            return "Narrow char: " + this.narrow + ", Wide char: " + this.wide;
        }

        public void write(AbstractCdrOutput abstractCdrOutput) {
            AbstractCdrOutput abstractCdrOutput2 = abstractCdrOutput.createEncapsulation();
            this.narrow.write(abstractCdrOutput2);
            this.wide.write(abstractCdrOutput2);
            try {
                abstractCdrOutput2.close();
            }
            catch (IOException iOException) {
                throw new InternalError();
            }
        }

        private final /* synthetic */ void this() {
            this.narrow = new CodeSet_component();
            this.wide = new CodeSet_component();
        }

        public CodeSets_profile() {
            this.this();
            int[] nArray = CharSets_OSF.getSupportedCharSets();
            this.narrow.native_set = 65537;
            this.narrow.conversion = nArray;
            this.wide.native_set = 65801;
            this.wide.conversion = nArray;
        }

        public static class CodeSet_component {
            public int[] conversion;
            public int native_set;

            public void read(InputStream inputStream) {
                this.native_set = inputStream.read_ulong();
                this.conversion = ULongSeqHelper.read(inputStream);
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("native " + this.name(this.native_set));
                if (this.conversion != null && this.conversion.length > 0) {
                    stringBuffer.append(" conversion ");
                    int n = 0;
                    while (n < this.conversion.length) {
                        stringBuffer.append(this.name(this.conversion[n]));
                        stringBuffer.append(' ');
                        ++n;
                    }
                }
                stringBuffer.append(' ');
                return stringBuffer.toString();
            }

            public String toStringFormatted() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\n  Native set " + this.name(this.native_set));
                if (this.conversion != null && this.conversion.length > 0) {
                    stringBuffer.append("\n  Other supported sets:\n    ");
                    int n = 0;
                    while (n < this.conversion.length) {
                        stringBuffer.append(this.name(this.conversion[n]));
                        stringBuffer.append(' ');
                        ++n;
                    }
                }
                stringBuffer.append("\n");
                return stringBuffer.toString();
            }

            public void write(org.omg.CORBA.portable.OutputStream outputStream) {
                outputStream.write_long(this.native_set);
                ULongSeqHelper.write(outputStream, this.conversion);
            }

            private final String name(int n) {
                return "0x" + Integer.toHexString(n) + " (" + CharSets_OSF.getName(n) + ") ";
            }
        }
    }
}

