/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support.low;

import gnu.javax.swing.text.html.parser.support.low.Buffer;
import gnu.javax.swing.text.html.parser.support.low.Location;
import gnu.javax.swing.text.html.parser.support.low.Token;
import gnu.javax.swing.text.html.parser.support.low.node;
import gnu.javax.swing.text.html.parser.support.low.pattern;
import java.util.BitSet;

public class Constants {
    public static final int BEGIN = 60;
    public static final int END = 62;
    public static final int EXCLAMATION = 33;
    public static final int SLASH = 47;
    public static final int EQ = 61;
    public static final int AP = 39;
    public static final int QUOT = 34;
    public static final int DOUBLE_DASH = 1000;
    public static final int STYLE = 1001;
    public static final int SCRIPT = 1002;
    public static final int WS = 1003;
    public static final int ENTITY = 1004;
    public static final int NUMTOKEN = 1005;
    public static final pattern COMMENT_OPEN = new pattern(new node[]{new node(60), new node(1003, true), new node(33), new node(1003, true), new node(1000)});
    public static final pattern COMMENT_END = new pattern(new node[]{new node(1000), new node(1003, true), new node(62)});
    public static final pattern COMMENT_TRIPLEDASH_END = new pattern(new node[]{new node(1000), new node(1005), new node(62)});
    public static final pattern STYLE_OPEN = new pattern(new node[]{new node(60), new node(1003, true), new node(1001)});
    public static final pattern SCRIPT_OPEN = new pattern(new node[]{new node(60), new node(1003, true), new node(1002)});
    public static final pattern SGML = new pattern(new node[]{new node(60), new node(1003, true), new node(33)});
    public static final pattern SCRIPT_CLOSE = new pattern(new node[]{new node(60), new node(1003, true), new node(47), new node(1003, true), new node(1002), new node(1003, true), new node(62)});
    public static final pattern STYLE_CLOSE = new pattern(new node[]{new node(60), new node(1003, true), new node(47), new node(1003, true), new node(1001), new node(1003, true), new node(62)});
    public static final pattern TAG = new pattern(new node[]{new node(60), new node(1003, true), new node(47, true), new node(1003, true), new node(1005)});
    public static final int OTHER = 1999;
    static final char ETX = '\u0003';
    public static final int EOF = 3;
    public static final BitSet bSINGLE_CHAR_TOKEN = new BitSet();
    public static final BitSet bSPECIAL = new BitSet();
    public static final BitSet bLETTER = new BitSet();
    public static final BitSet bDIGIT = new BitSet();
    public static final BitSet bLINEBREAK = new BitSet();
    public static final BitSet bWHITESPACE = new BitSet();
    public static final BitSet bQUOTING = new BitSet();
    public static final BitSet bNAME = new BitSet();
    public static final int ENTITY_NAMED = 1;
    public static final int ENTITY_NUMERIC = 2;

    public Token endMatches(Buffer buffer2) {
        if (buffer2.length() < 2) {
            return null;
        }
        int n = buffer2.length() - 2;
        if (buffer2.length() > 2 && buffer2.charAt(n) == '-' && buffer2.charAt(n - 1) == '-') {
            return new Token(1000, "--", buffer2.getLocation(n - 1, n + 1));
        }
        char c = buffer2.charAt(n);
        if (bSINGLE_CHAR_TOKEN.get(c)) {
            return new Token((int)c, c, buffer2.getLocation(n, n + 1));
        }
        char c2 = buffer2.charAt(n + 1);
        if (bNAME.get(c) && !bNAME.get(c2)) {
            int n2 = n - 1;
            while (n2 >= 0 && bNAME.get(buffer2.charAt(n2))) {
                --n2;
            }
            char[] cArray = new char[n - ++n2 + 1];
            buffer2.getChars(n2, n + 1, cArray, 0);
            String string = new String(cArray);
            if (n2 > 0 && buffer2.charAt(n2 - 1) == '&') {
                return new Token(1004, 1, "&" + string, buffer2.getLocation(n2 - 1, n + 1));
            }
            if (n2 > 1 && buffer2.charAt(n2 - 1) == '#' && buffer2.charAt(n2 - 2) == '&') {
                return new Token(1004, 2, "&#" + string, buffer2.getLocation(n2 - 2, n + 2));
            }
            Location location = buffer2.getLocation(n2, n + 1);
            if (string.equalsIgnoreCase("SCRIPT")) {
                return new Token(1002, string, location);
            }
            if (string.equalsIgnoreCase("STYLE")) {
                return new Token(1001, string, location);
            }
            return new Token(1005, string, location);
        }
        if (bWHITESPACE.get(c) && !bWHITESPACE.get(c2)) {
            int n3 = n - 1;
            while (n3 >= 0 && bWHITESPACE.get(buffer2.charAt(n3))) {
                --n3;
            }
            char[] cArray = new char[n - ++n3 + 1];
            buffer2.getChars(n3, n + 1, cArray, 0);
            return new Token(1003, new String(cArray), buffer2.getLocation(n3, n + 1));
        }
        return null;
    }

    static {
        bQUOTING.set(39);
        bQUOTING.set(34);
        bSINGLE_CHAR_TOKEN.set(60);
        bSINGLE_CHAR_TOKEN.set(62);
        bSINGLE_CHAR_TOKEN.set(33);
        bSINGLE_CHAR_TOKEN.set(47);
        bSINGLE_CHAR_TOKEN.set(61);
        bSINGLE_CHAR_TOKEN.set(3);
        bSINGLE_CHAR_TOKEN.or(bQUOTING);
        bLINEBREAK.set(13);
        bLINEBREAK.set(10);
        bWHITESPACE.set(32);
        bWHITESPACE.set(9);
        bWHITESPACE.set(12);
        bWHITESPACE.or(bLINEBREAK);
        int n = 48;
        while (n <= 57) {
            bDIGIT.set(n);
            n = (char)(n + 1);
        }
        n = 97;
        while (n <= 122) {
            bLETTER.set(n);
            n = (char)(n + 1);
        }
        n = 65;
        while (n <= 90) {
            bLETTER.set(n);
            n = (char)(n + 1);
        }
        bSPECIAL.set(45);
        bSPECIAL.set(95);
        bSPECIAL.set(58);
        bSPECIAL.set(46);
        bNAME.or(bLETTER);
        bNAME.or(bDIGIT);
        bNAME.or(bSPECIAL);
    }
}

