/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.classpath.SystemProperties;
import gnu.java.net.URLParseError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class URL
implements Serializable {
    private static final String DEFAULT_SEARCH_PATH = "gnu.java.net.protocol|gnu.inet";
    private static ClassLoader systemClassLoader;
    private static URLStreamHandlerFactory factory;
    private static final long serialVersionUID = -7627629688361524110L;
    private static HashMap ph_cache;
    private static boolean cache_handlers;
    private String protocol;
    private String authority;
    private String host;
    private String userInfo;
    private int port;
    private String file;
    private String ref;
    private int hashCode;
    transient URLStreamHandler ph;

    public final boolean equals(Object object) {
        if (!(object instanceof URL)) {
            return false;
        }
        return this.ph.equals(this, (URL)object);
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classArray) throws IOException {
        return this.getContent();
    }

    public final String getFile() {
        return this.file == null ? "" : this.file;
    }

    public final String getPath() {
        if (this.file == null) {
            return null;
        }
        int n = this.file.indexOf(63);
        return n < 0 ? this.getFile() : this.file.substring(0, n);
    }

    public final String getAuthority() {
        return this.authority;
    }

    public final String getHost() {
        int n = this.host == null ? -1 : this.host.indexOf(64);
        return n < 0 ? this.host : this.host.substring(n + 1, this.host.length());
    }

    public final int getPort() {
        return this.port;
    }

    public final int getDefaultPort() {
        return this.ph.getDefaultPort();
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final String getRef() {
        return this.ref;
    }

    public final String getUserInfo() {
        if (this.userInfo != null) {
            return this.userInfo;
        }
        int n = this.host == null ? -1 : this.host.indexOf(64);
        return n < 0 ? null : this.host.substring(0, n);
    }

    public final String getQuery() {
        int n = this.file == null ? -1 : this.file.indexOf(63);
        return n < 0 ? null : this.file.substring(n + 1, this.file.length());
    }

    public final int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        return this.ph.hashCode(this);
    }

    public final URLConnection openConnection() throws IOException {
        return this.ph.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public final boolean sameFile(URL uRL) {
        return this.ph.sameFile(this, uRL);
    }

    protected final void set(String string, String string2, int n, String string3, String string4) {
        URLStreamHandler uRLStreamHandler = null;
        if (!this.protocol.equals(string = string.toLowerCase())) {
            uRLStreamHandler = URL.getURLStreamHandler(string);
        }
        if (uRLStreamHandler != null) {
            this.ph = uRLStreamHandler;
            this.protocol = string;
        }
        this.authority = "";
        this.port = n;
        this.host = string2;
        this.file = string3;
        this.ref = string4;
        if (string2 != null) {
            this.authority = this.authority + string2;
        }
        if (n >= 0) {
            this.authority = this.authority + ':' + n;
        }
        this.hashCode = this.hashCode();
    }

    protected final void set(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        URLStreamHandler uRLStreamHandler = null;
        if (!this.protocol.equals(string = string.toLowerCase())) {
            uRLStreamHandler = URL.getURLStreamHandler(string);
        }
        if (uRLStreamHandler != null) {
            this.ph = uRLStreamHandler;
            this.protocol = string;
        }
        this.host = string2;
        this.userInfo = string4;
        this.port = n;
        this.authority = string3;
        this.file = string6 == null ? string5 : string5 + '?' + string6;
        this.ref = string7;
        this.hashCode = this.hashCode();
    }

    public static final synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (factory != null) {
            throw new Error("URLStreamHandlerFactory already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = uRLStreamHandlerFactory;
    }

    public final String toExternalForm() {
        return this.ph.toExternalForm(this);
    }

    public final String toString() {
        return this.ph.toExternalForm(this);
    }

    private static final synchronized URLStreamHandler getURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler = null;
        if (cache_handlers && (uRLStreamHandler = (URLStreamHandler)ph_cache.get(string)) != null) {
            return uRLStreamHandler;
        }
        if (factory != null) {
            uRLStreamHandler = factory.createURLStreamHandler(string);
        }
        if (uRLStreamHandler == null) {
            String string2 = SystemProperties.getProperty("java.protocol.handler.pkgs");
            string2 = string2 != null ? string2 + "|gnu.java.net.protocol|gnu.inet" : DEFAULT_SEARCH_PATH;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            if (systemClassLoader == null) {
                systemClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public final Object run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
            }
            do {
                try {
                    String string3 = stringTokenizer.nextToken() + '.' + string + ".Handler";
                    Class clazz = Class.forName(string3, true, systemClassLoader);
                    uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {}
            } while (uRLStreamHandler == null && stringTokenizer.hasMoreTokens());
        }
        if (uRLStreamHandler != null && cache_handlers) {
            ph_cache.put(string, uRLStreamHandler);
        } else {
            uRLStreamHandler = null;
        }
        return uRLStreamHandler;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ph = URL.getURLStreamHandler(this.protocol);
        if (this.ph == null) {
            throw new IOException("Handler for protocol " + this.protocol + " not found");
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public final URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    private final /* synthetic */ void this() {
        this.port = -1;
    }

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        this(string, string2, n, string3, null);
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3, null);
    }

    public URL(String string, String string2, int n, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        int n2;
        this.this();
        if (string == null) {
            throw new MalformedURLException("null protocol");
        }
        this.protocol = string = string.toLowerCase();
        if (uRLStreamHandler != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = uRLStreamHandler;
        } else {
            this.ph = URL.getURLStreamHandler(string);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + string);
        }
        this.host = string2;
        this.port = n;
        String string4 = this.authority = string2 != null ? string2 : "";
        if (n >= 0 && string2 != null) {
            this.authority = this.authority + ':' + n;
        }
        if ((n2 = string3.indexOf(35)) < 0) {
            this.file = string3;
            this.ref = null;
        } else {
            this.file = string3.substring(0, n2);
            this.ref = string3.substring(n2 + 1);
        }
        this.hashCode = this.hashCode();
    }

    public URL(String string) throws MalformedURLException {
        this((URL)null, string != null ? string : "", (URLStreamHandler)null);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(uRL, string, uRL == null ? null : uRL.ph);
    }

    public URL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        Object object;
        this.this();
        int n = string.indexOf(47);
        int n2 = string.indexOf("://", 1);
        if (!(n2 <= 0 || n2 >= n && n >= 0 || string.regionMatches(n2, "://:", 0, 4))) {
            uRL = null;
        }
        boolean bl = false;
        n2 = string.indexOf(58);
        if (n2 > 0 && (n2 < n || n < 0)) {
            bl = true;
            this.protocol = string.substring(0, n2).toLowerCase();
            if (uRL != null) {
                if (uRL.protocol.equals(this.protocol)) {
                    this.host = uRL.host;
                    this.port = uRL.port;
                    this.userInfo = uRL.userInfo;
                    this.authority = uRL.authority;
                } else {
                    object = URL.getURLStreamHandler(this.protocol.trim());
                    if (object == null) {
                        bl = false;
                    }
                }
            }
        }
        if (!bl) {
            if (uRL != null) {
                n2 = -1;
                this.protocol = uRL.protocol;
                this.host = uRL.host;
                this.port = uRL.port;
                this.userInfo = uRL.userInfo;
                if (string.indexOf(":/", 1) < 0) {
                    this.file = uRL.file;
                    if (this.file == null || this.file.length() == 0) {
                        this.file = "/";
                    }
                }
                this.authority = uRL.authority;
            } else {
                throw new MalformedURLException("Absolute URL required with null context: " + string);
            }
        }
        this.protocol = this.protocol.trim();
        if (uRLStreamHandler != null) {
            object = System.getSecurityManager();
            if (object != null) {
                ((SecurityManager)object).checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = uRLStreamHandler;
        } else {
            this.ph = URL.getURLStreamHandler(this.protocol);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + this.protocol);
        }
        int n3 = string.indexOf(35, n2 + 1);
        try {
            this.ph.parseURL(this, string, n2 + 1, n3 < 0 ? string.length() : n3);
        }
        catch (URLParseError uRLParseError) {
            throw new MalformedURLException(uRLParseError.getMessage());
        }
        if (n3 >= 0) {
            this.ref = string.substring(n3 + 1);
        }
        this.hashCode = this.hashCode();
    }

    static {
        ph_cache = new HashMap();
        String string = SystemProperties.getProperty("gnu.java.net.nocache_protocol_handlers");
        cache_handlers = string == null;
    }
}

