/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JTree
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = 7559816092864483649L;
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String SCROLLS_ON_EXPAND_PROPERTY = "scrollsOnExpand";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String TOGGLE_CLICK_COUNT_PROPERTY = "toggleClickCount";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String ANCHOR_SELECTION_PATH_PROPERTY = "anchorSelectionPath";
    public static final String LEAD_SELECTION_PATH_PROPERTY = "leadSelectionPath";
    public static final String EXPANDS_SELECTED_PATHS_PROPERTY = "expandsSelectedPaths";
    private static final Object EXPANDED = new Object();
    private static final Object COLLAPSED = new Object();
    private boolean dragEnabled;
    private boolean expandsSelectedPaths;
    private TreePath anchorSelectionPath;
    private TreePath leadSelectionPath;
    private Hashtable nodeStates;
    protected transient TreeCellEditor cellEditor;
    protected transient TreeCellRenderer cellRenderer;
    protected boolean editable;
    protected boolean invokesStopCellEditing;
    protected boolean largeModel;
    protected boolean rootVisible;
    protected int rowHeight;
    protected boolean scrollsOnExpand;
    protected transient TreeSelectionModel selectionModel;
    protected boolean showsRootHandles;
    protected int toggleClickCount;
    protected transient TreeModel treeModel;
    protected int visibleRowCount;
    protected transient TreeModelListener treeModelListener;
    protected TreeSelectionRedirector selectionRedirector;
    static /* synthetic */ Class class$javax$swing$event$TreeExpansionListener;
    static /* synthetic */ Class class$javax$swing$event$TreeSelectionListener;
    static /* synthetic */ Class class$javax$swing$event$TreeWillExpandListener;

    public int getRowForPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowForPath(this, treePath);
        }
        return -1;
    }

    public TreePath getPathForRow(int n) {
        TreeUI treeUI = this.getUI();
        return treeUI != null ? treeUI.getPathForRow(this, n) : null;
    }

    protected TreePath[] getPathBetweenRows(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI == null) {
            return null;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        TreePath[] treePathArray = new TreePath[n4 - n3 + 1];
        int n5 = n3;
        while (n5 <= n4) {
            treePathArray[n5 - n3] = treeUI.getPathForRow(this, n5);
            ++n5;
        }
        return treePathArray;
    }

    protected static TreeModel createTreeModel(Object object) {
        return new DefaultTreeModel(new DynamicUtilTreeNode(object, object));
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public void setUI(TreeUI treeUI) {
        super.setUI(treeUI);
    }

    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "TreeUI";
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJTree();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getPreferredSize().width, this.getVisibleRowCount() * this.getRowHeight());
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3;
        if (n == 1) {
            int n4 = this.getClosestRowForLocation(rectangle.x, rectangle.y + 1);
            if ((n4 += n2) < 0) {
                n4 = 0;
            }
            Rectangle rectangle2 = this.getRowBounds(n4);
            n3 = rectangle2.y - rectangle.y;
        } else {
            n3 = n2 * this.rowHeight == 0 ? 20 : this.rowHeight;
        }
        return n3;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.getScrollableUnitIncrement(rectangle, n, n2);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        Class clazz = class$javax$swing$event$TreeExpansionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeExpansionListener = JTree.class("[Ljavax.swing.event.TreeExpansionListener;", false);
        }
        this.listenerList.add(clazz, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        Class clazz = class$javax$swing$event$TreeExpansionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeExpansionListener = JTree.class("[Ljavax.swing.event.TreeExpansionListener;", false);
        }
        this.listenerList.remove(clazz, treeExpansionListener);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        Class clazz = class$javax$swing$event$TreeExpansionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeExpansionListener = JTree.class("[Ljavax.swing.event.TreeExpansionListener;", false);
        }
        return (TreeExpansionListener[])this.getListeners(clazz);
    }

    public void fireTreeCollapsed(TreePath treePath) {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeExpansionListener[] treeExpansionListenerArray = this.getTreeExpansionListeners();
        int n = 0;
        while (n < treeExpansionListenerArray.length) {
            treeExpansionListenerArray[n].treeCollapsed(treeExpansionEvent);
            ++n;
        }
    }

    public void fireTreeExpanded(TreePath treePath) {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeExpansionListener[] treeExpansionListenerArray = this.getTreeExpansionListeners();
        int n = 0;
        while (n < treeExpansionListenerArray.length) {
            treeExpansionListenerArray[n].treeExpanded(treeExpansionEvent);
            ++n;
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = JTree.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.add(clazz, treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = JTree.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.remove(clazz, treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = JTree.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        return (TreeSelectionListener[])this.getListeners(clazz);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeSelectionListener[] treeSelectionListenerArray = this.getTreeSelectionListeners();
        int n = 0;
        while (n < treeSelectionListenerArray.length) {
            treeSelectionListenerArray[n].valueChanged(treeSelectionEvent);
            ++n;
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        Class clazz = class$javax$swing$event$TreeWillExpandListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeWillExpandListener = JTree.class("[Ljavax.swing.event.TreeWillExpandListener;", false);
        }
        this.listenerList.add(clazz, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        Class clazz = class$javax$swing$event$TreeWillExpandListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeWillExpandListener = JTree.class("[Ljavax.swing.event.TreeWillExpandListener;", false);
        }
        this.listenerList.remove(clazz, treeWillExpandListener);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        Class clazz = class$javax$swing$event$TreeWillExpandListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeWillExpandListener = JTree.class("[Ljavax.swing.event.TreeWillExpandListener;", false);
        }
        return (TreeWillExpandListener[])this.getListeners(clazz);
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeWillExpandListener[] treeWillExpandListenerArray = this.getTreeWillExpandListeners();
        int n = 0;
        while (n < treeWillExpandListenerArray.length) {
            treeWillExpandListenerArray[n].treeWillCollapse(treeExpansionEvent);
            ++n;
        }
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        TreeWillExpandListener[] treeWillExpandListenerArray = this.getTreeWillExpandListeners();
        int n = 0;
        while (n < treeWillExpandListenerArray.length) {
            treeWillExpandListenerArray[n].treeWillExpand(treeExpansionEvent);
            ++n;
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel treeModel) {
        if (this.treeModel == treeModel) {
            return;
        }
        if (this.treeModelListener == null) {
            this.treeModelListener = this.createTreeModelListener();
        }
        if (treeModel != null) {
            treeModel.addTreeModelListener(this.treeModelListener);
        }
        TreeModel treeModel2 = this.treeModel;
        this.treeModel = treeModel;
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, treeModel);
        this.updateUI();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, this.editable);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean bl) {
        if (this.rootVisible == bl) {
            return;
        }
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setShowsRootHandles(boolean bl) {
        if (this.showsRootHandles == bl) {
            return;
        }
        boolean bl2 = this.showsRootHandles;
        this.showsRootHandles = bl;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, bl2, bl);
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TreeCellEditor treeCellEditor) {
        if (this.cellEditor == treeCellEditor) {
            return;
        }
        TreeCellEditor treeCellEditor2 = this.cellEditor;
        this.cellEditor = treeCellEditor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, treeCellEditor2, treeCellEditor);
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (this.cellRenderer == treeCellRenderer) {
            return;
        }
        TreeCellRenderer treeCellRenderer2 = this.cellRenderer;
        this.cellRenderer = treeCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, treeCellRenderer2, treeCellRenderer);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.selectionModel == treeSelectionModel) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
        }
        TreeSelectionModel treeSelectionModel2 = this.selectionModel;
        this.selectionModel = treeSelectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, treeSelectionModel2, treeSelectionModel);
        this.revalidate();
        this.repaint();
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        if (this.visibleRowCount == n) {
            return;
        }
        int n2 = this.visibleRowCount;
        this.visibleRowCount = n;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, n2, n);
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setLargeModel(boolean bl) {
        if (this.largeModel == bl) {
            return;
        }
        boolean bl2 = this.largeModel;
        this.largeModel = bl;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, bl2, bl);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        if (this.rowHeight == n) {
            return;
        }
        int n2 = this.rowHeight;
        this.rowHeight = n;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, n2, n);
    }

    public boolean isFixedRowHeight() {
        boolean bl = false;
        if (this.rowHeight > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setInvokesStopCellEditing(boolean bl) {
        if (this.invokesStopCellEditing == bl) {
            return;
        }
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public int getToggleClickCount() {
        return this.toggleClickCount;
    }

    public void setToggleClickCount(int n) {
        if (this.toggleClickCount == n) {
            return;
        }
        int n2 = this.toggleClickCount;
        this.toggleClickCount = n;
        this.firePropertyChange(TOGGLE_CLICK_COUNT_PROPERTY, n2, n);
    }

    /*
     * Unable to fully structure code
     */
    public void scrollPathToVisible(TreePath var1_1) {
        if (var1_1 == null) {
            return;
        }
        var2_2 = var1_1.getPath();
        var3_3 = new TreePath(var2_2[0]);
        var4_4 = false;
        var5_5 = 1;
        ** GOTO lbl16
        {
            block3: {
                if (var5_5 < var2_2.length) break block3;
                var4_4 = true;
                ** GOTO lbl15
            }
            var3_3 = var3_3.pathByAddingChild(var2_2[var5_5++]);
            do {
                if (this.isVisible(var3_3)) continue block0;
lbl15:
                // 2 sources

                this.makeVisible(var3_3);
lbl16:
                // 2 sources

            } while (!var4_4);
        }
        var6_6 = this.getPathBounds(var1_1);
        this.scrollRectToVisible(var6_6);
        this.revalidate();
        this.repaint();
    }

    public void scrollRowToVisible(int n) {
        this.scrollPathToVisible(this.getPathForRow(n));
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public void setScrollsOnExpand(boolean bl) {
        if (this.scrollsOnExpand == bl) {
            return;
        }
        boolean bl2 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl;
        this.firePropertyChange(SCROLLS_ON_EXPAND_PROPERTY, bl2, bl);
    }

    public void setSelectionPath(TreePath treePath) {
        this.selectionModel.setSelectionPath(treePath);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.selectionModel.setSelectionPaths(treePathArray);
    }

    public void setSelectionRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.selectionModel.setSelectionPath(treePath);
        }
    }

    public void setSelectionRows(int[] nArray) {
        if (nArray == null || this.getUI() == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            treePathArray[n] = this.getPathForRow(nArray[n]);
            --n;
        }
        this.setSelectionPaths(treePathArray);
    }

    public void setSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null) {
            this.setSelectionPaths(treePathArray);
        }
    }

    public void addSelectionPath(TreePath treePath) {
        this.selectionModel.addSelectionPath(treePath);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        this.selectionModel.addSelectionPaths(treePathArray);
    }

    public void addSelectionRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.selectionModel.addSelectionPath(treePath);
        }
    }

    public void addSelectionRows(int[] nArray) {
        if (nArray == null || this.getUI() == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            treePathArray[n] = this.getPathForRow(nArray[n]);
            --n;
        }
        this.addSelectionPaths(treePathArray);
    }

    public void addSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null) {
            this.addSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        this.selectionModel.removeSelectionPath(treePath);
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.selectionModel.removeSelectionPaths(treePathArray);
    }

    public void removeSelectionRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.selectionModel.removeSelectionPath(treePath);
        }
    }

    public void removeSelectionRows(int[] nArray) {
        if (nArray == null || this.getUI() == null) {
            return;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            treePathArray[n] = this.getPathForRow(nArray[n]);
            --n;
        }
        this.removeSelectionPaths(treePathArray);
    }

    public void removeSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        if (treePathArray != null) {
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.setLeadSelectionPath(null);
    }

    public TreePath getLeadSelectionPath() {
        return this.leadSelectionPath;
    }

    public void setLeadSelectionPath(TreePath treePath) {
        if (this.leadSelectionPath == treePath) {
            return;
        }
        TreePath treePath2 = this.leadSelectionPath;
        this.leadSelectionPath = treePath;
        this.firePropertyChange(LEAD_SELECTION_PATH_PROPERTY, treePath2, treePath);
    }

    public TreePath getAnchorSelectionPath() {
        return this.anchorSelectionPath;
    }

    public void setAnchorSelectionPath(TreePath treePath) {
        if (this.anchorSelectionPath == treePath) {
            return;
        }
        TreePath treePath2 = this.anchorSelectionPath;
        this.anchorSelectionPath = treePath;
        this.firePropertyChange(ANCHOR_SELECTION_PATH_PROPERTY, treePath2, treePath);
    }

    public int getLeadSelectionRow() {
        return this.selectionModel.getLeadSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.selectionModel.getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.selectionModel.getMinSelectionRow();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.selectionModel.getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.selectionModel.getSelectionRows();
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.selectionModel.isPathSelected(treePath);
    }

    public boolean isRowSelected(int n) {
        return this.selectionModel.isPathSelected(this.getPathForRow(n));
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public int getRowCount() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowCount(this);
        }
        return 0;
    }

    public void collapsePath(TreePath treePath) {
        try {
            this.fireTreeWillCollapse(treePath);
        }
        catch (ExpandVetoException expandVetoException) {}
        this.setExpandedState(treePath, false);
        this.fireTreeCollapsed(treePath);
    }

    public void collapseRow(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.collapsePath(treePath);
        }
    }

    public void expandPath(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        try {
            this.fireTreeWillExpand(treePath);
        }
        catch (ExpandVetoException expandVetoException) {}
        this.setExpandedState(treePath, true);
        this.fireTreeExpanded(treePath);
    }

    public void expandRow(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            this.expandPath(treePath);
        }
    }

    public boolean isCollapsed(TreePath treePath) {
        return this.isExpanded(treePath) ^ true;
    }

    public boolean isCollapsed(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return false;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            return this.isCollapsed(treePath);
        }
        return false;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = this.nodeStates.get(treePath);
        if (object == null || object != EXPANDED) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    public boolean isExpanded(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return false;
        }
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            return this.isExpanded(treePath);
        }
        return false;
    }

    public boolean getExpandsSelectedPaths() {
        return this.expandsSelectedPaths;
    }

    public void setExpandsSelectedPaths(boolean bl) {
        if (this.expandsSelectedPaths == bl) {
            return;
        }
        boolean bl2 = this.expandsSelectedPaths;
        this.expandsSelectedPaths = bl;
        this.firePropertyChange(EXPANDS_SELECTED_PATHS_PROPERTY, bl2, bl);
    }

    public Rectangle getPathBounds(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI == null) {
            return null;
        }
        return treeUI.getPathBounds(this, treePath);
    }

    public Rectangle getRowBounds(int n) {
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null) {
            return this.getPathBounds(treePath);
        }
        return null;
    }

    public boolean isEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        TreeUI treeUI = this.getUI();
        if (this.isEditing() && treeUI != null) {
            return treeUI.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        TreeUI treeUI = this.getUI();
        if (this.isEditing() && treeUI != null) {
            treeUI.cancelEditing(this);
        }
    }

    public void startEditingAtPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.startEditingAtPath(this, treePath);
        }
    }

    public TreePath getEditingPath() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getEditingPath(this);
        }
        return null;
    }

    public TreePath getPathForLocation(int n, int n2) {
        Rectangle rectangle;
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null && rectangle.contains(n, n2)) {
            return treePath;
        }
        return null;
    }

    public int getRowForLocation(int n, int n2) {
        TreePath treePath = this.getPathForLocation(n, n2);
        if (treePath != null) {
            return this.getRowForPath(treePath);
        }
        return -1;
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getClosestPathForLocation(this, n, n2);
        }
        return null;
    }

    public int getClosestRowForLocation(int n, int n2) {
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null) {
            return this.getRowForPath(treePath);
        }
        return -1;
    }

    public Object getLastSelectedPathComponent() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }

    private final void doExpandParents(TreePath treePath, boolean bl) {
        TreePath treePath2 = treePath.getParentPath();
        if (!this.isExpanded(treePath2) && treePath2 != null) {
            this.doExpandParents(treePath2, false);
        }
        this.nodeStates.put(treePath, bl ? EXPANDED : COLLAPSED);
    }

    protected void setExpandedState(TreePath treePath, boolean bl) {
        if (treePath == null) {
            return;
        }
        this.doExpandParents(treePath, bl);
    }

    protected void clearToggledPaths() {
        this.nodeStates.clear();
    }

    protected Enumeration getDescendantToggledPaths(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Enumeration enumeration = this.nodeStates.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = (TreePath)enumeration.nextElement();
            if (!treePath2.isDescendant(treePath)) continue;
            vector.addElement(treePath2);
        }
        return vector.elements();
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        boolean bl = false;
        if (this.nodeStates.get(treePath) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isVisible(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return true;
        }
        return this.isExpanded(treePath2);
    }

    public void makeVisible(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        this.expandPath(treePath.getParentPath());
    }

    public boolean isPathEditable(TreePath treePath) {
        return this.isEditable();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root node");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Child node 1");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Child node 1.1");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Child node 1.2");
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Child node 1.3");
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Child node 2");
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("Child node 2.1");
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Child node 2.2");
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("Child node 2.3");
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode("Child node 2.4");
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode("Child node 3");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        defaultMutableTreeNode2.add(defaultMutableTreeNode5);
        defaultMutableTreeNode6.add(defaultMutableTreeNode7);
        defaultMutableTreeNode6.add(defaultMutableTreeNode8);
        defaultMutableTreeNode6.add(defaultMutableTreeNode9);
        defaultMutableTreeNode6.add(defaultMutableTreeNode10);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        return object.toString();
    }

    protected String paramString() {
        return "";
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        Enumeration enumeration = this.nodeStates.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = (TreePath)enumeration.nextElement();
            if (this.nodeStates.get(treePath2) != EXPANDED || !treePath.isDescendant(treePath2)) continue;
            vector.add(treePath2);
        }
        return vector.elements();
    }

    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        if (string == null) {
            throw new IllegalArgumentException("The argument 'prefix' must not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("The argument 'startingRow' must not be less than zero.");
        }
        int n2 = this.getRowCount();
        if (n > n2) {
            throw new IllegalArgumentException("The argument 'startingRow' must not be greater than the number of elements in the TreeModel.");
        }
        TreePath treePath = null;
        if (bias == Position.Bias.Forward) {
            int n3 = n;
            while (n3 < n2) {
                TreePath treePath2 = this.getPathForRow(n3);
                Object object = treePath2.getLastPathComponent();
                String string2 = this.convertValueToText(object, this.isRowSelected(n3), this.isExpanded(n3), this.treeModel.isLeaf(object), n3, false);
                if (string2.startsWith(string)) {
                    treePath = treePath2;
                    break;
                }
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 >= 0) {
                TreePath treePath3 = this.getPathForRow(n4);
                Object object = treePath3.getLastPathComponent();
                String string3 = this.convertValueToText(object, this.isRowSelected(n4), this.isExpanded(n4), this.treeModel.isLeaf(object), n4, false);
                if (string3.startsWith(string)) {
                    treePath = treePath3;
                    break;
                }
                --n4;
            }
        }
        return treePath;
    }

    protected boolean removeDescendantSelectedPaths(TreePath treePath, boolean bl) {
        boolean bl2 = false;
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePathArray[n] == treePath && bl || treePathArray[n].isDescendant(treePath)) {
                this.removeSelectionPath(treePathArray[n]);
                bl2 = true;
            }
            ++n;
        }
        return bl2;
    }

    protected void removeDescendantToggledPaths(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            TreePath treePath = (TreePath)enumeration.nextElement();
            Enumeration enumeration2 = this.getDescendantToggledPaths(treePath);
            while (enumeration2.hasMoreElements()) {
                TreePath treePath2 = (TreePath)enumeration2.nextElement();
                if (!this.isExpanded(treePath2)) continue;
                this.nodeStates.remove(treePath2);
            }
        }
    }

    public void treeDidChange() {
        this.repaint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.nodeStates = new Hashtable();
        this.selectionRedirector = new TreeSelectionRedirector();
    }

    public JTree() {
        this(JTree.createTreeModel(null));
    }

    public JTree(Hashtable hashtable) {
        this(JTree.createTreeModel(hashtable));
    }

    public JTree(Object[] objectArray) {
        this(JTree.createTreeModel(objectArray));
    }

    public JTree(TreeModel treeModel) {
        this.this();
        this.updateUI();
        this.setRootVisible(true);
        this.setModel(treeModel);
        this.setSelectionModel(new EmptySelectionModel());
        this.selectionModel.setSelectionMode(1);
        this.nodeStates.put(new TreePath(treeModel.getRoot()), EXPANDED);
    }

    public JTree(TreeNode treeNode) {
        this(treeNode, false);
    }

    public JTree(TreeNode treeNode, boolean bl) {
        this(new DefaultTreeModel(treeNode, bl));
    }

    public JTree(Vector vector) {
        this(JTree.createTreeModel(vector));
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected Object childValue;
        protected boolean loadedChildren;
        protected boolean hasChildren;

        public int getChildCount() {
            this.loadChildren();
            return super.getChildCount();
        }

        protected void loadChildren() {
            if (!this.loadedChildren) {
                DynamicUtilTreeNode.createChildren(this, this.childValue);
                this.loadedChildren = true;
            }
        }

        public Enumeration children() {
            this.loadChildren();
            return super.children();
        }

        public TreeNode getChildAt(int n) {
            this.loadChildren();
            return super.getChildAt(n);
        }

        public boolean isLeaf() {
            boolean bl = false;
            if (this.childValue == null || !(this.childValue instanceof Hashtable) && !(this.childValue instanceof Vector) && !this.childValue.getClass().isArray()) {
                bl = true;
            }
            return bl;
        }

        public static void createChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
            block4: {
                block5: {
                    block3: {
                        if (!(object instanceof Hashtable)) break block3;
                        Hashtable hashtable = (Hashtable)object;
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            Object object2 = enumeration.nextElement();
                            Object object3 = hashtable.get(object2);
                            defaultMutableTreeNode.add(new DynamicUtilTreeNode(object2, object3));
                        }
                        break block4;
                    }
                    if (!(object instanceof Vector)) break block5;
                    Iterator iterator = ((Vector)object).iterator();
                    while (iterator.hasNext()) {
                        Object object4 = iterator.next();
                        defaultMutableTreeNode.add(new DynamicUtilTreeNode(object4, object4));
                    }
                    break block4;
                }
                if (object == null || !object.getClass().isArray()) break block4;
                Object[] objectArray = (Object[])object;
                int n = 0;
                while (n < objectArray.length) {
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(objectArray[n], objectArray[n]));
                    ++n;
                }
            }
        }

        public DynamicUtilTreeNode(Object object, Object object2) {
            super(object);
            this.childValue = object2;
            this.loadedChildren = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeSelectionListener,
    TreeModelListener,
    TreeExpansionListener {
        public void addAccessibleSelection(int n) {
            JTree.this.addSelectionInterval(n, n);
        }

        public void clearAccessibleSelection() {
            JTree.this.clearSelection();
        }

        public void fireVisibleDataPropertyChange() {
            JTree.this.treeDidChange();
        }

        public Accessible getAccessibleAt(Point point) {
            TreePath treePath = JTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath != null) {
                return new AccessibleJTreeNode(JTree.this, treePath, null);
            }
            return null;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                return treeModel.getChildCount(treeModel.getRoot());
            }
            return 0;
        }

        public int getAccessibleIndexInParent() {
            return 0;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public AccessibleSelection getAccessibleSelection() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                return new AccessibleJTreeNode(JTree.this, new TreePath(treeModel.getRoot()), null).getAccessibleSelection();
            }
            return null;
        }

        public Accessible getAccessibleSelection(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                return new AccessibleJTreeNode(JTree.this, new TreePath(treeModel.getRoot()), null).getAccessibleSelection(n);
            }
            return null;
        }

        public int getAccessibleSelectionCount() {
            return JTree.this.getSelectionCount();
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public void removeAccessibleSelection(int n) {
            JTree.this.removeSelectionInterval(n, n);
        }

        public void selectAllAccessibleSelection() {
            if (JTree.this.getSelectionModel().getSelectionMode() != 1) {
                JTree.this.addSelectionInterval(0, JTree.this.getVisibleRowCount());
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            JTree.this.fireTreeCollapsed(treeExpansionEvent.getPath());
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            JTree.this.fireTreeExpanded(treeExpansionEvent.getPath());
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            JTree.this.fireValueChanged(treeSelectionEvent);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private JTree tree;
            private TreePath tp;
            private Accessible acc;
            private AccessibleStateSet states = new AccessibleStateSet();
            private Vector selectionList = new Vector();
            private Vector actionList = new Vector();
            private TreeModel mod = this.tree.getModel();
            private Cursor cursor;

            public void addAccessibleSelection(int n) {
                Object object;
                if (this.mod != null && (object = this.mod.getChild(this.tp.getLastPathComponent(), n)) != null) {
                    if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                        this.clearAccessibleSelection();
                    }
                    this.selectionList.add(object);
                    this.tree.addSelectionPath(this.tp.pathByAddingChild(object));
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                this.tree.addFocusListener(focusListener);
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void clearAccessibleSelection() {
                this.selectionList.clear();
            }

            public boolean contains(Point point) {
                return this.getBounds().contains(point);
            }

            public boolean doAccessibleAction(int n) {
                if (n >= this.actionList.size() || n < 0) {
                    return false;
                }
                if (this.actionList.get(n).equals("EXPAND")) {
                    this.tree.expandPath(this.tp);
                } else if (this.actionList.get(n).equals("COLLAPSE")) {
                    this.tree.collapsePath(this.tp);
                } else if (this.actionList.get(n).equals("SELECT")) {
                    this.tree.addSelectionPath(this.tp);
                } else if (this.actionList.get(n).equals("DESELECT")) {
                    this.tree.removeSelectionPath(this.tp);
                } else if (this.actionList.get(n).equals("EDIT")) {
                    this.tree.startEditingAtPath(this.tp);
                } else {
                    return false;
                }
                return true;
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public int getAccessibleActionCount() {
                return this.actionList.size();
            }

            public String getAccessibleActionDescription(int n) {
                if (n < 0 || n >= this.actionList.size()) {
                    return this.actionList.get(n).toString();
                }
                return super.getAccessibleDescription();
            }

            public Accessible getAccessibleAt(Point point) {
                TreePath treePath = this.tree.getClosestPathForLocation(point.x, point.y);
                if (treePath != null) {
                    return new AccessibleJTreeNode(this.tree, treePath, this);
                }
                return null;
            }

            public Accessible getAccessibleChild(int n) {
                Object object;
                if (this.mod != null && (object = this.mod.getChild(this.tp.getLastPathComponent(), n)) != null) {
                    return new AccessibleJTreeNode(this.tree, this.tp.pathByAddingChild(object), this.acc);
                }
                return null;
            }

            public int getAccessibleChildrenCount() {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null) {
                    return treeModel.getChildCount(this.tp.getLastPathComponent());
                }
                return 0;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleDescription() {
                return super.getAccessibleDescription();
            }

            public int getAccessibleIndexInParent() {
                AccessibleContext accessibleContext = this.getAccessibleParent().getAccessibleContext();
                if (accessibleContext != null) {
                    int n = 0;
                    while (n < accessibleContext.getAccessibleChildrenCount()) {
                        if (accessibleContext.getAccessibleChild(n).equals(this)) {
                            return n;
                        }
                        ++n;
                    }
                }
                return -1;
            }

            public String getAccessibleName() {
                return super.getAccessibleName();
            }

            public Accessible getAccessibleParent() {
                return super.getAccessibleParent();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleJTree.this.getAccessibleRole();
            }

            public AccessibleSelection getAccessibleSelection() {
                return this;
            }

            public Accessible getAccessibleSelection(int n) {
                if (n > 0 && n < this.getAccessibleSelectionCount()) {
                    return new AccessibleJTreeNode(this.tree, this.tp.pathByAddingChild(this.selectionList.get(n)), this.acc);
                }
                return null;
            }

            public int getAccessibleSelectionCount() {
                return this.selectionList.size();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                if (this.isVisible()) {
                    this.states.add(AccessibleState.VISIBLE);
                }
                if (this.tree.isCollapsed(this.tp)) {
                    this.states.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    this.states.add(AccessibleState.EDITABLE);
                }
                if (this.mod != null && !this.mod.isLeaf(this.tp.getLastPathComponent())) {
                    this.states.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.tp)) {
                    this.states.add(AccessibleState.EXPANDED);
                }
                if (JTree.this.isFocusable()) {
                    this.states.add(AccessibleState.FOCUSABLE);
                }
                if (JTree.this.hasFocus()) {
                    this.states.add(AccessibleState.FOCUSED);
                }
                if (this.tree.getSelectionModel().getSelectionMode() != 1) {
                    this.states.add(AccessibleState.MULTISELECTABLE);
                }
                if (this.tree.isOpaque()) {
                    this.states.add(AccessibleState.OPAQUE);
                }
                if (this.tree.isPathSelected(this.tp)) {
                    this.states.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    this.states.add(AccessibleState.SHOWING);
                }
                this.states.add(AccessibleState.SELECTABLE);
                return this.states;
            }

            public AccessibleText getAccessibleText() {
                return super.getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return super.getAccessibleValue();
            }

            public Color getBackground() {
                return this.tree.getBackground();
            }

            public Rectangle getBounds() {
                return this.tree.getPathBounds(this.tp);
            }

            public Cursor getCursor() {
                return this.cursor;
            }

            public Font getFont() {
                return this.tree.getFont();
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.tree.getFontMetrics(font);
            }

            public Color getForeground() {
                return this.tree.getForeground();
            }

            public Locale getLocale() {
                return this.tree.getLocale();
            }

            public Point getLocation() {
                return this.getLocationInJTree();
            }

            protected Point getLocationInJTree() {
                Rectangle rectangle = this.tree.getPathBounds(this.tp);
                return new Point(rectangle.x, rectangle.y);
            }

            public Point getLocationOnScreen() {
                Point point = this.getLocation();
                SwingUtilities.convertPointToScreen(point, this.tree);
                return point;
            }

            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                return rectangle.getSize();
            }

            public boolean isAccessibleChildSelected(int n) {
                Object object = this.mod.getChild(this.tp.getLastPathComponent(), n);
                if (object != null) {
                    return this.tree.isPathSelected(this.tp.pathByAddingChild(object));
                }
                return false;
            }

            public boolean isEnabled() {
                return this.tree.isEnabled();
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public boolean isShowing() {
                boolean bl = false;
                if (this.isVisible() && this.tree.isShowing()) {
                    bl = true;
                }
                return bl;
            }

            public boolean isVisible() {
                return this.tree.isVisible(this.tp);
            }

            public void removeAccessibleSelection(int n) {
                Object object;
                if (this.mod != null && (object = this.mod.getChild(this.tp.getLastPathComponent(), n)) != null) {
                    if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                        this.clearAccessibleSelection();
                    }
                    if (this.selectionList.contains(object)) {
                        this.selectionList.remove(object);
                        this.tree.removeSelectionPath(this.tp.pathByAddingChild(object));
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                this.tree.removeFocusListener(focusListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void requestFocus() {
                this.tree.requestFocus();
            }

            public void selectAllAccessibleSelection() {
                Object object = this.tp.getLastPathComponent();
                if (this.mod != null) {
                    int n = 0;
                    while (n < this.mod.getChildCount(object)) {
                        Object object2 = this.mod.getChild(object, n);
                        if (object2 != null) {
                            if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                                this.clearAccessibleSelection();
                            }
                            if (this.selectionList.contains(object2)) {
                                this.selectionList.add(object2);
                                this.tree.addSelectionPath(this.tp.pathByAddingChild(object2));
                            }
                        }
                        ++n;
                    }
                }
            }

            public void setAccessibleDescription(String string) {
                super.setAccessibleDescription(string);
            }

            public void setAccessibleName(String string) {
                super.setAccessibleName(string);
            }

            public void setBackground(Color color) {
            }

            public void setBounds(Rectangle rectangle) {
            }

            public void setCursor(Cursor cursor) {
                this.cursor = cursor;
            }

            public void setEnabled(boolean bl) {
            }

            public void setFont(Font font) {
            }

            public void setForeground(Color color) {
            }

            public void setLocation(Point point) {
            }

            public void setSize(Dimension dimension) {
            }

            public void setVisible(boolean bl) {
            }

            public AccessibleJTreeNode(JTree jTree, TreePath treePath, Accessible accessible) {
                this.cursor = JTree.this.getCursor();
                this.tree = jTree;
                this.tp = treePath;
                this.acc = accessible;
                TreePath[] treePathArray = this.tree.getSelectionPaths();
                int n = 0;
                while (n < treePathArray.length) {
                    TreePath treePath2 = treePathArray[n];
                    if (treePath2.getParentPath().equals(this.tp)) {
                        this.selectionList.add(treePath2);
                    }
                    ++n;
                }
                this.actionList.add("EXPAND");
                this.actionList.add("COLLAPSE");
                this.actionList.add("EDIT");
                this.actionList.add("SELECT");
                this.actionList.add("DESELECT");
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            JTree.this.setExpandedState(treePath, JTree.this.isExpanded(treePath));
        }

        protected TreeModelHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class TreeSelectionRedirector
    implements TreeSelectionListener,
    Serializable {
        private static final long serialVersionUID = -3505069663646241664L;

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = (TreeSelectionEvent)treeSelectionEvent.cloneWithSource(JTree.this);
            JTree.this.fireValueChanged(treeSelectionEvent2);
            JTree.this.repaint();
        }

        protected TreeSelectionRedirector() {
        }
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -5815023306225701477L;
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
        }

        protected EmptySelectionModel() {
        }
    }
}

