/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import java.util.Arrays;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueStatus;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueTempo;
import org.tritonus.midi.device.alsa.AlsaMidiIn;
import org.tritonus.midi.device.alsa.AlsaMidiOut;
import org.tritonus.midi.device.alsa.AlsaReceiver;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.MidiUtils;
import org.tritonus.share.midi.TMidiDevice;
import org.tritonus.share.midi.TSequencer;

public class AlsaSequencer
extends TSequencer {
    private static final Sequencer.SyncMode[] MASTER_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static final Sequencer.SyncMode[] SLAVE_SYNC_MODES = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC, Sequencer.SyncMode.MIDI_SYNC};
    private static final int CLOCK_EVENT_TAG = 255;
    private AlsaSeq m_playbackAlsaSeq;
    private AlsaSeq m_recordingAlsaSeq;
    private int m_nRecordingPort;
    private int m_nPlaybackPort;
    private int m_nQueue;
    private AlsaSeqQueueInfo m_queueInfo;
    private AlsaSeqQueueStatus m_queueStatus;
    private AlsaSeqQueueTempo m_queueTempo;
    private AlsaMidiIn m_playbackAlsaMidiIn;
    private AlsaMidiOut m_playbackAlsaMidiOut;
    private AlsaMidiIn m_recordingAlsaMidiIn;
    private Thread m_loaderThread;
    private Thread m_syncThread;
    private AlsaSeqEvent m_queueControlEvent;
    private AlsaSeqEvent m_clockEvent;
    private boolean m_bRecording;
    private Track m_track;
    private AlsaSeqEvent m_allNotesOffEvent;
    private Sequencer.SyncMode m_oldSlaveSyncMode;
    private float m_fCachedRealMPQ;

    private final int getPlaybackClient() {
        int n = this.getPlaybackAlsaSeq().getClientId();
        return n;
    }

    private final int getPlaybackPort() {
        return this.m_nPlaybackPort;
    }

    private final int getRecordingClient() {
        int n = this.getRecordingAlsaSeq().getClientId();
        return n;
    }

    private final int getRecordingPort() {
        return this.m_nRecordingPort;
    }

    private final int getQueue() {
        return this.m_nQueue;
    }

    private final AlsaSeqQueueStatus getQueueStatus() {
        return this.m_queueStatus;
    }

    private final AlsaSeqQueueTempo getQueueTempo() {
        return this.m_queueTempo;
    }

    private final AlsaSeq getPlaybackAlsaSeq() {
        return this.m_playbackAlsaSeq;
    }

    private final AlsaSeq getRecordingAlsaSeq() {
        return this.m_recordingAlsaSeq;
    }

    private final void updateQueueStatus() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.updateQueueStatus(): begin");
        }
        this.getPlaybackAlsaSeq().getQueueStatus(this.getQueue(), this.getQueueStatus());
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.updateQueueStatus(): end");
        }
    }

    protected void openImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.openImpl(): begin");
        }
        this.m_recordingAlsaSeq = new AlsaSeq("Tritonus ALSA Sequencer (recording/synchronization)");
        this.m_nRecordingPort = this.getRecordingAlsaSeq().createPort("recording/synchronization port", 99, 0, 0x100000, 0, 0, 0);
        this.m_playbackAlsaSeq = new AlsaSeq("Tritonus ALSA Sequencer (playback)");
        this.m_nPlaybackPort = this.getPlaybackAlsaSeq().createPort("playback port", 99, 0, 0x100000, 0, 0, 0);
        this.m_nQueue = this.getPlaybackAlsaSeq().allocQueue();
        this.m_queueInfo = new AlsaSeqQueueInfo();
        this.m_queueStatus = new AlsaSeqQueueStatus();
        this.m_queueTempo = new AlsaSeqQueueTempo();
        this.getPlaybackAlsaSeq().getQueueInfo(this.getQueue(), this.m_queueInfo);
        this.m_queueInfo.setLocked(false);
        this.getPlaybackAlsaSeq().setQueueInfo(this.getQueue(), this.m_queueInfo);
        this.m_playbackAlsaMidiOut = new AlsaMidiOut(this.getPlaybackAlsaSeq(), this.getPlaybackPort(), this.getQueue());
        this.m_playbackAlsaMidiOut.setHandleMetaMessages(true);
        this.getRecordingAlsaSeq().setQueueUsage(this.getQueue(), true);
        PlaybackAlsaMidiInListener playbackAlsaMidiInListener = new PlaybackAlsaMidiInListener();
        this.m_playbackAlsaMidiIn = new AlsaMidiIn(this.getPlaybackAlsaSeq(), this.getPlaybackPort(), this.getPlaybackClient(), this.getPlaybackPort(), playbackAlsaMidiInListener);
        this.m_playbackAlsaMidiIn.start();
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.openImpl(): end");
        }
        this.m_queueControlEvent = new AlsaSeqEvent();
        this.m_clockEvent = new AlsaSeqEvent();
        this.m_clockEvent.setCommon(36, 0, 255, this.getQueue(), 0L, 0, this.getRecordingPort(), 254, 253);
        this.m_allNotesOffEvent = new AlsaSeqEvent();
        this.m_oldSlaveSyncMode = this.getSlaveSyncMode();
        if (this.m_fCachedRealMPQ != -1.0f) {
            this.setTempoImpl(this.m_fCachedRealMPQ);
            this.m_fCachedRealMPQ = -1.0f;
        }
        this.m_loaderThread = new LoaderThread();
        this.m_loaderThread.start();
    }

    protected void closeImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.closeImpl(): begin");
        }
        this.m_playbackAlsaMidiIn.interrupt();
        this.m_playbackAlsaMidiIn = null;
        this.getQueueStatus().free();
        this.m_queueStatus = null;
        this.getQueueTempo().free();
        this.m_queueTempo = null;
        this.getRecordingAlsaSeq().close();
        this.m_recordingAlsaSeq = null;
        this.getPlaybackAlsaSeq().close();
        this.m_playbackAlsaSeq = null;
        this.m_queueControlEvent.free();
        this.m_queueControlEvent = null;
        this.m_clockEvent.free();
        this.m_clockEvent = null;
        this.m_allNotesOffEvent.free();
        this.m_allNotesOffEvent = null;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.closeImpl(): end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startImpl() {
        block8: {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.startImpl(): begin");
            }
            if (this.getTickPosition() == 0L) {
                this.startQueue();
            } else {
                this.continueQueue();
            }
            Thread thread = this.m_loaderThread;
            synchronized (thread) {
                if (TDebug.TraceSequencer) {
                    TDebug.out("AlsaSequencer.startImpl(): notifying loader thread");
                }
                this.m_loaderThread.notify();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                if (!this.getSlaveSyncMode().equals(Sequencer.SyncMode.NO_SYNC)) {
                    this.sendStartEvent();
                }
                if (!TDebug.TraceSequencer) break block8;
            }
            TDebug.out("AlsaSequencer.startImpl(): end");
        }
    }

    protected void stopImpl() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.stopImpl(): begin");
        }
        this.stopQueue();
        this.sendAllNotesOff();
        this.stopRecording();
        if (!this.getSlaveSyncMode().equals(Sequencer.SyncMode.NO_SYNC)) {
            this.sendStopEvent();
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.stopImpl(): end");
        }
    }

    public boolean isRunning() {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.isRunning(): begin");
        }
        boolean bl = false;
        if (this.isOpen()) {
            this.updateQueueStatus();
            int n = this.getQueueStatus().getStatus();
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.isRunning(): queue status: " + n);
            }
            boolean bl2 = false;
            if (n != 0) {
                bl2 = bl = true;
            }
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.isRunning(): end");
        }
        return bl;
    }

    public void startRecording() {
        this.checkOpen();
        this.m_bRecording = true;
        this.start();
    }

    public void stopRecording() {
        this.checkOpen();
        this.m_bRecording = false;
    }

    public boolean isRecording() {
        return this.m_bRecording;
    }

    public void recordEnable(Track track, int n) {
        this.m_track = track;
    }

    public void recordDisable(Track track) {
    }

    protected void setTempoImpl(float f) {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTempoImpl(): begin");
        }
        if (this.isOpen()) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.setTempoImpl(): setting tempo to " + (int)f);
            }
            this.getQueueTempo().setTempo((int)f);
            this.getQueueTempo().setPpq(this.getResolution());
            this.getPlaybackAlsaSeq().setQueueTempo(this.getQueue(), this.getQueueTempo());
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.setTempoImpl(): ignoring because sequencer is not opened");
            }
            this.m_fCachedRealMPQ = f;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTempoImpl(): end");
        }
    }

    public long getTickPosition() {
        long l;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getTickPosition(): begin");
        }
        if (this.isOpen()) {
            this.updateQueueStatus();
            l = this.getQueueStatus().getTickTime();
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.getTickPosition(): sequencer not open, returning 0");
            }
            l = 0L;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getTickPosition(): end");
        }
        return l;
    }

    public void setTickPosition(long l) {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTickPosition(): begin");
        }
        if (this.isOpen()) {
            int n = this.getRecordingPort();
            int n2 = this.getQueue();
            long l2 = l;
            this.sendQueueControlEvent(33, 3, 0, 253, 0L, n, 0, 0, n2, 0, l2);
        } else if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTickPosition(): ignored because sequencer is not open");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setTickPosition(): end");
        }
    }

    public long getMicrosecondPosition() {
        long l;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getMicrosecondPosition(): begin");
        }
        if (this.isOpen()) {
            this.updateQueueStatus();
            long l2 = this.getQueueStatus().getRealTime();
            l = l2 / 1000L;
        } else {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.getMicrosecondPosition(): sequencer not open, returning 0");
            }
            l = 0L;
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.getMicrosecondPosition(): end");
        }
        return l;
    }

    public void setMicrosecondPosition(long l) {
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setMicrosecondPosition(): begin");
        }
        if (this.isOpen()) {
            long l2 = l * 1000L;
            int n = this.getRecordingPort();
            int n2 = this.getQueue();
            long l3 = l2;
            this.sendQueueControlEvent(34, 3, 0, 253, 0L, n, 0, 0, n2, 0, l3);
        } else if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setMicrosecondPosition(): ignoring because sequencer is not open");
        }
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.setMicrosecondPosition(): end");
        }
    }

    protected void setMasterSyncModeImpl(Sequencer.SyncMode syncMode) {
    }

    protected void setSlaveSyncModeImpl(Sequencer.SyncMode syncMode) {
        if (this.isRunning()) {
            if (this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.NO_SYNC) && (syncMode.equals(Sequencer.SyncMode.MIDI_SYNC) || syncMode.equals(Sequencer.SyncMode.MIDI_TIME_CODE))) {
                this.sendStartEvent();
            } else if ((this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.MIDI_SYNC) || this.m_oldSlaveSyncMode.equals(Sequencer.SyncMode.MIDI_TIME_CODE)) && syncMode.equals(Sequencer.SyncMode.NO_SYNC)) {
                this.sendStopEvent();
            }
        }
    }

    protected void setTrackEnabledImpl(int n, boolean bl) {
    }

    private final synchronized void enqueueMessage(MidiMessage midiMessage, long l) {
        this.m_playbackAlsaMidiOut.enqueueMessage(midiMessage, l);
    }

    public void sendMessageTick(MidiMessage midiMessage, long l) {
        this.enqueueMessage(midiMessage, l);
    }

    private final void startQueue() {
        this.controlQueue(30);
    }

    private final void continueQueue() {
        this.controlQueue(31);
    }

    private final void stopQueue() {
        this.controlQueue(32);
    }

    private final void controlQueue(int n) {
        int n2 = this.getPlaybackPort();
        int n3 = this.getQueue();
        this.sendQueueControlEvent(n, 3, 0, 253, 0L, n2, 0, 0, n3, 0, 0L);
    }

    private final void sendStartEvent() {
        this.sendRealtimeEvent(30);
    }

    private final void sendStopEvent() {
        this.sendRealtimeEvent(32);
    }

    private final void sendRealtimeEvent(int n) {
        this.sendQueueControlEvent(n, 3, 0, 253, 0L, this.getPlaybackPort(), 254, 253, 0, 0, 0L);
    }

    private final void sendQueueControlEvent(int n, int n2, int n3, int n4, long l, int n5, int n6, int n7, int n8, int n9, long l2) {
        this.m_queueControlEvent.setCommon(n, n2, n3, n4, l, 0, n5, n6, n7);
        this.m_queueControlEvent.setQueueControl(n8, n9, l2);
        this.getPlaybackAlsaSeq().eventOutputDirect(this.m_queueControlEvent);
    }

    private final void sendAllNotesOffEvent(int n) {
        int n2 = this.getPlaybackPort();
        this.m_allNotesOffEvent.setCommon(10, 3, 0, 253, 0L, 0, n2, 254, 253);
        this.m_allNotesOffEvent.setControl(n, 120, 0);
        this.getPlaybackAlsaSeq().eventOutputDirect(this.m_allNotesOffEvent);
    }

    private final void sendAllNotesOff() {
        int n = 0;
        while (n < 16) {
            this.sendAllNotesOffEvent(n);
            ++n;
        }
    }

    private final void receiveTimestamped(MidiMessage midiMessage, long l) {
        if (this.isRecording()) {
            Track track = this.m_track;
            MidiEvent midiEvent = new MidiEvent(midiMessage, l);
            track.add(midiEvent);
        }
    }

    protected void receive(MidiMessage midiMessage, long l) {
        l = this.getTickPosition();
        this.receiveTimestamped(midiMessage, l);
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        return new AlsaSequencerReceiver();
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        return new AlsaSequencerTransmitter();
    }

    public AlsaSequencer(MidiDevice.Info info) {
        super(info, Arrays.asList(MASTER_SYNC_MODES), Arrays.asList(SLAVE_SYNC_MODES));
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.<init>(): begin");
        }
        this.m_fCachedRealMPQ = -1.0f;
        if (TDebug.TraceSequencer) {
            TDebug.out("AlsaSequencer.<init>(): end");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PlaybackAlsaMidiInListener
    implements AlsaMidiIn.AlsaMidiInListener {
        public void dequeueEvent(MidiMessage midiMessage, long l) {
            MetaMessage metaMessage;
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.PlaybackAlsaMidiInListener.dequeueEvent(): begin");
            }
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.PlaybackAlsaMidiInListener.dequeueEvent(): message: " + midiMessage);
            }
            if (midiMessage instanceof MetaMessage && (metaMessage = (MetaMessage)midiMessage).getType() == 81) {
                byte[] byArray = metaMessage.getData();
                int n = MidiUtils.getUnsignedInteger(byArray[0]) * 65536 + MidiUtils.getUnsignedInteger(byArray[1]) * 256 + MidiUtils.getUnsignedInteger(byArray[2]);
                AlsaSequencer.this.setTempoInMPQ(n);
            }
            AlsaSequencer.this.sendImpl(midiMessage, -1);
            AlsaSequencer.this.notifyListeners(midiMessage);
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.PlaybackAlsaMidiInListener.dequeueEvent(): end");
            }
        }

        private PlaybackAlsaMidiInListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LoaderThread
    extends Thread {
        private long m_lLoadingPosition;

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 24->44)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final void loadSequenceToNative() {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.loadSequenceToNative(): begin");
            }
            Sequence sequence = AlsaSequencer.this.getSequence();
            Track[] trackArray = sequence.getTracks();
            int[] nArray = new int[trackArray.length];
            int n = 0;
            while (n < trackArray.length) {
                nArray[n] = 0;
                ++n;
            }
            this.m_lLoadingPosition = 0L;
            while (AlsaSequencer.this.isRunning()) {
                long l;
                Object object;
                n = 0;
                long l2 = Long.MAX_VALUE;
                int n2 = -1;
                int n3 = 0;
                while (n3 < trackArray.length) {
                    if (nArray[n3] < trackArray[n3].size()) {
                        n = 1;
                        object = trackArray[n3].get(nArray[n3]);
                        l = ((MidiEvent)object).getTick();
                        if (l < l2) {
                            l2 = l;
                            n2 = n3;
                        }
                    }
                    ++n3;
                }
                if (n == 0) {
                    MetaMessage metaMessage;
                    block13: {
                        metaMessage = new MetaMessage();
                        try {
                            metaMessage.setMessage(47, new byte[0], 0);
                        }
                        catch (InvalidMidiDataException invalidMidiDataException) {
                            if (!TDebug.TraceAllExceptions) break block13;
                            TDebug.out(invalidMidiDataException);
                        }
                    }
                    if (TDebug.TraceSequencer) {
                        TDebug.out("AlsaSequencer.loadSequenceToNative(): sending End of Track message with tick " + (this.m_lLoadingPosition + 1L));
                    }
                    AlsaSequencer.this.enqueueMessage(metaMessage, this.m_lLoadingPosition + 1L);
                    break;
                }
                MidiEvent midiEvent = trackArray[n2].get(nArray[n2]);
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
                object = midiEvent.getMessage();
                l = midiEvent.getTick();
                this.m_lLoadingPosition = Math.max(this.m_lLoadingPosition, l);
                if (object instanceof MetaMessage && ((MetaMessage)object).getType() == 47) {
                    if (!TDebug.TraceSequencer) continue;
                    TDebug.out("AlsaSequencer.loadSequenceToNative(): ignoring End of Track message with tick " + l);
                    continue;
                }
                if (TDebug.TraceSequencer) {
                    TDebug.out("AlsaSequencer.loadSequenceToNative(): enqueueing event with tick " + l);
                }
                AlsaSequencer.this.enqueueMessage((MidiMessage)object, l);
            }
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.loadSequenceToNative(): end");
            }
        }

        private LoaderThread() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlsaSequencerReceiver
    extends TMidiDevice.TReceiver
    implements AlsaReceiver {
        public boolean subscribeTo(int n, int n2) {
            try {
                AlsaSeqPortSubscribe alsaSeqPortSubscribe = new AlsaSeqPortSubscribe();
                alsaSeqPortSubscribe.setSender(n, n2);
                alsaSeqPortSubscribe.setDest(AlsaSequencer.this.getRecordingClient(), AlsaSequencer.this.getRecordingPort());
                alsaSeqPortSubscribe.setQueue(AlsaSequencer.this.getQueue());
                alsaSeqPortSubscribe.setExclusive(false);
                alsaSeqPortSubscribe.setTimeUpdate(true);
                alsaSeqPortSubscribe.setTimeReal(false);
                AlsaSequencer.this.getRecordingAlsaSeq().subscribePort(alsaSeqPortSubscribe);
                alsaSeqPortSubscribe.free();
                return true;
            }
            catch (RuntimeException runtimeException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(runtimeException);
                }
                return false;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlsaSequencerTransmitter
    extends TMidiDevice.TTransmitter {
        private boolean m_bReceiverSubscribed = false;

        public void setReceiver(Receiver receiver) {
            super.setReceiver(receiver);
            if (receiver instanceof AlsaReceiver) {
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaSequencer.this.getPlaybackClient(), AlsaSequencer.this.getPlaybackPort());
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaSequencer.this.getRecordingClient(), AlsaSequencer.this.getRecordingPort());
            }
        }

        public void send(MidiMessage midiMessage, long l) {
            if (!this.m_bReceiverSubscribed) {
                super.send(midiMessage, l);
            }
        }

        public void close() {
            super.close();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MasterSynchronizer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.MasterSynchronizer.run(): begin");
            }
            while (AlsaSequencer.this.isOpen()) {
                while (true) {
                    MasterSynchronizer masterSynchronizer = this;
                    // MONITORENTER : masterSynchronizer
                    {
                        block11: {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                if (!TDebug.TraceAllExceptions) break block11;
                                TDebug.out(interruptedException);
                            }
                        }
                        // MONITOREXIT : masterSynchronizer
                        if (!AlsaSequencer.this.isRunning()) continue;
                    }
                    break;
                }
                double d = AlsaSequencer.this.getTickPosition();
                double d2 = AlsaSequencer.this.getSequence().getTickLength();
                double d3 = (double)AlsaSequencer.this.getSequence().getResolution() / 24.0;
                if (TDebug.TraceSequencer) {
                    TDebug.out("MasterSynchronizer.run(): tick step: " + d3);
                }
                double d4 = d;
                while (d4 < d2 && AlsaSequencer.this.isRunning()) {
                    long l = Math.round(d4);
                    if (TDebug.TraceSequencer) {
                        TDebug.out("MasterSynchronizer.run(): sending clock event with tick " + l);
                    }
                    AlsaSequencer.this.m_clockEvent.setTimestamp(l);
                    AlsaSequencer.this.getRecordingAlsaSeq().eventOutput(AlsaSequencer.this.m_clockEvent);
                    AlsaSequencer.this.getRecordingAlsaSeq().drainOutput();
                    d4 += d3;
                }
            }
            if (!TDebug.TraceSequencer) return;
            TDebug.out("AlsaSequencer.MasterSynchronizer.run(): end");
        }

        private MasterSynchronizer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RecordingAlsaMidiInListener
    implements AlsaMidiIn.AlsaMidiInListener {
        public void dequeueEvent(MidiMessage midiMessage, long l) {
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.RecordingAlsaMidiInListener.dequeueEvent(): begin");
            }
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.RecordingAlsaMidiInListener.dequeueEvent(): message: " + midiMessage);
            }
            AlsaSequencer.this.receiveTimestamped(midiMessage, l);
            if (TDebug.TraceSequencer) {
                TDebug.out("AlsaSequencer.RecordingAlsaMidiInListener.dequeueEvent(): end");
            }
        }

        private RecordingAlsaMidiInListener() {
        }
    }
}

