/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.EvaluationContext;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.specs.Spec;

public class FilteringProvider<T>
extends AbstractMinimalProvider<T> {
    protected final ProviderInternal<T> provider;
    protected final Spec<? super T> spec;

    public FilteringProvider(ProviderInternal<T> provider, Spec<? super T> spec) {
        this.spec = spec;
        this.provider = provider;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.provider.getType();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        try (EvaluationContext.ScopeContext ignored = this.openScope();){
            ValueSupplier.ValueProducer valueProducer = this.provider.getProducer();
            return valueProducer;
        }
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        try (EvaluationContext.ScopeContext context = this.openScope();){
            ValueSupplier.ExecutionTimeValue<T> value = this.provider.calculateExecutionTimeValue();
            if (value.isMissing()) {
                ValueSupplier.ExecutionTimeValue<T> executionTimeValue = value;
                return executionTimeValue;
            }
            if (value.hasChangingContent()) {
                ValueSupplier.ExecutionTimeValue<? super T> executionTimeValue = ValueSupplier.ExecutionTimeValue.changingValue(new FilteringProvider<T>(value.toProvider(), this.spec));
                return executionTimeValue;
            }
            ValueSupplier.ExecutionTimeValue<T> executionTimeValue = ValueSupplier.ExecutionTimeValue.value(this.filterValue(context, value.toValue()));
            return executionTimeValue;
        }
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        try (EvaluationContext.ScopeContext context = this.openScope();){
            this.beforeRead(context);
            ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
            ValueSupplier.Value<T> value2 = this.filterValue(context, value);
            return value2;
        }
    }

    @Nonnull
    protected ValueSupplier.Value<? extends T> filterValue(EvaluationContext.ScopeContext context, ValueSupplier.Value<? extends T> value) {
        if (value.isMissing()) {
            return value.asType();
        }
        T unpackedValue = value.getWithoutSideEffect();
        if (this.spec.isSatisfiedBy(unpackedValue)) {
            return value;
        }
        return ValueSupplier.Value.missing();
    }

    protected void beforeRead(EvaluationContext.ScopeContext context) {
        this.provider.getProducer().visitContentProducerTasks((Action<? super Task>)((Action)producer -> {
            if (!producer.getState().getExecuted()) {
                throw new InvalidUserCodeException(String.format("Querying the filtered value of %s before %s has completed is not supported", this.provider, producer));
            }
        }));
    }

    @Override
    protected String toStringNoReentrance() {
        return "filter(" + (this.getType() == null ? "" : this.getType().getName() + " ") + this.provider + ")";
    }
}

