/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.BaseMode;
import java.math.BigInteger;

public class ICM
extends BaseMode
implements Cloneable {
    private static final BigInteger TWO_FIFTY_SIX = new BigInteger("256");
    private BigInteger maxBlocksPerSegment;
    private BigInteger counterRange;
    private BigInteger C0;
    private BigInteger blockNdx;

    public Object clone() {
        return new ICM(this);
    }

    public void setup() {
        if (this.modeBlockSize != this.cipherBlockSize) {
            throw new IllegalArgumentException();
        }
        this.counterRange = TWO_FIFTY_SIX.pow(this.cipherBlockSize);
        this.maxBlocksPerSegment = TWO_FIFTY_SIX.pow(this.cipherBlockSize / 2);
        BigInteger bigInteger = new BigInteger(1, this.iv);
        this.C0 = this.maxBlocksPerSegment.add(bigInteger).modPow(BigInteger.ONE, this.counterRange);
        this.blockNdx = BigInteger.ZERO;
    }

    public void teardown() {
        this.counterRange = null;
        this.maxBlocksPerSegment = null;
        this.C0 = null;
        this.blockNdx = null;
    }

    public void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.icm(byArray, n, byArray2, n2);
    }

    public void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.icm(byArray, n, byArray2, n2);
    }

    private final void icm(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.blockNdx.compareTo(this.maxBlocksPerSegment) >= 0) {
            throw new RuntimeException("Maximum blocks for segment reached");
        }
        BigInteger bigInteger = this.C0.add(this.blockNdx).modPow(BigInteger.ONE, this.counterRange);
        byte[] byArray3 = bigInteger.toByteArray();
        int n3 = byArray3.length;
        int n4 = 0;
        if (n3 < this.cipherBlockSize) {
            byte[] byArray4 = new byte[this.cipherBlockSize];
            System.arraycopy(byArray3, 0, byArray4, this.cipherBlockSize - n3, n3);
            byArray3 = byArray4;
        } else if (n3 > this.cipherBlockSize) {
            n4 = n3 - this.cipherBlockSize;
        }
        this.cipher.encryptBlock(byArray3, n4, byArray3, n4);
        this.blockNdx = this.blockNdx.add(BigInteger.ONE);
        int n5 = 0;
        while (n5 < this.modeBlockSize) {
            byArray2[n2++] = (byte)(byArray[n++] ^ byArray3[n4++]);
            ++n5;
        }
    }

    ICM(IBlockCipher iBlockCipher, int n) {
        super("icm", iBlockCipher, n);
    }

    private ICM(ICM iCM) {
        this((IBlockCipher)iCM.cipher.clone(), iCM.cipherBlockSize);
    }
}

