/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public final class Engine {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final int MAX_ALIASES = 5;
    private static final Object[] NO_ARGS = new Object[0];

    public static final Object getInstance(String service, String algorithm, Provider provider) throws InvocationTargetException, NoSuchAlgorithmException {
        return Engine.getInstance(service, algorithm, provider, NO_ARGS);
    }

    public static final Object getInstance(String service, String algorithm, Provider provider, Object[] initArgs) throws InvocationTargetException, NoSuchAlgorithmException {
        if (service == null || algorithm == null || provider == null || initArgs == null) {
            throw new IllegalArgumentException();
        }
        if (provider.getProperty(service + '.' + algorithm) == null) {
            String alias = null;
            int count = 0;
            while ((alias = provider.getProperty(ALG_ALIAS + service + '.' + algorithm)) != null) {
                if (algorithm.equals(alias)) break;
                algorithm = alias;
                if (count++ <= 5) continue;
                throw new NoSuchAlgorithmException("too many aliases");
            }
            if (provider.getProperty(service + '.' + algorithm) == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
        }
        Class clazz = null;
        ClassLoader loader = provider.getClass().getClassLoader();
        Constructor constructor = null;
        String error = algorithm;
        try {
            clazz = loader != null ? loader.loadClass(provider.getProperty(service + '.' + algorithm)) : Class.forName(provider.getProperty(service + '.' + algorithm));
            constructor = Engine.getCompatibleConstructor(clazz, initArgs);
            return constructor.newInstance(initArgs);
        }
        catch (ClassNotFoundException cnfe) {
            error = "class not found: " + algorithm;
        }
        catch (IllegalAccessException iae) {
            error = "illegal access: " + iae.getMessage();
        }
        catch (InstantiationException ie) {
            error = "instantiation exception: " + ie.getMessage();
        }
        catch (ExceptionInInitializerError eiie) {
            error = "exception in initializer: " + eiie.getMessage();
        }
        catch (SecurityException se) {
            error = "security exception: " + se.getMessage();
        }
        catch (NoSuchMethodException nsme) {
            error = "no appropriate constructor found";
        }
        throw new NoSuchAlgorithmException(error);
    }

    private static final Constructor getCompatibleConstructor(Class clazz, Object[] initArgs) throws NoSuchMethodException {
        Constructor[] c = clazz.getConstructors();
        int i = 0;
        while (i < c.length) {
            block4: {
                Class[] argTypes = c[i].getParameterTypes();
                if (argTypes.length == initArgs.length) {
                    int j = 0;
                    while (j < argTypes.length) {
                        if (initArgs[j] == null || argTypes[j].isAssignableFrom(initArgs[j].getClass())) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return c[i];
                }
            }
            ++i;
        }
        throw new NoSuchMethodException();
    }

    private Engine() {
    }
}

