/*
 * Decompiled with CFR 0.152.
 */
package net.pflaeging.PortableSigner;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultiLineToolTipUI
extends BasicToolTipUI {
    protected CellRendererPane rendererPane;
    private static JTextArea textArea;
    private static int maximumWidth;
    static MultiLineToolTipUI singleton;

    public static void initialize() {
        String key = "ToolTipUI";
        Class<?> cls = singleton.getClass();
        String name = cls.getName();
        UIManager.put(key, name);
        UIManager.put(name, cls);
    }

    private MultiLineToolTipUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return singleton;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    public static void setMaximumWidth(int width) {
        maximumWidth = width;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        textArea.setBackground(c.getBackground());
        this.rendererPane.paintComponent(g, textArea, c, 1, 1, size.width - 1, size.height - 1, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        textArea = new JTextArea(tipText);
        this.rendererPane.removeAll();
        this.rendererPane.add(textArea);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(false);
        if (maximumWidth > 0 && (double)maximumWidth < textArea.getPreferredSize().getWidth()) {
            textArea.setLineWrap(true);
            Dimension d = textArea.getPreferredSize();
            d.width = maximumWidth;
            ++d.height;
            textArea.setSize(d);
        }
        Dimension dim = textArea.getPreferredSize();
        ++dim.height;
        ++dim.width;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    static {
        maximumWidth = 0;
        singleton = new MultiLineToolTipUI();
    }
}

