/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util.cli;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.activemq.apollo.util.IntrospectionSupport;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class CommonsCLISupport {
    public static String[] setOptions(Object target, CommandLine cli) {
        Option[] options;
        for (Option option : options = cli.getOptions()) {
            String name = option.getLongOpt();
            if (name == null) continue;
            String propName = CommonsCLISupport.convertOptionToPropertyName(name);
            String value = option.getValue();
            if (value != null) {
                Class<AbstractCollection> type = IntrospectionSupport.getPropertyType(target, propName);
                if (type.isArray()) {
                    IntrospectionSupport.setProperty(target, propName, option.getValues());
                    continue;
                }
                if (type.isAssignableFrom(ArrayList.class)) {
                    IntrospectionSupport.setProperty(target, propName, new ArrayList(option.getValuesList()));
                    continue;
                }
                if (type.isAssignableFrom(HashSet.class)) {
                    IntrospectionSupport.setProperty(target, propName, new HashSet(option.getValuesList()));
                    continue;
                }
                IntrospectionSupport.setProperty(target, propName, value);
                continue;
            }
            IntrospectionSupport.setProperty(target, propName, true);
        }
        return cli.getArgs();
    }

    private static String convertOptionToPropertyName(String name) {
        String rc = "";
        int p = name.indexOf("-");
        while (p > 0) {
            rc = rc + name.substring(0, p);
            if ((name = name.substring(p + 1)).length() > 0) {
                rc = rc + name.substring(0, 1).toUpperCase();
                name = name.substring(1);
            }
            p = name.indexOf("-");
        }
        return rc + name;
    }
}

