/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.layout;

import java.awt.Insets;
import javax.swing.border.Border;
import org.flexdock.plaf.common.border.CompoundEmptyBorder;

public class InsetBorder
extends CompoundEmptyBorder {
    private boolean leftEdge;
    private boolean rightEdge;
    private boolean bottomEdge;

    protected InsetBorder(Border outer, Border inner, boolean emptyInner) {
        super(outer, inner, emptyInner);
    }

    public static InsetBorder createBorder(Border border, boolean inner) {
        return InsetBorder.createBorder(border, inner, null);
    }

    public static InsetBorder createBorder(Border border, boolean inner, Insets base) {
        if (base == null) {
            base = new Insets(0, 0, 0, 0);
        }
        CompoundEmptyBorder.MutableEmptyBorder empty = new CompoundEmptyBorder.MutableEmptyBorder(base.top, base.left, base.bottom, base.right);
        if (inner) {
            return new InsetBorder(border, empty, inner);
        }
        return new InsetBorder(empty, border, inner);
    }

    public void toggleEdge(int edge, boolean on) {
        switch (edge) {
            case 2: {
                this.leftEdge = on;
                break;
            }
            case 4: {
                this.rightEdge = on;
                break;
            }
            case 3: {
                this.bottomEdge = on;
            }
        }
    }

    public boolean isBottomEdge() {
        return this.bottomEdge;
    }

    public void setBottomEdge(boolean bottomEdge) {
        this.bottomEdge = bottomEdge;
    }

    public boolean isLeftEdge() {
        return this.leftEdge;
    }

    public void setLeftEdge(boolean leftEdge) {
        this.leftEdge = leftEdge;
    }

    public boolean isRightEdge() {
        return this.rightEdge;
    }

    public void setRightEdge(boolean rightEdge) {
        this.rightEdge = rightEdge;
    }

    void clearEdges() {
        this.setLeftEdge(false);
        this.setRightEdge(false);
        this.setBottomEdge(false);
    }

    public boolean setEmptyInsets(int top, int left, int bottom, int right) {
        left = this.isLeftEdge() ? left : 0;
        right = this.isRightEdge() ? right : 0;
        bottom = this.isBottomEdge() ? bottom : 0;
        return super.setEmptyInsets(top, left, bottom, right);
    }
}

