/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortEnumerator;
import javax.comm.CommPortOwnershipListener;
import javax.comm.CpoList;
import javax.comm.NoSuchPortException;
import javax.comm.OwnershipEventThread;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    String name;
    private int portType;
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private boolean nativeObjectsCreated;
    private int ownedEvent;
    private int unownedEvent;
    private int ownershipRequestedEvent;
    private int shmem;
    private String shname;
    private boolean maskOwnershipEvents;
    OwnershipEventThread oeThread;
    CpoList cpoList = new CpoList();
    CommPortIdentifier next;
    private CommPort port;
    private CommDriver driver;
    static Object lock = new Object();
    static String propfilename;
    static CommPortIdentifier masterIdList;
    boolean owned;
    String owner;

    public static Enumeration getPortIdentifiers() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        return new CommPortEnumerator();
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = null;
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.name.equals(string)) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = null;
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.port == commPort) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    private static void addPort(CommPort commPort, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(commPort.getName(), commPort, n, null);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
            return;
        }
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(string, null, n, commDriver);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPortType() {
        return this.portType;
    }

    private native int nCreateMutex(String var1);

    private native int nCreateEvent(String var1);

    private native boolean nClaimMutex(int var1, int var2);

    private native boolean nReleaseMutex(int var1);

    private native boolean nPulseEvent(int var1);

    private native boolean nSetEvent(int var1);

    private native boolean nCloseHandle(int var1);

    private void createNativeObjects() {
        if (this.ownershipRequestedEvent == 0) {
            this.ownershipRequestedEvent = this.nCreateEvent("javax.comm." + this.name + "-ownershipRequestedEvent");
        }
        if (this.ownedEvent == 0) {
            this.ownedEvent = this.nCreateEvent("javax.comm." + this.name + "-ownedEvent");
        }
        if (this.unownedEvent == 0) {
            this.unownedEvent = this.nCreateEvent("javax.comm." + this.name + "-unownedEvent");
        }
        this.nativeObjectsCreated = true;
    }

    public synchronized CommPort open(String string, int n) throws PortInUseException {
        if (!this.nativeObjectsCreated) {
            this.createNativeObjects();
        }
        if (this.owned) {
            this.maskOwnershipEvents = true;
            this.fireOwnershipEvent(3);
            this.maskOwnershipEvents = false;
            if (this.owned) {
                throw new PortInUseException(this.owner);
            }
        }
        this.port = this.driver.getCommPort(this.name, this.portType);
        if (this.port == null) {
            this.nSetEvent(this.ownershipRequestedEvent);
            int n2 = n > 200 ? n : 200;
            while (n2 > 0) {
                try {
                    this.wait(200L);
                }
                catch (InterruptedException interruptedException) {}
                this.port = this.driver.getCommPort(this.name, this.portType);
                if (this.port != null) break;
                n2 -= 200;
            }
            if (this.port == null) {
                String string2 = this.nGetOwner(this.shname);
                if (string2 == null || string2.length() == 0) {
                    string2 = "Unknown Windows Application";
                }
                throw new PortInUseException(string2);
            }
        }
        this.owned = true;
        this.owner = string;
        this.shmem = string == null || string.length() == 0 ? this.nSetOwner(this.shname, "Unspecified Java Application", true) : this.nSetOwner(this.shname, string, true);
        if (!this.nSetEvent(this.ownedEvent)) {
            System.err.println("Error pulsing ownedEvent");
        }
        return this.port;
    }

    private native int nSetOwner(String var1, String var2, boolean var3);

    private native String nGetOwner(String var1);

    private native void nUnsetOwner(String var1);

    public String getCurrentOwner() {
        if (this.owned) {
            return this.owner;
        }
        String string = this.nGetOwner(this.shname);
        if (string == null || string.length() == 0) {
            return "Port currently not owned";
        }
        return string;
    }

    public boolean isCurrentlyOwned() {
        if (this.owned) {
            return true;
        }
        String string = this.nGetOwner(this.shname);
        return string != null && string.length() != 0;
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        this.cpoList.add(commPortOwnershipListener);
        if (this.oeThread == null) {
            this.oeThread = new OwnershipEventThread(this);
            this.oeThread.start();
        }
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        this.cpoList.remove(commPortOwnershipListener);
    }

    private native int nWaitForEvents(int var1, int var2, int var3);

    void ownershipThreadWaiter() {
        int n = this.nWaitForEvents(this.ownedEvent, this.unownedEvent, this.ownershipRequestedEvent);
        if (n >= 0) {
            this.maskOwnershipEvents = true;
            switch (n) {
                case 0: {
                    this.fireOwnershipEvent(1);
                    break;
                }
                case 1: {
                    this.fireOwnershipEvent(2);
                    break;
                }
                case 2: {
                    this.fireOwnershipEvent(3);
                    break;
                }
            }
            this.maskOwnershipEvents = false;
        }
    }

    synchronized void internalClosePort() {
        this.owned = false;
        this.owner = null;
        this.port = null;
        this.nUnsetOwner(this.shname);
        this.nSetEvent(this.unownedEvent);
    }

    CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.name = string;
        this.port = commPort;
        this.portType = n;
        this.next = null;
        this.driver = commDriver;
        this.shname = "javax.comm-" + string;
        this.shmem = this.nSetOwner(this.shname, "", false);
    }

    void fireOwnershipEvent(int n) {
        CpoList cpoList = this.cpoList.clonelist();
        cpoList.fireOwnershipEvent(n);
    }

    private static String[] parsePropsFile(InputStream inputStream) {
        int n;
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            int n2;
            objectArray = new byte[4096];
            n = 0;
            boolean bl = false;
            block7: while ((n2 = inputStream.read()) != -1) {
                switch (n2) {
                    case 10: 
                    case 13: {
                        String string;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case 35: {
                        String string;
                        bl = true;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        break;
                    }
                    default: {
                        if (bl || n >= 4096) continue block7;
                        objectArray[n++] = (byte)n2;
                    }
                    case 9: 
                    case 32: 
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Caught " + throwable + " parsing prop file.");
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                objectArray[n] = (byte)((String)vector.elementAt(n));
                ++n;
            }
            return objectArray;
        }
        return null;
    }

    private static void loadDriver(String string) throws IOException {
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        String[] stringArray = CommPortIdentifier.parsePropsFile(bufferedInputStream);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].regionMatches(true, 0, "driver=", 0, 7)) {
                    String string2 = stringArray[n].substring(7);
                    string2.trim();
                    try {
                        CommDriver commDriver = (CommDriver)Class.forName(string2).newInstance();
                        commDriver.initialize();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Caught " + throwable + " while loading driver " + string2);
                    }
                }
                ++n;
            }
        }
    }

    private static String findPropFile() {
        String string = System.getProperty("java.class.path");
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.whitespaceChars(File.pathSeparatorChar, File.pathSeparatorChar);
        streamTokenizer.wordChars(File.separatorChar, File.separatorChar);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.wordChars(46, 46);
        try {
            while (streamTokenizer.nextToken() != -1) {
                String string2;
                File file;
                int n = -1;
                if (streamTokenizer.ttype != -3 || (n = streamTokenizer.sval.indexOf("comm.jar")) == -1 || !(file = new File(string2 = new String(streamTokenizer.sval))).exists()) continue;
                String string3 = string2.substring(0, n);
                string3 = string3 != null ? String.valueOf(string3) + "." + File.separator + "javax.comm.properties" : "." + File.separator + "javax.comm.properties";
                file = new File(string3);
                if (file.exists()) {
                    return new String(string3);
                }
                return null;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    static {
        String string = System.getProperty("javax.comm.properties");
        if (string != null) {
            System.err.println("Comm Drivers: " + string);
        }
        String string2 = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "javax.comm.properties";
        try {
            CommPortIdentifier.loadDriver(string2);
            propfilename = new String(string2);
            return;
        }
        catch (IOException iOException) {
            propfilename = CommPortIdentifier.findPropFile();
            try {
                if (propfilename != null) {
                    CommPortIdentifier.loadDriver(propfilename);
                    return;
                }
            }
            catch (IOException iOException2) {
                propfilename = new String(" ");
                System.err.println(iOException2);
                return;
            }
            return;
        }
    }
}

