/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WiggleWindow {
    private static final Log LOG = LogFactory.getLog(WiggleWindow.class);
    private int startPosition = -1;
    private int curWindowPosition;
    private final PrintWriter writer;
    private final int windowSize;
    private int maxDataSize;
    private int windowTotal;

    public WiggleWindow(PrintWriter writer, int windowSize, int maxDataSize) {
        this.writer = writer;
        this.windowSize = windowSize;
        this.maxDataSize = maxDataSize;
    }

    public void addData(int position, int length, int value) {
        if (value == 0) {
            return;
        }
        if (this.startPosition == -1) {
            this.startPosition = position;
        } else if (position < this.startPosition + this.windowSize) {
            this.curWindowPosition = position - this.startPosition;
        } else {
            this.outputCurrentWindow();
            this.startPosition = position;
        }
        this.writeDataToWindow(length, value);
    }

    private void writeDataToWindow(int length, int value) {
        for (int i = 0; i < length; ++i) {
            this.windowTotal += value;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("pos[%d]=%d", this.curWindowPosition + this.startPosition, value));
            }
            ++this.curWindowPosition;
            if (this.curWindowPosition != this.windowSize) continue;
            this.outputCurrentWindow();
            this.startPosition += this.windowSize;
        }
    }

    public void finish() {
        this.outputCurrentWindow();
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void reset() {
        this.startPosition = -1;
        this.curWindowPosition = 0;
        this.windowTotal = 0;
    }

    public int getMaxDataSize() {
        return this.maxDataSize;
    }

    public void setMaxDataSize(int maxDataSize) {
        this.maxDataSize = maxDataSize;
    }

    private void outputCurrentWindow() {
        if (this.curWindowPosition == 0) {
            return;
        }
        int windowAverage = Math.round((float)this.windowTotal / (float)this.curWindowPosition);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("... average=%d (%d/%d)", windowAverage, this.windowTotal, this.curWindowPosition));
        }
        if (this.startPosition + this.windowSize <= this.maxDataSize) {
            if (this.writer != null) {
                this.writer.printf("%d %d%n", this.startPosition + 1, windowAverage);
            }
        } else {
            LOG.warn((Object)String.format("Not writing %d %d", this.startPosition + 1, windowAverage));
        }
        this.curWindowPosition = 0;
        this.windowTotal = 0;
    }
}

