/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeNodeItem;

public class RPTreeNode {
    boolean leaf;
    protected RPChromosomeRegion chromosomeBounds;
    protected ArrayList<RPTreeNodeItem> items;

    public RPTreeNode(boolean leaf) {
        this.leaf = leaf;
        this.items = new ArrayList();
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    public int compareRegions(RPChromosomeRegion chromosomeRegion) {
        return this.chromosomeBounds.compareRegions(chromosomeRegion);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public RPTreeNodeItem getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return this.items.get(index);
    }

    public void insertItem(RPTreeNodeItem item) {
        RPTreeNodeItem newItem = item;
        this.items.add(newItem);
        this.chromosomeBounds = this.chromosomeBounds == null ? new RPChromosomeRegion(newItem.getChromosomeBounds()) : this.chromosomeBounds.getExtremes(newItem.getChromosomeBounds());
    }

    public void printItems() {
        for (int item = 0; item < this.items.size(); ++item) {
            this.items.get(item).print();
        }
    }
}

