/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.blast;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.blast.BlastMapping;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.Strand;

public class BlastParser {
    public List<BlastMapping> parse(String file) {
        ArrayList<BlastMapping> mappings = new ArrayList<BlastMapping>();
        BufferedReader reader = null;
        boolean tabblastn = file.contains(".tabblastn");
        int queryChrIdx = 0;
        int queryStartIdx = tabblastn ? 6 : 1;
        int queryEndIdx = tabblastn ? 7 : 2;
        int queryStrandIdx = tabblastn ? -1 : 3;
        int subjectChrIdx = tabblastn ? 1 : 4;
        int subjectStartIdx = tabblastn ? 8 : 5;
        int subjectEndIdx = tabblastn ? 9 : 6;
        int subjectStrandIdx = tabblastn ? -1 : 7;
        int nTokens = tabblastn ? 10 : 8;
        long lineCount = 0L;
        String nextLine = null;
        boolean dataParsed = false;
        try {
            reader = new BufferedReader(new FileReader(file));
            while ((nextLine = reader.readLine()) != null) {
                int subjectEnd;
                int subjectStart;
                int queryEnd;
                int queryStart;
                ++lineCount;
                String[] tokens = nextLine.split("\t");
                if (tokens.length < nTokens) continue;
                dataParsed = true;
                String queryCht = tokens[queryChrIdx];
                try {
                    queryStart = Integer.parseInt(tokens[queryStartIdx]);
                    queryEnd = Integer.parseInt(tokens[queryEndIdx]);
                }
                catch (NumberFormatException ne) {
                    throw new RuntimeException("Non-numeric value found in either start or end column");
                }
                Strand queryStrand = Strand.NONE;
                if (!tabblastn) {
                    int str = Integer.parseInt(tokens[queryStrandIdx]);
                    queryStrand = str == 1 ? Strand.POSITIVE : Strand.NEGATIVE;
                }
                String subjectChr = tokens[subjectChrIdx];
                try {
                    subjectStart = Integer.parseInt(tokens[subjectStartIdx]);
                    subjectEnd = Integer.parseInt(tokens[subjectEndIdx]);
                }
                catch (NumberFormatException ne) {
                    throw new RuntimeException("Non-numeric value found in  either subject start or end column");
                }
                Strand subjectStrand = Strand.NONE;
                if (!tabblastn) {
                    try {
                        int str = Integer.parseInt(tokens[subjectStrandIdx]);
                        subjectStrand = str == 1 ? Strand.POSITIVE : Strand.NEGATIVE;
                    }
                    catch (NumberFormatException ne) {
                        throw new RuntimeException("Non-numeric value found in  either subject strand column");
                    }
                }
                float percentIden = tabblastn ? Float.parseFloat(tokens[2]) : 100.0f;
                BlastMapping.Block queryBlock = new BlastMapping.Block(queryCht, queryStart, queryEnd, queryStrand);
                BlastMapping.Block subjectBlock = new BlastMapping.Block(subjectChr, subjectStart, subjectEnd, subjectStrand);
                mappings.add(new BlastMapping(queryBlock, subjectBlock, percentIden));
            }
            if (!dataParsed) {
                throw new RuntimeException("Data not loaded. Number of columns is less than " + nTokens + ".");
            }
        }
        catch (Exception ex) {
            if (lineCount != 0L) {
                throw new ParserException(ex.getMessage(), lineCount, nextLine);
            }
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return mappings;
    }
}

