/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Map;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.legend.LegendPanel;
import org.broad.igv.ui.legend.MutationColorMapEditor;

public class MutationLegendPanel
extends LegendPanel {
    PaletteColorTable colorTable;

    public MutationLegendPanel() {
        this.init();
    }

    private void init() {
        PaletteColorTable prefTable = PreferencesManager.getPreferences().getMutationColorScheme();
        this.colorTable = new PaletteColorTable();
        for (String key : prefTable.getKeys()) {
            this.colorTable.put(key, prefTable.get(key));
        }
    }

    @Override
    protected void persistResetPreferences() {
        PreferencesManager.getPreferences().resetMutationColorScheme();
        this.reloadPreferences();
    }

    @Override
    protected void reloadPreferences() {
        this.init();
        this.repaint();
    }

    protected ColorScale getColorScale() {
        return null;
    }

    @Override
    protected void resetPreferencesToDefault() {
        this.persistResetPreferences();
        this.showResetDisplay();
    }

    @Override
    public void edit() {
        boolean useColorsNew;
        boolean useColors = IGV.getInstance().getSession().getColorOverlay();
        PaletteColorTable ct = PreferencesManager.getPreferences().getMutationColorScheme();
        MutationColorMapEditor editor = new MutationColorMapEditor(IGV.getMainFrame(), ct.getColorMap(), useColors);
        editor.setVisible(true);
        Map<String, Color> changedColors = editor.getChangedColors();
        if (!changedColors.isEmpty()) {
            for (Map.Entry<String, Color> entry : changedColors.entrySet()) {
                ct.put(entry.getKey(), entry.getValue());
            }
            String colorTableString = ct.getMapAsString();
            PreferencesManager.getPreferences().put("MUTATION_COLOR_TABLE", colorTableString);
            this.reloadPreferences();
        }
        if ((useColorsNew = editor.getUseColors()) != useColors) {
            PreferencesManager.getPreferences().put("COVER_OVERLAY_KEY", String.valueOf(useColorsNew));
        }
    }

    @Override
    public void paintLegend(Graphics2D g2D) {
        int lineHeight;
        if (this.colorTable == null) {
            return;
        }
        g2D.setFont(FontManager.getFont(10));
        FontMetrics fm = g2D.getFontMetrics();
        int dh = fm.getHeight() / 2 + 3;
        int x = 0;
        int y = lineHeight = 12;
        int colCount = 0;
        for (Map.Entry<String, Color> entry : this.colorTable.entrySet()) {
            String mutType = entry.getKey();
            String label = mutType.replace("_", " ");
            int labelWidth = (int)fm.getStringBounds(label, g2D).getWidth();
            g2D.setColor(entry.getValue());
            g2D.fillRect(x, y, 10, 10);
            g2D.setColor(Color.BLACK);
            g2D.drawRect(x, y, 10, 10);
            g2D.drawString(label, x + 20, y + dh);
            x += labelWidth + 40;
            if (++colCount % 5 != 0) continue;
            y += lineHeight + 5;
            x = 0;
        }
    }
}

