/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.utils.ValidationUtils;
import java.nio.ByteBuffer;

final class RANSEncodingSymbol {
    private int xMax;
    private int rcpFreq;
    private int bias;
    private int cmplFreq;
    private int rcpShift;

    RANSEncodingSymbol() {
    }

    public void reset() {
        this.rcpFreq = 0;
        this.cmplFreq = 0;
        this.bias = 0;
        this.rcpFreq = 0;
        this.xMax = 0;
    }

    public void set(int start, int freq, int scaleBits) {
        this.xMax = (0x800000 >> scaleBits << 8) * freq;
        this.cmplFreq = (1 << scaleBits) - freq;
        if (freq < 2) {
            this.rcpFreq = -1;
            this.rcpShift = 0;
            this.bias = start + (1 << scaleBits) - 1;
        } else {
            int shift = 0;
            while ((long)freq > 1L << shift) {
                ++shift;
            }
            this.rcpFreq = (int)(((1L << shift + 31) + (long)freq - 1L) / (long)freq);
            this.rcpShift = shift - 1;
            this.bias = start;
        }
        this.rcpShift += 32;
    }

    public int putSymbol(int r, ByteBuffer byteBuffer) {
        ValidationUtils.validateArg(this.xMax != 0, "can't encode symbol with freq=0");
        int x = r;
        if (x >= this.xMax) {
            byteBuffer.put((byte)(x & 0xFF));
            if ((x >>= 8) >= this.xMax) {
                byteBuffer.put((byte)(x & 0xFF));
                x >>= 8;
            }
        }
        long q = (long)x * (0xFFFFFFFFL & (long)this.rcpFreq) >> this.rcpShift;
        r = (int)((long)(x + this.bias) + q * (long)this.cmplFreq);
        return r;
    }
}

